/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.codegen;

import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.cypher.internal.codegen.CompiledExpandUtils;
import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;

public class CompiledExpandUtilsTest {
    @Test
    public void shouldUseGivenOrderIfItHasLowerDegree() throws EntityNotFoundException {
        ReadOperations readOperations = (ReadOperations)Mockito.mock(ReadOperations.class);
        Mockito.when((Object)readOperations.nodeGetDegree(1L, Direction.OUTGOING)).thenReturn((Object)1);
        Mockito.when((Object)readOperations.nodeGetDegree(2L, Direction.INCOMING)).thenReturn((Object)3);
        CompiledExpandUtils.connectingRelationships((ReadOperations)readOperations, (long)1L, (Direction)Direction.OUTGOING, (long)2L);
        ((ReadOperations)Mockito.verify((Object)readOperations, (VerificationMode)Mockito.times((int)1))).nodeGetRelationships(1L, Direction.OUTGOING);
    }

    @Test
    public void shouldSwitchOrderIfItHasLowerDegree() throws EntityNotFoundException {
        ReadOperations readOperations = (ReadOperations)Mockito.mock(ReadOperations.class);
        Mockito.when((Object)readOperations.nodeGetDegree(1L, Direction.OUTGOING)).thenReturn((Object)3);
        Mockito.when((Object)readOperations.nodeGetDegree(2L, Direction.INCOMING)).thenReturn((Object)1);
        CompiledExpandUtils.connectingRelationships((ReadOperations)readOperations, (long)1L, (Direction)Direction.OUTGOING, (long)2L);
        ((ReadOperations)Mockito.verify((Object)readOperations, (VerificationMode)Mockito.times((int)1))).nodeGetRelationships(2L, Direction.INCOMING);
    }

    @Test
    public void shouldUseGivenOrderIfItHasLowerDegreeWithTypes() throws EntityNotFoundException {
        ReadOperations readOperations = (ReadOperations)Mockito.mock(ReadOperations.class);
        Mockito.when((Object)readOperations.nodeGetDegree(1L, Direction.OUTGOING, 1)).thenReturn((Object)1);
        Mockito.when((Object)readOperations.nodeGetDegree(2L, Direction.INCOMING, 1)).thenReturn((Object)3);
        CompiledExpandUtils.connectingRelationships((ReadOperations)readOperations, (long)1L, (Direction)Direction.OUTGOING, (long)2L, (int[])new int[]{1});
        ((ReadOperations)Mockito.verify((Object)readOperations, (VerificationMode)Mockito.times((int)1))).nodeGetRelationships(1L, Direction.OUTGOING, new int[]{1});
    }

    @Test
    public void shouldSwitchOrderIfItHasLowerDegreeWithTypes() throws EntityNotFoundException {
        ReadOperations readOperations = (ReadOperations)Mockito.mock(ReadOperations.class);
        Mockito.when((Object)readOperations.nodeGetDegree(1L, Direction.OUTGOING, 1)).thenReturn((Object)3);
        Mockito.when((Object)readOperations.nodeGetDegree(2L, Direction.INCOMING, 1)).thenReturn((Object)1);
        CompiledExpandUtils.connectingRelationships((ReadOperations)readOperations, (long)1L, (Direction)Direction.OUTGOING, (long)2L, (int[])new int[]{1});
        ((ReadOperations)Mockito.verify((Object)readOperations, (VerificationMode)Mockito.times((int)1))).nodeGetRelationships(2L, Direction.INCOMING, new int[]{1});
    }
}

