/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.codegen;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.cypher.internal.codegen.CompiledIndexUtils;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.index.IndexNotApplicableKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.schema.IndexQuery;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;

public class CompiledIndexUtilsTest {
    @Test
    public void shouldCallIndexSeek() throws EntityNotFoundException, IndexNotApplicableKernelException, IndexNotFoundKernelException {
        ReadOperations read = (ReadOperations)Mockito.mock(ReadOperations.class);
        IndexDescriptor descriptor = IndexDescriptorFactory.forLabel((int)12, (int[])new int[]{42});
        CompiledIndexUtils.indexSeek((ReadOperations)read, (IndexDescriptor)descriptor, (int)42, (Object)"hello");
        ((ReadOperations)Mockito.verify((Object)read, (VerificationMode)Mockito.times((int)1))).indexQuery(descriptor, new IndexQuery[]{IndexQuery.exact((int)42, (Object)"hello")});
    }

    @Test
    public void shouldHandleNullInIndexSeek() throws EntityNotFoundException, IndexNotApplicableKernelException, IndexNotFoundKernelException {
        ReadOperations read = (ReadOperations)Mockito.mock(ReadOperations.class);
        IndexDescriptor descriptor = IndexDescriptorFactory.forLabel((int)12, (int[])new int[]{42});
        PrimitiveLongIterator iterator2 = CompiledIndexUtils.indexSeek((ReadOperations)read, (IndexDescriptor)descriptor, (int)42, null);
        ((ReadOperations)Mockito.verify((Object)read, (VerificationMode)Mockito.never())).indexQuery((IndexDescriptor)Matchers.any(), (IndexQuery[])Matchers.any());
        Assert.assertFalse((boolean)iterator2.hasNext());
    }
}

