/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.codegen;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.cypher.internal.codegen.NodeIdWrapperImpl;
import org.neo4j.cypher.internal.codegen.ParameterConverter;
import org.neo4j.cypher.internal.codegen.RelationshipIdWrapperImpl;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.storable.LongArray;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.EdgeValue;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.PathValue;
import org.neo4j.values.virtual.PointValue;
import org.neo4j.values.virtual.VirtualValues;

public class ParameterConverterTest {
    private ParameterConverter converter = new ParameterConverter((NodeManager)Mockito.mock(NodeManager.class));

    @Before
    public void setup() {
        NodeManager manager = (NodeManager)Mockito.mock(NodeManager.class);
        Mockito.when((Object)manager.newNodeProxyById(org.mockito.Matchers.anyLong())).thenAnswer(invocationOnMock -> {
            long id = (Long)invocationOnMock.getArgumentAt(0, Long.TYPE);
            NodeProxy mock = (NodeProxy)Mockito.mock(NodeProxy.class);
            Mockito.when((Object)mock.getId()).thenReturn((Object)id);
            return mock;
        });
        Mockito.when((Object)manager.newRelationshipProxyById(org.mockito.Matchers.anyLong())).thenAnswer(invocationOnMock -> {
            long id = (Long)invocationOnMock.getArgumentAt(0, Long.TYPE);
            RelationshipProxy mock = (RelationshipProxy)Mockito.mock(RelationshipProxy.class);
            Mockito.when((Object)mock.getId()).thenReturn((Object)id);
            return mock;
        });
        this.converter = new ParameterConverter(manager);
    }

    @Test
    public void shouldTurnAllIntegerTypesToLongs() {
        AnyValue[] values;
        for (AnyValue val : values = new AnyValue[]{Values.byteValue((byte)13), Values.shortValue((short)13), Values.intValue((int)13), Values.longValue((long)13L)}) {
            val.writeTo((AnyValueWriter)this.converter);
            Object value = this.converter.value();
            MatcherAssert.assertThat((Object)value, (Matcher)Matchers.instanceOf(Long.class));
            MatcherAssert.assertThat((Object)value, (Matcher)Matchers.equalTo((Object)13L));
        }
    }

    @Test
    public void shouldTurnAllFloatingTypesToDoubles() {
        AnyValue[] values;
        for (AnyValue val : values = new AnyValue[]{Values.floatValue((float)13.0f), Values.doubleValue((double)13.0)}) {
            val.writeTo((AnyValueWriter)this.converter);
            Object value = this.converter.value();
            MatcherAssert.assertThat((Object)value, (Matcher)Matchers.instanceOf(Double.class));
            MatcherAssert.assertThat((Object)value, (Matcher)Matchers.equalTo((Object)13.0));
        }
    }

    @Test
    public void shouldHandleNodes() {
        NodeValue nodeValue = VirtualValues.nodeValue((long)42L, (TextArray)Values.stringArray((String[])new String[]{"L"}), (MapValue)VirtualValues.EMPTY_MAP);
        nodeValue.writeTo((AnyValueWriter)this.converter);
        MatcherAssert.assertThat((Object)this.converter.value(), (Matcher)Matchers.equalTo((Object)new NodeIdWrapperImpl(42L)));
    }

    @Test
    public void shouldHandleEdges() {
        EdgeValue edgeValue = VirtualValues.edgeValue((long)1L, (NodeValue)VirtualValues.nodeValue((long)42L, (TextArray)Values.stringArray((String[])new String[]{"L"}), (MapValue)VirtualValues.EMPTY_MAP), (NodeValue)VirtualValues.nodeValue((long)42L, (TextArray)Values.stringArray((String[])new String[]{"L"}), (MapValue)VirtualValues.EMPTY_MAP), (TextValue)Values.stringValue((String)"R"), (MapValue)VirtualValues.EMPTY_MAP);
        edgeValue.writeTo((AnyValueWriter)this.converter);
        MatcherAssert.assertThat((Object)this.converter.value(), (Matcher)Matchers.equalTo((Object)new RelationshipIdWrapperImpl(1L)));
    }

    @Test
    public void shouldHandleBooleans() {
        Values.TRUE.writeTo((AnyValueWriter)this.converter);
        MatcherAssert.assertThat((Object)this.converter.value(), (Matcher)Matchers.equalTo((Object)true));
        Values.FALSE.writeTo((AnyValueWriter)this.converter);
        MatcherAssert.assertThat((Object)this.converter.value(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldHandlePaths() {
        NodeValue n1 = VirtualValues.nodeValue((long)42L, (TextArray)Values.stringArray((String[])new String[]{"L"}), (MapValue)VirtualValues.EMPTY_MAP);
        NodeValue n2 = VirtualValues.nodeValue((long)43L, (TextArray)Values.stringArray((String[])new String[]{"L"}), (MapValue)VirtualValues.EMPTY_MAP);
        PathValue p = VirtualValues.path((NodeValue[])new NodeValue[]{n1, n2}, (EdgeValue[])new EdgeValue[]{VirtualValues.edgeValue((long)1L, (NodeValue)n1, (NodeValue)n2, (TextValue)Values.stringValue((String)"T"), (MapValue)VirtualValues.EMPTY_MAP)});
        p.writeTo((AnyValueWriter)this.converter);
        Object value = this.converter.value();
        MatcherAssert.assertThat((Object)value, (Matcher)Matchers.instanceOf(Path.class));
        Path path = (Path)value;
        MatcherAssert.assertThat((Object)path.length(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)path.startNode().getId(), (Matcher)Matchers.equalTo((Object)42L));
        MatcherAssert.assertThat((Object)path.endNode().getId(), (Matcher)Matchers.equalTo((Object)43L));
        MatcherAssert.assertThat((Object)((Relationship)path.relationships().iterator().next()).getId(), (Matcher)Matchers.equalTo((Object)1L));
    }

    @Test
    public void shouldHandlePoints() {
        PointValue pointValue = VirtualValues.pointGeographic((double)1.0, (double)2.0);
        pointValue.writeTo((AnyValueWriter)this.converter);
        Object value = this.converter.value();
        MatcherAssert.assertThat((Object)value, (Matcher)Matchers.instanceOf(Point.class));
        Point point = (Point)value;
        MatcherAssert.assertThat(point.getCoordinate().getCoordinate().get(0), (Matcher)Matchers.equalTo((Object)1.0));
        MatcherAssert.assertThat(point.getCoordinate().getCoordinate().get(1), (Matcher)Matchers.equalTo((Object)2.0));
        MatcherAssert.assertThat((Object)point.getCRS().getCode(), (Matcher)Matchers.equalTo((Object)4326));
    }

    @Test
    public void shouldHandleLists() {
        ListValue list2 = VirtualValues.list((AnyValue[])new AnyValue[]{Values.stringValue((String)"foo"), Values.longValue((long)42L), Values.TRUE});
        list2.writeTo((AnyValueWriter)this.converter);
        MatcherAssert.assertThat((Object)this.converter.value(), (Matcher)Matchers.equalTo(Arrays.asList("foo", 42L, true)));
    }

    @Test
    public void shouldHandleArrays() {
        LongArray longArray = Values.longArray((long[])new long[]{1L, 2L, 3L});
        longArray.writeTo((AnyValueWriter)this.converter);
        MatcherAssert.assertThat((Object)this.converter.value(), (Matcher)Matchers.equalTo((Object)new long[]{1L, 2L, 3L}));
    }

    @Test
    public void shouldHandleMaps() {
        MapValue map = VirtualValues.map((String[])new String[]{"foo", "bar"}, (AnyValue[])new AnyValue[]{Values.longValue((long)42L), Values.stringValue((String)"baz")});
        map.writeTo((AnyValueWriter)this.converter);
        MatcherAssert.assertThat((Object)this.converter.value(), (Matcher)Matchers.equalTo((Object)MapUtil.map((Object[])new Object[]{"foo", 42L, "bar", "baz"})));
    }

    @Test
    public void shouldHandleListWithMaps() {
        ListValue list2 = VirtualValues.list((AnyValue[])new AnyValue[]{Values.longValue((long)42L), VirtualValues.map((String[])new String[]{"foo", "bar"}, (AnyValue[])new AnyValue[]{Values.longValue((long)42L), Values.stringValue((String)"baz")})});
        list2.writeTo((AnyValueWriter)this.converter);
        List converted = (List)this.converter.value();
        MatcherAssert.assertThat(converted.get(0), (Matcher)Matchers.equalTo((Object)42L));
        MatcherAssert.assertThat(converted.get(1), (Matcher)Matchers.equalTo((Object)MapUtil.map((Object[])new Object[]{"foo", 42L, "bar", "baz"})));
    }

    @Test
    public void shouldHandleMapsWithLists() {
        MapValue map = VirtualValues.map((String[])new String[]{"foo", "bar"}, (AnyValue[])new AnyValue[]{Values.longValue((long)42L), VirtualValues.list((AnyValue[])new AnyValue[]{Values.stringValue((String)"baz")})});
        map.writeTo((AnyValueWriter)this.converter);
        Map value = (Map)this.converter.value();
        MatcherAssert.assertThat(value.get("foo"), (Matcher)Matchers.equalTo((Object)42L));
        MatcherAssert.assertThat(value.get("bar"), (Matcher)Matchers.equalTo(Collections.singletonList("baz")));
        MatcherAssert.assertThat((Object)value.size(), (Matcher)Matchers.equalTo((Object)2));
    }
}

