/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compatibility.v3_3.runtime;

import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.ClosingIterator;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.TaskCloser;
import org.neo4j.cypher.internal.frontend.v3_3.CypherException;
import org.neo4j.cypher.internal.frontend.v3_3.test_helpers.CypherFunSuite;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t3A!\u0001\u0002\u0001#\t\u00192\t\\8tS:<\u0017\n^3sCR|'\u000fV3ti*\u00111\u0001B\u0001\beVtG/[7f\u0015\t)a!\u0001\u0003wg}\u001b$BA\u0004\t\u00035\u0019w.\u001c9bi&\u0014\u0017\u000e\\5us*\u0011\u0011BC\u0001\tS:$XM\u001d8bY*\u00111\u0002D\u0001\u0007Gf\u0004\b.\u001a:\u000b\u00055q\u0011!\u00028f_RR'\"A\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0011\u0002CA\n\u001a\u001b\u0005!\"BA\u000b\u0017\u00031!Xm\u001d;`Q\u0016d\u0007/\u001a:t\u0015\t)qC\u0003\u0002\u0019\u0011\u0005AaM]8oi\u0016tG-\u0003\u0002\u001b)\tq1)\u001f9iKJ4UO\\*vSR,\u0007\"\u0002\u000f\u0001\t\u0003i\u0012A\u0002\u001fj]&$h\bF\u0001\u001f!\ty\u0002!D\u0001\u0003\u0011%\t\u0003\u00011AA\u0002\u0013\u0005!%\u0001\u0006uCN\\7\t\\8tKJ,\u0012a\t\t\u0003?\u0011J!!\n\u0002\u0003\u0015Q\u000b7o[\"m_N,'\u000fC\u0005(\u0001\u0001\u0007\t\u0019!C\u0001Q\u0005qA/Y:l\u00072|7/\u001a:`I\u0015\fHCA\u00150!\tQS&D\u0001,\u0015\u0005a\u0013!B:dC2\f\u0017B\u0001\u0018,\u0005\u0011)f.\u001b;\t\u000fA2\u0013\u0011!a\u0001G\u0005\u0019\u0001\u0010J\u0019\t\rI\u0002\u0001\u0015)\u0003$\u0003-!\u0018m]6DY>\u001cXM\u001d\u0011\t\u000fQ\u0002!\u0019!C\u0001k\u0005\u0011R\r_2faRLwN\u001c#fG>\u0014\u0018\r^8s+\u00051\u0004\u0003\u0002\u00168seJ!\u0001O\u0016\u0003\u0013\u0019+hn\u0019;j_:\f\u0004C\u0001\u001e<\u001b\u00051\u0012B\u0001\u001f\u0017\u0005=\u0019\u0015\u0010\u001d5fe\u0016C8-\u001a9uS>t\u0007B\u0002 \u0001A\u0003%a'A\nfq\u000e,\u0007\u000f^5p]\u0012+7m\u001c:bi>\u0014\b\u0005C\u0003A\u0001\u0011\u0005\u0013)\u0001\u0006cK\u001a|'/Z#bG\"$\u0012!\u000b")
public class ClosingIteratorTest
extends CypherFunSuite {
    private TaskCloser taskCloser;
    private final Function1<CypherException, CypherException> exceptionDecorator = new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final CypherException apply(CypherException x) {
            return (CypherException)Predef$.MODULE$.identity((Object)x);
        }
    };

    public TaskCloser taskCloser() {
        return this.taskCloser;
    }

    public void taskCloser_$eq(TaskCloser x$1) {
        this.taskCloser = x$1;
    }

    public Function1<CypherException, CypherException> exceptionDecorator() {
        return this.exceptionDecorator;
    }

    public void beforeEach() {
        super.beforeEach();
        this.taskCloser_$eq((TaskCloser)this.mock(ManifestFactory$.MODULE$.classType(TaskCloser.class)));
    }

    public ClosingIteratorTest() {
        this.test("should not close prematurely", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClosingIteratorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Iterator wrapee = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k"), (Object)Values.intValue((int)42))}))}));
                ClosingIterator iterator2 = new ClosingIterator(wrapee, this.$outer.taskCloser(), this.$outer.exceptionDecorator());
                Map result2 = iterator2.next();
                ((TaskCloser)Mockito.verify((Object)this.$outer.taskCloser(), (VerificationMode)Mockito.never())).close(Matchers.anyBoolean());
                this.$outer.convertToAnyShouldWrapper(result2).should(this.$outer.equal(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k"), (Object)Values.intValue((int)42))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should cleanup even for empty iterator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClosingIteratorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Iterator wrapee = package$.MODULE$.Iterator().empty();
                ClosingIterator iterator2 = new ClosingIterator(wrapee, this.$outer.taskCloser(), this.$outer.exceptionDecorator());
                boolean result2 = iterator2.hasNext();
                ((TaskCloser)Mockito.verify((Object)this.$outer.taskCloser())).close(true);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)result2)).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("multiple has next should not close more than once", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClosingIteratorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Iterator wrapee = package$.MODULE$.Iterator().empty();
                ClosingIterator iterator2 = new ClosingIterator(wrapee, this.$outer.taskCloser(), this.$outer.exceptionDecorator());
                boolean result2 = iterator2.hasNext();
                iterator2.hasNext();
                iterator2.hasNext();
                iterator2.hasNext();
                iterator2.hasNext();
                ((TaskCloser)Mockito.verify((Object)this.$outer.taskCloser(), (VerificationMode)Mockito.atLeastOnce())).close(true);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)result2)).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("exception in hasNext should fail transaction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClosingIteratorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Iterator wrapee = (Iterator)this.$outer.mock(ManifestFactory$.MODULE$.classType(Iterator.class, ManifestFactory$.MODULE$.classType(scala.collection.immutable.Map.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.classType(AnyValue.class)})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
                Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)wrapee.hasNext())).thenThrow(new Throwable[]{new RuntimeException()});
                ClosingIterator iterator2 = new ClosingIterator(wrapee, this.$outer.taskCloser(), this.$outer.exceptionDecorator());
                this.$outer.intercept((Function0)new Serializable(this, iterator2){
                    public static final long serialVersionUID = 0L;
                    private final ClosingIterator iterator$1;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return this.iterator$1.hasNext();
                    }
                    {
                        this.iterator$1 = iterator$1;
                    }
                }, ManifestFactory$.MODULE$.classType(RuntimeException.class));
                ((TaskCloser)Mockito.verify((Object)this.$outer.taskCloser())).close(false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("exception in next should fail transaction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClosingIteratorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Iterator wrapee = (Iterator)this.$outer.mock(ManifestFactory$.MODULE$.classType(Iterator.class, ManifestFactory$.MODULE$.classType(scala.collection.immutable.Map.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.classType(AnyValue.class)})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
                Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)wrapee.hasNext())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
                Mockito.when((Object)wrapee.next()).thenThrow(new Throwable[]{new RuntimeException()});
                ClosingIterator iterator2 = new ClosingIterator(wrapee, this.$outer.taskCloser(), this.$outer.exceptionDecorator());
                this.$outer.intercept((Function0)new Serializable(this, iterator2){
                    public static final long serialVersionUID = 0L;
                    private final ClosingIterator iterator$2;

                    public final Map<String, AnyValue> apply() {
                        return this.iterator$2.next();
                    }
                    {
                        this.iterator$2 = iterator$2;
                    }
                }, ManifestFactory$.MODULE$.classType(RuntimeException.class));
                ((TaskCloser)Mockito.verify((Object)this.$outer.taskCloser())).close(false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("close runs cleanup", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClosingIteratorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Iterator wrapee = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k"), (Object)Values.intValue((int)42))})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k"), (Object)Values.intValue((int)43))}))}));
                ClosingIterator iterator2 = new ClosingIterator(wrapee, this.$outer.taskCloser(), this.$outer.exceptionDecorator());
                Map result2 = iterator2.next();
                iterator2.close();
                ((TaskCloser)Mockito.verify((Object)this.$outer.taskCloser())).close(true);
                this.$outer.convertToAnyShouldWrapper(result2).should(this.$outer.equal(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k"), (Object)Values.intValue((int)42))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

