/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compatibility.v3_3.runtime.commands;

import org.neo4j.cypher.internal.compatibility.v3_3.runtime.executionplan.MatchPattern;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.executionplan.MatchRelationship;
import org.neo4j.cypher.internal.frontend.v3_3.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t2A!\u0001\u0002\u0001'\t\u0001R*\u0019;dQB\u000bG\u000f^3s]R+7\u000f\u001e\u0006\u0003\u0007\u0011\t\u0001bY8n[\u0006tGm\u001d\u0006\u0003\u000b\u0019\tqA];oi&lWM\u0003\u0002\b\u0011\u0005!aoM04\u0015\tI!\"A\u0007d_6\u0004\u0018\r^5cS2LG/\u001f\u0006\u0003\u00171\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u001b9\taaY=qQ\u0016\u0014(BA\b\u0011\u0003\u0015qWm\u001c\u001bk\u0015\u0005\t\u0012aA8sO\u000e\u00011C\u0001\u0001\u0015!\t)2$D\u0001\u0017\u0015\t9\u0002$\u0001\u0007uKN$x\f[3ma\u0016\u00148O\u0003\u0002\b3)\u0011!DC\u0001\tMJ|g\u000e^3oI&\u0011AD\u0006\u0002\u000f\u0007f\u0004\b.\u001a:Gk:\u001cV/\u001b;f\u0011\u0015q\u0002\u0001\"\u0001 \u0003\u0019a\u0014N\\5u}Q\t\u0001\u0005\u0005\u0002\"\u00015\t!\u0001")
public class MatchPatternTest
extends CypherFunSuite {
    public MatchPatternTest() {
        this.test("should find disjoint graph with single nodes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatchPatternTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MatchPattern pattern = new MatchPattern((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A", "B"})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                this.$outer.convertToAnyShouldWrapper(pattern.disconnectedPatterns()).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MatchPattern[]{new MatchPattern((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), new MatchPattern((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"B"})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should be non empty if it contains a node", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatchPatternTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)new MatchPattern((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)).nonEmpty())).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should find single graph for simple rel", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatchPatternTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MatchPattern pattern = new MatchPattern((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A", "B"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MatchRelationship[]{new MatchRelationship((Option)None$.MODULE$, "A", "B")})));
                this.$outer.convertToAnyShouldWrapper(pattern.disconnectedPatterns()).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MatchPattern[]{pattern}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should find deeply nested disjoint graphs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatchPatternTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MatchPattern pattern = new MatchPattern((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A", "B", "C", "D"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MatchRelationship[]{new MatchRelationship((Option)None$.MODULE$, "A", "B"), new MatchRelationship((Option)None$.MODULE$, "B", "D")})));
                this.$outer.convertToAnyShouldWrapper(pattern.disconnectedPatterns()).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MatchPattern[]{new MatchPattern((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A", "B", "D"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MatchRelationship[]{new MatchRelationship((Option)None$.MODULE$, "A", "B"), new MatchRelationship((Option)None$.MODULE$, "B", "D")}))), new MatchPattern((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"C"})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should list subgraphs without specified points", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatchPatternTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MatchPattern pattern = new MatchPattern((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A", "B", "C"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MatchRelationship[]{new MatchRelationship((Option)None$.MODULE$, "A", "B")})));
                this.$outer.convertToAnyShouldWrapper(pattern.disconnectedPatternsWithout((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"B"})))).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MatchPattern[]{new MatchPattern((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"C"})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not consider patterns bound by relationships as unbounded", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatchPatternTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MatchPattern pattern = new MatchPattern((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A", "B"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MatchRelationship[]{new MatchRelationship((Option)new Some((Object)"r"), "A", "B")})));
                this.$outer.convertToAnyShouldWrapper(pattern.disconnectedPatternsWithout((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"r"})))).should(this.$outer.equal(Seq$.MODULE$.empty()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

