/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compatibility.v3_3.runtime.commands.expressions;

import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.ExecutionContext;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.ExecutionContext$;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.commands.expressions.ContainerIndex;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.commands.expressions.ContainerIndexTest$;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.commands.expressions.Expression;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.commands.expressions.ListLiteral;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.commands.expressions.Literal;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.pipes.QueryState;
import org.neo4j.cypher.internal.compiler.v3_3.QueryStateHelper$;
import org.neo4j.cypher.internal.frontend.v3_3.CypherTypeException;
import org.neo4j.cypher.internal.frontend.v3_3.InvalidArgumentException;
import org.neo4j.cypher.internal.frontend.v3_3.test_helpers.CypherFunSuite;
import org.neo4j.cypher.internal.spi.v3_3.Operations;
import org.neo4j.cypher.internal.spi.v3_3.QueryContext;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00014A!\u0001\u0002\u0001+\t\u00112i\u001c8uC&tWM]%oI\u0016DH+Z:u\u0015\t\u0019A!A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0003\u0007\u0003!\u0019w.\\7b]\u0012\u001c(BA\u0004\t\u0003\u001d\u0011XO\u001c;j[\u0016T!!\u0003\u0006\u0002\tY\u001ctl\r\u0006\u0003\u00171\tQbY8na\u0006$\u0018NY5mSRL(BA\u0007\u000f\u0003!Ig\u000e^3s]\u0006d'BA\b\u0011\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011\u0011CE\u0001\u0006]\u0016|GG\u001b\u0006\u0002'\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0006\t\u0003/ui\u0011\u0001\u0007\u0006\u00033i\tA\u0002^3ti~CW\r\u001c9feNT!!C\u000e\u000b\u0005qa\u0011\u0001\u00034s_:$XM\u001c3\n\u0005yA\"AD\"za\",'OR;o'VLG/\u001a\u0005\u0006A\u0001!\t!I\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\t\u0002\"a\t\u0001\u000e\u0003\tAq!\n\u0001C\u0002\u0013\u0005a%A\u0002rib,\u0012a\n\t\u0003Q1j\u0011!\u000b\u0006\u0003\u0013)R!a\u000b\u0007\u0002\u0007M\u0004\u0018.\u0003\u0002.S\ta\u0011+^3ss\u000e{g\u000e^3yi\"1q\u0006\u0001Q\u0001\n\u001d\nA!\u001d;yA!9\u0011\u0007\u0001b\u0001\n\u0007\u0011\u0014!B:uCR,W#A\u001a\u0011\u0005Q:T\"A\u001b\u000b\u0005Y2\u0011!\u00029ja\u0016\u001c\u0018B\u0001\u001d6\u0005)\tV/\u001a:z'R\fG/\u001a\u0005\u0007u\u0001\u0001\u000b\u0011B\u001a\u0002\rM$\u0018\r^3!\u0011\u001da\u0004A1A\u0005\u0002u\n1a\u0019;y+\u0005q\u0004CA A\u001b\u00051\u0011BA!\u0007\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH\u000f\u0003\u0004D\u0001\u0001\u0006IAP\u0001\u0005GRD\b\u0005C\u0004F\u0001\t\u0007I\u0011\u0001$\u0002\u0019\u0015D\b/Z2uK\u0012tU\u000f\u001c7\u0016\u0003\u001d\u0003\"\u0001S&\u000e\u0003%S!A\u0013\t\u0002\rY\fG.^3t\u0013\ta\u0015J\u0001\u0005B]f4\u0016\r\\;f\u0011\u0019q\u0005\u0001)A\u0005\u000f\u0006iQ\r\u001f9fGR,GMT;mY\u0002BQ\u0001\u0015\u0001\u0005\nE\u000b1!\u001b3y)\t\u0011\u0006\f\u0006\u0002H'\")Ak\u0014a\u0002+\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\u0011\u0005\r2\u0016BA,\u0003\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\u00063>\u0003\rAW\u0001\u0006m\u0006dW/\u001a\t\u00037zk\u0011\u0001\u0018\u0006\u0002;\u0006)1oY1mC&\u0011q\f\u0018\u0002\u0004\u0003:L\b")
public class ContainerIndexTest
extends CypherFunSuite {
    private final QueryContext qtx = (QueryContext)this.mock(ManifestFactory$.MODULE$.classType(QueryContext.class));
    private final QueryState state = QueryStateHelper$.MODULE$.empty().withQueryContext(this.qtx());
    private final ExecutionContext ctx = ExecutionContext$.MODULE$.empty();
    private final AnyValue expectedNull = Values.NO_VALUE;

    public QueryContext qtx() {
        return this.qtx;
    }

    public QueryState state() {
        return this.state;
    }

    public ExecutionContext ctx() {
        return this.ctx;
    }

    public AnyValue expectedNull() {
        return this.expectedNull;
    }

    public AnyValue org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ContainerIndexTest$$idx(Object value, Expression collection) {
        return new ContainerIndex(collection, (Expression)new Literal(value)).apply(this.ctx(), this.state());
    }

    public ContainerIndexTest() {
        this.test("handles collection lookup", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerIndexTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Literal collection = new Literal((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})));
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ContainerIndexTest$$idx(BoxesRunTime.boxToInteger((int)0), (Expression)collection)).should(this.$outer.equal(Values.longValue((long)1L)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ContainerIndexTest$$idx(BoxesRunTime.boxToInteger((int)1), (Expression)collection)).should(this.$outer.equal(Values.longValue((long)2L)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ContainerIndexTest$$idx(BoxesRunTime.boxToInteger((int)2), (Expression)collection)).should(this.$outer.equal(Values.longValue((long)3L)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ContainerIndexTest$$idx(BoxesRunTime.boxToInteger((int)3), (Expression)collection)).should(this.$outer.equal(Values.longValue((long)4L)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ContainerIndexTest$$idx(BoxesRunTime.boxToInteger((int)-1), (Expression)collection)).should(this.$outer.equal(Values.longValue((long)4L)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ContainerIndexTest$$idx(BoxesRunTime.boxToInteger((int)100), (Expression)collection)).should(this.$outer.equal(this.$outer.expectedNull()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("handles empty collections", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerIndexTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ListLiteral collection = new ListLiteral((Seq)Nil$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ContainerIndexTest$$idx(BoxesRunTime.boxToInteger((int)0), (Expression)collection)).should(this.$outer.equal(this.$outer.expectedNull()), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ContainerIndexTest$$idx(BoxesRunTime.boxToInteger((int)-1), (Expression)collection)).should(this.$outer.equal(this.$outer.expectedNull()), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ContainerIndexTest$$idx(BoxesRunTime.boxToInteger((int)100), (Expression)collection)).should(this.$outer.equal(this.$outer.expectedNull()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("handles nulls", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerIndexTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Literal collection = new Literal(null);
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ContainerIndexTest$$idx(BoxesRunTime.boxToInteger((int)0), (Expression)collection)).should(this.$outer.equal(this.$outer.expectedNull()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("handles scala map lookup", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerIndexTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Literal expression = new Literal((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"foo")})));
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ContainerIndexTest$$idx("a", (Expression)expression)).should(this.$outer.equal(Values.longValue((long)1L)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ContainerIndexTest$$idx("b", (Expression)expression)).should(this.$outer.equal(Values.stringValue((String)"foo")), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ContainerIndexTest$$idx("c", (Expression)expression)).should(this.$outer.equal(this.$outer.expectedNull()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("handles java map lookup", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerIndexTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Literal expression = new Literal(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"foo")}))).asJava());
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ContainerIndexTest$$idx("a", (Expression)expression)).should(this.$outer.equal(Values.longValue((long)1L)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ContainerIndexTest$$idx("b", (Expression)expression)).should(this.$outer.equal(Values.stringValue((String)"foo")), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ContainerIndexTest$$idx("c", (Expression)expression)).should(this.$outer.equal(this.$outer.expectedNull()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("handles node lookup", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerIndexTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Node node2 = (Node)this.$outer.mock(ManifestFactory$.MODULE$.classType(Node.class));
                Mockito.when((Object)BoxesRunTime.boxToLong((long)node2.getId())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
                Literal expression = new Literal((Object)node2);
                Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.$outer.qtx().getPropertyKeyId("v"))).thenReturn((Object)BoxesRunTime.boxToInteger((int)0));
                Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.$outer.qtx().getPropertyKeyId("c"))).thenReturn((Object)BoxesRunTime.boxToInteger((int)1));
                Operations nodeOps = (Operations)this.$outer.mock(ManifestFactory$.MODULE$.classType(Operations.class, ManifestFactory$.MODULE$.classType(Node.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
                Mockito.when((Object)nodeOps.getProperty(0L, 0)).thenAnswer((Answer)new Answer<Value>(this){

                    public Value answer(InvocationOnMock invocation) {
                        return Values.longValue((long)1L);
                    }
                });
                Mockito.when((Object)nodeOps.getProperty(0L, 1)).thenAnswer((Answer)new Answer<Value>(this){

                    public Value answer(InvocationOnMock invocation) {
                        return Values.NO_VALUE;
                    }
                });
                Mockito.when((Object)this.$outer.qtx().nodeOps()).thenReturn((Object)nodeOps);
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ContainerIndexTest$$idx("v", (Expression)expression)).should(this.$outer.equal(Values.longValue((long)1L)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ContainerIndexTest$$idx("c", (Expression)expression)).should(this.$outer.equal(this.$outer.expectedNull()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("handles relationship lookup", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerIndexTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Relationship rel = (Relationship)this.$outer.mock(ManifestFactory$.MODULE$.classType(Relationship.class));
                Mockito.when((Object)BoxesRunTime.boxToLong((long)rel.getId())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
                Literal expression = new Literal((Object)rel);
                Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.$outer.qtx().getPropertyKeyId("v"))).thenReturn((Object)BoxesRunTime.boxToInteger((int)0));
                Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.$outer.qtx().getPropertyKeyId("c"))).thenReturn((Object)BoxesRunTime.boxToInteger((int)1));
                Operations relOps = (Operations)this.$outer.mock(ManifestFactory$.MODULE$.classType(Operations.class, ManifestFactory$.MODULE$.classType(Relationship.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
                Mockito.when((Object)relOps.getProperty(0L, 0)).thenAnswer((Answer)new Answer<Value>(this){

                    public Value answer(InvocationOnMock invocation) {
                        return Values.longValue((long)1L);
                    }
                });
                Mockito.when((Object)relOps.getProperty(0L, 1)).thenAnswer((Answer)new Answer<Value>(this){

                    public Value answer(InvocationOnMock invocation) {
                        return Values.NO_VALUE;
                    }
                });
                Mockito.when((Object)this.$outer.qtx().relationshipOps()).thenReturn((Object)relOps);
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ContainerIndexTest$$idx("v", (Expression)expression)).should(this.$outer.equal(Values.longValue((long)1L)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ContainerIndexTest$$idx("c", (Expression)expression)).should(this.$outer.equal(this.$outer.expectedNull()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should fail when not integer values are passed", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerIndexTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Literal collection = new Literal((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})));
                this.$outer.a(ManifestFactory$.MODULE$.classType(CypherTypeException.class)).should(this.$outer.be()).thrownBy((Function0)new Serializable(this, collection){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;
                    private final Literal collection$1;

                    public final AnyValue apply() {
                        return this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ContainerIndexTest$$anonfun$$$outer().org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ContainerIndexTest$$idx(BoxesRunTime.boxToFloat((float)1.0f), (Expression)this.collection$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.collection$1 = collection$1;
                    }
                });
                this.$outer.a(ManifestFactory$.MODULE$.classType(CypherTypeException.class)).should(this.$outer.be()).thrownBy((Function0)new Serializable(this, collection){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;
                    private final Literal collection$1;

                    public final AnyValue apply() {
                        return this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ContainerIndexTest$$anonfun$$$outer().org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ContainerIndexTest$$idx(BoxesRunTime.boxToDouble((double)1.0), (Expression)this.collection$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.collection$1 = collection$1;
                    }
                });
                this.$outer.a(ManifestFactory$.MODULE$.classType(CypherTypeException.class)).should(this.$outer.be()).thrownBy((Function0)new Serializable(this, collection){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;
                    private final Literal collection$1;

                    public final AnyValue apply() {
                        return this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ContainerIndexTest$$anonfun$$$outer().org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ContainerIndexTest$$idx("bad value", (Expression)this.collection$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.collection$1 = collection$1;
                    }
                });
            }

            public /* synthetic */ ContainerIndexTest org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ContainerIndexTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should fail when too big values are used to access the array", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerIndexTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Literal collection = new Literal((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})));
                long index = 0x80000000L;
                this.$outer.an(ManifestFactory$.MODULE$.classType(InvalidArgumentException.class)).should(this.$outer.be()).thrownBy((Function0)new Serializable(this, collection, index){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$9 $outer;
                    private final Literal collection$2;
                    private final long index$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ContainerIndexTest$$anonfun$$$outer().org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ContainerIndexTest$$idx(BoxesRunTime.boxToLong((long)this.index$1), (Expression)this.collection$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.collection$2 = collection$2;
                        this.index$1 = index$1;
                    }
                });
            }

            public /* synthetic */ ContainerIndexTest org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ContainerIndexTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

