/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compatibility.v3_3.runtime.commands.expressions;

import org.mockito.Mockito;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.ImplicitValueConversion$;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.commands.expressions.PathImpl;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.commands.expressions.PathValueBuilder;
import org.neo4j.cypher.internal.frontend.v3_3.test_helpers.CypherFunSuite;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00194A!\u0001\u0002\u0001+\t!\u0002+\u0019;i-\u0006dW/\u001a\"vS2$WM\u001d+fgRT!a\u0001\u0003\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u000b\u0019\t\u0001bY8n[\u0006tGm\u001d\u0006\u0003\u000f!\tqA];oi&lWM\u0003\u0002\n\u0015\u0005!aoM04\u0015\tYA\"A\u0007d_6\u0004\u0018\r^5cS2LG/\u001f\u0006\u0003\u001b9\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u001fA\taaY=qQ\u0016\u0014(BA\t\u0013\u0003\u0015qWm\u001c\u001bk\u0015\u0005\u0019\u0012aA8sO\u000e\u00011C\u0001\u0001\u0017!\t9R$D\u0001\u0019\u0015\tI\"$\u0001\u0007uKN$x\f[3ma\u0016\u00148O\u0003\u0002\n7)\u0011A\u0004D\u0001\tMJ|g\u000e^3oI&\u0011a\u0004\u0007\u0002\u000f\u0007f\u0004\b.\u001a:Gk:\u001cV/\u001b;f\u0011\u0015\u0001\u0003\u0001\"\u0001\"\u0003\u0019a\u0014N\\5u}Q\t!\u0005\u0005\u0002$\u00015\t!\u0001C\u0004&\u0001\t\u0007I\u0011\u0001\u0014\u0002\u0003\u0005+\u0012a\n\t\u0003Q-j\u0011!\u000b\u0006\u0003UA\tqa\u001a:ba\"$'-\u0003\u0002-S\t!aj\u001c3f\u0011\u0019q\u0003\u0001)A\u0005O\u0005\u0011\u0011\t\t\u0005\ba\u0001\u0011\r\u0011\"\u0001'\u0003\u0005\u0011\u0005B\u0002\u001a\u0001A\u0003%q%\u0001\u0002CA!9A\u0007\u0001b\u0001\n\u00031\u0013!A\"\t\rY\u0002\u0001\u0015!\u0003(\u0003\t\u0019\u0005\u0005C\u00049\u0001\t\u0007I\u0011\u0001\u0014\u0002\u0003\u0011CaA\u000f\u0001!\u0002\u00139\u0013A\u0001#!\u0011\u001da\u0004A1A\u0005\u0002\u0019\n\u0011!\u0012\u0005\u0007}\u0001\u0001\u000b\u0011B\u0014\u0002\u0005\u0015\u0003\u0003b\u0002!\u0001\u0005\u0004%\t!Q\u0001\u0005e\u0016d\u0017'F\u0001C!\tA3)\u0003\u0002ES\ta!+\u001a7bi&|gn\u001d5ja\"1a\t\u0001Q\u0001\n\t\u000bQA]3mc\u0001Bq\u0001\u0013\u0001C\u0002\u0013\u0005\u0011)\u0001\u0003sK2\u0014\u0004B\u0002&\u0001A\u0003%!)A\u0003sK2\u0014\u0004\u0005C\u0004M\u0001\t\u0007I\u0011A!\u0002\tI,Gn\r\u0005\u0007\u001d\u0002\u0001\u000b\u0011\u0002\"\u0002\u000bI,Gn\r\u0011\t\u000fA\u0003!\u0019!C\u0001\u0003\u0006!!/\u001a75\u0011\u0019\u0011\u0006\u0001)A\u0005\u0005\u0006)!/\u001a75A!)A\u000b\u0001C\u0005+\u0006\u0011Rn\\2lK\u0012\u0014V\r\\1uS>t7\u000f[5q)\u0011\u0011eK\u00181\t\u000b]\u001b\u0006\u0019\u0001-\u0002\u0005%$\u0007CA-]\u001b\u0005Q&\"A.\u0002\u000bM\u001c\u0017\r\\1\n\u0005uS&\u0001\u0002'p]\u001eDQaX*A\u0002\u001d\nQa\u001d;beRDQ!Y*A\u0002\u001d\n1!\u001a8e\u0011\u0015\u0019\u0007\u0001\"\u0003e\u0003)iwnY6fI:{G-\u001a\u000b\u0003O\u0015DQa\u00162A\u0002a\u0003")
public class PathValueBuilderTest
extends CypherFunSuite {
    private final Node A = this.mockedNode(1L);
    private final Node B = this.mockedNode(2L);
    private final Node C = this.mockedNode(3L);
    private final Node D = this.mockedNode(4L);
    private final Node E = this.mockedNode(5L);
    private final Relationship rel1 = this.mockedRelationship(1L, this.A(), this.B());
    private final Relationship rel2 = this.mockedRelationship(2L, this.B(), this.C());
    private final Relationship rel3 = this.mockedRelationship(3L, this.C(), this.D());
    private final Relationship rel4 = this.mockedRelationship(3L, this.D(), this.E());

    public Node A() {
        return this.A;
    }

    public Node B() {
        return this.B;
    }

    public Node C() {
        return this.C;
    }

    public Node D() {
        return this.D;
    }

    public Node E() {
        return this.E;
    }

    public Relationship rel1() {
        return this.rel1;
    }

    public Relationship rel2() {
        return this.rel2;
    }

    public Relationship rel3() {
        return this.rel3;
    }

    public Relationship rel4() {
        return this.rel4;
    }

    private Relationship mockedRelationship(long id, Node start, Node end) {
        Relationship rel = (Relationship)this.mock(ManifestFactory$.MODULE$.classType(Relationship.class));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)rel.getId())).thenReturn((Object)BoxesRunTime.boxToLong((long)id));
        Mockito.when((Object)rel.getStartNode()).thenReturn((Object)start);
        Mockito.when((Object)rel.getEndNode()).thenReturn((Object)end);
        Mockito.when((Object)rel.getType()).thenReturn((Object)RelationshipType.withName((String)"X"));
        Mockito.when((Object)rel.getOtherNode(start)).thenReturn((Object)end);
        Mockito.when((Object)rel.getOtherNode(end)).thenReturn((Object)start);
        return rel;
    }

    /*
     * WARNING - void declaration
     */
    private Node mockedNode(long id) {
        void var3_2;
        Node node2 = (Node)this.mock(ManifestFactory$.MODULE$.classType(Node.class));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)node2.getId())).thenReturn((Object)BoxesRunTime.boxToLong((long)id));
        return var3_2;
    }

    public PathValueBuilderTest() {
        this.test("p = (a)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(ImplicitValueConversion$.MODULE$.toNodeValue(this.$outer.A()));
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(ValueUtils.fromPath((Path)new PathImpl((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyContainer[]{this.$outer.A()})))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (a)-[r:X]->(b)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(ImplicitValueConversion$.MODULE$.toNodeValue(this.$outer.A())).addOutgoingRelationship(ImplicitValueConversion$.MODULE$.toEdgeValue(this.$outer.rel1()));
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(ValueUtils.fromPath((Path)new PathImpl((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyContainer[]{this.$outer.A(), this.$outer.rel1(), this.$outer.B()})))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (b)<-[r:X]-(a)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(ImplicitValueConversion$.MODULE$.toNodeValue(this.$outer.B())).addIncomingRelationship(ImplicitValueConversion$.MODULE$.toEdgeValue(this.$outer.rel1()));
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(ValueUtils.fromPath((Path)new PathImpl((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyContainer[]{this.$outer.B(), this.$outer.rel1(), this.$outer.A()})))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (a)-[r:X]-(b)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(ImplicitValueConversion$.MODULE$.toNodeValue(this.$outer.A())).addUndirectedRelationship(ImplicitValueConversion$.MODULE$.toEdgeValue(this.$outer.rel1()));
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(ValueUtils.fromPath((Path)new PathImpl((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyContainer[]{this.$outer.A(), this.$outer.rel1(), this.$outer.B()})))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (b)-[r:X]-(a)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(ImplicitValueConversion$.MODULE$.toNodeValue(this.$outer.B())).addUndirectedRelationship(ImplicitValueConversion$.MODULE$.toEdgeValue(this.$outer.rel1()));
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(ValueUtils.fromPath((Path)new PathImpl((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyContainer[]{this.$outer.B(), this.$outer.rel1(), this.$outer.A()})))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("p = <empty> should throw", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                this.$outer.evaluating((Function0)new Serializable(this, builder){
                    public static final long serialVersionUID = 0L;
                    private final PathValueBuilder builder$1;

                    public final AnyValue apply() {
                        return this.builder$1.result();
                    }
                    {
                        this.builder$1 = builder$1;
                    }
                }).should(this.$outer.produce(ManifestFactory$.MODULE$.classType(IllegalArgumentException.class)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (a)-[r:X*]->(b)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(ImplicitValueConversion$.MODULE$.toNodeValue(this.$outer.A())).addOutgoingRelationships(ImplicitValueConversion$.MODULE$.toListValue((TraversableOnce)package$.MODULE$.Iterable().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.rel1(), this.$outer.rel2()}))));
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(ValueUtils.fromPath((Path)new PathImpl((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyContainer[]{this.$outer.A(), this.$outer.rel1(), this.$outer.B(), this.$outer.rel2(), this.$outer.C()})))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (a)-[r:X*]->(b) when rels is null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(ImplicitValueConversion$.MODULE$.toNodeValue(this.$outer.A())).addOutgoingRelationships(null);
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(Values.NO_VALUE), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (a)-[r:X]->(b)--(c)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(ImplicitValueConversion$.MODULE$.toNodeValue(this.$outer.A())).addOutgoingRelationship(ImplicitValueConversion$.MODULE$.toEdgeValue(this.$outer.rel1())).addUndirectedRelationship(ImplicitValueConversion$.MODULE$.toEdgeValue(this.$outer.rel2()));
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(ValueUtils.fromPath((Path)new PathImpl((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyContainer[]{this.$outer.A(), this.$outer.rel1(), this.$outer.B(), this.$outer.rel2(), this.$outer.C()})))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (b)<-[r:X*]-(a)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(ImplicitValueConversion$.MODULE$.toNodeValue(this.$outer.C())).addIncomingRelationships(ImplicitValueConversion$.MODULE$.toListValue((TraversableOnce)package$.MODULE$.Iterable().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.rel2(), this.$outer.rel1()}))));
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(ValueUtils.fromPath((Path)new PathImpl((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyContainer[]{this.$outer.C(), this.$outer.rel2(), this.$outer.B(), this.$outer.rel1(), this.$outer.A()})))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (b)<-[r:X*]-(a) when rels is null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(ImplicitValueConversion$.MODULE$.toNodeValue(this.$outer.A())).addIncomingRelationships(null);
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(Values.NO_VALUE), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (b)-[r:X*]-(a)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(ImplicitValueConversion$.MODULE$.toNodeValue(this.$outer.C())).addUndirectedRelationships(ImplicitValueConversion$.MODULE$.toListValue((TraversableOnce)package$.MODULE$.Iterable().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.rel2(), this.$outer.rel1()}))));
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(ValueUtils.fromPath((Path)new PathImpl((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyContainer[]{this.$outer.C(), this.$outer.rel2(), this.$outer.B(), this.$outer.rel1(), this.$outer.A()})))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (b)-[r:X*]-(a) reversed", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(ImplicitValueConversion$.MODULE$.toNodeValue(this.$outer.C())).addUndirectedRelationships(ImplicitValueConversion$.MODULE$.toListValue((TraversableOnce)package$.MODULE$.Iterable().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.rel1(), this.$outer.rel2()}))));
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(ValueUtils.fromPath((Path)new PathImpl((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyContainer[]{this.$outer.C(), this.$outer.rel2(), this.$outer.B(), this.$outer.rel1(), this.$outer.A()})))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (a)-[r1*]-()-[r2*]-()", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(ImplicitValueConversion$.MODULE$.toNodeValue(this.$outer.A())).addUndirectedRelationships(ImplicitValueConversion$.MODULE$.toListValue((TraversableOnce)package$.MODULE$.Iterable().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.rel1(), this.$outer.rel2()})))).addUndirectedRelationships(ImplicitValueConversion$.MODULE$.toListValue((TraversableOnce)package$.MODULE$.Iterable().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.rel3(), this.$outer.rel4()}))));
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(ValueUtils.fromPath((Path)new PathImpl((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyContainer[]{this.$outer.A(), this.$outer.rel1(), this.$outer.B(), this.$outer.rel2(), this.$outer.C(), this.$outer.rel3(), this.$outer.D(), this.$outer.rel4(), this.$outer.E()})))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (a)-[r1*]-()-[r2*]-() reversed r1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(ImplicitValueConversion$.MODULE$.toNodeValue(this.$outer.A())).addUndirectedRelationships(ImplicitValueConversion$.MODULE$.toListValue((TraversableOnce)package$.MODULE$.Iterable().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.rel2(), this.$outer.rel1()})))).addUndirectedRelationships(ImplicitValueConversion$.MODULE$.toListValue((TraversableOnce)package$.MODULE$.Iterable().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.rel3(), this.$outer.rel4()}))));
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(ValueUtils.fromPath((Path)new PathImpl((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyContainer[]{this.$outer.A(), this.$outer.rel1(), this.$outer.B(), this.$outer.rel2(), this.$outer.C(), this.$outer.rel3(), this.$outer.D(), this.$outer.rel4(), this.$outer.E()})))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (a)-[r1*]-()-[r2*]-() reversed r2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(ImplicitValueConversion$.MODULE$.toNodeValue(this.$outer.A())).addUndirectedRelationships(ImplicitValueConversion$.MODULE$.toListValue((TraversableOnce)package$.MODULE$.Iterable().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.rel1(), this.$outer.rel2()})))).addUndirectedRelationships(ImplicitValueConversion$.MODULE$.toListValue((TraversableOnce)package$.MODULE$.Iterable().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.rel4(), this.$outer.rel3()}))));
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(ValueUtils.fromPath((Path)new PathImpl((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyContainer[]{this.$outer.A(), this.$outer.rel1(), this.$outer.B(), this.$outer.rel2(), this.$outer.C(), this.$outer.rel3(), this.$outer.D(), this.$outer.rel4(), this.$outer.E()})))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (a)-[r1*]-()-[r2*]-() reversed r1 && r2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(ImplicitValueConversion$.MODULE$.toNodeValue(this.$outer.A())).addUndirectedRelationships(ImplicitValueConversion$.MODULE$.toListValue((TraversableOnce)package$.MODULE$.Iterable().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.rel2(), this.$outer.rel1()})))).addUndirectedRelationships(ImplicitValueConversion$.MODULE$.toListValue((TraversableOnce)package$.MODULE$.Iterable().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.rel4(), this.$outer.rel3()}))));
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(ValueUtils.fromPath((Path)new PathImpl((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyContainer[]{this.$outer.A(), this.$outer.rel1(), this.$outer.B(), this.$outer.rel2(), this.$outer.C(), this.$outer.rel3(), this.$outer.D(), this.$outer.rel4(), this.$outer.E()})))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (b)-[r:X*0]-(a)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(ImplicitValueConversion$.MODULE$.toNodeValue(this.$outer.C())).addUndirectedRelationships(ImplicitValueConversion$.MODULE$.toListValue((TraversableOnce)package$.MODULE$.Iterable().apply((Seq)Nil$.MODULE$)));
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(ValueUtils.fromPath((Path)new PathImpl((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyContainer[]{this.$outer.C()})))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (b)-[r:X*]-(a) when rels is null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(ImplicitValueConversion$.MODULE$.toNodeValue(this.$outer.A())).addUndirectedRelationships(null);
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(Values.NO_VALUE), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (a) when single node is null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                AnyValue result2 = builder.addNode(null).result();
                this.$outer.convertToAnyShouldWrapper(result2).should(this.$outer.equal(Values.NO_VALUE), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (a) when single node is null also for mutable builder", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(null);
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(Values.NO_VALUE), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (a)-[r]->(b) when relationship is null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                AnyValue result2 = builder.addNode(ImplicitValueConversion$.MODULE$.toNodeValue(this.$outer.A())).addIncomingRelationship(null).result();
                this.$outer.convertToAnyShouldWrapper(result2).should(this.$outer.equal(Values.NO_VALUE), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

