/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compatibility.v3_3.runtime.commands.expressions;

import java.util.HashMap;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.ExecutionContext$;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.commands.expressions.Expression;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.commands.expressions.Literal;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.commands.expressions.PropertiesFunction;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.commands.expressions.PropertiesFunctionTest$;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.pipes.QueryStateHelper$;
import org.neo4j.cypher.internal.frontend.v3_3.CypherTypeException;
import org.neo4j.cypher.internal.frontend.v3_3.test_helpers.CypherFunSuite;
import org.neo4j.cypher.internal.spi.v3_3.Operations;
import org.neo4j.cypher.internal.spi.v3_3.QueryContext;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.VirtualValues;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001a3A!\u0001\u0002\u0001+\t1\u0002K]8qKJ$\u0018.Z:Gk:\u001cG/[8o)\u0016\u001cHO\u0003\u0002\u0004\t\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t)a!\u0001\u0005d_6l\u0017M\u001c3t\u0015\t9\u0001\"A\u0004sk:$\u0018.\\3\u000b\u0005%Q\u0011\u0001\u0002<4?NR!a\u0003\u0007\u0002\u001b\r|W\u000e]1uS\nLG.\u001b;z\u0015\tia\"\u0001\u0005j]R,'O\\1m\u0015\ty\u0001#\u0001\u0004dsBDWM\u001d\u0006\u0003#I\tQA\\3pi)T\u0011aE\u0001\u0004_J<7\u0001A\n\u0003\u0001Y\u0001\"aF\u000f\u000e\u0003aQ!!\u0007\u000e\u0002\u0019Q,7\u000f^0iK2\u0004XM]:\u000b\u0005%Y\"B\u0001\u000f\r\u0003!1'o\u001c8uK:$\u0017B\u0001\u0010\u0019\u00059\u0019\u0015\u0010\u001d5fe\u001a+hnU;ji\u0016DQ\u0001\t\u0001\u0005\u0002\u0005\na\u0001P5oSRtD#\u0001\u0012\u0011\u0005\r\u0002Q\"\u0001\u0002\t\u000f\u0015\u0002!\u0019!C\u0001M\u0005)\u0011/^3ssV\tq\u0005\u0005\u0002)Y5\t\u0011F\u0003\u0002\nU)\u00111\u0006D\u0001\u0004gBL\u0017BA\u0017*\u00051\tV/\u001a:z\u0007>tG/\u001a=u\u0011\u0019y\u0003\u0001)A\u0005O\u00051\u0011/^3ss\u0002Bq!\r\u0001C\u0002\u0013\u0005!'A\u0004o_\u0012,w\n]:\u0016\u0003M\u00022\u0001\u000b\u001b7\u0013\t)\u0014F\u0001\u0006Pa\u0016\u0014\u0018\r^5p]N\u0004\"a\u000e\u001e\u000e\u0003aR!!\u000f\t\u0002\u000f\u001d\u0014\u0018\r\u001d5eE&\u00111\b\u000f\u0002\u0005\u001d>$W\r\u0003\u0004>\u0001\u0001\u0006IaM\u0001\t]>$Wm\u00149tA!9q\b\u0001b\u0001\n\u0003\u0001\u0015A\u0002:fY>\u00038/F\u0001B!\rACG\u0011\t\u0003o\rK!\u0001\u0012\u001d\u0003\u0019I+G.\u0019;j_:\u001c\b.\u001b9\t\r\u0019\u0003\u0001\u0015!\u0003B\u0003\u001d\u0011X\r\\(qg\u0002BQ\u0001\u0013\u0001\u0005\n%\u000b!\u0002\u001d:pa\u0016\u0014H/[3t)\tQ\u0005\u000b\u0005\u0002L\u001d6\tAJ\u0003\u0002N!\u00051a/\u00197vKNL!a\u0014'\u0003\u0011\u0005s\u0017PV1mk\u0016DQ!U$A\u0002I\u000bAa\u001c:jOB\u00111KV\u0007\u0002)*\tQ+A\u0003tG\u0006d\u0017-\u0003\u0002X)\n\u0019\u0011I\\=")
public class PropertiesFunctionTest
extends CypherFunSuite {
    private final QueryContext query = (QueryContext)this.mock(ManifestFactory$.MODULE$.classType(QueryContext.class));
    private final Operations<Node> nodeOps = (Operations)this.mock(ManifestFactory$.MODULE$.classType(Operations.class, ManifestFactory$.MODULE$.classType(Node.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
    private final Operations<Relationship> relOps = (Operations)this.mock(ManifestFactory$.MODULE$.classType(Operations.class, ManifestFactory$.MODULE$.classType(Relationship.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));

    public QueryContext query() {
        return this.query;
    }

    public Operations<Node> nodeOps() {
        return this.nodeOps;
    }

    public Operations<Relationship> relOps() {
        return this.relOps;
    }

    public AnyValue org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$PropertiesFunctionTest$$properties(Object orig) {
        return new PropertiesFunction((Expression)new Literal(orig)).apply(ExecutionContext$.MODULE$.empty(), QueryStateHelper$.MODULE$.empty().withQueryContext(this.query()));
    }

    public PropertiesFunctionTest() {
        Mockito.when((Object)this.query().nodeOps()).thenReturn(this.nodeOps());
        Mockito.when((Object)this.query().relationshipOps()).thenReturn(this.relOps());
        this.test("should return null if argument is null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PropertiesFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$PropertiesFunctionTest$$properties(null)).should(this.$outer.be().apply((Object)Values.NO_VALUE));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should map Java maps to maps", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PropertiesFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                HashMap<String, String> m = new HashMap<String, String>();
                m.put("a", "x");
                m.put("b", "y");
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$PropertiesFunctionTest$$properties(m)).should(this.$outer.equal(VirtualValues.map((String[])((String[])((Object[])new String[]{"a", "b"})), (AnyValue[])((AnyValue[])((Object[])new AnyValue[]{Values.stringValue((String)"x"), Values.stringValue((String)"y")})))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should map Scala maps to maps", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PropertiesFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Map m = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"x"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"y")}));
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$PropertiesFunctionTest$$properties(m)).should(this.$outer.equal(VirtualValues.map((String[])((String[])((Object[])new String[]{"a", "b"})), (AnyValue[])((AnyValue[])((Object[])new AnyValue[]{Values.stringValue((String)"x"), Values.stringValue((String)"y")})))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should map nodes to maps", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PropertiesFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Node node2 = (Node)this.$outer.mock(ManifestFactory$.MODULE$.classType(Node.class));
                Mockito.when((Object)BoxesRunTime.boxToLong((long)node2.getId())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
                Mockito.when((Object)this.$outer.nodeOps().propertyKeyIds(BoxesRunTime.unboxToLong((Object)Matchers.any()))).thenAnswer((Answer)new Answer<Iterator<Object>>(this){

                    public Iterator<Object> answer(InvocationOnMock invocationOnMock) {
                        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})).iterator();
                    }
                });
                Mockito.when((Object)this.$outer.query().getPropertyKeyName(0)).thenReturn((Object)"a");
                Mockito.when((Object)this.$outer.query().getPropertyKeyName(1)).thenReturn((Object)"b");
                Mockito.when((Object)this.$outer.nodeOps().getProperty(0L, 0)).thenReturn((Object)Values.stringValue((String)"x"));
                Mockito.when((Object)this.$outer.nodeOps().getProperty(0L, 1)).thenReturn((Object)Values.stringValue((String)"y"));
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$PropertiesFunctionTest$$properties(node2)).should(this.$outer.equal(VirtualValues.map((String[])((String[])((Object[])new String[]{"a", "b"})), (AnyValue[])((AnyValue[])((Object[])new AnyValue[]{Values.stringValue((String)"x"), Values.stringValue((String)"y")})))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should map relationships to maps", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PropertiesFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Relationship rel = (Relationship)this.$outer.mock(ManifestFactory$.MODULE$.classType(Relationship.class));
                Mockito.when((Object)BoxesRunTime.boxToLong((long)rel.getId())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
                Mockito.when((Object)BoxesRunTime.boxToLong((long)rel.getId())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
                Mockito.when((Object)this.$outer.relOps().propertyKeyIds(BoxesRunTime.unboxToLong((Object)Matchers.any()))).thenAnswer((Answer)new Answer<Iterator<Object>>(this){

                    public Iterator<Object> answer(InvocationOnMock invocationOnMock) {
                        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})).iterator();
                    }
                });
                Mockito.when((Object)this.$outer.query().getPropertyKeyName(0)).thenReturn((Object)"a");
                Mockito.when((Object)this.$outer.query().getPropertyKeyName(1)).thenReturn((Object)"b");
                Mockito.when((Object)this.$outer.relOps().getProperty(0L, 0)).thenReturn((Object)Values.stringValue((String)"x"));
                Mockito.when((Object)this.$outer.relOps().getProperty(0L, 1)).thenReturn((Object)Values.stringValue((String)"y"));
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$PropertiesFunctionTest$$properties(rel)).should(this.$outer.equal(VirtualValues.map((String[])((String[])((Object[])new String[]{"a", "b"})), (AnyValue[])((AnyValue[])((Object[])new AnyValue[]{Values.stringValue((String)"x"), Values.stringValue((String)"y")})))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should fail trying to map an int", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PropertiesFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.a(ManifestFactory$.MODULE$.classType(CypherTypeException.class)).should(this.$outer.be()).thrownBy((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;

                    public final AnyValue apply() {
                        return this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$PropertiesFunctionTest$$anonfun$$$outer().org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$PropertiesFunctionTest$$properties(BoxesRunTime.boxToInteger((int)12));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ PropertiesFunctionTest org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$PropertiesFunctionTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should fail trying to map a string", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PropertiesFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.a(ManifestFactory$.MODULE$.classType(CypherTypeException.class)).should(this.$outer.be()).thrownBy((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;

                    public final AnyValue apply() {
                        return this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$PropertiesFunctionTest$$anonfun$$$outer().org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$PropertiesFunctionTest$$properties("Hullo");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ PropertiesFunctionTest org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$PropertiesFunctionTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should fail trying to map a list", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PropertiesFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.a(ManifestFactory$.MODULE$.classType(CypherTypeException.class)).should(this.$outer.be()).thrownBy((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;

                    public final AnyValue apply() {
                        return this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$PropertiesFunctionTest$$anonfun$$$outer().org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$PropertiesFunctionTest$$properties(List$.MODULE$.empty());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ PropertiesFunctionTest org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$PropertiesFunctionTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

