/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compatibility.v3_3.runtime.commands.expressions;

import org.neo4j.cypher.internal.compatibility.v3_3.runtime.ExecutionContext$;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.commands.expressions.Expression;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.commands.expressions.Literal;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.commands.expressions.ToFloatFunction;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.commands.expressions.ToFloatFunctionTest$;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.pipes.QueryStateHelper$;
import org.neo4j.cypher.internal.frontend.v3_3.ParameterWrongTypeException;
import org.neo4j.cypher.internal.frontend.v3_3.test_helpers.CypherFunSuite;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001U2A!\u0001\u0002\u0001+\t\u0019Bk\u001c$m_\u0006$h)\u001e8di&|g\u000eV3ti*\u00111\u0001B\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u0006\r\u0005A1m\\7nC:$7O\u0003\u0002\b\u0011\u00059!/\u001e8uS6,'BA\u0005\u000b\u0003\u001118gX\u001a\u000b\u0005-a\u0011!D2p[B\fG/\u001b2jY&$\u0018P\u0003\u0002\u000e\u001d\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\u0010!\u000511-\u001f9iKJT!!\u0005\n\u0002\u000b9,w\u000e\u000e6\u000b\u0003M\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\f\u0011\u0005]iR\"\u0001\r\u000b\u0005eQ\u0012\u0001\u0004;fgR|\u0006.\u001a7qKJ\u001c(BA\u0005\u001c\u0015\taB\"\u0001\u0005ge>tG/\u001a8e\u0013\tq\u0002D\u0001\bDsBDWM\u001d$v]N+\u0018\u000e^3\t\u000b\u0001\u0002A\u0011A\u0011\u0002\rqJg.\u001b;?)\u0005\u0011\u0003CA\u0012\u0001\u001b\u0005\u0011\u0001\"B\u0013\u0001\t\u00131\u0013a\u0002;p\r2|\u0017\r\u001e\u000b\u0003O5\u0002\"\u0001K\u0016\u000e\u0003%R!A\u000b\t\u0002\rY\fG.^3t\u0013\ta\u0013F\u0001\u0005B]f4\u0016\r\\;f\u0011\u0015qC\u00051\u00010\u0003\u0011y'/[4\u0011\u0005A\u001aT\"A\u0019\u000b\u0003I\nQa]2bY\u0006L!\u0001N\u0019\u0003\u0007\u0005s\u0017\u0010")
public class ToFloatFunctionTest
extends CypherFunSuite {
    public AnyValue org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToFloatFunctionTest$$toFloat(Object orig) {
        return new ToFloatFunction((Expression)new Literal(orig)).apply(ExecutionContext$.MODULE$.empty(), QueryStateHelper$.MODULE$.empty());
    }

    public ToFloatFunctionTest() {
        this.test("should return null if argument is null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToFloatFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToFloatFunctionTest$$toFloat(null));
                Value $org_scalatest_assert_macro_right = Values.NO_VALUE;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert a string to a float", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToFloatFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToFloatFunctionTest$$toFloat("10.599")).should(this.$outer.be().apply((Object)Values.doubleValue((double)10.599)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert an integer string to a float", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToFloatFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToFloatFunctionTest$$toFloat("21")).should(this.$outer.be().apply((Object)Values.doubleValue((double)21.0)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert an integer to a float", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToFloatFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToFloatFunctionTest$$toFloat(BoxesRunTime.boxToInteger((int)23))).should(this.$outer.be().apply((Object)Values.doubleValue((double)23.0)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should return null if the argument is a partially numeric string", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToFloatFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToFloatFunctionTest$$toFloat("20foobar2"));
                Value $org_scalatest_assert_macro_right = Values.NO_VALUE;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert a string with leading zeros to a float", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToFloatFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToFloatFunctionTest$$toFloat("000123121.5")).should(this.$outer.be().apply((Object)Values.doubleValue((double)123121.5)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert a string with leading minus to a negative float", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToFloatFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToFloatFunctionTest$$toFloat("-12.66")).should(this.$outer.be().apply((Object)Values.doubleValue((double)-12.66)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert a string with leading minus and zeros to a negative float", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToFloatFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToFloatFunctionTest$$toFloat("-00012.91")).should(this.$outer.be().apply((Object)Values.doubleValue((double)-12.91)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should throw an exception if the argument is an object which cannot be converted to a float", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToFloatFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ParameterWrongTypeException caughtException = (ParameterWrongTypeException)this.$outer.evaluating((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$9 $outer;

                    public final AnyValue apply() {
                        return this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToFloatFunctionTest$$anonfun$$$outer().org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToFloatFunctionTest$$toFloat(BoxesRunTime.boxToBoolean((boolean)true));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).should(this.$outer.produce(ManifestFactory$.MODULE$.classType(ParameterWrongTypeException.class)));
                this.$outer.convertToStringShouldWrapper(caughtException.getMessage()).should(this.$outer.startWith().apply("Expected a String or Number, got: "));
            }

            public /* synthetic */ ToFloatFunctionTest org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToFloatFunctionTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("given a float should give the same value back", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToFloatFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToFloatFunctionTest$$toFloat(BoxesRunTime.boxToDouble((double)50.5))).should(this.$outer.be().apply((Object)Values.doubleValue((double)50.5)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

