/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compatibility.v3_3.runtime.commands.expressions;

import org.neo4j.cypher.internal.compatibility.v3_3.runtime.ExecutionContext$;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.commands.expressions.Expression;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.commands.expressions.Literal;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.commands.expressions.ToIntegerFunction;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.commands.expressions.ToIntegerFunctionTest$;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.pipes.QueryStateHelper$;
import org.neo4j.cypher.internal.frontend.v3_3.CypherTypeException;
import org.neo4j.cypher.internal.frontend.v3_3.ParameterWrongTypeException;
import org.neo4j.cypher.internal.frontend.v3_3.test_helpers.CypherFunSuite;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001U2A!\u0001\u0002\u0001+\t)Bk\\%oi\u0016<WM\u001d$v]\u000e$\u0018n\u001c8UKN$(BA\u0002\u0005\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u00151\u0011\u0001C2p[6\fg\u000eZ:\u000b\u0005\u001dA\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u0013)\tAA^\u001a`g)\u00111\u0002D\u0001\u000eG>l\u0007/\u0019;jE&d\u0017\u000e^=\u000b\u00055q\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005=\u0001\u0012AB2za\",'O\u0003\u0002\u0012%\u0005)a.Z85U*\t1#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001-A\u0011q#H\u0007\u00021)\u0011\u0011DG\u0001\ri\u0016\u001cHo\u00185fYB,'o\u001d\u0006\u0003\u0013mQ!\u0001\b\u0007\u0002\u0011\u0019\u0014xN\u001c;f]\u0012L!A\b\r\u0003\u001d\rK\b\u000f[3s\rVt7+^5uK\")\u0001\u0005\u0001C\u0001C\u00051A(\u001b8jiz\"\u0012A\t\t\u0003G\u0001i\u0011A\u0001\u0005\u0006K\u0001!IAJ\u0001\ni>Le\u000e^3hKJ$\"aJ\u0017\u0011\u0005!ZS\"A\u0015\u000b\u0005)\u0002\u0012A\u0002<bYV,7/\u0003\u0002-S\tA\u0011I\\=WC2,X\rC\u0003/I\u0001\u0007q&\u0001\u0003pe&<\u0007C\u0001\u00194\u001b\u0005\t$\"\u0001\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\n$aA!os\u0002")
public class ToIntegerFunctionTest
extends CypherFunSuite {
    public AnyValue org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToIntegerFunctionTest$$toInteger(Object orig) {
        return new ToIntegerFunction((Expression)new Literal(orig)).apply(ExecutionContext$.MODULE$.empty(), QueryStateHelper$.MODULE$.empty());
    }

    public ToIntegerFunctionTest() {
        this.test("should return null if argument is null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntegerFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToIntegerFunctionTest$$toInteger(null));
                Value $org_scalatest_assert_macro_right = Values.NO_VALUE;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert a string to an integer", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntegerFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToIntegerFunctionTest$$toInteger("10")).should(this.$outer.equal(Values.longValue((long)10L)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert a double to an integer", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntegerFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToIntegerFunctionTest$$toInteger(BoxesRunTime.boxToDouble((double)23.5))).should(this.$outer.equal(Values.longValue((long)23L)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should parse float and truncate to int if the argument is a float literal", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntegerFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToIntegerFunctionTest$$toInteger("20.5")).should(this.$outer.equal(Values.longValue((long)20L)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should return null if the argument is a partially numeric string", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntegerFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToIntegerFunctionTest$$toInteger("20foobar2"));
                Value $org_scalatest_assert_macro_right = Values.NO_VALUE;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should return null if the argument is a hexadecimal string", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntegerFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToIntegerFunctionTest$$toInteger("0x20"));
                Value $org_scalatest_assert_macro_right = Values.NO_VALUE;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert a string with leading zeros to an integer", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntegerFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToIntegerFunctionTest$$toInteger("000123121")).should(this.$outer.equal(Values.longValue((long)123121L)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert a string with leading minus in a negative integer", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntegerFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToIntegerFunctionTest$$toInteger("-12")).should(this.$outer.equal(Values.longValue((long)-12L)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert a string with leading minus and zeros in a negative integer", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntegerFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToIntegerFunctionTest$$toInteger("-00012")).should(this.$outer.equal(Values.longValue((long)-12L)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should throw an exception if the argument is an object which cannot be converted to integer", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntegerFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ParameterWrongTypeException caughtException = (ParameterWrongTypeException)this.$outer.evaluating((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$10 $outer;

                    public final AnyValue apply() {
                        return this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToIntegerFunctionTest$$anonfun$$$outer().org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToIntegerFunctionTest$$toInteger(BoxesRunTime.boxToBoolean((boolean)true));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).should(this.$outer.produce(ManifestFactory$.MODULE$.classType(ParameterWrongTypeException.class)));
                this.$outer.convertToStringShouldWrapper(caughtException.getMessage()).should(this.$outer.startWith().apply("Expected a String or Number, got: "));
            }

            public /* synthetic */ ToIntegerFunctionTest org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToIntegerFunctionTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("given an integer should give the same value back", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntegerFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToIntegerFunctionTest$$toInteger(BoxesRunTime.boxToInteger((int)50))).should(this.$outer.equal(Values.longValue((long)50L)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should truncate floats if given a float", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntegerFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToIntegerFunctionTest$$toInteger(BoxesRunTime.boxToFloat((float)20.6f))).should(this.$outer.equal(Values.longValue((long)20L)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should fail for larger integers larger that 8 bytes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntegerFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                CypherTypeException caughtException = (CypherTypeException)this.$outer.evaluating((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$13 $outer;

                    public final AnyValue apply() {
                        return this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToIntegerFunctionTest$$anonfun$$$outer().org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToIntegerFunctionTest$$toInteger("10508455564958384115");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).should(this.$outer.produce(ManifestFactory$.MODULE$.classType(CypherTypeException.class)));
                this.$outer.convertToStringShouldWrapper(caughtException.getMessage()).should(this.$outer.be().apply((Object)"integer, 10508455564958384115, is too large"));
            }

            public /* synthetic */ ToIntegerFunctionTest org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToIntegerFunctionTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should handle floats larger than 2^31 - 1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntegerFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToIntegerFunctionTest$$toInteger("8589934592.0")).should(this.$outer.equal(Values.longValue((long)0x200000000L)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should handle -2^63", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntegerFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToIntegerFunctionTest$$toInteger("-9223372036854775808")).should(this.$outer.equal(Values.longValue((long)Long.MIN_VALUE)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("cannot handle -2^63-1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntegerFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                CypherTypeException caughtException = (CypherTypeException)this.$outer.evaluating((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$16 $outer;

                    public final AnyValue apply() {
                        return this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToIntegerFunctionTest$$anonfun$$$outer().org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToIntegerFunctionTest$$toInteger("-9223372036854775809");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).should(this.$outer.produce(ManifestFactory$.MODULE$.classType(CypherTypeException.class)));
                this.$outer.convertToStringShouldWrapper(caughtException.getMessage()).should(this.$outer.be().apply((Object)"integer, -9223372036854775809, is too large"));
            }

            public /* synthetic */ ToIntegerFunctionTest org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToIntegerFunctionTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should handle 2^63 - 1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntegerFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToIntegerFunctionTest$$toInteger("9223372036854775807")).should(this.$outer.equal(Values.longValue((long)Long.MAX_VALUE)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("cannot handle 2^63", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntegerFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                CypherTypeException caughtException = (CypherTypeException)this.$outer.evaluating((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$18 $outer;

                    public final AnyValue apply() {
                        return this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToIntegerFunctionTest$$anonfun$$$outer().org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToIntegerFunctionTest$$toInteger("9223372036854775808");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).should(this.$outer.produce(ManifestFactory$.MODULE$.classType(CypherTypeException.class)));
                this.$outer.convertToStringShouldWrapper(caughtException.getMessage()).should(this.$outer.be().apply((Object)"integer, 9223372036854775808, is too large"));
            }

            public /* synthetic */ ToIntegerFunctionTest org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToIntegerFunctionTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

