/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compatibility.v3_3.runtime.commands.expressions;

import org.neo4j.cypher.internal.compatibility.v3_3.runtime.ExecutionContext$;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.commands.expressions.Expression;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.commands.expressions.Literal;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.commands.expressions.ToStringFunction;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.commands.expressions.ToStringFunctionTest$;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.pipes.QueryStateHelper$;
import org.neo4j.cypher.internal.frontend.v3_3.ParameterWrongTypeException;
import org.neo4j.cypher.internal.frontend.v3_3.test_helpers.CypherFunSuite;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001U2A!\u0001\u0002\u0001+\t!Bk\\*ue&twMR;oGRLwN\u001c+fgRT!a\u0001\u0003\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u000b\u0019\t\u0001bY8n[\u0006tGm\u001d\u0006\u0003\u000f!\tqA];oi&lWM\u0003\u0002\n\u0015\u0005!aoM04\u0015\tYA\"A\u0007d_6\u0004\u0018\r^5cS2LG/\u001f\u0006\u0003\u001b9\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u001fA\taaY=qQ\u0016\u0014(BA\t\u0013\u0003\u0015qWm\u001c\u001bk\u0015\u0005\u0019\u0012aA8sO\u000e\u00011C\u0001\u0001\u0017!\t9R$D\u0001\u0019\u0015\tI\"$\u0001\u0007uKN$x\f[3ma\u0016\u00148O\u0003\u0002\n7)\u0011A\u0004D\u0001\tMJ|g\u000e^3oI&\u0011a\u0004\u0007\u0002\u000f\u0007f\u0004\b.\u001a:Gk:\u001cV/\u001b;f\u0011\u0015\u0001\u0003\u0001\"\u0001\"\u0003\u0019a\u0014N\\5u}Q\t!\u0005\u0005\u0002$\u00015\t!\u0001C\u0003&\u0001\u0011%a%\u0001\tu_N#(/\u001b8h\rVt7\r^5p]R\u0011q%\f\t\u0003Q-j\u0011!\u000b\u0006\u0003UA\taA^1mk\u0016\u001c\u0018B\u0001\u0017*\u0005!\te.\u001f,bYV,\u0007\"\u0002\u0018%\u0001\u0004y\u0013\u0001B8sS\u001e\u0004\"\u0001M\u001a\u000e\u0003ER\u0011AM\u0001\u0006g\u000e\fG.Y\u0005\u0003iE\u00121!\u00118z\u0001")
public class ToStringFunctionTest
extends CypherFunSuite {
    public AnyValue org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToStringFunctionTest$$toStringFunction(Object orig) {
        return new ToStringFunction((Expression)new Literal(orig)).apply(ExecutionContext$.MODULE$.empty(), QueryStateHelper$.MODULE$.empty());
    }

    public ToStringFunctionTest() {
        this.test("should return null if argument is null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToStringFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToStringFunctionTest$$toStringFunction(null));
                Value $org_scalatest_assert_macro_right = Values.NO_VALUE;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not change a string", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToStringFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToStringFunctionTest$$toStringFunction("10.599")).should(this.$outer.be().apply((Object)Values.stringValue((String)"10.599")));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert an integer to a string", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToStringFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToStringFunctionTest$$toStringFunction(BoxesRunTime.boxToInteger((int)21))).should(this.$outer.be().apply((Object)Values.stringValue((String)"21")));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert a float to a string", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToStringFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToStringFunctionTest$$toStringFunction(BoxesRunTime.boxToDouble((double)23.34))).should(this.$outer.be().apply((Object)Values.stringValue((String)"23.34")));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert a negative float to a string", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToStringFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToStringFunctionTest$$toStringFunction(BoxesRunTime.boxToDouble((double)-12.66))).should(this.$outer.be().apply((Object)Values.stringValue((String)"-12.66")));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert a negative integer to a string", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToStringFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToStringFunctionTest$$toStringFunction(BoxesRunTime.boxToInteger((int)-12))).should(this.$outer.be().apply((Object)Values.stringValue((String)"-12")));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should handle boolean false", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToStringFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToStringFunctionTest$$toStringFunction(BoxesRunTime.boxToBoolean((boolean)false))).should(this.$outer.be().apply((Object)Values.stringValue((String)"false")));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should handle boolean true", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToStringFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToStringFunctionTest$$toStringFunction(BoxesRunTime.boxToBoolean((boolean)true))).should(this.$outer.be().apply((Object)Values.stringValue((String)"true")));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should throw an exception if the argument is an object which cannot be converted to a string", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToStringFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ParameterWrongTypeException caughtException = (ParameterWrongTypeException)this.$outer.evaluating((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$9 $outer;

                    public final AnyValue apply() {
                        return this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToStringFunctionTest$$anonfun$$$outer().org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToStringFunctionTest$$toStringFunction(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 24})));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).should(this.$outer.produce(ManifestFactory$.MODULE$.classType(ParameterWrongTypeException.class)));
                this.$outer.convertToStringShouldWrapper(caughtException.getMessage()).should(this.$outer.startWith().apply("Expected a String, Number or Boolean, got: "));
            }

            public /* synthetic */ ToStringFunctionTest org$neo4j$cypher$internal$compatibility$v3_3$runtime$commands$expressions$ToStringFunctionTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

