/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compatibility.v3_3.runtime.executionplan;

import java.net.URL;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.executionplan.LoadCsvPeriodicCommitObserver;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.pipes.ExternalCSVResource;
import org.neo4j.cypher.internal.frontend.v3_3.test_helpers.CypherFunSuite;
import org.neo4j.cypher.internal.spi.v3_3.QueryContext;
import org.neo4j.cypher.internal.spi.v3_3.QueryTransactionalContext;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00114A!\u0001\u0002\u0001'\t\tCj\\1e\u0007N4\b+\u001a:j_\u0012L7mQ8n[&$xJY:feZ,'\u000fV3ti*\u00111\u0001B\u0001\u000eKb,7-\u001e;j_:\u0004H.\u00198\u000b\u0005\u00151\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u000f!\tAA^\u001a`g)\u0011\u0011BC\u0001\u000eG>l\u0007/\u0019;jE&d\u0017\u000e^=\u000b\u0005-a\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u00055q\u0011AB2za\",'O\u0003\u0002\u0010!\u0005)a.Z85U*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001)A\u0011QcG\u0007\u0002-)\u0011q\u0003G\u0001\ri\u0016\u001cHo\u00185fYB,'o\u001d\u0006\u0003\u000feQ!A\u0007\u0006\u0002\u0011\u0019\u0014xN\u001c;f]\u0012L!\u0001\b\f\u0003\u001d\rK\b\u000f[3s\rVt7+^5uK\")a\u0004\u0001C\u0001?\u00051A(\u001b8jiz\"\u0012\u0001\t\t\u0003C\u0001i\u0011A\u0001\u0005\nG\u0001\u0001\r\u00111A\u0005\u0002\u0011\n\u0011C]3t_V\u00148-Z+oI\u0016\u0014H+Z:u+\u0005)\u0003CA\u0011'\u0013\t9#AA\u000fM_\u0006$7i\u001d<QKJLw\u000eZ5d\u0007>lW.\u001b;PEN,'O^3s\u0011%I\u0003\u00011AA\u0002\u0013\u0005!&A\u000bsKN|WO]2f+:$WM\u001d+fgR|F%Z9\u0015\u0005-\n\u0004C\u0001\u00170\u001b\u0005i#\"\u0001\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Aj#\u0001B+oSRDqA\r\u0015\u0002\u0002\u0003\u0007Q%A\u0002yIEBa\u0001\u000e\u0001!B\u0013)\u0013A\u0005:fg>,(oY3V]\u0012,'\u000fV3ti\u0002B\u0011B\u000e\u0001A\u0002\u0003\u0007I\u0011A\u001c\u0002)Q\u0014\u0018M\\:bGRLwN\\1m\u0007>tG/\u001a=u+\u0005A\u0004CA\u001d>\u001b\u0005Q$BA\u0004<\u0015\ta$\"A\u0002ta&L!A\u0010\u001e\u00033E+XM]=Ue\u0006t7/Y2uS>t\u0017\r\\\"p]R,\u0007\u0010\u001e\u0005\n\u0001\u0002\u0001\r\u00111A\u0005\u0002\u0005\u000b\u0001\u0004\u001e:b]N\f7\r^5p]\u0006d7i\u001c8uKb$x\fJ3r)\tY#\tC\u00043\u007f\u0005\u0005\t\u0019\u0001\u001d\t\r\u0011\u0003\u0001\u0015)\u00039\u0003U!(/\u00198tC\u000e$\u0018n\u001c8bY\u000e{g\u000e^3yi\u0002B\u0011B\u0012\u0001A\u0002\u0003\u0007I\u0011A$\u0002\u0011I,7o\\;sG\u0016,\u0012\u0001\u0013\t\u0003\u00132k\u0011A\u0013\u0006\u0003\u0017\u0012\tQ\u0001]5qKNL!!\u0014&\u0003'\u0015CH/\u001a:oC2\u001c5K\u0016*fg>,(oY3\t\u0013=\u0003\u0001\u0019!a\u0001\n\u0003\u0001\u0016\u0001\u0004:fg>,(oY3`I\u0015\fHCA\u0016R\u0011\u001d\u0011d*!AA\u0002!Caa\u0015\u0001!B\u0013A\u0015!\u0003:fg>,(oY3!\u0011\u001d)\u0006A1A\u0005\u0002Y\u000b1!\u001e:m+\u00059\u0006C\u0001-^\u001b\u0005I&B\u0001.\\\u0003\rqW\r\u001e\u0006\u00029\u0006!!.\u0019<b\u0013\tq\u0016LA\u0002V%2Ca\u0001\u0019\u0001!\u0002\u00139\u0016\u0001B;sY\u0002BQA\u0019\u0001\u0005R\r\f!BY3g_J,W)Y2i)\u0005Y\u0003")
public class LoadCsvPeriodicCommitObserverTest
extends CypherFunSuite {
    private LoadCsvPeriodicCommitObserver resourceUnderTest;
    private QueryTransactionalContext transactionalContext;
    private ExternalCSVResource resource;
    private final URL url = new URL("file:///tmp/something.csv");

    public LoadCsvPeriodicCommitObserver resourceUnderTest() {
        return this.resourceUnderTest;
    }

    public void resourceUnderTest_$eq(LoadCsvPeriodicCommitObserver x$1) {
        this.resourceUnderTest = x$1;
    }

    public QueryTransactionalContext transactionalContext() {
        return this.transactionalContext;
    }

    public void transactionalContext_$eq(QueryTransactionalContext x$1) {
        this.transactionalContext = x$1;
    }

    public ExternalCSVResource resource() {
        return this.resource;
    }

    public void resource_$eq(ExternalCSVResource x$1) {
        this.resource = x$1;
    }

    public URL url() {
        return this.url;
    }

    public void beforeEach() {
        QueryContext queryContext = (QueryContext)this.mock(ManifestFactory$.MODULE$.classType(QueryContext.class));
        this.transactionalContext_$eq((QueryTransactionalContext)this.mock(ManifestFactory$.MODULE$.classType(QueryTransactionalContext.class)));
        Mockito.when((Object)queryContext.transactionalContext()).thenReturn((Object)this.transactionalContext());
        this.resource_$eq((ExternalCSVResource)this.mock(ManifestFactory$.MODULE$.classType(ExternalCSVResource.class)));
        this.resourceUnderTest_$eq(new LoadCsvPeriodicCommitObserver(1L, this.resource(), queryContext));
    }

    public LoadCsvPeriodicCommitObserverTest() {
        this.test("should not trigger tx restart until after first batch has been processed", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LoadCsvPeriodicCommitObserverTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Mockito.when((Object)this.$outer.resource().getCsvIterator((URL)Matchers.eq((Object)this.$outer.url()), (Option)Matchers.any(), Matchers.anyBoolean(), Matchers.anyBoolean())).thenReturn((Object)package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{(String[])((Object[])new String[]{"Row1"}), (String[])((Object[])new String[]{"Row2"})})));
                LoadCsvPeriodicCommitObserver qual$1 = this.$outer.resourceUnderTest();
                URL x$1 = this.$outer.url();
                None$ x$2 = None$.MODULE$;
                boolean x$3 = false;
                boolean x$4 = qual$1.getCsvIterator$default$4();
                Iterator iterator2 = qual$1.getCsvIterator(x$1, (Option)x$2, x$3, x$4);
                this.$outer.convertToAnyShouldWrapper(iterator2.next()).should(this.$outer.equal(new String[]{"Row1"}), (Object)Equality$.MODULE$.default());
                ((QueryTransactionalContext)Mockito.verify((Object)this.$outer.transactionalContext(), (VerificationMode)Mockito.never())).commitAndRestartTx();
                this.$outer.convertToAnyShouldWrapper(iterator2.next()).should(this.$outer.equal(new String[]{"Row2"}), (Object)Equality$.MODULE$.default());
                ((QueryTransactionalContext)Mockito.verify((Object)this.$outer.transactionalContext(), (VerificationMode)Mockito.times((int)1))).commitAndRestartTx();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("headers should not count", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LoadCsvPeriodicCommitObserverTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Mockito.when((Object)this.$outer.resource().getCsvIterator((URL)Matchers.eq((Object)this.$outer.url()), (Option)Matchers.any(), Matchers.anyBoolean(), Matchers.eq((boolean)true))).thenReturn((Object)package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{(String[])((Object[])new String[]{"header"}), (String[])((Object[])new String[]{"Row1"}), (String[])((Object[])new String[]{"Row2"}), (String[])((Object[])new String[]{"Row3"})})));
                Iterator iterator2 = this.$outer.resourceUnderTest().getCsvIterator(this.$outer.url(), (Option)None$.MODULE$, false, true);
                ((QueryTransactionalContext)Mockito.verify((Object)this.$outer.transactionalContext(), (VerificationMode)Mockito.never())).commitAndRestartTx();
                this.$outer.convertToAnyShouldWrapper(iterator2.next()).should(this.$outer.equal(new String[]{"header"}), (Object)Equality$.MODULE$.default());
                ((QueryTransactionalContext)Mockito.verify((Object)this.$outer.transactionalContext(), (VerificationMode)Mockito.never())).commitAndRestartTx();
                this.$outer.convertToAnyShouldWrapper(iterator2.next()).should(this.$outer.equal(new String[]{"Row1"}), (Object)Equality$.MODULE$.default());
                ((QueryTransactionalContext)Mockito.verify((Object)this.$outer.transactionalContext(), (VerificationMode)Mockito.never())).commitAndRestartTx();
                this.$outer.convertToAnyShouldWrapper(iterator2.next()).should(this.$outer.equal(new String[]{"Row2"}), (Object)Equality$.MODULE$.default());
                ((QueryTransactionalContext)Mockito.verify((Object)this.$outer.transactionalContext(), (VerificationMode)Mockito.times((int)1))).commitAndRestartTx();
                this.$outer.convertToAnyShouldWrapper(iterator2.next()).should(this.$outer.equal(new String[]{"Row3"}), (Object)Equality$.MODULE$.default());
                ((QueryTransactionalContext)Mockito.verify((Object)this.$outer.transactionalContext(), (VerificationMode)Mockito.times((int)2))).commitAndRestartTx();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("multiple iterators are still handled correctly only commit when the first iterator advances", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LoadCsvPeriodicCommitObserverTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Mockito.when((Object)this.$outer.resource().getCsvIterator((URL)Matchers.eq((Object)this.$outer.url()), (Option)Matchers.any(), Matchers.anyBoolean(), Matchers.anyBoolean())).thenReturn((Object)package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{(String[])((Object[])new String[]{"outer1"}), (String[])((Object[])new String[]{"outer2"})}))).thenReturn((Object)package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{(String[])((Object[])new String[]{"inner1"}), (String[])((Object[])new String[]{"inner2"}), (String[])((Object[])new String[]{"inner3"}), (String[])((Object[])new String[]{"inner4"})})));
                Iterator iterator1 = this.$outer.resourceUnderTest().getCsvIterator(this.$outer.url(), (Option)None$.MODULE$, false, false);
                Iterator iterator2 = this.$outer.resourceUnderTest().getCsvIterator(this.$outer.url(), (Option)None$.MODULE$, false, false);
                iterator1.next();
                iterator2.next();
                iterator2.next();
                iterator2.next();
                ((QueryTransactionalContext)Mockito.verify((Object)this.$outer.transactionalContext(), (VerificationMode)Mockito.never())).commitAndRestartTx();
                iterator1.next();
                ((QueryTransactionalContext)Mockito.verify((Object)this.$outer.transactionalContext(), (VerificationMode)Mockito.times((int)1))).commitAndRestartTx();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("if a custom separator is specified it should be passed to the wrapped resource", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LoadCsvPeriodicCommitObserverTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.resourceUnderTest().getCsvIterator(this.$outer.url(), (Option)new Some((Object)";"), false, false);
                ((ExternalCSVResource)Mockito.verify((Object)this.$outer.resource(), (VerificationMode)Mockito.times((int)1))).getCsvIterator(this.$outer.url(), (Option)new Some((Object)";"), false, false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

