/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compatibility.v3_3.runtime.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.helpers.JavaListWrapper;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.helpers.RuntimeScalaValueConverter;
import org.neo4j.cypher.internal.frontend.v3_3.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import org.scalatest.matchers.TypeMatcherHelper$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Stream;
import scala.package$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001)2A!\u0001\u0002\u0001'\tq\"+\u001e8uS6,7kY1mCZ\u000bG.^3D_:4XM\u001d;feR+7\u000f\u001e\u0006\u0003\u0007\u0011\tq\u0001[3ma\u0016\u00148O\u0003\u0002\u0006\r\u00059!/\u001e8uS6,'BA\u0004\t\u0003\u001118gX\u001a\u000b\u0005%Q\u0011!D2p[B\fG/\u001b2jY&$\u0018P\u0003\u0002\f\u0019\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\u000e\u001d\u000511-\u001f9iKJT!a\u0004\t\u0002\u000b9,w\u000e\u000e6\u000b\u0003E\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u000b\u0011\u0005UYR\"\u0001\f\u000b\u0005]A\u0012\u0001\u0004;fgR|\u0006.\u001a7qKJ\u001c(BA\u0004\u001a\u0015\tQ\"\"\u0001\u0005ge>tG/\u001a8e\u0013\tabC\u0001\bDsBDWM\u001d$v]N+\u0018\u000e^3\t\u000by\u0001A\u0011A\u0010\u0002\rqJg.\u001b;?)\u0005\u0001\u0003CA\u0011\u0001\u001b\u0005\u0011\u0001bB\u0012\u0001\u0005\u0004%\t\u0001J\u0001\nG>tg/\u001a:uKJ,\u0012!\n\t\u0003C\u0019J!a\n\u0002\u00035I+h\u000e^5nKN\u001b\u0017\r\\1WC2,XmQ8om\u0016\u0014H/\u001a:\t\r%\u0002\u0001\u0015!\u0003&\u0003)\u0019wN\u001c<feR,'\u000f\t")
public class RuntimeScalaValueConverterTest
extends CypherFunSuite {
    private final RuntimeScalaValueConverter converter = new RuntimeScalaValueConverter((Function1)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final boolean apply(Object x$1) {
            return false;
        }
    });

    public RuntimeScalaValueConverter converter() {
        return this.converter;
    }

    public RuntimeScalaValueConverterTest() {
        this.test("should convert hash map", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RuntimeScalaValueConverterTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                HashMap<String, Integer> it = new HashMap<String, Integer>();
                it.put("k1", BoxesRunTime.boxToInteger((int)5));
                it.put("k2", BoxesRunTime.boxToInteger((int)15));
                this.$outer.convertToAnyShouldWrapper(this.$outer.converter().asDeepScalaValue(it)).should(this.$outer.equal(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k1"), (Object)BoxesRunTime.boxToInteger((int)5)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k2"), (Object)BoxesRunTime.boxToInteger((int)15))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert singleton map", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RuntimeScalaValueConverterTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Map<String, Integer> it = Collections.singletonMap("key", BoxesRunTime.boxToInteger((int)12));
                this.$outer.convertToAnyShouldWrapper(this.$outer.converter().asDeepScalaValue(it)).should(this.$outer.equal(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key"), (Object)BoxesRunTime.boxToInteger((int)12))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert empty map", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RuntimeScalaValueConverterTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Map<K, V> it = Collections.emptyMap();
                this.$outer.convertToAnyShouldWrapper(this.$outer.converter().asDeepScalaValue(it)).should(this.$outer.equal(Predef$.MODULE$.Map().empty()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert nested map", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RuntimeScalaValueConverterTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                HashMap<String, Object> it = new HashMap<String, Object>();
                it.put("k1", Collections.singletonMap("a", BoxesRunTime.boxToInteger((int)2)));
                it.put("k2", BoxesRunTime.boxToInteger((int)15));
                this.$outer.convertToAnyShouldWrapper(this.$outer.converter().asDeepScalaValue(it)).should(this.$outer.equal(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k1"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)2))}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k2"), (Object)BoxesRunTime.boxToInteger((int)15))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert linked list", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RuntimeScalaValueConverterTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LinkedList<Integer> it = new LinkedList<Integer>();
                it.add(BoxesRunTime.boxToInteger((int)12));
                it.add(BoxesRunTime.boxToInteger((int)14));
                this.$outer.convertToAnyShouldWrapper(this.$outer.converter().asDeepScalaValue(it)).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{12, 14}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert array list", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RuntimeScalaValueConverterTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ArrayList<Integer> it = new ArrayList<Integer>();
                it.add(BoxesRunTime.boxToInteger((int)12));
                it.add(BoxesRunTime.boxToInteger((int)14));
                this.$outer.convertToAnyShouldWrapper(this.$outer.converter().asDeepScalaValue(it)).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{12, 14}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert singleton set", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RuntimeScalaValueConverterTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Set<Integer> it = Collections.singleton(BoxesRunTime.boxToInteger((int)3));
                this.$outer.convertToAnyShouldWrapper(this.$outer.converter().asDeepScalaValue(it)).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert empty list", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RuntimeScalaValueConverterTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                java.util.List<T> it = Collections.emptyList();
                this.$outer.convertToAnyShouldWrapper(this.$outer.converter().asDeepScalaValue(it)).should(this.$outer.equal(List$.MODULE$.empty()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert nested data structures", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RuntimeScalaValueConverterTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Set<java.util.List<Object>> it = Collections.singleton(Arrays.asList(ScalaRunTime$.MODULE$.toObjectArray((Object)new int[]{3, 4})));
                this.$outer.convertToAnyShouldWrapper(this.$outer.converter().asDeepScalaValue(it)).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new List[]{List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4}))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert from set", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RuntimeScalaValueConverterTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                HashSet<String> it = new HashSet<String>();
                it.add("Hello");
                this.$outer.convertToAnyShouldWrapper(this.$outer.converter().asDeepScalaValue(it)).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Hello"}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert traversable to Iterable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RuntimeScalaValueConverterTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Stream it = package$.MODULE$.Stream().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3)}));
                TypeMatcherHelper$.MODULE$.checkAnType(this.$outer.convertToAnyShouldWrapper(this.$outer.converter().asDeepScalaValue((Object)it)).leftSideValue(), this.$outer.an(ManifestFactory$.MODULE$.classType(Iterable.class, ManifestFactory$.MODULE$.wildcardType(ManifestFactory$.MODULE$.Nothing(), ManifestFactory$.MODULE$.Any()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0]))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should preserve java lists without copying", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RuntimeScalaValueConverterTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                java.util.List<Object> javaList = Arrays.asList(ScalaRunTime$.MODULE$.toObjectArray((Object)new int[]{1, 2, 3}));
                Object converted = this.$outer.converter().asDeepScalaValue(javaList);
                TypeMatcherHelper$.MODULE$.checkAType(this.$outer.convertToAnyShouldWrapper(converted).leftSideValue(), this.$outer.a(ManifestFactory$.MODULE$.classType(JavaListWrapper.class, ManifestFactory$.MODULE$.wildcardType(ManifestFactory$.MODULE$.Nothing(), ManifestFactory$.MODULE$.Any()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0]))));
                TypeMatcherHelper$.MODULE$.checkAnType(this.$outer.convertToAnyShouldWrapper(((JavaListWrapper)converted).inner()).leftSideValue(), this.$outer.an(ManifestFactory$.MODULE$.classType(ArrayList.class, ManifestFactory$.MODULE$.wildcardType(ManifestFactory$.MODULE$.Nothing(), ManifestFactory$.MODULE$.Any()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0]))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

