/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compatibility.v3_3.runtime.pipes;

import org.mockito.Mockito;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.pipes.LazyTypes;
import org.neo4j.cypher.internal.compiler.v3_3.spi.TokenContext;
import org.neo4j.cypher.internal.frontend.v3_3.test_helpers.CypherFunSuite;
import org.neo4j.cypher.internal.spi.v3_3.QueryContext;
import org.scalatest.Tag;
import scala.Function0;
import scala.None$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t2A!\u0001\u0002\u0001'\tiA*\u0019>z)f\u0004Xm\u001d+fgRT!a\u0001\u0003\u0002\u000bAL\u0007/Z:\u000b\u0005\u00151\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u000f!\tAA^\u001a`g)\u0011\u0011BC\u0001\u000eG>l\u0007/\u0019;jE&d\u0017\u000e^=\u000b\u0005-a\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u00055q\u0011AB2za\",'O\u0003\u0002\u0010!\u0005)a.Z85U*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001)A\u0011QcG\u0007\u0002-)\u0011q\u0003G\u0001\ri\u0016\u001cHo\u00185fYB,'o\u001d\u0006\u0003\u000feQ!A\u0007\u0006\u0002\u0011\u0019\u0014xN\u001c;f]\u0012L!\u0001\b\f\u0003\u001d\rK\b\u000f[3s\rVt7+^5uK\")a\u0004\u0001C\u0001?\u00051A(\u001b8jiz\"\u0012\u0001\t\t\u0003C\u0001i\u0011A\u0001")
public class LazyTypesTest
extends CypherFunSuite {
    public LazyTypesTest() {
        this.test("should not initialize state when state is complete", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LazyTypesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LazyTypes types = new LazyTypes((String[])((Object[])new String[]{"a", "b", "c"}));
                QueryContext context = (QueryContext)this.$outer.mock(ManifestFactory$.MODULE$.classType(QueryContext.class));
                Mockito.when((Object)context.getOptRelTypeId("a")).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)));
                Mockito.when((Object)context.getOptRelTypeId("b")).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)2)));
                Mockito.when((Object)context.getOptRelTypeId("c")).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)3)));
                types.types(context);
                QueryContext newContext = (QueryContext)this.$outer.mock(ManifestFactory$.MODULE$.classType(QueryContext.class));
                types.types(newContext);
                Mockito.verifyZeroInteractions((Object[])new Object[]{newContext});
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should re-initialize if not fully initialized", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LazyTypesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LazyTypes types = new LazyTypes((String[])((Object[])new String[]{"a", "b", "c"}));
                QueryContext context = (QueryContext)this.$outer.mock(ManifestFactory$.MODULE$.classType(QueryContext.class));
                Mockito.when((Object)context.getOptRelTypeId("a")).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)));
                Mockito.when((Object)context.getOptRelTypeId("b")).thenReturn((Object)None$.MODULE$);
                Mockito.when((Object)context.getOptRelTypeId("c")).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)3)));
                types.types(context);
                QueryContext newContext = (QueryContext)this.$outer.mock(ManifestFactory$.MODULE$.classType(QueryContext.class));
                Mockito.when((Object)newContext.getOptRelTypeId("a")).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)));
                Mockito.when((Object)newContext.getOptRelTypeId("b")).thenReturn((Object)None$.MODULE$);
                Mockito.when((Object)newContext.getOptRelTypeId("c")).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)3)));
                types.types(newContext);
                ((TokenContext)Mockito.verify((Object)newContext)).getOptRelTypeId("b");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

