/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compatibility.v3_3.runtime.pipes;

import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.OngoingStubbing;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.ExecutionContext;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.ExecutionContext$;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.pipes.Pipe;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.pipes.PipeTestSupport;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.pipes.QueryState;
import org.neo4j.cypher.internal.frontend.v3_3.SemanticDirection;
import org.neo4j.cypher.internal.frontend.v3_3.symbols.CypherType;
import org.neo4j.cypher.internal.frontend.v3_3.symbols.package$;
import org.neo4j.cypher.internal.spi.v3_3.QueryContext;
import org.neo4j.cypher.internal.v3_3.logical.plans.LogicalPlanId$;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.AnyValue;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set$;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public abstract class PipeTestSupport$class {
    public static Pipe pipeWithResults(PipeTestSupport $this, Function1 f) {
        return new Pipe($this, f){
            private final Function1 f$1;

            public Iterator<ExecutionContext> createResults(QueryState state) {
                return Pipe.class.createResults((Pipe)this, (QueryState)state);
            }

            public Iterator<ExecutionContext> internalCreateResults(QueryState state) {
                return (Iterator)this.f$1.apply((Object)state);
            }

            public int id() {
                return LogicalPlanId$.MODULE$.DEFAULT();
            }
            {
                this.f$1 = f$1;
                Pipe.class.$init$((Pipe)this);
            }
        };
    }

    public static ExecutionContext row(PipeTestSupport $this, Seq values) {
        return ExecutionContext$.MODULE$.from((Seq)values.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, AnyValue> apply(Tuple2<String, Object> v) {
                return new Tuple2(v._1(), (Object)ValueUtils.of((Object)v._2()));
            }
        }, Seq$.MODULE$.canBuildFrom()));
    }

    public static void setUpRelMockingInQueryContext(PipeTestSupport $this, Seq rels) {
        Map relsByStartNode = rels.groupBy((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Node apply(Relationship x$1) {
                return x$1.getStartNode();
            }
        });
        Map relsByEndNode = rels.groupBy((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Node apply(Relationship x$2) {
                return x$2.getEndNode();
            }
        });
        Map relsByNode = ((TraversableOnce)relsByStartNode.keySet().$plus$plus((GenTraversableOnce)relsByEndNode.keySet()).map((Function1)new Serializable($this, relsByStartNode, relsByEndNode){
            public static final long serialVersionUID = 0L;
            private final Map relsByStartNode$1;
            private final Map relsByEndNode$1;

            public final Tuple2<Node, Seq<Relationship>> apply(Node n) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)n), ((TraversableLike)this.relsByStartNode$1.getOrElse((Object)n, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<Nothing$> apply() {
                        return (Seq)Seq$.MODULE$.empty();
                    }
                })).$plus$plus((GenTraversableOnce)this.relsByEndNode$1.getOrElse((Object)n, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<Nothing$> apply() {
                        return (Seq)Seq$.MODULE$.empty();
                    }
                }), Seq$.MODULE$.canBuildFrom()));
            }
            {
                this.relsByStartNode$1 = relsByStartNode$1;
                this.relsByEndNode$1 = relsByEndNode$1;
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        $this.setUpRelLookupMocking((SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Map<Node, Seq<Relationship>>)relsByStartNode);
        $this.setUpRelLookupMocking((SemanticDirection)SemanticDirection.INCOMING$.MODULE$, (Map<Node, Seq<Relationship>>)relsByEndNode);
        $this.setUpRelLookupMocking((SemanticDirection)SemanticDirection.BOTH$.MODULE$, (Map<Node, Seq<Relationship>>)relsByNode);
    }

    public static void setUpRelLookupMocking(PipeTestSupport $this, SemanticDirection direction, Map relsByNode) {
        relsByNode.foreach((Function1)new Serializable($this, direction){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PipeTestSupport $outer;
            private final SemanticDirection direction$1;

            public final OngoingStubbing<Object> apply(Tuple2<Node, Seq<Relationship>> x0$1) {
                Tuple2<Node, Seq<Relationship>> tuple2 = x0$1;
                if (tuple2 != null) {
                    Node node2 = (Node)tuple2._1();
                    Seq rels = (Seq)tuple2._2();
                    Mockito.when((Object)this.$outer.query().getRelationshipsForIds(node2.getId(), this.direction$1, (Option)None$.MODULE$)).thenAnswer((Answer)new Answer<Iterator<Relationship>>(this, rels){
                        private final Seq rels$1;

                        public Iterator<Relationship> answer(InvocationOnMock invocation) {
                            return this.rels$1.iterator();
                        }
                        {
                            this.rels$1 = rels$1;
                        }
                    });
                    OngoingStubbing ongoingStubbing = Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.$outer.query().nodeGetDegree(node2.getId(), this.direction$1))).thenReturn((Object)BoxesRunTime.boxToInteger((int)rels.size()));
                    return ongoingStubbing;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.direction$1 = direction$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static Node newMockedNode(PipeTestSupport $this, int id) {
        void var2_2;
        Node node2 = (Node)$this.mock(ManifestFactory$.MODULE$.classType(Node.class));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)node2.getId())).thenReturn((Object)BoxesRunTime.boxToLong((long)id));
        return var2_2;
    }

    public static Relationship newMockedRelationship(PipeTestSupport $this, int id, Node startNode, Node endNode) {
        Relationship relationship = (Relationship)$this.mock(ManifestFactory$.MODULE$.classType(Relationship.class));
        long startId = startNode.getId();
        long endId = endNode.getId();
        Mockito.when((Object)BoxesRunTime.boxToLong((long)relationship.getId())).thenReturn((Object)BoxesRunTime.boxToLong((long)id));
        Mockito.when((Object)relationship.getStartNode()).thenReturn((Object)startNode);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)relationship.getStartNodeId())).thenReturn((Object)BoxesRunTime.boxToLong((long)startId));
        Mockito.when((Object)relationship.getEndNode()).thenReturn((Object)endNode);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)relationship.getEndNodeId())).thenReturn((Object)BoxesRunTime.boxToLong((long)endId));
        Mockito.when((Object)relationship.getOtherNode(startNode)).thenReturn((Object)endNode);
        Mockito.when((Object)relationship.getOtherNode(endNode)).thenReturn((Object)startNode);
        return relationship;
    }

    public static Pipe newMockedPipe(PipeTestSupport $this, String node2, Seq rows2) {
        return $this.newMockedPipe((Map<String, CypherType>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)node2), (Object)package$.MODULE$.CTNode())}))), (Seq<ExecutionContext>)rows2);
    }

    /*
     * WARNING - void declaration
     */
    public static Pipe newMockedPipe(PipeTestSupport $this, Map symbols, Seq rows2) {
        void var3_3;
        Pipe pipe = (Pipe)$this.mock(ManifestFactory$.MODULE$.classType(Pipe.class));
        Mockito.when((Object)pipe.createResults((QueryState)Matchers.any())).thenAnswer((Answer)new Answer<Iterator<ExecutionContext>>($this, rows2){
            private final Seq rows$1;

            public Iterator<ExecutionContext> answer(InvocationOnMock invocation) {
                return this.rows$1.iterator();
            }
            {
                this.rows$1 = rows$1;
            }
        });
        return var3_3;
    }

    public static void $init$(PipeTestSupport $this) {
        $this.org$neo4j$cypher$internal$compatibility$v3_3$runtime$pipes$PipeTestSupport$_setter_$query_$eq((QueryContext)$this.mock(ManifestFactory$.MODULE$.classType(QueryContext.class)));
    }
}

