/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compatibility.v3_3.runtime.pipes.aggregation;

import org.neo4j.cypher.internal.compatibility.v3_3.runtime.commands.expressions.Expression;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.pipes.aggregation.AggregateTest;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.pipes.aggregation.AggregateTest$class;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.pipes.aggregation.SumFunction;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.pipes.aggregation.SumFunctionTest$;
import org.neo4j.cypher.internal.frontend.v3_3.CypherTypeException;
import org.neo4j.cypher.internal.frontend.v3_3.test_helpers.CypherFunSuite;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.Values;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import org.scalatest.matchers.TypeMatcherHelper$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001]2A!\u0001\u0002\u0001+\ty1+^7Gk:\u001cG/[8o)\u0016\u001cHO\u0003\u0002\u0004\t\u0005Y\u0011mZ4sK\u001e\fG/[8o\u0015\t)a!A\u0003qSB,7O\u0003\u0002\b\u0011\u00059!/\u001e8uS6,'BA\u0005\u000b\u0003\u001118gX\u001a\u000b\u0005-a\u0011!D2p[B\fG/\u001b2jY&$\u0018P\u0003\u0002\u000e\u001d\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\u0010!\u000511-\u001f9iKJT!!\u0005\n\u0002\u000b9,w\u000e\u000e6\u000b\u0003M\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\f !\t9R$D\u0001\u0019\u0015\tI\"$\u0001\u0007uKN$x\f[3ma\u0016\u00148O\u0003\u0002\n7)\u0011A\u0004D\u0001\tMJ|g\u000e^3oI&\u0011a\u0004\u0007\u0002\u000f\u0007f\u0004\b.\u001a:Gk:\u001cV/\u001b;f!\t\u0001\u0013%D\u0001\u0003\u0013\t\u0011#AA\u0007BO\u001e\u0014XmZ1uKR+7\u000f\u001e\u0005\u0006I\u0001!\t!J\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0019\u0002\"\u0001\t\u0001\t\u000b!\u0002A\u0011A\u0015\u0002!\r\u0014X-\u0019;f\u0003\u001e<'/Z4bi>\u0014HC\u0001\u0016.!\t\u00013&\u0003\u0002-\u0005\tY1+^7Gk:\u001cG/[8o\u0011\u0015qs\u00051\u00010\u0003\u0015IgN\\3s!\t\u0001T'D\u00012\u0015\t\u00114'A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u001b\u0007\u0003!\u0019w.\\7b]\u0012\u001c\u0018B\u0001\u001c2\u0005))\u0005\u0010\u001d:fgNLwN\u001c")
public class SumFunctionTest
extends CypherFunSuite
implements AggregateTest {
    @Override
    public Object aggregateOn(Seq<AnyValue> values) {
        return AggregateTest$class.aggregateOn(this, values);
    }

    public SumFunction createAggregator(Expression inner) {
        return new SumFunction(inner);
    }

    public SumFunctionTest() {
        AggregateTest$class.$init$(this);
        this.test("singleValueReturnsThatNumber", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SumFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Object result2 = this.$outer.aggregateOn((Seq<AnyValue>)Predef$.MODULE$.wrapRefArray((Object[])new AnyValue[]{Values.longValue((long)1L)}));
                this.$outer.convertToAnyShouldWrapper(result2).should(this.$outer.equal(Values.longValue((long)1L)), (Object)Equality$.MODULE$.default());
                TypeMatcherHelper$.MODULE$.checkAType(this.$outer.convertToAnyShouldWrapper(result2).leftSideValue(), this.$outer.a(ManifestFactory$.MODULE$.classType(LongValue.class)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("singleValueOfDecimalReturnsDecimal", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SumFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Object result2 = this.$outer.aggregateOn((Seq<AnyValue>)Predef$.MODULE$.wrapRefArray((Object[])new AnyValue[]{Values.doubleValue((double)1.0)}));
                this.$outer.convertToAnyShouldWrapper(result2).should(this.$outer.equal(Values.doubleValue((double)1.0)), (Object)Equality$.MODULE$.default());
                TypeMatcherHelper$.MODULE$.checkAType(this.$outer.convertToAnyShouldWrapper(result2).leftSideValue(), this.$outer.a(ManifestFactory$.MODULE$.classType(DoubleValue.class)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("mixOfIntAndDoubleYieldsDouble", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SumFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Object result2 = this.$outer.aggregateOn((Seq<AnyValue>)Predef$.MODULE$.wrapRefArray((Object[])new AnyValue[]{Values.intValue((int)1), Values.doubleValue((double)1.0)}));
                this.$outer.convertToAnyShouldWrapper(result2).should(this.$outer.equal(Values.doubleValue((double)2.0)), (Object)Equality$.MODULE$.default());
                TypeMatcherHelper$.MODULE$.checkAType(this.$outer.convertToAnyShouldWrapper(result2).leftSideValue(), this.$outer.a(ManifestFactory$.MODULE$.classType(DoubleValue.class)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("mixedLotsOfStuff", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SumFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Object result2 = this.$outer.aggregateOn((Seq<AnyValue>)Predef$.MODULE$.wrapRefArray((Object[])new AnyValue[]{Values.byteValue((byte)Predef$.MODULE$.int2Integer(1).byteValue()), Values.shortValue((short)Predef$.MODULE$.int2Integer(1).shortValue())}));
                this.$outer.convertToAnyShouldWrapper(result2).should(this.$outer.equal(Values.longValue((long)2L)), (Object)Equality$.MODULE$.default());
                TypeMatcherHelper$.MODULE$.checkAType(this.$outer.convertToAnyShouldWrapper(result2).leftSideValue(), this.$outer.a(ManifestFactory$.MODULE$.classType(LongValue.class)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("noNumbersEqualsZero", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SumFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Object result2 = this.$outer.aggregateOn((Seq<AnyValue>)Nil$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(result2).should(this.$outer.equal(Values.longValue((long)0L)), (Object)Equality$.MODULE$.default());
                TypeMatcherHelper$.MODULE$.checkAType(this.$outer.convertToAnyShouldWrapper(result2).leftSideValue(), this.$outer.a(ManifestFactory$.MODULE$.classType(LongValue.class)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("nullDoesNotChangeTheSum", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SumFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Object result2 = this.$outer.aggregateOn((Seq<AnyValue>)Predef$.MODULE$.wrapRefArray((Object[])new AnyValue[]{Values.intValue((int)1), Values.NO_VALUE}));
                this.$outer.convertToAnyShouldWrapper(result2).should(this.$outer.equal(Values.longValue((long)1L)), (Object)Equality$.MODULE$.default());
                TypeMatcherHelper$.MODULE$.checkAType(this.$outer.convertToAnyShouldWrapper(result2).leftSideValue(), this.$outer.a(ManifestFactory$.MODULE$.classType(LongValue.class)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("noNumberValuesThrowAnException", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SumFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;

                    public final Object apply() {
                        return this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$pipes$aggregation$SumFunctionTest$$anonfun$$$outer().aggregateOn((Seq<AnyValue>)Predef$.MODULE$.wrapRefArray((Object[])new AnyValue[]{Values.intValue((int)1), Values.stringValue((String)"wut")}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ManifestFactory$.MODULE$.classType(CypherTypeException.class));
            }

            public /* synthetic */ SumFunctionTest org$neo4j$cypher$internal$compatibility$v3_3$runtime$pipes$aggregation$SumFunctionTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("intOverflowTransformsSumToLong", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SumFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int halfInt = Integer.MAX_VALUE;
                Object result2 = this.$outer.aggregateOn((Seq<AnyValue>)Predef$.MODULE$.wrapRefArray((Object[])new AnyValue[]{Values.intValue((int)halfInt), Values.intValue((int)halfInt), Values.intValue((int)halfInt)}));
                long expected = 3L * (long)halfInt;
                this.$outer.convertToAnyShouldWrapper(result2).should(this.$outer.equal(Values.longValue((long)expected)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("typesArentUnnecessaryWidened", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SumFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int thirdOfMaxInt = 0x2AAAAAAA;
                Object result2 = this.$outer.aggregateOn((Seq<AnyValue>)Predef$.MODULE$.wrapRefArray((Object[])new AnyValue[]{Values.intValue((int)thirdOfMaxInt), Values.intValue((int)thirdOfMaxInt)}));
                int expected = thirdOfMaxInt + thirdOfMaxInt;
                this.$outer.convertToAnyShouldWrapper(result2).should(this.$outer.equal(Values.longValue((long)expected)), (Object)Equality$.MODULE$.default());
                TypeMatcherHelper$.MODULE$.checkAType(this.$outer.convertToAnyShouldWrapper(result2).leftSideValue(), this.$outer.a(ManifestFactory$.MODULE$.classType(LongValue.class)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

