/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compatibility.v3_3.runtime.planDescription;

import org.neo4j.cypher.internal.compatibility.v3_3.runtime.planDescription.Argument;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.planDescription.InternalPlanDescription;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.planDescription.PlanDescriptionArgumentSerializer$;
import org.neo4j.cypher.internal.compiler.v3_3.ast.NestedPlanExpression;
import org.neo4j.cypher.internal.frontend.v3_3.DummyPosition$;
import org.neo4j.cypher.internal.frontend.v3_3.InputPosition;
import org.neo4j.cypher.internal.frontend.v3_3.SemanticDirection;
import org.neo4j.cypher.internal.frontend.v3_3.ast.DummyExpression;
import org.neo4j.cypher.internal.frontend.v3_3.ast.Expression;
import org.neo4j.cypher.internal.frontend.v3_3.ast.SignedDecimalIntegerLiteral;
import org.neo4j.cypher.internal.frontend.v3_3.symbols.CypherType;
import org.neo4j.cypher.internal.frontend.v3_3.symbols.package$;
import org.neo4j.cypher.internal.frontend.v3_3.test_helpers.CypherFunSuite;
import org.neo4j.cypher.internal.ir.v3_3.Cardinality;
import org.neo4j.cypher.internal.ir.v3_3.CardinalityEstimation$;
import org.neo4j.cypher.internal.ir.v3_3.PlannerQuery;
import org.neo4j.cypher.internal.ir.v3_3.PlannerQuery$;
import org.neo4j.cypher.internal.ir.v3_3.RegularPlannerQuery;
import org.neo4j.cypher.internal.v3_3.logical.plans.LogicalPlan;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import org.scalatest.matchers.TypeMatcherHelper$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u001d3A!\u0001\u0002\u0001'\t1\u0003\u000b\\1o\t\u0016\u001c8M]5qi&|g.\u0011:hk6,g\u000e^*fe&\fG.\u001b>feR+7\u000f^:\u000b\u0005\r!\u0011a\u00049mC:$Um]2sSB$\u0018n\u001c8\u000b\u0005\u00151\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u000f!\tAA^\u001a`g)\u0011\u0011BC\u0001\u000eG>l\u0007/\u0019;jE&d\u0017\u000e^=\u000b\u0005-a\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u00055q\u0011AB2za\",'O\u0003\u0002\u0010!\u0005)a.Z85U*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001)A\u0011QcG\u0007\u0002-)\u0011q\u0003G\u0001\ri\u0016\u001cHo\u00185fYB,'o\u001d\u0006\u0003\u000feQ!A\u0007\u0006\u0002\u0011\u0019\u0014xN\u001c;f]\u0012L!\u0001\b\f\u0003\u001d\rK\b\u000f[3s\rVt7+^5uK\")a\u0004\u0001C\u0001?\u00051A(\u001b8jiz\"\u0012\u0001\t\t\u0003C\u0001i\u0011A\u0001\u0005\bG\u0001\u0011\r\u0011\"\u0001%\u0003\u0019\u0019x\u000e\u001c<fIV\tQEE\u0002'_M2Aa\n\u0001\u0001K\taAH]3gS:,W.\u001a8u}%\u0011\u0011FK\u0001\u0005Y&4GO\u0003\u0002,Y\u0005)2)\u0019:eS:\fG.\u001b;z\u000bN$\u0018.\\1uS>t'BA\u0004.\u0015\tq#\"\u0001\u0002jeB\u0011\u0001'M\u0007\u0002Y%\u0011!\u0007\f\u0002\u0014%\u0016<W\u000f\\1s!2\fgN\\3s#V,'/\u001f\t\u0003aQJ!!\u000e\u0017\u0003+\r\u000b'\u000fZ5oC2LG/_#ti&l\u0017\r^5p]\"9qG\nb\u0001\n\u0003A\u0014\u0001F3ti&l\u0017\r^3e\u0007\u0006\u0014H-\u001b8bY&$\u00180F\u0001:!\t\u0001$(\u0003\u0002<Y\tY1)\u0019:eS:\fG.\u001b;z\u0011\u0019i\u0004\u0001)A\u0005K\u000591o\u001c7wK\u0012\u0004\u0003bB \u0001\u0005\u0004%I\u0001Q\u0001\u0004a>\u001cX#A!\u0011\u0005\t\u001bU\"\u0001\r\n\u0005\u0011C\"!D%oaV$\bk\\:ji&|g\u000e\u0003\u0004G\u0001\u0001\u0006I!Q\u0001\u0005a>\u001c\b\u0005")
public class PlanDescriptionArgumentSerializerTests
extends CypherFunSuite {
    private final RegularPlannerQuery solved = CardinalityEstimation$.MODULE$.lift((PlannerQuery)PlannerQuery$.MODULE$.empty(), new Cardinality(1.0));
    private final InputPosition org$neo4j$cypher$internal$compatibility$v3_3$runtime$planDescription$PlanDescriptionArgumentSerializerTests$$pos = DummyPosition$.MODULE$.apply(0);

    public RegularPlannerQuery solved() {
        return this.solved;
    }

    public InputPosition org$neo4j$cypher$internal$compatibility$v3_3$runtime$planDescription$PlanDescriptionArgumentSerializerTests$$pos() {
        return this.org$neo4j$cypher$internal$compatibility$v3_3$runtime$planDescription$PlanDescriptionArgumentSerializerTests$$pos;
    }

    public PlanDescriptionArgumentSerializerTests() {
        this.test("serialization should leave numeric arguments as numbers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlanDescriptionArgumentSerializerTests $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TypeMatcherHelper$.MODULE$.checkAType(this.$outer.convertToAnyShouldWrapper(PlanDescriptionArgumentSerializer$.MODULE$.serialize((Argument)new InternalPlanDescription.Arguments$.DbHits(12L))).leftSideValue(), this.$outer.a(ManifestFactory$.MODULE$.classType(Number.class)));
                TypeMatcherHelper$.MODULE$.checkAType(this.$outer.convertToAnyShouldWrapper(PlanDescriptionArgumentSerializer$.MODULE$.serialize((Argument)new InternalPlanDescription.Arguments$.Rows(12L))).leftSideValue(), this.$outer.a(ManifestFactory$.MODULE$.classType(Number.class)));
                TypeMatcherHelper$.MODULE$.checkAType(this.$outer.convertToAnyShouldWrapper(PlanDescriptionArgumentSerializer$.MODULE$.serialize((Argument)new InternalPlanDescription.Arguments$.EstimatedRows(12.0))).leftSideValue(), this.$outer.a(ManifestFactory$.MODULE$.classType(Number.class)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("ExpandExpression should look like Cypher syntax", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlanDescriptionArgumentSerializerTests $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(PlanDescriptionArgumentSerializer$.MODULE$.serialize((Argument)new InternalPlanDescription.Arguments$.ExpandExpression("a", "r", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LIKES", "LOVES"})), "b", (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, 1, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1))))).should(this.$outer.equal("(a)-[r:LIKES|:LOVES]->(b)"), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(PlanDescriptionArgumentSerializer$.MODULE$.serialize((Argument)new InternalPlanDescription.Arguments$.ExpandExpression("a", "r", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LIKES", "LOVES"})), "b", (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, 1, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)5))))).should(this.$outer.equal("(a)-[r:LIKES|:LOVES*..5]->(b)"), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(PlanDescriptionArgumentSerializer$.MODULE$.serialize((Argument)new InternalPlanDescription.Arguments$.ExpandExpression("a", "r", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LIKES", "LOVES"})), "b", (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, 1, (Option)None$.MODULE$))).should(this.$outer.equal("(a)-[r:LIKES|:LOVES*]->(b)"), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(PlanDescriptionArgumentSerializer$.MODULE$.serialize((Argument)new InternalPlanDescription.Arguments$.ExpandExpression("a", "r", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LIKES", "LOVES"})), "b", (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, 3, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)5))))).should(this.$outer.equal("(a)-[r:LIKES|:LOVES*3..5]->(b)"), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(PlanDescriptionArgumentSerializer$.MODULE$.serialize((Argument)new InternalPlanDescription.Arguments$.ExpandExpression("a", "r", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LIKES", "LOVES"})), "b", (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, 3, (Option)None$.MODULE$))).should(this.$outer.equal("(a)-[r:LIKES|:LOVES*3..]->(b)"), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("serialize nested plan expression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlanDescriptionArgumentSerializerTests $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                org.neo4j.cypher.internal.v3_3.logical.plans.Argument argument = new org.neo4j.cypher.internal.v3_3.logical.plans.Argument(Predef$.MODULE$.Set().empty(), (PlannerQuery)this.$outer.solved(), Predef$.MODULE$.Map().empty());
                DummyExpression expression = new DummyExpression(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTNode())).$bar(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTBoolean())).$bar(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTString()))), DummyPosition$.MODULE$.apply(5));
                NestedPlanExpression nested = new NestedPlanExpression((LogicalPlan)argument, (Expression)expression, this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$planDescription$PlanDescriptionArgumentSerializerTests$$pos());
                this.$outer.convertToAnyShouldWrapper(PlanDescriptionArgumentSerializer$.MODULE$.serialize((Argument)new InternalPlanDescription.Arguments$.Expression((Expression)nested))).should(this.$outer.equal("NestedPlanExpression(Argument)"), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("projection should show multiple expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlanDescriptionArgumentSerializerTests $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(PlanDescriptionArgumentSerializer$.MODULE$.serialize((Argument)new InternalPlanDescription.Arguments$.Expressions((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"1"), (Object)new SignedDecimalIntegerLiteral("42", this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$planDescription$PlanDescriptionArgumentSerializerTests$$pos())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"2"), (Object)new SignedDecimalIntegerLiteral("56", this.$outer.org$neo4j$cypher$internal$compatibility$v3_3$runtime$planDescription$PlanDescriptionArgumentSerializerTests$$pos()))}))))).should(this.$outer.equal("{1 : 42, 2 : 56}"), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("serialize something that includes a regex should work", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlanDescriptionArgumentSerializerTests $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String value = "GenericCase(Vector((any(  x@40 in n.values where   x@40 =~ Literal(^T-?\\d+$)),SubstringFunction(ContainerIndex(FilterFunction(n.values,  x@106,  x@106 =~ Literal(^T-?\\d+$)),Literal(0)),Literal(1),None))),Some(Literal(1))) == {p0}";
                this.$outer.convertToAnyShouldWrapper(PlanDescriptionArgumentSerializer$.MODULE$.serialize((Argument)new InternalPlanDescription.Arguments$.KeyNames((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{value}))))).should(this.$outer.equal("GenericCase(Vector((any(x in n.values where x =~ Literal(^T-?\\d+$)),SubstringFunction(ContainerIndex(FilterFunction(n.values,x,x =~ Literal(^T-?\\d+$)),Literal(0)),Literal(1),None))),Some(Literal(1))) == {p0}"), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

