/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.javacompat;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.cypher.internal.ExecutionEngine;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.TestGraphDatabaseFactory;

public class CypherLoggingTest {
    private final AssertableLogProvider logProvider = new AssertableLogProvider();
    private GraphDatabaseService database;

    @Before
    public void setUp() {
        this.database = new TestGraphDatabaseFactory().setUserLogProvider((LogProvider)this.logProvider).newImpermanentDatabase();
    }

    @After
    public void tearDown() {
        this.database.shutdown();
    }

    @Test
    public void shouldNotLogQueries() throws Exception {
        this.database.execute("CREATE (n:Reference) CREATE (foo {test:'me'}) RETURN n");
        this.database.execute("MATCH (n) RETURN n");
        AssertableLogProvider.inLog(ExecutionEngine.class);
        this.logProvider.assertNoLoggingOccurred();
    }
}

