/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.javacompat;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.mockito.matcher.Neo4jMatchers;

public class CypherUpdateMapTest {
    private GraphDatabaseService db;

    @Test
    public void updateNodeByMapParameter() throws Throwable {
        this.db.execute("CREATE (n:Reference) SET n = {data} RETURN n", MapUtil.map((Object[])new Object[]{"data", MapUtil.map((Object[])new Object[]{"key1", "value1", "key2", 1234})}));
        Node node1 = this.getNodeByIdInTx(0);
        Assert.assertThat((Object)node1, this.inTxS((Matcher)Neo4jMatchers.hasProperty((String)"key1").withValue((Object)"value1")));
        Assert.assertThat((Object)node1, this.inTxS((Matcher)Neo4jMatchers.hasProperty((String)"key2").withValue((Object)1234)));
        this.db.execute("MATCH (n:Reference) SET n = {data} RETURN n", MapUtil.map((Object[])new Object[]{"data", MapUtil.map((Object[])new Object[]{"key1", null, "key3", 5678})}));
        Node node2 = this.getNodeByIdInTx(0);
        Assert.assertThat((Object)node2, this.inTxS(Matchers.not((Matcher)Neo4jMatchers.hasProperty((String)"key1"))));
        Assert.assertThat((Object)node2, this.inTxS(Matchers.not((Matcher)Neo4jMatchers.hasProperty((String)"key2"))));
        Assert.assertThat((Object)node2, this.inTxS((Matcher)Neo4jMatchers.hasProperty((String)"key3").withValue((Object)5678)));
    }

    public <T> Matcher<? super T> inTxS(Matcher<T> inner) {
        return Neo4jMatchers.inTx((GraphDatabaseService)this.db, inner, (boolean)false);
    }

    private Node getNodeByIdInTx(int nodeId2) {
        try (Transaction ignored = this.db.beginTx();){
            Node node2 = this.db.getNodeById((long)nodeId2);
            return node2;
        }
    }

    @Before
    public void setup() {
        this.db = new TestGraphDatabaseFactory().newImpermanentDatabase();
    }

    @After
    public void cleanup() {
        this.db.shutdown();
    }
}

