/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.javacompat;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.function.LongSupplier;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactoryState;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContext;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.context.TransactionVersionContext;
import org.neo4j.kernel.impl.context.TransactionVersionContextSupplier;
import org.neo4j.kernel.impl.factory.CommunityEditionModule;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;

public class EagerResultIT {
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();
    private GraphDatabaseService database;
    private TestTransactionVersionContextSupplier testContextSupplier;
    private File storeDir;
    private TestVersionContext testCursorContext;

    @Before
    public void setUp() {
        this.storeDir = this.testDirectory.directory();
        this.testContextSupplier = new TestTransactionVersionContextSupplier();
        this.database = this.startRestartableDatabase();
        this.prepareData();
        TransactionIdStore transactionIdStore = this.getTransactionIdStore();
        this.testCursorContext = new TestVersionContext(() -> ((TransactionIdStore)transactionIdStore).getLastClosedTransactionId());
        this.testContextSupplier.setCursorContext((VersionContext)this.testCursorContext);
    }

    @After
    public void tearDown() {
        if (this.database != null) {
            this.database.shutdown();
        }
    }

    @Test
    public void eagerResultContainsAllData() {
        Result result2 = this.database.execute("MATCH (n) RETURN n.c");
        Assert.assertEquals((long)1L, (long)this.testCursorContext.getAdditionalAttempts());
        int rows2 = 0;
        while (result2.hasNext()) {
            result2.next();
            ++rows2;
        }
        Assert.assertEquals((long)2L, (long)rows2);
    }

    @Test
    public void eagerResultContainsExecutionType() {
        Result result2 = this.database.execute("MATCH (n) RETURN n.c");
        Assert.assertEquals((long)1L, (long)this.testCursorContext.getAdditionalAttempts());
        Assert.assertEquals((Object)QueryExecutionType.query((QueryExecutionType.QueryType)QueryExecutionType.QueryType.READ_ONLY), (Object)result2.getQueryExecutionType());
    }

    @Test
    public void eagerResultContainsColumns() {
        Result result2 = this.database.execute("MATCH (n) RETURN n.c as a, count(n) as b");
        Assert.assertEquals((long)1L, (long)this.testCursorContext.getAdditionalAttempts());
        Assert.assertEquals(Arrays.asList("a", "b"), (Object)result2.columns());
    }

    @Test
    public void useColumnAsOnEagerResult() {
        Result result2 = this.database.execute("MATCH (n) RETURN n.c as c, n.b as b");
        Assert.assertEquals((long)1L, (long)this.testCursorContext.getAdditionalAttempts());
        ResourceIterator cValues = result2.columnAs("c");
        int rows2 = 0;
        while (cValues.hasNext()) {
            cValues.next();
            ++rows2;
        }
        Assert.assertEquals((long)2L, (long)rows2);
    }

    @Test
    public void eagerResultHaveQueryStatistic() {
        Result result2 = this.database.execute("MATCH (n) RETURN n.c");
        Assert.assertEquals((long)1L, (long)this.testCursorContext.getAdditionalAttempts());
        Assert.assertFalse((boolean)result2.getQueryStatistics().containsUpdates());
    }

    @Test
    public void eagerResultHaveExecutionPlan() {
        Result result2 = this.database.execute("profile MATCH (n) RETURN n.c");
        Assert.assertEquals((long)1L, (long)this.testCursorContext.getAdditionalAttempts());
        Assert.assertEquals((long)2L, (long)result2.getExecutionPlanDescription().getProfilerStatistics().getRows());
    }

    @Test
    public void eagerResultHaveNotifications() {
        Result result2 = this.database.execute(" CYPHER planner=rule MATCH (n) RETURN n.c");
        Assert.assertEquals((long)1L, (long)this.testCursorContext.getAdditionalAttempts());
        Assert.assertEquals((long)1L, (long)Iterables.count((Iterable)result2.getNotifications()));
    }

    @Test
    public void eagerResultToString() {
        Result result2 = this.database.execute("MATCH (n) RETURN n.c, n.d");
        Assert.assertEquals((long)1L, (long)this.testCursorContext.getAdditionalAttempts());
        String resultString = result2.resultAsString();
        Assert.assertTrue((boolean)resultString.contains("n.c, n.d"));
        Assert.assertTrue((boolean)resultString.contains("d, a"));
        Assert.assertTrue((boolean)resultString.contains("y, k"));
    }

    @Test
    public void eagerResultWriteAsStringToStream() {
        Result result2 = this.database.execute("MATCH (n) RETURN n.c");
        Assert.assertEquals((long)1L, (long)this.testCursorContext.getAdditionalAttempts());
        Assert.assertEquals((Object)result2.resultAsString(), (Object)this.printToStream(result2));
    }

    @Test
    public void eagerResultVisit() throws Exception {
        Result result2 = this.database.execute("MATCH (n) RETURN n.c");
        ArrayList values = new ArrayList();
        result2.accept(row2 -> {
            values.add(row2.getString("n.c"));
            return false;
        });
        Assert.assertThat(values, (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat(values, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"d", "y"}));
    }

    @Test(expected=QueryExecutionException.class)
    public void dirtyContextDuringResultVisitResultInUnstableSnapshotException() throws Exception {
        Result result2 = this.database.execute("MATCH (n) RETURN n.c");
        ArrayList values = new ArrayList();
        result2.accept(row2 -> {
            this.testCursorContext.markAsDirty();
            values.add(row2.getString("n.c"));
            return false;
        });
    }

    @Test(expected=QueryExecutionException.class)
    public void dirtyContextEntityNotFoundExceptionDuringResultVisitResultInUnstableSnapshotException() throws Exception {
        Result result2 = this.database.execute("MATCH (n) RETURN n.c");
        result2.accept(row2 -> {
            this.testCursorContext.markAsDirty();
            throw new NotFoundException((Throwable)new RuntimeException());
        });
    }

    private String printToStream(Result result2) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        result2.writeAsStringTo(printWriter);
        printWriter.flush();
        return stringWriter.toString();
    }

    private void prepareData() {
        Node node2;
        Label label = Label.label((String)"label");
        try (Transaction transaction = this.database.beginTx();){
            node2 = this.database.createNode(new Label[]{label});
            node2.setProperty("c", (Object)"d");
            node2.setProperty("d", (Object)"a");
            transaction.success();
        }
        transaction = this.database.beginTx();
        var3_3 = null;
        try {
            node2 = this.database.createNode(new Label[]{label});
            node2.setProperty("c", (Object)"y");
            node2.setProperty("d", (Object)"k");
            transaction.success();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var3_3 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    private GraphDatabaseService startRestartableDatabase() {
        return new CustomGraphDatabaseFactory(new CustomFacadeFactory()).newEmbeddedDatabaseBuilder(this.storeDir).setConfig(GraphDatabaseSettings.snapshot_query, "true").newGraphDatabase();
    }

    private TransactionIdStore getTransactionIdStore() {
        DependencyResolver dependencyResolver = ((GraphDatabaseAPI)this.database).getDependencyResolver();
        return (TransactionIdStore)dependencyResolver.resolveDependency(TransactionIdStore.class);
    }

    private class TestTransactionVersionContextSupplier
    extends TransactionVersionContextSupplier {
        private TestTransactionVersionContextSupplier() {
        }

        void setCursorContext(VersionContext versionContext) {
            this.cursorContext.set(versionContext);
        }
    }

    private class TestVersionContext
    extends TransactionVersionContext {
        private boolean useCorrectLastCommittedTxId;
        private int additionalAttempts;

        TestVersionContext(LongSupplier transactionIdSupplier2) {
            super(transactionIdSupplier2);
        }

        public long lastClosedTransactionId() {
            return this.useCorrectLastCommittedTxId ? 1L : super.lastClosedTransactionId();
        }

        public void markAsDirty() {
            super.markAsDirty();
            this.useCorrectLastCommittedTxId = true;
        }

        public boolean isDirty() {
            ++this.additionalAttempts;
            return super.isDirty();
        }

        int getAdditionalAttempts() {
            return this.additionalAttempts;
        }
    }

    private class CustomFacadeFactory
    extends GraphDatabaseFacadeFactory {
        CustomFacadeFactory() {
            super(DatabaseInfo.COMMUNITY, CommunityEditionModule::new);
        }

        protected PlatformModule createPlatform(File storeDir, Config config, GraphDatabaseFacadeFactory.Dependencies dependencies, GraphDatabaseFacade graphDatabaseFacade) {
            return new PlatformModule(storeDir, config, this.databaseInfo, dependencies, graphDatabaseFacade){

                protected VersionContextSupplier createCursorContextSupplier(Config config) {
                    return EagerResultIT.this.testContextSupplier != null ? EagerResultIT.this.testContextSupplier : super.createCursorContextSupplier(config);
                }
            };
        }
    }

    private class CustomGraphDatabaseFactory
    extends TestGraphDatabaseFactory {
        private GraphDatabaseFacadeFactory customFacadeFactory;

        CustomGraphDatabaseFactory(GraphDatabaseFacadeFactory customFacadeFactory) {
            this.customFacadeFactory = customFacadeFactory;
        }

        protected GraphDatabaseBuilder.DatabaseCreator createDatabaseCreator(final File storeDir, final GraphDatabaseFactoryState state) {
            return new GraphDatabaseBuilder.DatabaseCreator(){

                public GraphDatabaseService newDatabase(Map<String, String> config) {
                    return this.newDatabase(Config.defaults(config));
                }

                public GraphDatabaseService newDatabase(Config config) {
                    return CustomGraphDatabaseFactory.this.customFacadeFactory.newFacade(storeDir, config, (GraphDatabaseFacadeFactory.Dependencies)GraphDatabaseDependencies.newDependencies((GraphDatabaseFacadeFactory.Dependencies)state.databaseDependencies()));
                }
            };
        }
    }
}

