/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.javacompat;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.cypher.internal.CommunityCompatibilityFactory;
import org.neo4j.cypher.internal.CompatibilityFactory;
import org.neo4j.cypher.internal.javacompat.ExecutionEngine;
import org.neo4j.cypher.javacompat.internal.GraphDatabaseCypherService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Result;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.PropertyContainerLocker;
import org.neo4j.kernel.impl.query.Neo4jTransactionalContextFactory;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.impl.query.TransactionalContextFactory;
import org.neo4j.kernel.impl.query.clientconnection.ClientConnectionInfo;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.ImpermanentDatabaseRule;
import org.neo4j.values.virtual.VirtualValues;

public class ExecutionEngineTest {
    private static final Map<String, Object> NO_PARAMS = Collections.emptyMap();
    @Rule
    public DatabaseRule database = new ImpermanentDatabaseRule();

    @Test
    public void shouldConvertListsAndMapsWhenPassingFromScalaToJava() throws Exception {
        GraphDatabaseCypherService graph = new GraphDatabaseCypherService((GraphDatabaseService)this.database.getGraphDatabaseAPI());
        KernelAPI kernelAPI = (KernelAPI)graph.getDependencyResolver().resolveDependency(KernelAPI.class);
        Monitors monitors = (Monitors)graph.getDependencyResolver().resolveDependency(Monitors.class);
        NullLogProvider nullLogProvider = NullLogProvider.getInstance();
        CommunityCompatibilityFactory compatibilityFactory = new CommunityCompatibilityFactory((GraphDatabaseQueryService)graph, kernelAPI, monitors, (LogProvider)nullLogProvider);
        ExecutionEngine executionEngine = new ExecutionEngine((GraphDatabaseQueryService)graph, (LogProvider)nullLogProvider, (CompatibilityFactory)compatibilityFactory);
        try (InternalTransaction tx = graph.beginTransaction(KernelTransaction.Type.implicit, SecurityContext.AUTH_DISABLED);){
            String query = "RETURN { key : 'Value' , collectionKey: [{ inner: 'Map1' }, { inner: 'Map2' }]}";
            TransactionalContext tc = this.createTransactionContext((GraphDatabaseQueryService)graph, tx, query);
            Result result2 = executionEngine.executeQuery(query, NO_PARAMS, tc);
            this.verifyResult(result2);
            result2.close();
            tx.success();
        }
    }

    private void verifyResult(Result result2) {
        Map firstRowValue = (Map)result2.next().values().iterator().next();
        Assert.assertThat(firstRowValue.get("key"), (Matcher)Is.is((Object)"Value"));
        List theList = (List)firstRowValue.get("collectionKey");
        Assert.assertThat(((Map)theList.get(0)).get("inner"), (Matcher)Is.is((Object)"Map1"));
        Assert.assertThat(((Map)theList.get(1)).get("inner"), (Matcher)Is.is((Object)"Map2"));
    }

    private TransactionalContext createTransactionContext(GraphDatabaseQueryService graph, InternalTransaction tx, String query) {
        PropertyContainerLocker locker = new PropertyContainerLocker();
        TransactionalContextFactory contextFactory = Neo4jTransactionalContextFactory.create((GraphDatabaseQueryService)graph, (PropertyContainerLocker)locker);
        return contextFactory.newContext(ClientConnectionInfo.EMBEDDED_CONNECTION, tx, query, VirtualValues.EMPTY_MAP);
    }
}

