/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.javacompat;

import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNull;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.cypher.ArithmeticException;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.TopLevelTransaction;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

public class ExecutionResultTest {
    @Rule
    public final ImpermanentDatabaseRule db = new ImpermanentDatabaseRule();

    @Test
    public void shouldCloseTransactionsWhenIteratingResults() throws Exception {
        this.createNode();
        this.createNode();
        Result executionResult = this.db.execute("CYPHER runtime=interpreted MATCH (n) RETURN n");
        executionResult.next();
        MatcherAssert.assertThat((Object)this.activeTransaction(), (Matcher)Matchers.is((Matcher)IsNull.notNullValue()));
        executionResult.close();
        MatcherAssert.assertThat((Object)this.activeTransaction(), (Matcher)Matchers.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldCloseTransactionsWhenIteratingOverSingleColumn() throws Exception {
        this.createNode();
        this.createNode();
        Result executionResult = this.db.execute("CYPHER runtime=interpreted MATCH (n) RETURN n");
        ResourceIterator resultIterator = executionResult.columnAs("n");
        resultIterator.next();
        MatcherAssert.assertThat((Object)this.activeTransaction(), (Matcher)Matchers.is((Matcher)IsNull.notNullValue()));
        resultIterator.close();
        MatcherAssert.assertThat((Object)this.activeTransaction(), (Matcher)Matchers.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldThrowAppropriateException() throws Exception {
        try {
            this.db.execute("RETURN rand()/0").next();
        }
        catch (QueryExecutionException ex) {
            MatcherAssert.assertThat((Object)ex.getCause(), (Matcher)Matchers.instanceOf(QueryExecutionKernelException.class));
            MatcherAssert.assertThat((Object)ex.getCause().getCause(), (Matcher)Matchers.instanceOf(ArithmeticException.class));
        }
    }

    @Test(expected=ArithmeticException.class)
    public void shouldThrowAppropriateExceptionAlsoWhenVisiting() throws Exception {
        this.db.execute("RETURN rand()/0").accept(row2 -> true);
    }

    private void createNode() {
        try (Transaction tx = this.db.beginTx();){
            this.db.createNode();
            tx.success();
        }
    }

    @Test
    public void shouldHandleListsOfPointsAsInput() {
        Point point1 = (Point)this.db.execute("RETURN point({latitude: 12.78, longitude: 56.7}) as point").next().get("point");
        Point point2 = (Point)this.db.execute("RETURN point({latitude: 12.18, longitude: 56.2}) as point").next().get("point");
        double distance = (Double)this.db.execute("RETURN distance({points}[0], {points}[1]) as dist", MapUtil.map((Object[])new Object[]{"points", Arrays.asList(point1, point2)})).next().get("dist");
        MatcherAssert.assertThat((Object)Math.round(distance), (Matcher)CoreMatchers.equalTo((Object)86107L));
    }

    @Test
    public void shouldHandleMapWithPointsAsInput() {
        Point point1 = (Point)this.db.execute("RETURN point({latitude: 12.78, longitude: 56.7}) as point").next().get("point");
        Point point2 = (Point)this.db.execute("RETURN point({latitude: 12.18, longitude: 56.2}) as point").next().get("point");
        double distance = (Double)this.db.execute("RETURN distance({points}['p1'], {points}['p2']) as dist", MapUtil.map((Object[])new Object[]{"points", MapUtil.map((Object[])new Object[]{"p1", point1, "p2", point2})})).next().get("dist");
        MatcherAssert.assertThat((Object)Math.round(distance), (Matcher)CoreMatchers.equalTo((Object)86107L));
    }

    private TopLevelTransaction activeTransaction() {
        ThreadToStatementContextBridge bridge = (ThreadToStatementContextBridge)this.db.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
        KernelTransaction kernelTransaction = bridge.getTopLevelTransactionBoundToThisThread(false);
        return kernelTransaction == null ? null : new TopLevelTransaction(kernelTransaction, null);
    }
}

