/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.javacompat;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Result;
import org.neo4j.test.TestGraphDatabaseFactory;

public class JavaValueCompatibilityTest {
    private GraphDatabaseService db;

    @Before
    public void setUp() throws IOException {
        this.db = new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().newGraphDatabase();
    }

    @After
    public void tearDown() {
        this.db.shutdown();
    }

    @Test
    public void collections_in_collections_look_aiight() throws Exception {
        Result result2 = this.db.execute("CREATE (n:TheNode) RETURN [[ [1,2],[3,4] ],[[5,6]]] as x");
        Map next = result2.next();
        List x = (List)next.get("x");
        Iterable objects = (Iterable)x.get(0);
        MatcherAssert.assertThat((Object)objects, (Matcher)Matchers.isA(Iterable.class));
    }
}

