/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.javacompat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.InputPosition;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.SeverityLevel;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.impl.notification.NotificationCode;
import org.neo4j.graphdb.impl.notification.NotificationDetail;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.procedure.Procedure;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

public class NotificationAcceptanceTest {
    @Rule
    public final ImpermanentDatabaseRule rule = new ImpermanentDatabaseRule();
    private Matcher<Notification> cartesianProductWarning = this.notification("Neo.ClientNotification.Statement.CartesianProductWarning", (Matcher<String>)Matchers.containsString((String)"If a part of a query contains multiple disconnected patterns, this will build a cartesian product between all those parts. This may produce a large amount of data and slow down query processing. While occasionally intended, it may often be possible to reformulate the query that avoids the use of this cross product, perhaps by adding a relationship between the different parts or by using OPTIONAL MATCH"), (Matcher<InputPosition>)Matchers.any(InputPosition.class), SeverityLevel.WARNING);
    private Matcher<Notification> largeLabelCSVWarning = this.notification("Neo.ClientNotification.Statement.NoApplicableIndexWarning", (Matcher<String>)Matchers.containsString((String)"Using LOAD CSV with a large data set in a query where the execution plan contains the Using LOAD CSV followed by a MATCH or MERGE that matches a non-indexed label will most likely not perform well on large data sets. Please consider using a schema index."), (Matcher<InputPosition>)Matchers.any(InputPosition.class), SeverityLevel.WARNING);
    private Matcher<Notification> deprecatedFeatureWarning = this.notification("Neo.ClientNotification.Statement.FeatureDeprecationWarning", (Matcher<String>)Matchers.containsString((String)"The query used a deprecated function."), (Matcher<InputPosition>)Matchers.any(InputPosition.class), SeverityLevel.WARNING);
    private Matcher<Notification> deprecatedStartWarning = this.notification("Neo.ClientNotification.Statement.FeatureDeprecationWarning", (Matcher<String>)Matchers.containsString((String)"START has been deprecated and will be removed in a future version. "), (Matcher<InputPosition>)Matchers.any(InputPosition.class), SeverityLevel.WARNING);
    private Matcher<Notification> deprecatedProcedureWarning = this.notification("Neo.ClientNotification.Statement.FeatureDeprecationWarning", (Matcher<String>)Matchers.containsString((String)"The query used a deprecated procedure."), (Matcher<InputPosition>)Matchers.any(InputPosition.class), SeverityLevel.WARNING);
    private Matcher<Notification> deprecatedProcedureReturnFieldWarning = this.notification("Neo.ClientNotification.Statement.FeatureDeprecationWarning", (Matcher<String>)Matchers.containsString((String)"The query used a deprecated field from a procedure."), (Matcher<InputPosition>)Matchers.any(InputPosition.class), SeverityLevel.WARNING);
    private Matcher<Notification> depracatedBindingWarning = this.notification("Neo.ClientNotification.Statement.FeatureDeprecationWarning", (Matcher<String>)Matchers.containsString((String)"Binding relationships to a list in a variable length pattern is deprecated."), (Matcher<InputPosition>)Matchers.any(InputPosition.class), SeverityLevel.WARNING);
    private Matcher<Notification> deprecatedSeparatorWarning = this.notification("Neo.ClientNotification.Statement.FeatureDeprecationWarning", (Matcher<String>)Matchers.containsString((String)"The semantics of using colon in the separation of alternative relationship types in conjunction with the use of variable binding, inlined property predicates, or variable length will change in a future version."), (Matcher<InputPosition>)Matchers.any(InputPosition.class), SeverityLevel.WARNING);
    private Matcher<Notification> eagerOperatorWarning = this.notification("Neo.ClientNotification.Statement.EagerOperatorWarning", (Matcher<String>)Matchers.containsString((String)"Using LOAD CSV with a large data set in a query where the execution plan contains the Eager operator could potentially consume a lot of memory and is likely to not perform well. See the Neo4j Manual entry on the Eager operator for more information and hints on how problems could be avoided."), (Matcher<InputPosition>)Matchers.any(InputPosition.class), SeverityLevel.WARNING);
    private Matcher<Notification> unknownPropertyKeyWarning = this.notification("Neo.ClientNotification.Statement.UnknownPropertyKeyWarning", (Matcher<String>)Matchers.containsString((String)"the missing property name is"), (Matcher<InputPosition>)Matchers.any(InputPosition.class), SeverityLevel.WARNING);
    private Matcher<Notification> unknownRelationshipWarning = this.notification("Neo.ClientNotification.Statement.UnknownRelationshipTypeWarning", (Matcher<String>)Matchers.containsString((String)"the missing relationship type is"), (Matcher<InputPosition>)Matchers.any(InputPosition.class), SeverityLevel.WARNING);
    private Matcher<Notification> unknownLabelWarning = this.notification("Neo.ClientNotification.Statement.UnknownLabelWarning", (Matcher<String>)Matchers.containsString((String)"the missing label name is"), (Matcher<InputPosition>)Matchers.any(InputPosition.class), SeverityLevel.WARNING);
    private Matcher<Notification> dynamicPropertyWarning = this.notification("Neo.ClientNotification.Statement.DynamicPropertyWarning", (Matcher<String>)Matchers.containsString((String)"Using a dynamic property makes it impossible to use an index lookup for this query"), (Matcher<InputPosition>)Matchers.any(InputPosition.class), SeverityLevel.WARNING);
    private Matcher<Notification> joinHintUnsuportedWarning = this.notification("Neo.Status.Statement.JoinHintUnsupportedWarning", (Matcher<String>)Matchers.containsString((String)"Using RULE planner is unsupported for queries with join hints, please use COST planner instead"), (Matcher<InputPosition>)Matchers.any(InputPosition.class), SeverityLevel.WARNING);

    @Test
    public void shouldNotifyWhenUsingCypher3_1ForTheRulePlannerWhenCypherVersionIsTheDefault() throws Exception {
        Result result2 = this.db().execute("CYPHER planner=rule RETURN 1");
        InputPosition position = new InputPosition(20, 1, 21);
        Assert.assertThat((Object)result2.getNotifications(), (Matcher)Matchers.contains((Object[])new Notification[]{NotificationCode.RULE_PLANNER_UNAVAILABLE_FALLBACK.notification(position, new NotificationDetail[0])}));
        Map arguments = result2.getExecutionPlanDescription().getArguments();
        Assert.assertThat(arguments.get("version"), (Matcher)Matchers.equalTo((Object)"CYPHER 3.1"));
        Assert.assertThat(arguments.get("planner"), (Matcher)Matchers.equalTo((Object)"RULE"));
        result2.close();
    }

    @Test
    public void shouldFailWhenSpecifyingCypher3_3ForTheRulePlanner() throws Exception {
        try {
            this.db().execute("CYPHER 3.3 planner=rule RETURN 1");
            Assert.fail();
        }
        catch (QueryExecutionException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)"Unsupported PLANNER - VERSION combination: rule - 3.3"));
        }
    }

    @Test
    public void shouldFailWhenSpecifyingCypher3_2ForTheRulePlanner() throws Exception {
        try {
            this.db().execute("CYPHER 3.2 planner=rule RETURN 1");
            Assert.fail();
        }
        catch (QueryExecutionException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)"Unsupported PLANNER - VERSION combination: rule - 3.2"));
        }
    }

    @Test
    public void shouldNotNotifyWhenUsingTheRulePlannerWhenCypherVersionIsNot3_2() throws Exception {
        Stream.of("CYPHER 3.1", "CYPHER 2.3").forEach(version -> {
            Result result2 = this.db().execute(version + " planner=rule RETURN 1");
            Assert.assertThat((Object)Iterables.asList((Iterable)result2.getNotifications()), (Matcher)Matchers.empty());
            Map arguments = result2.getExecutionPlanDescription().getArguments();
            Assert.assertThat(arguments.get("version"), (Matcher)Matchers.equalTo((Object)version));
            Assert.assertThat(arguments.get("planner"), (Matcher)Matchers.equalTo((Object)"RULE"));
            result2.close();
        });
    }

    @Test
    public void shouldWarnWhenRequestingCompiledRuntimeOnUnsupportedQuery() throws Exception {
        Stream.of("CYPHER 3.1", "CYPHER 3.2", "CYPHER 3.3").forEach(version -> this.shouldNotifyInStream((String)version, "EXPLAIN CYPHER runtime=compiled MATCH (a)-->(b), (c)-->(d) RETURN count(*)", InputPosition.empty, NotificationCode.RUNTIME_UNSUPPORTED));
    }

    @Test
    public void shouldWarnWhenRequestingSlottedRuntimeOnUnsupportedQuery() throws Exception {
        Stream.of("CYPHER 3.3").forEach(version -> this.shouldNotifyInStream((String)version, "explain cypher runtime=slotted merge (a)-[:X]->(b)", InputPosition.empty, NotificationCode.RUNTIME_UNSUPPORTED));
    }

    @Test
    public void shouldNotifyWhenUsingCreateUniqueWhenCypherVersionIsDefault() throws Exception {
        Result result2 = this.db().execute("MATCH (b) WITH b LIMIT 1 CREATE UNIQUE (b)-[:REL]->()");
        InputPosition position = new InputPosition(25, 1, 26);
        Assert.assertThat((Object)result2.getNotifications(), (Matcher)Matchers.contains((Object[])new Notification[]{NotificationCode.CREATE_UNIQUE_UNAVAILABLE_FALLBACK.notification(position, new NotificationDetail[0])}));
        Map arguments = result2.getExecutionPlanDescription().getArguments();
        Assert.assertThat(arguments.get("version"), (Matcher)Matchers.equalTo((Object)"CYPHER 3.1"));
        result2.close();
    }

    @Test
    public void shouldNotifyWhenUsingCreateUniqueWhenCypherVersionIs3_3() throws Exception {
        Result result2 = this.db().execute("CYPHER 3.3 MATCH (b) WITH b LIMIT 1 CREATE UNIQUE (b)-[:REL]->()");
        InputPosition position = new InputPosition(36, 1, 37);
        Assert.assertThat((Object)result2.getNotifications(), (Matcher)Matchers.contains((Object[])new Notification[]{NotificationCode.CREATE_UNIQUE_UNAVAILABLE_FALLBACK.notification(position, new NotificationDetail[0])}));
        Map arguments = result2.getExecutionPlanDescription().getArguments();
        Assert.assertThat(arguments.get("version"), (Matcher)Matchers.equalTo((Object)"CYPHER 3.1"));
        result2.close();
    }

    @Test
    public void shouldNotifyWhenUsingCreateUniqueWhenCypherVersionIs3_2() throws Exception {
        Result result2 = this.db().execute("CYPHER 3.2 MATCH (b) WITH b LIMIT 1 CREATE UNIQUE (b)-[:REL]->()");
        InputPosition position = new InputPosition(36, 1, 37);
        Assert.assertThat((Object)result2.getNotifications(), (Matcher)Matchers.contains((Object[])new Notification[]{NotificationCode.CREATE_UNIQUE_UNAVAILABLE_FALLBACK.notification(position, new NotificationDetail[0])}));
        Map arguments = result2.getExecutionPlanDescription().getArguments();
        Assert.assertThat(arguments.get("version"), (Matcher)Matchers.equalTo((Object)"CYPHER 3.1"));
        result2.close();
    }

    @Test
    public void shouldNotNotifyWhenUsingCreateUniqueWhenCypherVersionIsNot3_2() throws Exception {
        Stream.of("CYPHER 3.1", "CYPHER 2.3").forEach(version -> this.shouldNotNotifyInStream((String)version, " MATCH (b) WITH b LIMIT 1 CREATE UNIQUE (b)-[:REL]->()"));
    }

    @Test
    public void shouldWarnWhenUsingLengthOnNonPath() throws Exception {
        Stream.of("CYPHER 3.1", "CYPHER 3.2", "CYPHER 3.3").forEach(version -> {
            this.shouldNotifyInStream((String)version, "explain match (a) where a.name='Alice' return length((a)-->()-->())", new InputPosition(63, 1, 64), NotificationCode.LENGTH_ON_NON_PATH);
            this.shouldNotifyInStream((String)version, " explain return length([1, 2, 3])", new InputPosition(33, 1, 34), NotificationCode.LENGTH_ON_NON_PATH);
            this.shouldNotifyInStream((String)version, " explain return length('a string')", new InputPosition(33, 1, 34), NotificationCode.LENGTH_ON_NON_PATH);
        });
    }

    @Test
    public void shouldNotNotifyWhenUsingLengthOnPath() throws Exception {
        Stream.of("CYPHER 2.3", "CYPHER 3.1", "CYPHER 3.2", "CYPHER 3.3").forEach(version -> this.shouldNotNotifyInStream((String)version, " explain match p=(a)-[*]->(b) return length(p)"));
    }

    @Test
    public void shouldNotNotifyWhenUsingSizeOnCollection() throws Exception {
        Stream.of("CYPHER 2.3", "CYPHER 3.1", "CYPHER 3.2", "CYPHER 3.3").forEach(version -> this.shouldNotNotifyInStream((String)version, "explain return size([1, 2, 3])"));
    }

    @Test
    public void shouldNotNotifyWhenUsingSizeOnString() throws Exception {
        Stream.of("CYPHER 2.3", "CYPHER 3.1", "CYPHER 3.2", "CYPHER 3.3").forEach(version -> this.shouldNotNotifyInStream((String)version, " explain return size('a string')"));
    }

    @Test
    public void shouldNotNotifyForCostUnsupportedUpdateQueryIfPlannerNotExplicitlyRequested() throws Exception {
        Stream.of("CYPHER 2.3", "CYPHER 3.1", "CYPHER 3.2", "CYPHER 3.3").forEach(version -> this.shouldNotNotifyInStream((String)version, " EXPLAIN MATCH (n:Movie) SET n.title = 'The Movie'"));
    }

    @Test
    public void shouldNotNotifyForCostSupportedUpdateQuery() throws Exception {
        Stream.of("CYPHER 3.1", "CYPHER 3.2", "CYPHER 3.3").forEach(version -> {
            this.shouldNotNotifyInStream((String)version, "EXPLAIN CYPHER planner=cost MATCH (n:Movie) SET n:Seen");
            this.shouldNotNotifyInStream((String)version, "EXPLAIN CYPHER planner=idp MATCH (n:Movie) SET n:Seen");
            this.shouldNotNotifyInStream((String)version, "EXPLAIN CYPHER planner=dp MATCH (n:Movie) SET n:Seen");
        });
    }

    @Test
    public void shouldNotNotifyUsingJoinHintWithCost() throws Exception {
        List<String> queries = Arrays.asList("CYPHER planner=cost EXPLAIN MATCH (a)-->(b) USING JOIN ON b RETURN a, b", "CYPHER planner=cost EXPLAIN MATCH (a)-->(x)<--(b) USING JOIN ON x RETURN a, b");
        Stream.of("CYPHER 2.3", "CYPHER 3.1", "CYPHER 3.2", "CYPHER 3.3").forEach(version -> {
            for (String query : queries) {
                this.assertNotifications(version + query, this.containsNoItem(this.joinHintUnsuportedWarning));
            }
        });
    }

    @Test
    public void shouldWarnOnPotentiallyCachedQueries() throws Exception {
        Stream.of("CYPHER 2.3", "CYPHER 3.1", "CYPHER 3.2", "CYPHER 3.3").forEach(version -> {
            this.assertNotifications(version + "explain match (a)-->(b), (c)-->(d) return *", this.containsItem(this.cartesianProductWarning));
            this.shouldNotNotifyInStream((String)version, "match (a)-->(b), (c)-->(d) return *");
        });
    }

    @Test
    public void shouldWarnOnceWhenSingleIndexHintCannotBeFulfilled() throws Exception {
        Stream.of("CYPHER 2.3", "CYPHER 3.1", "CYPHER 3.2", "CYPHER 3.3").forEach(version -> this.shouldNotifyInStreamWithDetail((String)version, " EXPLAIN MATCH (n:Person) USING INDEX n:Person(name) WHERE n.name = 'John' RETURN n", InputPosition.empty, NotificationCode.INDEX_HINT_UNFULFILLABLE, NotificationDetail.Factory.index((String)"Person", (String[])new String[]{"name"})));
    }

    @Test
    public void shouldWarnOnEachUnfulfillableIndexHint() throws Exception {
        String query = " EXPLAIN MATCH (n:Person), (m:Party), (k:Animal) USING INDEX n:Person(name) USING INDEX m:Party(city) USING INDEX k:Animal(species) WHERE n.name = 'John' AND m.city = 'Reykjavik' AND k.species = 'Sloth' RETURN n";
        Stream.of("CYPHER 2.3", "CYPHER 3.1", "CYPHER 3.2", "CYPHER 3.3").forEach(version -> {
            this.shouldNotifyInStreamWithDetail((String)version, query, InputPosition.empty, NotificationCode.INDEX_HINT_UNFULFILLABLE, NotificationDetail.Factory.index((String)"Person", (String[])new String[]{"name"}));
            this.shouldNotifyInStreamWithDetail((String)version, query, InputPosition.empty, NotificationCode.INDEX_HINT_UNFULFILLABLE, NotificationDetail.Factory.index((String)"Party", (String[])new String[]{"city"}));
            this.shouldNotifyInStreamWithDetail((String)version, query, InputPosition.empty, NotificationCode.INDEX_HINT_UNFULFILLABLE, NotificationDetail.Factory.index((String)"Animal", (String[])new String[]{"species"}));
        });
    }

    @Test
    public void shouldNotNotifyOnLiteralMaps() throws Exception {
        Stream.of("CYPHER 3.1", "CYPHER 3.2", "CYPHER 3.3").forEach(version -> this.shouldNotNotifyInStream((String)version, " explain return { id: 42 } "));
    }

    @Test
    public void shouldNotNotifyOnNonExistingLabelUsingLoadCSV() throws Exception {
        Stream.of("CYPHER 3.1", "CYPHER 3.2", "CYPHER 3.3").forEach(version -> {
            this.shouldNotNotifyInStream((String)version, " EXPLAIN LOAD CSV WITH HEADERS FROM 'file:///fake.csv' AS row CREATE (n:Category)");
            this.shouldNotNotifyInStream((String)version, " EXPLAIN LOAD CSV WITH HEADERS FROM 'file:///fake.csv' AS row MERGE (n:Category)");
            this.shouldNotNotifyInStream((String)version, " EXPLAIN LOAD CSV WITH HEADERS FROM 'file:///fake.csv' AS row CREATE (n) SET n:Category");
        });
    }

    @Test
    public void shouldNotNotifyOnNonExistingRelTypeUsingLoadCSV() throws Exception {
        Stream.of("CYPHER 3.1", "CYPHER 3.2", "CYPHER 3.3").forEach(version -> {
            this.shouldNotNotifyInStream((String)version, " EXPLAIN LOAD CSV WITH HEADERS FROM 'file:///fake.csv' AS row CREATE ()-[:T]->()");
            this.shouldNotNotifyInStream((String)version, " EXPLAIN LOAD CSV WITH HEADERS FROM 'file:///fake.csv' AS row MERGE ()-[:T]->()");
        });
    }

    @Test
    public void shouldNotNotifyOnNonExistingPropKeyIdUsingLoadCSV() throws Exception {
        Stream.of("CYPHER 3.1", "CYPHER 3.2", "CYPHER 3.3").forEach(version -> {
            this.shouldNotNotifyInStream((String)version, " EXPLAIN LOAD CSV WITH HEADERS FROM 'file:///fake.csv' AS row CREATE (n) SET n.p = 'a'");
            this.shouldNotNotifyInStream((String)version, " EXPLAIN LOAD CSV WITH HEADERS FROM 'file:///fake.csv' AS row MERGE (n) ON CREATE SET n.p = 'a'");
        });
    }

    @Test
    public void shouldNotNotifyOnEagerBeforeLoadCSVDelete() throws Exception {
        Stream.of("CYPHER 3.1", "CYPHER 3.2", "CYPHER 3.3").forEach(version -> this.shouldNotNotifyInStream((String)version, "EXPLAIN MATCH (n) DELETE n WITH * LOAD CSV FROM 'file:///ignore/ignore.csv' AS line MERGE () RETURN line"));
    }

    @Test
    public void shouldNotNotifyOnEagerBeforeLoadCSVCreate() throws Exception {
        Stream.of("CYPHER 3.1", "CYPHER 3.2", "CYPHER 3.3").forEach(version -> this.assertNotifications(version + "EXPLAIN MATCH (a), (b) CREATE (c) WITH c LOAD CSV FROM 'file:///ignore/ignore.csv' AS line RETURN *", this.containsNoItem(this.eagerOperatorWarning)));
    }

    @Test
    public void shouldWarnOnEagerAfterLoadCSV() throws Exception {
        Stream.of("CYPHER 3.1", "CYPHER 3.2", "CYPHER 3.3").forEach(version -> this.shouldNotifyInStream((String)version, "EXPLAIN MATCH (n) LOAD CSV FROM 'file:///ignore/ignore.csv' AS line WITH * DELETE n MERGE () RETURN line", InputPosition.empty, NotificationCode.EAGER_LOAD_CSV));
    }

    @Test
    public void shouldNotNotifyOnLoadCSVWithoutEager() throws Exception {
        Stream.of("CYPHER 3.1", "CYPHER 3.2", "CYPHER 3.3").forEach(version -> this.shouldNotNotifyInStream((String)version, "EXPLAIN LOAD CSV FROM 'file:///ignore/ignore.csv' AS line MATCH (:A) CREATE (:B) RETURN line"));
    }

    @Test
    public void shouldNotNotifyOnEagerWithoutLoadCSV() throws Exception {
        Stream.of("CYPHER 3.1", "CYPHER 3.2", "CYPHER 3.3").forEach(version -> this.assertNotifications(version + "EXPLAIN MATCH (a), (b) CREATE (c) RETURN *", this.containsNoItem(this.eagerOperatorWarning)));
    }

    @Test
    public void shouldWarnOnLargeLabelScansWithLoadCVSMatch() throws Exception {
        for (int i = 0; i < 11; ++i) {
            try (Transaction tx = this.db().beginTx();){
                this.db().createNode().addLabel(Label.label((String)"A"));
                tx.success();
                continue;
            }
        }
        Stream.of("CYPHER 3.1", "CYPHER 3.2", "CYPHER 3.3").forEach(version -> this.assertNotifications(version + "EXPLAIN LOAD CSV FROM 'file:///ignore/ignore.csv' AS line MATCH (a:A) RETURN *", this.containsNoItem(this.largeLabelCSVWarning)));
    }

    @Test
    public void shouldWarnOnLargeLabelScansWithLoadCVSMerge() throws Exception {
        for (int i = 0; i < 11; ++i) {
            try (Transaction tx = this.db().beginTx();){
                this.db().createNode().addLabel(Label.label((String)"A"));
                tx.success();
                continue;
            }
        }
        Stream.of("CYPHER 3.1", "CYPHER 3.2", "CYPHER 3.3").forEach(version -> this.assertNotifications(version + "EXPLAIN LOAD CSV FROM 'file:///ignore/ignore.csv' AS line MERGE (a:A) RETURN *", this.containsNoItem(this.largeLabelCSVWarning)));
    }

    @Test
    public void shouldNotWarnOnSmallLabelScansWithLoadCVS() throws Exception {
        try (Transaction tx = this.db().beginTx();){
            this.db().createNode().addLabel(Label.label((String)"A"));
            tx.success();
        }
        Stream.of("CYPHER 3.1", "CYPHER 3.2", "CYPHER 3.3").forEach(version -> {
            this.shouldNotNotifyInStream((String)version, "EXPLAIN LOAD CSV FROM 'file:///ignore/ignore.csv' AS line MATCH (a:A) RETURN *");
            this.shouldNotNotifyInStream((String)version, "EXPLAIN LOAD CSV FROM 'file:///ignore/ignore.csv' AS line MERGE (a:A) RETURN *");
        });
    }

    @Test
    public void shouldWarnOnDeprecatedToInt() throws Exception {
        Stream.of("CYPHER 3.1", "CYPHER 3.2", "CYPHER 3.3").forEach(version -> this.assertNotifications(version + " EXPLAIN RETURN toInt('1') AS one", this.containsItem(this.deprecatedFeatureWarning)));
    }

    @Test
    public void shouldWarnOnDeprecatedUpper() throws Exception {
        Stream.of("CYPHER 3.1", "CYPHER 3.2", "CYPHER 3.3").forEach(version -> this.assertNotifications(version + " EXPLAIN RETURN upper('foo') AS one", this.containsItem(this.deprecatedFeatureWarning)));
    }

    @Test
    public void shouldWarnOnDeprecatedLower() throws Exception {
        Stream.of("CYPHER 3.1", "CYPHER 3.2", "CYPHER 3.3").forEach(version -> this.assertNotifications(version + " EXPLAIN RETURN lower('BAR') AS one", this.containsItem(this.deprecatedFeatureWarning)));
    }

    @Test
    public void shouldWarnOnDeprecatedRels() throws Exception {
        Stream.of("CYPHER 3.1", "CYPHER 3.2", "CYPHER 3.3").forEach(version -> this.assertNotifications(version + " EXPLAIN MATCH p = ()-->() RETURN rels(p) AS r", this.containsItem(this.deprecatedFeatureWarning)));
    }

    @Test
    public void shouldWarnOnDeprecatedProcedureCalls() throws Exception {
        ((Procedures)this.db().getDependencyResolver().provideDependency(Procedures.class).get()).registerProcedure(TestProcedures.class);
        Stream.of("CYPHER 3.1", "CYPHER 3.2", "CYPHER 3.3").forEach(version -> {
            this.assertNotifications(version + "explain CALL oldProc()", this.containsItem(this.deprecatedProcedureWarning));
            this.assertNotifications(version + "explain CALL oldProc() RETURN 1", this.containsItem(this.deprecatedProcedureWarning));
        });
    }

    @Test
    public void shouldWarnOnDeprecatedProcedureResultField() throws Exception {
        ((Procedures)this.db().getDependencyResolver().provideDependency(Procedures.class).get()).registerProcedure(TestProcedures.class);
        Stream.of("CYPHER 3.2", "CYPHER 3.3").forEach(version -> this.assertNotifications(version + "explain CALL changedProc() YIELD oldField RETURN oldField", this.containsItem(this.deprecatedProcedureReturnFieldWarning)));
    }

    @Test
    public void shouldWarnOnUnboundedShortestPath() throws Exception {
        Stream.of("CYPHER 2.3", "CYPHER 3.1", "CYPHER 3.2", "CYPHER 3.3").forEach(version -> this.shouldNotifyInStream((String)version, "EXPLAIN MATCH p = shortestPath((n)-[*]->(m)) RETURN m", new InputPosition(44, 1, 45), NotificationCode.UNBOUNDED_SHORTEST_PATH));
    }

    @Test
    public void shouldNotNotifyOnDynamicPropertyLookupWithNoLabels() throws Exception {
        Stream.of("CYPHER 2.3", "CYPHER 3.1", "CYPHER 3.2", "CYPHER 3.3").forEach(version -> {
            this.db().execute("CREATE INDEX ON :Person(name)");
            this.db().execute("Call db.awaitIndexes()");
            this.shouldNotNotifyInStream((String)version, "EXPLAIN MATCH (n) WHERE n['key-' + n.name] = 'value' RETURN n");
        });
    }

    @Test
    public void shouldWarnOnDynamicPropertyLookupWithBothStaticAndDynamicProperties() throws Exception {
        Stream.of("CYPHER 2.3", "CYPHER 3.1", "CYPHER 3.2", "CYPHER 3.3").forEach(version -> {
            this.db().execute("CREATE INDEX ON :Person(name)");
            this.db().execute("Call db.awaitIndexes()");
            this.assertNotifications(version + "EXPLAIN MATCH (n:Person) WHERE n.name = 'Tobias' AND n['key-' + n.name] = 'value' RETURN n", this.containsItem(this.dynamicPropertyWarning));
        });
    }

    @Test
    public void shouldNotNotifyOnDynamicPropertyLookupWithLabelHavingNoIndex() throws Exception {
        Stream.of("CYPHER 2.3", "CYPHER 3.1", "CYPHER 3.2", "CYPHER 3.3").forEach(version -> {
            this.db().execute("CREATE INDEX ON :Person(name)");
            this.db().execute("Call db.awaitIndexes()");
            try (Transaction tx = this.db().beginTx();){
                this.db().createNode().addLabel(Label.label((String)"Foo"));
                tx.success();
            }
            this.shouldNotNotifyInStream((String)version, "EXPLAIN MATCH (n:Foo) WHERE n['key-' + n.name] = 'value' RETURN n");
        });
    }

    @Test
    public void shouldWarnOnUnfulfillableIndexSeekUsingDynamicProperty() throws Exception {
        ArrayList<String> queries = new ArrayList<String>();
        queries.add("EXPLAIN MATCH (n:Person) WHERE n['key-' + n.name] = 'value' RETURN n");
        queries.add("EXPLAIN MATCH (n) WHERE n['key-' + n.name] = 'value' AND (n:Person) RETURN n");
        queries.add("EXPLAIN MATCH (n:Person) WHERE n['key-' + n.name] > 10 RETURN n");
        queries.add("EXPLAIN MATCH (n:Person) WHERE 10 > n['key-' + n.name] RETURN n");
        queries.add("EXPLAIN MATCH (n:Person) WHERE exists(n['na' + 'me']) RETURN n");
        queries.add("EXPLAIN MATCH (n:Person) WHERE n['key-' + n.name] STARTS WITH 'Foo' RETURN n");
        queries.add("EXPLAIN MATCH (n:Person) WHERE n['key-' + n.name] =~ 'Foo*' RETURN n");
        queries.add("EXPLAIN MATCH (n:Person) WHERE n['key-' + n.name] IN ['Foo', 'Bar'] RETURN n");
        Stream.of("CYPHER 2.3", "CYPHER 3.1", "CYPHER 3.2", "CYPHER 3.3").forEach(version -> {
            for (String query : queries) {
                this.db().execute("CREATE INDEX ON :Person(name)");
                this.db().execute("Call db.awaitIndexes()");
                this.assertNotifications(version + query, this.containsItem(this.dynamicPropertyWarning));
            }
        });
    }

    @Test
    public void shouldNotNotifyOnDynamicPropertyLookupWithSingleLabelAndNegativePredicate() throws Exception {
        Stream.of("CYPHER 2.3", "CYPHER 3.1", "CYPHER 3.2", "CYPHER 3.3").forEach(version -> {
            this.db().execute("CREATE INDEX ON :Person(name)");
            this.db().execute("Call db.awaitIndexes()");
            this.shouldNotNotifyInStream((String)version, "EXPLAIN MATCH (n:Person) WHERE n['key-' + n.name] <> 'value' RETURN n");
        });
    }

    @Test
    public void shouldWarnOnUnfulfillableIndexSeekUsingDynamicPropertyAndMultipleLabels() throws Exception {
        Stream.of("CYPHER 3.2", "CYPHER 3.3").forEach(version -> {
            this.db().execute("CREATE INDEX ON :Person(name)");
            this.db().execute("Call db.awaitIndexes()");
            this.assertNotifications(version + "EXPLAIN MATCH (n:Person:Foo) WHERE n['key-' + n.name] = 'value' RETURN n", this.containsItem(this.dynamicPropertyWarning));
        });
    }

    @Test
    public void shouldWarnOnUnfulfillableIndexSeekUsingDynamicPropertyAndMultipleIndexedLabels() throws Exception {
        Stream.of("CYPHER 2.3", "CYPHER 3.1", "CYPHER 3.2", "CYPHER 3.3").forEach(version -> {
            this.db().execute("CREATE INDEX ON :Person(name)");
            this.db().execute("CREATE INDEX ON :Jedi(weapon)");
            this.db().execute("Call db.awaitIndexes()");
            this.assertNotifications(version + "EXPLAIN MATCH (n:Person:Jedi) WHERE n['key-' + n.name] = 'value' RETURN n", this.containsItem(this.dynamicPropertyWarning));
        });
    }

    @Test
    public void shouldWarnOnFutureAmbiguousRelTypeSeparator() throws Exception {
        List<String> deprecatedQueries = Arrays.asList("explain MATCH (a)-[:A|:B|:C {foo:'bar'}]-(b) RETURN a,b", "explain MATCH (a)-[x:A|:B|:C]-() RETURN a", "explain MATCH (a)-[:A|:B|:C*]-() RETURN a");
        List<String> nonDeprecatedQueries = Arrays.asList("explain MATCH (a)-[:A|B|C {foo:'bar'}]-(b) RETURN a,b", "explain MATCH (a)-[:A|:B|:C]-(b) RETURN a,b", "explain MATCH (a)-[:A|B|C]-(b) RETURN a,b");
        for (String query : deprecatedQueries) {
            this.assertNotifications("CYPHER 3.3 " + query, this.containsItem(this.deprecatedSeparatorWarning));
        }
        for (String query : nonDeprecatedQueries) {
            this.assertNotifications("CYPHER 3.3 " + query, this.containsNoItem(this.deprecatedSeparatorWarning));
        }
    }

    @Test
    public void shouldWarnOnBindingVariableLengthRelationship() throws Exception {
        this.assertNotifications("CYPHER 3.3 explain MATCH ()-[rs*]-() RETURN rs", this.containsItem(this.depracatedBindingWarning));
        this.assertNotifications("CYPHER 3.3 explain MATCH p = ()-[*]-() RETURN relationships(p) AS rs", this.containsNoItem(this.depracatedBindingWarning));
    }

    @Test
    public void shouldWarnOnCartesianProduct() throws Exception {
        Stream.of("CYPHER 3.1", "CYPHER 3.2", "CYPHER 3.3").forEach(version -> {
            this.assertNotifications(version + "explain match (a)-->(b), (c)-->(d) return *", this.containsItem(this.cartesianProductWarning));
            this.assertNotifications(version + "explain cypher runtime=compiled match (a)-->(b), (c)-->(d) return *", this.containsItem(this.cartesianProductWarning));
            this.assertNotifications(version + "explain cypher runtime=interpreted match (a)-->(b), (c)-->(d) return *", this.containsItem(this.cartesianProductWarning));
        });
    }

    @Test
    public void shouldNotNotifyOnCartesianProductWithoutExplain() throws Exception {
        Stream.of("CYPHER 2.3", "CYPHER 3.1", "CYPHER 3.2", "CYPHER 3.3").forEach(version -> this.shouldNotNotifyInStream((String)version, " match (a)-->(b), (c)-->(d) return *"));
    }

    @Test
    public void shouldWarnOnMissingLabel() throws Exception {
        this.assertNotifications("EXPLAIN MATCH (a:NO_SUCH_THING) RETURN a", this.containsItem(this.unknownLabelWarning));
    }

    @Test
    public void shouldWarnOnMisspelledLabel() throws Exception {
        try (Transaction tx = this.db().beginTx();){
            this.db().createNode().addLabel(Label.label((String)"Person"));
            tx.success();
        }
        Stream.of("CYPHER 2.3", "CYPHER 3.1", "CYPHER 3.2", "CYPHER 3.3").forEach(version -> {
            this.assertNotifications(version + "EXPLAIN MATCH (n:Preson) RETURN *", this.containsItem(this.unknownLabelWarning));
            this.shouldNotNotifyInStream((String)version, "EXPLAIN MATCH (n:Person) RETURN *");
        });
    }

    @Test
    public void shouldWarnOnMissingLabelWithCommentInBeginningWithOlderCypherVersions() throws Exception {
        this.assertNotifications("CYPHER 2.3 EXPLAIN//TESTING \nMATCH (n:X) return n Limit 1", this.containsItem(this.unknownLabelWarning));
        this.assertNotifications("CYPHER 3.1 EXPLAIN//TESTING \nMATCH (n:X) return n Limit 1", this.containsItem(this.unknownLabelWarning));
    }

    @Test
    public void shouldWarnOnMissingLabelWithCommentInBeginning() throws Exception {
        this.assertNotifications("EXPLAIN//TESTING \nMATCH (n:X) return n Limit 1", this.containsItem(this.unknownLabelWarning));
    }

    @Test
    public void shouldWarnOnMissingLabelWithCommentInBeginningTwoLines() throws Exception {
        this.assertNotifications("//TESTING \n //TESTING \n EXPLAIN MATCH (n)\n MATCH (b:X) return n,b Limit 1", this.containsItem(this.unknownLabelWarning));
    }

    @Test
    public void shouldWarnOnMissingLabelWithCommentInBeginningOnOneLine() throws Exception {
        this.assertNotifications("explain /* Testing */ MATCH (n:X) RETURN n", this.containsItem(this.unknownLabelWarning));
    }

    @Test
    public void shouldWarnOnMissingLabelWithCommentInMiddel() throws Exception {
        this.assertNotifications("EXPLAIN\nMATCH (n)\n//TESTING \nMATCH (n:X)\nreturn n Limit 1", this.containsItem(this.unknownLabelWarning));
    }

    @Test
    public void shouldNotNotifyForMissingLabelOnUpdate() throws Exception {
        Stream.of("CYPHER 2.3", "CYPHER 3.1", "CYPHER 3.2", "CYPHER 3.3").forEach(version -> this.shouldNotNotifyInStream((String)version, " EXPLAIN CREATE (n:Person)"));
    }

    @Test
    public void shouldWarnOnMissingRelationshipType() throws Exception {
        this.assertNotifications("EXPLAIN MATCH ()-[a:NO_SUCH_THING]->() RETURN a", this.containsItem(this.unknownRelationshipWarning));
    }

    @Test
    public void shouldWarnOnMisspelledRelationship() throws Exception {
        try (Transaction tx = this.db().beginTx();){
            this.db().createNode().addLabel(Label.label((String)"Person"));
            tx.success();
        }
        Stream.of("CYPHER 2.3", "CYPHER 3.1", "CYPHER 3.2", "CYPHER 3.3").forEach(version -> {
            this.db().execute("CREATE (n)-[r:R]->(m)");
            this.assertNotifications(version + "EXPLAIN MATCH ()-[r:r]->() RETURN *", this.containsItem(this.unknownRelationshipWarning));
            this.shouldNotNotifyInStream((String)version, "EXPLAIN MATCH ()-[r:R]->() RETURN *");
        });
    }

    @Test
    public void shouldWarnOnMissingRelationshipTypeWithComment() throws Exception {
        this.assertNotifications("EXPLAIN /*Comment*/ MATCH ()-[a:NO_SUCH_THING]->() RETURN a", this.containsItem(this.unknownRelationshipWarning));
    }

    @Test
    public void shouldWarnOnMissingProperty() throws Exception {
        this.assertNotifications("EXPLAIN MATCH (a {NO_SUCH_THING: 1337}) RETURN a", this.containsItem(this.unknownPropertyKeyWarning));
    }

    @Test
    public void shouldWarnOnMisspelledProperty() throws Exception {
        this.db().execute("CREATE (n {prop : 42})");
        Stream.of("CYPHER 2.3", "CYPHER 3.1", "CYPHER 3.2", "CYPHER 3.3").forEach(version -> {
            this.db().execute("CREATE (n)-[r:R]->(m)");
            this.assertNotifications(version + "EXPLAIN MATCH (n) WHERE n.propp = 43 RETURN n", this.containsItem(this.unknownPropertyKeyWarning));
            this.shouldNotNotifyInStream((String)version, "EXPLAIN MATCH (n) WHERE n.prop = 43 RETURN n");
        });
    }

    @Test
    public void shouldWarnOnMissingPropertyWithComment() throws Exception {
        this.assertNotifications("EXPLAIN /*Comment*/ MATCH (a {NO_SUCH_THING: 1337}) RETURN a", this.containsItem(this.unknownPropertyKeyWarning));
    }

    @Test
    public void shouldNotNotifyForMissingPropertiesOnUpdate() throws Exception {
        Stream.of("CYPHER 2.3", "CYPHER 3.1", "CYPHER 3.2", "CYPHER 3.3").forEach(version -> this.shouldNotNotifyInStream((String)version, " EXPLAIN CREATE (n {prop: 42})"));
    }

    @Test
    public void shouldWarnThatStartIsDeprecatedForAllNodeScan() {
        this.assertNotifications("EXPLAIN START n=node(*) RETURN n", this.containsItem(this.deprecatedStartWarning));
    }

    @Test
    public void shouldWarnThatStartIsDeprecatedForNodeById() {
        this.assertNotifications("EXPLAIN START n=node(1337) RETURN n", this.containsItem(this.deprecatedStartWarning));
    }

    @Test
    public void shouldWarnThatStartIsDeprecatedForNodeByIds() {
        this.assertNotifications("EXPLAIN START n=node(42,1337) RETURN n", this.containsItem(this.deprecatedStartWarning));
    }

    @Test
    public void shouldWarnThatStartIsDeprecatedForNodeIndexSeek() {
        try (Transaction ignore = this.db().beginTx();){
            this.db().index().forNodes("index");
        }
        this.assertNotifications("EXPLAIN START n=node:index(key = 'value') RETURN n", this.containsItem(this.deprecatedStartWarning));
    }

    @Test
    public void shouldWarnThatStartIsDeprecatedForNodeIndexSearch() {
        try (Transaction ignore = this.db().beginTx();){
            this.db().index().forNodes("index");
        }
        this.assertNotifications("EXPLAIN START n=node:index('key:value*') RETURN n", this.containsItem(this.deprecatedStartWarning));
    }

    @Test
    public void shouldWarnThatStartIsDeprecatedForAllRelScan() {
        this.assertNotifications("EXPLAIN START r=relationship(*) RETURN r", this.containsItem(this.deprecatedStartWarning));
    }

    @Test
    public void shouldWarnThatStartIsDeprecatedForRelById() {
        this.assertNotifications("EXPLAIN START r=relationship(1337) RETURN r", this.containsItem(this.deprecatedStartWarning));
    }

    @Test
    public void shouldWarnThatStartIsDeprecatedForRelByIds() {
        this.assertNotifications("EXPLAIN START r=relationship(42,1337) RETURN r", this.containsItem(this.deprecatedStartWarning));
    }

    @Test
    public void shouldWarnThatStartIsDeprecatedForRelIndexSeek() {
        try (Transaction ignore = this.db().beginTx();){
            this.db().index().forRelationships("index");
        }
        this.assertNotifications("EXPLAIN START r=relationship:index(key = 'value') RETURN r", this.containsItem(this.deprecatedStartWarning));
    }

    @Test
    public void shouldWarnThatStartIsDeprecatedForRelIndexSearch() {
        try (Transaction ignore = this.db().beginTx();){
            this.db().index().forRelationships("index");
        }
        this.assertNotifications("EXPLAIN START r=relationship:index('key:value*') RETURN r", this.containsItem(this.deprecatedStartWarning));
    }

    @Test
    public void version2_3ShouldWarnAboutBareNodes() throws Exception {
        Result res = this.db().execute("EXPLAIN CYPHER 2.3 MATCH n RETURN n");
        assert (res.getNotifications().iterator().hasNext());
    }

    private void assertNotifications(String query, Matcher<Iterable<Notification>> matchesExpectation) {
        try (Result result2 = this.db().execute(query);){
            Assert.assertThat((Object)result2.getNotifications(), matchesExpectation);
        }
    }

    private Matcher<Notification> notification(final String code, final Matcher<String> description, final Matcher<InputPosition> position, final SeverityLevel severity) {
        return new TypeSafeMatcher<Notification>(){

            protected boolean matchesSafely(Notification item) {
                return code.equals(item.getCode()) && description.matches((Object)item.getDescription()) && position.matches((Object)item.getPosition()) && severity.equals((Object)item.getSeverity());
            }

            public void describeTo(Description target) {
                target.appendText("Notification{code=").appendValue((Object)code).appendText(", description=[").appendDescriptionOf((SelfDescribing)description).appendText("], position=[").appendDescriptionOf((SelfDescribing)position).appendText("], severity=").appendValue((Object)severity).appendText("}");
            }
        };
    }

    private GraphDatabaseAPI db() {
        return this.rule.getGraphDatabaseAPI();
    }

    private <T> Matcher<Iterable<T>> containsItem(final Matcher<T> itemMatcher) {
        return new TypeSafeMatcher<Iterable<T>>(){

            protected boolean matchesSafely(Iterable<T> items) {
                for (Object item : items) {
                    if (!itemMatcher.matches(item)) continue;
                    return true;
                }
                return false;
            }

            public void describeTo(Description description) {
                description.appendText("an iterable containing ").appendDescriptionOf((SelfDescribing)itemMatcher);
            }
        };
    }

    private <T> Matcher<Iterable<T>> containsNoItem(final Matcher<T> itemMatcher) {
        return new TypeSafeMatcher<Iterable<T>>(){

            protected boolean matchesSafely(Iterable<T> items) {
                for (Object item : items) {
                    if (!itemMatcher.matches(item)) continue;
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("an iterable not containing ").appendDescriptionOf((SelfDescribing)itemMatcher);
            }
        };
    }

    private void shouldNotifyInStream(String version, String query, InputPosition pos, NotificationCode code) {
        Result result2 = this.db().execute(version + query);
        NotificationCode.Notification notification = code.notification(pos, new NotificationDetail[0]);
        Assert.assertThat((Object)Iterables.asList((Iterable)result2.getNotifications()), (Matcher)Matchers.hasItems((Object[])new Notification[]{notification}));
        Map arguments = result2.getExecutionPlanDescription().getArguments();
        Assert.assertThat(arguments.get("version"), (Matcher)Matchers.equalTo((Object)version));
        result2.close();
    }

    private void shouldNotifyInStreamWithDetail(String version, String query, InputPosition pos, NotificationCode code, NotificationDetail detail) {
        Result result2 = this.db().execute(version + query);
        NotificationCode.Notification notification = code.notification(pos, new NotificationDetail[]{detail});
        Assert.assertThat((Object)Iterables.asList((Iterable)result2.getNotifications()), (Matcher)Matchers.hasItems((Object[])new Notification[]{notification}));
        Map arguments = result2.getExecutionPlanDescription().getArguments();
        Assert.assertThat(arguments.get("version"), (Matcher)Matchers.equalTo((Object)version));
        result2.close();
    }

    private void shouldNotNotifyInStream(String version, String query) {
        Result result2 = this.db().execute(version + query);
        Assert.assertThat((Object)Iterables.asList((Iterable)result2.getNotifications()), (Matcher)Matchers.empty());
        Map arguments = result2.getExecutionPlanDescription().getArguments();
        Assert.assertThat(arguments.get("version"), (Matcher)Matchers.equalTo((Object)version));
        result2.close();
    }

    public static class TestProcedures {
        @Procedure(value="newProc")
        public void newProc() {
        }

        @Deprecated
        @Procedure(name="oldProc", deprecatedBy="newProc")
        public void oldProc() {
        }

        @Procedure(value="changedProc")
        public Stream<ChangedResults> changedProc() {
            return Stream.of(new ChangedResults());
        }
    }

    public static class ChangedResults {
        @Deprecated
        public final String oldField = "deprecated";
        public final String newField = "use this";
    }
}

