/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.javacompat;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.test.rule.EmbeddedDatabaseRule;

public class ServerExecutionEngineTest {
    @Rule
    public EmbeddedDatabaseRule rule = new EmbeddedDatabaseRule();

    @Test
    public void shouldDetectPeriodicCommitQueries() throws Exception {
        QueryExecutionEngine engine = (QueryExecutionEngine)this.rule.getGraphDatabaseAPI().getDependencyResolver().resolveDependency(QueryExecutionEngine.class);
        boolean result2 = engine.isPeriodicCommit("USING PERIODIC COMMIT LOAD CSV FROM 'file:///tmp/foo.csv' AS line CREATE ()");
        Assert.assertTrue((String)"Did not detect periodic commit query", (boolean)result2);
    }

    @Test
    public void shouldNotDetectNonPeriodicCommitQueriesAsPeriodicCommitQueries() throws Exception {
        QueryExecutionEngine engine = (QueryExecutionEngine)this.rule.getGraphDatabaseAPI().getDependencyResolver().resolveDependency(QueryExecutionEngine.class);
        boolean result2 = engine.isPeriodicCommit("CREATE ()");
        Assert.assertFalse((String)"Did detect non-periodic commit query as periodic commit query", (boolean)result2);
    }

    @Test
    public void shouldNotDetectInvalidQueriesAsPeriodicCommitQueries() throws Exception {
        QueryExecutionEngine engine = (QueryExecutionEngine)this.rule.getGraphDatabaseAPI().getDependencyResolver().resolveDependency(QueryExecutionEngine.class);
        boolean result2 = engine.isPeriodicCommit("MATCH n RETURN m");
        Assert.assertFalse((String)"Did detect an invalid query as periodic commit query", (boolean)result2);
    }
}

