/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.javacompat;

import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.cypher.internal.CompatibilityFactory;
import org.neo4j.cypher.internal.javacompat.SnapshotExecutionEngine;
import org.neo4j.cypher.javacompat.internal.GraphDatabaseCypherService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.graphdb.Result;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContext;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

public class SnapshotExecutionEngineTest {
    @Rule
    public final DatabaseRule database = new ImpermanentDatabaseRule();
    private CompatibilityFactory compatibilityFactory;
    private TestSnapshotExecutionEngine executionEngine;
    private VersionContext versionContext;
    private SnapshotExecutionEngine.ParametrizedQueryExecutor executor;
    private TransactionalContext transactionalContext;
    private final Config config = Config.defaults();

    @Before
    public void setUp() throws Exception {
        GraphDatabaseCypherService cypherService = new GraphDatabaseCypherService((GraphDatabaseService)this.database.getGraphDatabaseAPI());
        this.compatibilityFactory = (CompatibilityFactory)Mockito.mock(CompatibilityFactory.class);
        this.transactionalContext = (TransactionalContext)Mockito.mock(TransactionalContext.class);
        KernelStatement kernelStatement = (KernelStatement)Mockito.mock(KernelStatement.class);
        this.executor = (SnapshotExecutionEngine.ParametrizedQueryExecutor)Mockito.mock(SnapshotExecutionEngine.ParametrizedQueryExecutor.class);
        this.versionContext = (VersionContext)Mockito.mock(VersionContext.class);
        this.executionEngine = this.createExecutionEngine((GraphDatabaseQueryService)cypherService);
        Mockito.when((Object)kernelStatement.getVersionContext()).thenReturn((Object)this.versionContext);
        Mockito.when((Object)this.transactionalContext.statement()).thenReturn((Object)kernelStatement);
        Result result2 = (Result)Mockito.mock(Result.class);
        Mockito.when((Object)result2.getQueryStatistics()).thenReturn(Mockito.mock(QueryStatistics.class));
        Mockito.when((Object)this.executor.execute((String)Matchers.any(), (Object)Matchers.anyMap(), (TransactionalContext)Matchers.any())).thenReturn((Object)result2);
    }

    @Test
    public void executeQueryWithoutRetries() throws QueryExecutionKernelException {
        this.executionEngine.executeWithRetries("query", Collections.emptyMap(), this.transactionalContext, this.executor);
        ((SnapshotExecutionEngine.ParametrizedQueryExecutor)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.times((int)1))).execute((String)Matchers.any(), (Object)Matchers.anyMap(), (TransactionalContext)Matchers.any());
        ((VersionContext)Mockito.verify((Object)this.versionContext, (VerificationMode)Mockito.times((int)1))).initRead();
    }

    @Test
    public void executeQueryAfterSeveralRetries() throws QueryExecutionKernelException {
        Mockito.when((Object)this.versionContext.isDirty()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        this.executionEngine.executeWithRetries("query", Collections.emptyMap(), this.transactionalContext, this.executor);
        ((SnapshotExecutionEngine.ParametrizedQueryExecutor)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.times((int)3))).execute((String)Matchers.any(), (Object)Matchers.anyMap(), (TransactionalContext)Matchers.any());
        ((VersionContext)Mockito.verify((Object)this.versionContext, (VerificationMode)Mockito.times((int)3))).initRead();
    }

    @Test
    public void failQueryAfterMaxRetriesReached() throws QueryExecutionKernelException {
        Mockito.when((Object)this.versionContext.isDirty()).thenReturn((Object)true);
        try {
            this.executionEngine.executeWithRetries("query", Collections.emptyMap(), this.transactionalContext, this.executor);
        }
        catch (QueryExecutionKernelException e) {
            Assert.assertEquals((Object)"Unable to get clean data snapshot for query 'query' after 5 attempts.", (Object)e.getMessage());
        }
        ((SnapshotExecutionEngine.ParametrizedQueryExecutor)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.times((int)5))).execute((String)Matchers.any(), (Object)Matchers.anyMap(), (TransactionalContext)Matchers.any());
        ((VersionContext)Mockito.verify((Object)this.versionContext, (VerificationMode)Mockito.times((int)5))).initRead();
    }

    private TestSnapshotExecutionEngine createExecutionEngine(GraphDatabaseQueryService cypherService) {
        return new TestSnapshotExecutionEngine(cypherService, this.config, (LogProvider)NullLogProvider.getInstance(), this.compatibilityFactory);
    }

    private class TestSnapshotExecutionEngine
    extends SnapshotExecutionEngine {
        TestSnapshotExecutionEngine(GraphDatabaseQueryService queryService, Config config, LogProvider logProvider, CompatibilityFactory compatibilityFactory) {
            super(queryService, config, logProvider, compatibilityFactory);
        }

        public <T> Result executeWithRetries(String query, T parameters, TransactionalContext context, SnapshotExecutionEngine.ParametrizedQueryExecutor<T> executor) throws QueryExecutionKernelException {
            return super.executeWithRetries(query, parameters, context, executor);
        }
    }
}

