/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.spi.v3_3;

import java.net.URL;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.mockito.Mockito;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.helpers.DynamicIterable$;
import org.neo4j.cypher.internal.compiler.v3_3.spi.KernelStatisticProvider;
import org.neo4j.cypher.internal.frontend.v3_3.SemanticDirection;
import org.neo4j.cypher.internal.frontend.v3_3.test_helpers.CypherFunSuite;
import org.neo4j.cypher.internal.spi.v3_3.TransactionBoundQueryContext;
import org.neo4j.cypher.internal.spi.v3_3.TransactionalContextWrapper;
import org.neo4j.cypher.javacompat.internal.GraphDatabaseCypherService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.PropertyContainerLocker;
import org.neo4j.kernel.impl.factory.AccessCapability;
import org.neo4j.kernel.impl.factory.CanWrite;
import org.neo4j.kernel.impl.locking.LockTracer;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.query.Neo4jTransactionalContext;
import org.neo4j.kernel.impl.query.Neo4jTransactionalContextFactory;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.impl.query.TransactionalContextFactory;
import org.neo4j.kernel.impl.query.clientconnection.ClientConnectionInfo;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.values.virtual.VirtualValues;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ub\u0001B\u0001\u0003\u0001=\u0011\u0001\u0005\u0016:b]N\f7\r^5p]\n{WO\u001c3Rk\u0016\u0014\u0018pQ8oi\u0016DH\u000fV3ti*\u00111\u0001B\u0001\u0005mNz6G\u0003\u0002\u0006\r\u0005\u00191\u000f]5\u000b\u0005\u001dA\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005%Q\u0011AB2za\",'O\u0003\u0002\f\u0019\u0005)a.Z85U*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011cF\u0007\u0002%)\u00111\u0003F\u0001\ri\u0016\u001cHo\u00185fYB,'o\u001d\u0006\u0003\u0007UQ!A\u0006\u0004\u0002\u0011\u0019\u0014xN\u001c;f]\u0012L!\u0001\u0007\n\u0003\u001d\rK\b\u000f[3s\rVt7+^5uK\")!\u0004\u0001C\u00017\u00051A(\u001b8jiz\"\u0012\u0001\b\t\u0003;\u0001i\u0011A\u0001\u0005\b?\u0001\u0001\r\u0011\"\u0001!\u0003\u00159'/\u00199i+\u0005\t\u0003C\u0001\u0012'\u001b\u0005\u0019#BA\u0004%\u0015\t)\u0003\"\u0001\u0006kCZ\f7m\\7qCRL!aJ\u0012\u00035\u001d\u0013\u0018\r\u001d5ECR\f'-Y:f\u0007f\u0004\b.\u001a:TKJ4\u0018nY3\t\u000f%\u0002\u0001\u0019!C\u0001U\u0005IqM]1qQ~#S-\u001d\u000b\u0003WE\u0002\"\u0001L\u0018\u000e\u00035R\u0011AL\u0001\u0006g\u000e\fG.Y\u0005\u0003a5\u0012A!\u00168ji\"9!\u0007KA\u0001\u0002\u0004\t\u0013a\u0001=%c!1A\u0007\u0001Q!\n\u0005\naa\u001a:ba\"\u0004\u0003b\u0002\u001c\u0001\u0001\u0004%\taN\u0001\b_V$XM\u001d+y+\u0005A\u0004CA\u001dA\u001b\u0005Q$BA\u001e=\u0003\u001d\u0019wN]3ba&T!!\u0010 \u0002\t%l\u0007\u000f\u001c\u0006\u0003\u007f)\taa[3s]\u0016d\u0017BA!;\u0005MIe\u000e^3s]\u0006dGK]1og\u0006\u001cG/[8o\u0011\u001d\u0019\u0005\u00011A\u0005\u0002\u0011\u000b1b\\;uKJ$\u0006p\u0018\u0013fcR\u00111&\u0012\u0005\be\t\u000b\t\u00111\u00019\u0011\u00199\u0005\u0001)Q\u0005q\u0005Aq.\u001e;feRC\b\u0005C\u0004J\u0001\u0001\u0007I\u0011\u0001&\u0002\u0013M$\u0018\r^3nK:$X#A&\u0011\u00051{U\"A'\u000b\u00059c\u0014aA1qS&\u0011\u0001+\u0014\u0002\u0010\u0017\u0016\u0014h.\u001a7Ti\u0006$X-\\3oi\"9!\u000b\u0001a\u0001\n\u0003\u0019\u0016!D:uCR,W.\u001a8u?\u0012*\u0017\u000f\u0006\u0002,)\"9!'UA\u0001\u0002\u0004Y\u0005B\u0002,\u0001A\u0003&1*\u0001\u0006ti\u0006$X-\\3oi\u0002Bq\u0001\u0017\u0001C\u0002\u0013\u0005\u0011,\u0001\nj]\u0012,\u0007pU3be\u000eDWj\u001c8ji>\u0014X#\u0001.\u0011\u0005mkgB\u0001/l\u001d\ti&N\u0004\u0002_S:\u0011q\f\u001b\b\u0003A\u001et!!\u00194\u000f\u0005\t,W\"A2\u000b\u0005\u0011t\u0011A\u0002\u001fs_>$h(C\u0001\u000e\u0013\tYA\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003\u000b\u0019I!a\u0001\u0003\n\u00051\u0014\u0011\u0001\b+sC:\u001c\u0018m\u0019;j_:\u0014u.\u001e8e#V,'/_\"p]R,\u0007\u0010^\u0005\u0003]>\u0014!#\u00138eKb\u001cV-\u0019:dQ6{g.\u001b;pe*\u0011AN\u0001\u0005\u0007c\u0002\u0001\u000b\u0011\u0002.\u0002'%tG-\u001a=TK\u0006\u00148\r['p]&$xN\u001d\u0011\t\u000fM\u0004!\u0019!C\u0001i\u00061An\\2lKJ,\u0012!\u001e\t\u0003sYL!a\u001e\u001e\u0003/A\u0013x\u000e]3sif\u001cuN\u001c;bS:,'\u000fT8dW\u0016\u0014\bBB=\u0001A\u0003%Q/A\u0004m_\u000e\\WM\u001d\u0011\t\u000bm\u0004A\u0011\t?\u0002\u0015\t,gm\u001c:f\u000b\u0006\u001c\u0007\u000eF\u0001,\u0011\u0015q\b\u0001\"\u0011}\u0003%\tg\r^3s\u000b\u0006\u001c\u0007\u000eC\u0004\u0002\u0002\u0001!I!a\u0001\u00021\r\u0014X-\u0019;f)J\fgn]1di&|gnQ8oi\u0016DH\u000f\u0006\u0004\u0002\u0006\u0005E\u0011Q\u0003\t\u0005\u0003\u000f\ti!\u0004\u0002\u0002\n)\u0019\u00111\u0002\u001f\u0002\u000bE,XM]=\n\t\u0005=\u0011\u0011\u0002\u0002\u0015)J\fgn]1di&|g.\u00197D_:$X\r\u001f;\t\r\u0005Mq\u00101\u0001\"\u0003i9'/\u00199i\t\u0006$\u0018MY1tK\u000eK\b\u000f[3s'\u0016\u0014h/[2f\u0011\u0019\t9b a\u0001q\u0005YAO]1og\u0006\u001cG/[8o\u0011\u001d\tY\u0002\u0001C\u0005\u0003;\tqb\u0019:fCR,W*\u001b8j\u000fJ\f\u0007\u000f\u001b\u000b\u0005\u0003?\tY\u0003\u0005\u0003\u0002\"\u0005\u001dRBAA\u0012\u0015\r\t)CC\u0001\bOJ\f\u0007\u000f\u001b3c\u0013\u0011\tI#a\t\u0003\t9{G-\u001a\u0005\t\u0003[\tI\u00021\u0001\u00020\u0005Y!/\u001a7UsB,g*Y7f!\u0011\t\t$a\u000e\u000f\u00071\n\u0019$C\u0002\u000265\na\u0001\u0015:fI\u00164\u0017\u0002BA\u001d\u0003w\u0011aa\u0015;sS:<'bAA\u001b[\u0001")
public class TransactionBoundQueryContextTest
extends CypherFunSuite {
    private GraphDatabaseCypherService graph = null;
    private InternalTransaction outerTx = null;
    private KernelStatement statement = null;
    private final TransactionBoundQueryContext.IndexSearchMonitor indexSearchMonitor = (TransactionBoundQueryContext.IndexSearchMonitor)this.mock(ManifestFactory$.MODULE$.classType(TransactionBoundQueryContext.IndexSearchMonitor.class));
    private final PropertyContainerLocker locker = (PropertyContainerLocker)this.mock(ManifestFactory$.MODULE$.classType(PropertyContainerLocker.class));

    public GraphDatabaseCypherService graph() {
        return this.graph;
    }

    public void graph_$eq(GraphDatabaseCypherService x$1) {
        this.graph = x$1;
    }

    public InternalTransaction outerTx() {
        return this.outerTx;
    }

    public void outerTx_$eq(InternalTransaction x$1) {
        this.outerTx = x$1;
    }

    public KernelStatement statement() {
        return this.statement;
    }

    public void statement_$eq(KernelStatement x$1) {
        this.statement = x$1;
    }

    public TransactionBoundQueryContext.IndexSearchMonitor indexSearchMonitor() {
        return this.indexSearchMonitor;
    }

    public PropertyContainerLocker locker() {
        return this.locker;
    }

    public void beforeEach() {
        super.beforeEach();
        this.graph_$eq(new GraphDatabaseCypherService(new TestGraphDatabaseFactory().newImpermanentDatabase()));
        this.outerTx_$eq((InternalTransaction)this.mock(ManifestFactory$.MODULE$.classType(InternalTransaction.class)));
        KernelTransactionImplementation kernelTransaction = (KernelTransactionImplementation)this.mock(ManifestFactory$.MODULE$.classType(KernelTransactionImplementation.class));
        Mockito.when((Object)kernelTransaction.securityContext()).thenReturn((Object)SecurityContext.AUTH_DISABLED);
        StorageStatement storeStatement = (StorageStatement)this.mock(ManifestFactory$.MODULE$.classType(StorageStatement.class));
        StatementOperationParts operations = (StatementOperationParts)this.mock(Mockito.RETURNS_DEEP_STUBS, ManifestFactory$.MODULE$.classType(StatementOperationParts.class));
        this.statement_$eq(new KernelStatement(kernelTransaction, null, storeStatement, new Procedures(), (AccessCapability)new CanWrite(), LockTracer.NONE, operations, EmptyVersionContextSupplier.EMPTY));
        this.statement().initialize(null, (PageCursorTracer)PageCursorTracerSupplier.NULL.get());
        this.statement().acquire();
    }

    public void afterEach() {
        this.graph().getGraphDatabaseService().shutdown();
    }

    public TransactionalContext org$neo4j$cypher$internal$spi$v3_3$TransactionBoundQueryContextTest$$createTransactionContext(GraphDatabaseCypherService graphDatabaseCypherService, InternalTransaction transaction) {
        TransactionalContextFactory contextFactory = Neo4jTransactionalContextFactory.create((GraphDatabaseQueryService)graphDatabaseCypherService, (PropertyContainerLocker)new PropertyContainerLocker());
        return contextFactory.newContext(ClientConnectionInfo.EMBEDDED_CONNECTION, transaction, "no query", VirtualValues.EMPTY_MAP);
    }

    /*
     * WARNING - void declaration
     */
    public Node org$neo4j$cypher$internal$spi$v3_3$TransactionBoundQueryContextTest$$createMiniGraph(String relTypeName2) {
        Node node2;
        RelationshipType relType2 = RelationshipType.withName((String)relTypeName2);
        InternalTransaction tx = this.graph().beginTransaction(KernelTransaction.Type.explicit, (SecurityContext)AnonymousContext.writeToken());
        try {
            Node node3 = this.graph().createNode();
            Node other1 = this.graph().createNode();
            Node other2 = this.graph().createNode();
            node3.createRelationshipTo(other1, relType2);
            other2.createRelationshipTo(node3, relType2);
            tx.success();
            node2 = node3;
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        tx.close();
        return node2;
    }

    public TransactionBoundQueryContextTest() {
        this.test("should mark transaction successful if successful", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionBoundQueryContextTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.outerTx().failure();
                Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new AssertionError((Object)"Shouldn't be called")});
                Mockito.when((Object)this.$outer.outerTx().transactionType()).thenReturn((Object)KernelTransaction.Type.implicit);
                Mockito.when((Object)this.$outer.outerTx().securityContext()).thenReturn((Object)SecurityContext.AUTH_DISABLED);
                Neo4jTransactionalContext tc = new Neo4jTransactionalContext((GraphDatabaseQueryService)this.$outer.graph(), null, null, null, this.$outer.locker(), this.$outer.outerTx(), (Statement)this.$outer.statement(), null);
                TransactionalContextWrapper transactionalContext = new TransactionalContextWrapper((TransactionalContext)tc);
                TransactionBoundQueryContext context = new TransactionBoundQueryContext(transactionalContext, this.$outer.indexSearchMonitor());
                context.transactionalContext().close(true);
                ((InternalTransaction)Mockito.verify((Object)this.$outer.outerTx())).transactionType();
                ((InternalTransaction)Mockito.verify((Object)this.$outer.outerTx())).securityContext();
                ((Transaction)Mockito.verify((Object)this.$outer.outerTx())).success();
                ((Transaction)Mockito.verify((Object)this.$outer.outerTx())).close();
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.$outer.outerTx()});
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should mark transaction failed if not successful", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionBoundQueryContextTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.outerTx().success();
                Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new AssertionError((Object)"Shouldn't be called")});
                Mockito.when((Object)this.$outer.outerTx().transactionType()).thenReturn((Object)KernelTransaction.Type.implicit);
                Mockito.when((Object)this.$outer.outerTx().securityContext()).thenReturn((Object)SecurityContext.AUTH_DISABLED);
                Neo4jTransactionalContext tc = new Neo4jTransactionalContext((GraphDatabaseQueryService)this.$outer.graph(), null, null, null, this.$outer.locker(), this.$outer.outerTx(), (Statement)this.$outer.statement(), null);
                TransactionalContextWrapper transactionalContext = new TransactionalContextWrapper((TransactionalContext)tc);
                TransactionBoundQueryContext context = new TransactionBoundQueryContext(transactionalContext, this.$outer.indexSearchMonitor());
                context.transactionalContext().close(false);
                ((InternalTransaction)Mockito.verify((Object)this.$outer.outerTx())).transactionType();
                ((InternalTransaction)Mockito.verify((Object)this.$outer.outerTx())).securityContext();
                ((Transaction)Mockito.verify((Object)this.$outer.outerTx())).failure();
                ((Transaction)Mockito.verify((Object)this.$outer.outerTx())).close();
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.$outer.outerTx()});
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should return fresh but equal iterators", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionBoundQueryContextTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String relTypeName2 = "LINK";
                Node node2 = this.$outer.org$neo4j$cypher$internal$spi$v3_3$TransactionBoundQueryContextTest$$createMiniGraph(relTypeName2);
                InternalTransaction tx = this.$outer.graph().beginTransaction(KernelTransaction.Type.explicit, (SecurityContext)AnonymousContext.read());
                TransactionalContextWrapper transactionalContext = new TransactionalContextWrapper(this.$outer.org$neo4j$cypher$internal$spi$v3_3$TransactionBoundQueryContextTest$$createTransactionContext(this.$outer.graph(), tx));
                TransactionBoundQueryContext context = new TransactionBoundQueryContext(transactionalContext, this.$outer.indexSearchMonitor());
                Iterable iterable = DynamicIterable$.MODULE$.apply((Function0)new Serializable(this, node2, context){
                    public static final long serialVersionUID = 0L;
                    private final Node node$1;
                    private final TransactionBoundQueryContext context$1;

                    public final Iterator<Relationship> apply() {
                        return this.context$1.getRelationshipsForIds(this.node$1.getId(), (SemanticDirection)SemanticDirection.BOTH$.MODULE$, (Option)None$.MODULE$);
                    }
                    {
                        this.node$1 = node$1;
                        this.context$1 = context$1;
                    }
                });
                Iterator iteratorA = iterable.iterator();
                Iterator iteratorB = iterable.iterator();
                this.$outer.convertToAnyShouldWrapper(iteratorA).should(this.$outer.not()).equal((Object)iteratorB, Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(iteratorA.toList()).should(this.$outer.equal(iteratorB.toList()), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)2)).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)iterable.size())), (Object)Equality$.MODULE$.default());
                transactionalContext.close(true);
                tx.success();
                tx.close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should deny non-whitelisted URL protocols for loading", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionBoundQueryContextTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InternalTransaction tx = this.$outer.graph().beginTransaction(KernelTransaction.Type.explicit, (SecurityContext)AnonymousContext.read());
                TransactionalContextWrapper transactionalContext = new TransactionalContextWrapper(this.$outer.org$neo4j$cypher$internal$spi$v3_3$TransactionBoundQueryContextTest$$createTransactionContext(this.$outer.graph(), tx));
                TransactionBoundQueryContext context = new TransactionBoundQueryContext(transactionalContext, this.$outer.indexSearchMonitor());
                this.$outer.convertToAnyShouldWrapper(context.getImportURL(new URL("http://localhost:7474/data.csv"))).should(this.$outer.equal(package$.MODULE$.Right().apply((Object)new URL("http://localhost:7474/data.csv"))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(context.getImportURL(new URL("file:///tmp/foo/data.csv"))).should(this.$outer.equal(package$.MODULE$.Right().apply((Object)new URL("file:///tmp/foo/data.csv"))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(context.getImportURL(new URL("jar:file:/tmp/blah.jar!/tmp/foo/data.csv"))).should(this.$outer.equal(package$.MODULE$.Left().apply((Object)"loading resources via protocol 'jar' is not permitted")), (Object)Equality$.MODULE$.default());
                transactionalContext.close(true);
                tx.success();
                tx.close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should deny file URLs when not allowed by config", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionBoundQueryContextTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.graph().getGraphDatabaseService().shutdown();
                scala.collection.immutable.Map config = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)GraphDatabaseSettings.allow_file_urls), (Object)"false")}));
                this.$outer.graph_$eq(new GraphDatabaseCypherService(new TestGraphDatabaseFactory().newImpermanentDatabase((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)config).asJava())));
                InternalTransaction tx = this.$outer.graph().beginTransaction(KernelTransaction.Type.explicit, (SecurityContext)AnonymousContext.read());
                TransactionalContextWrapper transactionalContext = new TransactionalContextWrapper(this.$outer.org$neo4j$cypher$internal$spi$v3_3$TransactionBoundQueryContextTest$$createTransactionContext(this.$outer.graph(), tx));
                TransactionBoundQueryContext context = new TransactionBoundQueryContext(transactionalContext, this.$outer.indexSearchMonitor());
                this.$outer.convertToAnyShouldWrapper(context.getImportURL(new URL("http://localhost:7474/data.csv"))).should(this.$outer.equal(package$.MODULE$.Right().apply((Object)new URL("http://localhost:7474/data.csv"))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(context.getImportURL(new URL("file:///tmp/foo/data.csv"))).should(this.$outer.equal(package$.MODULE$.Left().apply((Object)"configuration property 'dbms.security.allow_csv_import_from_file_urls' is false")), (Object)Equality$.MODULE$.default());
                transactionalContext.close(true);
                tx.success();
                tx.close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("provide access to kernel statement page cache tracer", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionBoundQueryContextTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InternalTransaction creator = this.$outer.graph().beginTransaction(KernelTransaction.Type.explicit, SecurityContext.AUTH_DISABLED);
                this.$outer.graph().createNode();
                this.$outer.graph().createNode();
                this.$outer.graph().createNode();
                creator.success();
                creator.close();
                InternalTransaction tx = this.$outer.graph().beginTransaction(KernelTransaction.Type.explicit, SecurityContext.AUTH_DISABLED);
                TransactionalContextWrapper transactionalContext = new TransactionalContextWrapper(this.$outer.org$neo4j$cypher$internal$spi$v3_3$TransactionBoundQueryContextTest$$createTransactionContext(this.$outer.graph(), tx));
                TransactionBoundQueryContext context = new TransactionBoundQueryContext(transactionalContext, this.$outer.indexSearchMonitor());
                KernelStatisticProvider tracer = transactionalContext.kernelStatisticProvider();
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)tracer.getPageCacheHits())).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)0)), (Object)Equality$.MODULE$.default());
                this.$outer.graph().getNodeById(2L);
                this.$outer.graph().getNodeById(1L);
                long accesses = tracer.getPageCacheHits() + tracer.getPageCacheMisses();
                Assert.assertThat((Object)BoxesRunTime.boxToLong((long)accesses), (Matcher)Matchers.greaterThan((Comparable)BoxesRunTime.boxToLong((long)1L)));
                transactionalContext.close(true);
                tx.close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

