/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.tracing;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.neo4j.cypher.internal.frontend.v3_3.helpers.package$;
import org.neo4j.cypher.internal.frontend.v3_3.phases.CompilationPhaseTracer;
import org.neo4j.cypher.internal.frontend.v3_3.test_helpers.CypherFunSuite;
import org.neo4j.cypher.internal.tracing.CompilationTracer;
import org.neo4j.cypher.internal.tracing.FakeClock;
import org.neo4j.cypher.internal.tracing.TimingCompilationTracer;
import org.neo4j.cypher.internal.tracing.TimingCompilationTracerTest$;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001e2A!\u0001\u0002\u0001\u001b\tYB+[7j]\u001e\u001cu.\u001c9jY\u0006$\u0018n\u001c8Ue\u0006\u001cWM\u001d+fgRT!a\u0001\u0003\u0002\u000fQ\u0014\u0018mY5oO*\u0011QAB\u0001\tS:$XM\u001d8bY*\u0011q\u0001C\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005%Q\u0011!\u00028f_RR'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001q\u0001CA\b\u0017\u001b\u0005\u0001\"BA\t\u0013\u00031!Xm\u001d;`Q\u0016d\u0007/\u001a:t\u0015\t\u0019B#\u0001\u0003wg}\u001b$BA\u000b\u0005\u0003!1'o\u001c8uK:$\u0017BA\f\u0011\u00059\u0019\u0015\u0010\u001d5fe\u001a+hnU;ji\u0016DQ!\u0007\u0001\u0005\u0002i\ta\u0001P5oSRtD#A\u000e\u0011\u0005q\u0001Q\"\u0001\u0002\t\u000by\u0001A\u0011A\u0010\u0002\u000f\r|W\u000e]5mKR!\u0001EJ\u00161!\t\tC%D\u0001#\u0015\u0005\u0019\u0013!B:dC2\f\u0017BA\u0013#\u0005\u0011)f.\u001b;\t\u000b\u001dj\u0002\u0019\u0001\u0015\u0002\u000b\rdwnY6\u0011\u0005qI\u0013B\u0001\u0016\u0003\u0005%1\u0015m[3DY>\u001c7\u000eC\u0003-;\u0001\u0007Q&\u0001\u0004ue\u0006\u001cWM\u001d\t\u000399J!a\f\u0002\u0003#\r{W\u000e]5mCRLwN\u001c+sC\u000e,'\u000fC\u00032;\u0001\u0007!'A\u0003rk\u0016\u0014\u0018\u0010\u0005\u00024m9\u0011\u0011\u0005N\u0005\u0003k\t\na\u0001\u0015:fI\u00164\u0017BA\u001c9\u0005\u0019\u0019FO]5oO*\u0011QG\t")
public class TimingCompilationTracerTest
extends CypherFunSuite {
    public void compile(FakeClock clock, CompilationTracer tracer, String query) {
        CompilationTracer.QueryCompilationEvent x$9 = tracer.compileQuery(query);
        Serializable x$10 = new Serializable(this, clock){
            public static final long serialVersionUID = 0L;
            public final FakeClock clock$1;

            public final void apply(CompilationTracer.QueryCompilationEvent event) {
                CompilationPhaseTracer.CompilationPhaseEvent x$1 = event.beginPhase(CompilationPhaseTracer.CompilationPhase.PARSING);
                Serializable x$2 = new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.clock$1.progress(11L, TimeUnit.MILLISECONDS);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
                Function1 x$3 = package$.MODULE$.closing$default$3((AutoCloseable)x$1, (Function0)x$2);
                Function2 x$4 = package$.MODULE$.closing$default$4((AutoCloseable)x$1, (Function0)x$2);
                package$.MODULE$.closing((AutoCloseable)x$1, (Function0)x$2, x$3, x$4);
                CompilationPhaseTracer.CompilationPhaseEvent x$5 = event.beginPhase(CompilationPhaseTracer.CompilationPhase.LOGICAL_PLANNING);
                Serializable x$6 = new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.clock$1.progress(216L, TimeUnit.MILLISECONDS);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
                Function1 x$7 = package$.MODULE$.closing$default$3((AutoCloseable)x$5, (Function0)x$6);
                Function2 x$8 = package$.MODULE$.closing$default$4((AutoCloseable)x$5, (Function0)x$6);
                package$.MODULE$.closing((AutoCloseable)x$5, (Function0)x$6, x$7, x$8);
            }
            {
                this.clock$1 = clock$1;
            }
        };
        Function1 x$11 = package$.MODULE$.using$default$3((AutoCloseable)x$9, (Function1)x$10);
        Function2 x$12 = package$.MODULE$.using$default$4((AutoCloseable)x$9, (Function1)x$10);
        package$.MODULE$.using((AutoCloseable)x$9, (Function1)x$10, x$11, x$12);
    }

    public TimingCompilationTracerTest() {
        this.test("no-op tracing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimingCompilationTracerTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.compile(new FakeClock(), CompilationTracer.NO_COMPILATION_TRACING, "MATCH (n) RETURN n");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("measure time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimingCompilationTracerTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                FakeClock clock = new FakeClock();
                TimingCompilationTracer.EventListener listener = (TimingCompilationTracer.EventListener)this.$outer.mock(ManifestFactory$.MODULE$.classType(TimingCompilationTracer.EventListener.class));
                this.$outer.compile(clock, (CompilationTracer)new TimingCompilationTracer((TimingCompilationTracer.Clock)clock, listener), "MATCH (n) RETURN n");
                ArgumentCaptor argumentCaptor = this.$outer.argCaptor(ManifestFactory$.MODULE$.classType(TimingCompilationTracer.QueryEvent.class));
                ((TimingCompilationTracer.EventListener)Mockito.verify((Object)listener)).queryCompiled((TimingCompilationTracer.QueryEvent)argumentCaptor.capture());
                TimingCompilationTracer.QueryEvent event = (TimingCompilationTracer.QueryEvent)argumentCaptor.getValue();
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)event.nanoTime())).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)227000000)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToStringShouldWrapper(event.query()).should(this.$outer.equal("MATCH (n) RETURN n"), (Object)Equality$.MODULE$.default());
                List phases = event.phases();
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)phases.size())).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)2)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(((TimingCompilationTracer.PhaseEvent)phases.get(0)).phase()).should(this.$outer.equal(CompilationPhaseTracer.CompilationPhase.PARSING), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)((TimingCompilationTracer.PhaseEvent)phases.get(0)).nanoTime())).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)11000000)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(((TimingCompilationTracer.PhaseEvent)phases.get(1)).phase()).should(this.$outer.equal(CompilationPhaseTracer.CompilationPhase.LOGICAL_PLANNING), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)((TimingCompilationTracer.PhaseEvent)phases.get(1)).nanoTime())).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)216000000)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

