/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.javacompat;

import org.neo4j.collection.Dependencies;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.cypher.internal.CommunityCompilerFactory;
import org.neo4j.cypher.internal.CompilerFactory;
import org.neo4j.cypher.internal.CypherConfiguration;
import org.neo4j.cypher.internal.CypherRuntimeConfiguration;
import org.neo4j.cypher.internal.compiler.CypherPlannerConfiguration;
import org.neo4j.cypher.internal.javacompat.ExecutionEngine;
import org.neo4j.cypher.internal.javacompat.GraphDatabaseCypherService;
import org.neo4j.cypher.internal.javacompat.SnapshotExecutionEngine;
import org.neo4j.cypher.internal.javacompat.SystemExecutionEngine;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.impl.query.QueryEngineProvider;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class CommunityCypherEngineProvider
extends QueryEngineProvider {
    protected int enginePriority() {
        return 42;
    }

    protected CompilerFactory makeCompilerFactory(GraphDatabaseCypherService queryService, QueryEngineProvider.SPI spi, CypherPlannerConfiguration plannerConfig, CypherRuntimeConfiguration runtimeConfig) {
        return new CommunityCompilerFactory((GraphDatabaseQueryService)queryService, spi.monitors(), spi.logProvider(), plannerConfig, runtimeConfig);
    }

    protected QueryExecutionEngine createEngine(Dependencies deps, GraphDatabaseAPI graphAPI, boolean isSystemDatabase, QueryEngineProvider.SPI spi) {
        GraphDatabaseCypherService queryService = new GraphDatabaseCypherService((GraphDatabaseService)graphAPI);
        deps.satisfyDependency((Object)queryService);
        CypherConfiguration cypherConfig = CypherConfiguration.fromConfig(spi.config());
        CypherPlannerConfiguration plannerConfig = cypherConfig.toCypherPlannerConfiguration(spi.config(), isSystemDatabase);
        CypherRuntimeConfiguration runtimeConfig = cypherConfig.toCypherRuntimeConfiguration();
        CompilerFactory compilerFactory = this.makeCompilerFactory(queryService, spi, plannerConfig, runtimeConfig);
        if (isSystemDatabase) {
            CypherPlannerConfiguration innerPlannerConfig = cypherConfig.toCypherPlannerConfiguration(spi.config(), false);
            CommunityCompilerFactory innerCompilerFactory = new CommunityCompilerFactory((GraphDatabaseQueryService)queryService, spi.monitors(), spi.logProvider(), innerPlannerConfig, runtimeConfig);
            return new SystemExecutionEngine((GraphDatabaseQueryService)queryService, spi.logProvider(), compilerFactory, innerCompilerFactory);
        }
        if (((Boolean)spi.config().get(GraphDatabaseInternalSettings.snapshot_query)).booleanValue()) {
            return new SnapshotExecutionEngine((GraphDatabaseQueryService)queryService, spi.config(), spi.logProvider(), compilerFactory);
        }
        return new ExecutionEngine((GraphDatabaseQueryService)queryService, spi.logProvider(), compilerFactory);
    }
}

