/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import org.neo4j.cypher.CypherPlannerOption;
import org.neo4j.cypher.CypherRuntimeOption;
import org.neo4j.cypher.CypherUpdateStrategy;
import org.neo4j.cypher.CypherVersion;
import org.neo4j.cypher.CypherVersion$v3_5$;
import org.neo4j.cypher.CypherVersion$v4_0$;
import org.neo4j.cypher.CypherVersion$v4_1$;
import org.neo4j.cypher.internal.CommunityAdministrationCommandRuntime;
import org.neo4j.cypher.internal.CommunityAdministrationCommandRuntime$;
import org.neo4j.cypher.internal.CommunityRuntimeContext;
import org.neo4j.cypher.internal.CommunityRuntimeContextManager;
import org.neo4j.cypher.internal.CommunityRuntimeFactory$;
import org.neo4j.cypher.internal.Compiler;
import org.neo4j.cypher.internal.CompilerFactory;
import org.neo4j.cypher.internal.CypherCurrentCompiler;
import org.neo4j.cypher.internal.CypherRuntimeConfiguration;
import org.neo4j.cypher.internal.ExecutionEngine;
import org.neo4j.cypher.internal.LastCommittedTxIdProvider;
import org.neo4j.cypher.internal.MasterCompiler$;
import org.neo4j.cypher.internal.compiler.CypherPlannerConfiguration;
import org.neo4j.cypher.internal.compiler.phases.Compatibility3_5$;
import org.neo4j.cypher.internal.compiler.phases.Compatibility4_0$;
import org.neo4j.cypher.internal.compiler.phases.Compatibility4_1$;
import org.neo4j.cypher.internal.compiler.phases.CypherCompatibilityVersion;
import org.neo4j.cypher.internal.planning.CypherPlanner;
import org.neo4j.exceptions.SyntaxException;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.monitoring.Monitors;
import scala.Function0;
import scala.MatchError;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001U4Aa\u0003\u0007\u0001+!A\u0001\u0005\u0001B\u0001B\u0003%\u0011\u0005\u0003\u0005(\u0001\t\u0005\t\u0015!\u0003)\u0011!q\u0003A!A!\u0002\u0013y\u0003\u0002C\u001b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001c\t\u0011q\u0002!\u0011!Q\u0001\nuBQ\u0001\u0011\u0001\u0005\u0002\u0005Cq\u0001\u0013\u0001C\u0002\u0013%\u0011\n\u0003\u0004N\u0001\u0001\u0006IA\u0013\u0005\u0006\u001d\u0002!\te\u0014\u0005\u0006'\u0002!\t\u0005\u0016\u0002\u0019\u0007>lW.\u001e8jif\u001cu.\u001c9jY\u0016\u0014h)Y2u_JL(BA\u0007\u000f\u0003!Ig\u000e^3s]\u0006d'BA\b\u0011\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011\u0011CE\u0001\u0006]\u0016|GG\u001b\u0006\u0002'\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0006\u000f\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\r\u0005s\u0017PU3g!\tib$D\u0001\r\u0013\tyBBA\bD_6\u0004\u0018\u000e\\3s\r\u0006\u001cGo\u001c:z\u0003\u00159'/\u00199i!\t\u0011S%D\u0001$\u0015\t!\u0003#\u0001\u0004lKJtW\r\\\u0005\u0003M\r\u0012\u0011d\u0012:ba\"$\u0015\r^1cCN,\u0017+^3ssN+'O^5dK\u0006q1.\u001a:oK2luN\\5u_J\u001c\bCA\u0015-\u001b\u0005Q#BA\u0016\u0011\u0003)iwN\\5u_JLgnZ\u0005\u0003[)\u0012\u0001\"T8oSR|'o]\u0001\fY><\u0007K]8wS\u0012,'\u000f\u0005\u00021g5\t\u0011G\u0003\u00023!\u00059An\\4hS:<\u0017B\u0001\u001b2\u0005-aun\u001a)s_ZLG-\u001a:\u0002\u001bAd\u0017M\u001c8fe\u000e{gNZ5h!\t9$(D\u00019\u0015\tID\"\u0001\u0005d_6\u0004\u0018\u000e\\3s\u0013\tY\u0004H\u0001\u000eDsBDWM\u001d)mC:tWM]\"p]\u001aLw-\u001e:bi&|g.A\u0007sk:$\u0018.\\3D_:4\u0017n\u001a\t\u0003;yJ!a\u0010\u0007\u00035\rK\b\u000f[3s%VtG/[7f\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\rqJg.\u001b;?)\u0019\u00115\tR#G\u000fB\u0011Q\u0004\u0001\u0005\u0006A\u0019\u0001\r!\t\u0005\u0006O\u0019\u0001\r\u0001\u000b\u0005\u0006]\u0019\u0001\ra\f\u0005\u0006k\u0019\u0001\rA\u000e\u0005\u0006y\u0019\u0001\r!P\u0001\u0004Y><W#\u0001&\u0011\u0005AZ\u0015B\u0001'2\u0005\raunZ\u0001\u0005Y><\u0007%\u0001\u0010tkB\u0004xN\u001d;t\u0003\u0012l\u0017N\\5tiJ\fG/\u001b<f\u0007>lW.\u00198egR\t\u0001\u000b\u0005\u0002\u0018#&\u0011!\u000b\u0007\u0002\b\u0005>|G.Z1o\u00039\u0019'/Z1uK\u000e{W\u000e]5mKJ$b!\u0016-_G\"l\u0007CA\u000fW\u0013\t9FB\u0001\u0005D_6\u0004\u0018\u000e\\3s\u0011\u0015I&\u00021\u0001[\u00035\u0019\u0017\u0010\u001d5feZ+'o]5p]B\u00111\fX\u0007\u0002\u001d%\u0011QL\u0004\u0002\u000e\u0007f\u0004\b.\u001a:WKJ\u001c\u0018n\u001c8\t\u000b}S\u0001\u0019\u00011\u0002\u001b\rL\b\u000f[3s!2\fgN\\3s!\tY\u0016-\u0003\u0002c\u001d\t\u00192)\u001f9iKJ\u0004F.\u00198oKJ|\u0005\u000f^5p]\")AM\u0003a\u0001K\u0006i1-\u001f9iKJ\u0014VO\u001c;j[\u0016\u0004\"a\u00174\n\u0005\u001dt!aE\"za\",'OU;oi&lWm\u00149uS>t\u0007\"B5\u000b\u0001\u0004Q\u0017\u0001F2za\",'/\u00169eCR,7\u000b\u001e:bi\u0016<\u0017\u0010\u0005\u0002\\W&\u0011AN\u0004\u0002\u0015\u0007f\u0004\b.\u001a:Va\u0012\fG/Z*ue\u0006$XmZ=\t\u000b9T\u0001\u0019A8\u0002/\u0015DXmY;uS>tWI\\4j]\u0016\u0004&o\u001c<jI\u0016\u0014\bcA\fqe&\u0011\u0011\u000f\u0007\u0002\n\rVt7\r^5p]B\u0002\"!H:\n\u0005Qd!aD#yK\u000e,H/[8o\u000b:<\u0017N\\3")
public class CommunityCompilerFactory
implements CompilerFactory {
    private final GraphDatabaseQueryService graph;
    private final Monitors kernelMonitors;
    private final CypherPlannerConfiguration plannerConfig;
    private final CypherRuntimeConfiguration runtimeConfig;
    private final Log log;

    private Log log() {
        return this.log;
    }

    @Override
    public boolean supportsAdministrativeCommands() {
        return this.plannerConfig.planSystemCommands();
    }

    @Override
    public Compiler createCompiler(CypherVersion cypherVersion, CypherPlannerOption cypherPlanner, CypherRuntimeOption cypherRuntime, CypherUpdateStrategy cypherUpdateStrategy, Function0<ExecutionEngine> executionEngineProvider) {
        CommunityAdministrationCommandRuntime communityAdministrationCommandRuntime;
        Compatibility3_5$ compatibility3_5$;
        CypherVersion cypherVersion2 = cypherVersion;
        if (CypherVersion$v3_5$.MODULE$.equals(cypherVersion2)) {
            compatibility3_5$ = Compatibility3_5$.MODULE$;
        } else if (CypherVersion$v4_0$.MODULE$.equals(cypherVersion2)) {
            compatibility3_5$ = Compatibility4_0$.MODULE$;
        } else if (CypherVersion$v4_1$.MODULE$.equals(cypherVersion2)) {
            compatibility3_5$ = Compatibility4_1$.MODULE$;
        } else {
            throw new MatchError((Object)cypherVersion2);
        }
        Compatibility3_5$ compatibilityMode = compatibility3_5$;
        CypherPlanner planner = new CypherPlanner(this.plannerConfig, MasterCompiler$.MODULE$.CLOCK(), this.kernelMonitors, this.log(), cypherPlanner, cypherUpdateStrategy, (Function0<Object>)new LastCommittedTxIdProvider(this.graph), (CypherCompatibilityVersion)compatibilityMode);
        if (this.plannerConfig.planSystemCommands()) {
            CommunityAdministrationCommandRuntime communityAdministrationCommandRuntime2;
            CypherVersion cypherVersion3 = cypherVersion;
            if (CypherVersion$v3_5$.MODULE$.equals(cypherVersion3)) {
                throw new SyntaxException("Commands towards system database are not supported in this Cypher version.");
            }
            communityAdministrationCommandRuntime = communityAdministrationCommandRuntime2 = new CommunityAdministrationCommandRuntime((ExecutionEngine)executionEngineProvider.apply(), this.graph.getDependencyResolver(), CommunityAdministrationCommandRuntime$.MODULE$.apply$default$3());
        } else {
            communityAdministrationCommandRuntime = CommunityRuntimeFactory$.MODULE$.getRuntime(cypherRuntime, this.plannerConfig.useErrorsOverWarnings());
        }
        CommunityAdministrationCommandRuntime runtime = communityAdministrationCommandRuntime;
        return new CypherCurrentCompiler<CommunityRuntimeContext>(planner, runtime, new CommunityRuntimeContextManager(this.log(), this.runtimeConfig), this.kernelMonitors);
    }

    public CommunityCompilerFactory(GraphDatabaseQueryService graph, Monitors kernelMonitors, LogProvider logProvider, CypherPlannerConfiguration plannerConfig, CypherRuntimeConfiguration runtimeConfig) {
        this.graph = graph;
        this.kernelMonitors = kernelMonitors;
        this.plannerConfig = plannerConfig;
        this.runtimeConfig = runtimeConfig;
        this.log = logProvider.getLog(this.getClass());
    }
}

