/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import org.neo4j.cypher.CypherRuntimeOption;
import org.neo4j.cypher.CypherRuntimeOption$default$;
import org.neo4j.cypher.internal.CypherRuntime;
import org.neo4j.cypher.internal.ExecutionPlan;
import org.neo4j.cypher.internal.ExecutionPlanWithNotifications;
import org.neo4j.cypher.internal.LogicalQuery;
import org.neo4j.cypher.internal.RuntimeContext;
import org.neo4j.cypher.internal.SchemaCommandRuntime$;
import org.neo4j.cypher.internal.compiler.RuntimeUnsupportedNotification;
import org.neo4j.cypher.internal.frontend.phases.RecordingNotificationLogger;
import org.neo4j.cypher.internal.frontend.phases.RecordingNotificationLogger$;
import org.neo4j.cypher.internal.util.InternalNotification;
import org.neo4j.exceptions.CantCompileQueryException;
import org.neo4j.exceptions.RuntimeUnsupportedException;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001q3Aa\u0002\u0005\u0001#!A\u0001\u0006\u0001B\u0001B\u0003%\u0011\u0006\u0003\u00056\u0001\t\u0005\t\u0015!\u00037\u0011\u0015Q\u0004\u0001\"\u0001<\u0011\u0015y\u0004\u0001\"\u0011A\u0011\u0015I\u0005\u0001\"\u0003K\u0011\u0015\u0001\u0006\u0001\"\u0011R\u0005=1\u0015\r\u001c7cC\u000e\\'+\u001e8uS6,'BA\u0005\u000b\u0003!Ig\u000e^3s]\u0006d'BA\u0006\r\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011QBD\u0001\u0006]\u0016|GG\u001b\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001U\u0011!cH\n\u0004\u0001MI\u0002C\u0001\u000b\u0018\u001b\u0005)\"\"\u0001\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005a)\"AB!osJ+g\rE\u0002\u001b7ui\u0011\u0001C\u0005\u00039!\u0011QbQ=qQ\u0016\u0014(+\u001e8uS6,\u0007C\u0001\u0010 \u0019\u0001!Q\u0001\t\u0001C\u0002\u0005\u0012qaQ(O)\u0016CF+\u0005\u0002#KA\u0011AcI\u0005\u0003IU\u0011qAT8uQ&tw\r\u0005\u0002\u001bM%\u0011q\u0005\u0003\u0002\u000f%VtG/[7f\u0007>tG/\u001a=u\u0003!\u0011XO\u001c;j[\u0016\u001c\bc\u0001\u0016339\u00111\u0006\r\b\u0003Y=j\u0011!\f\u0006\u0003]A\ta\u0001\u0010:p_Rt\u0014\"\u0001\f\n\u0005E*\u0012a\u00029bG.\fw-Z\u0005\u0003gQ\u00121aU3r\u0015\t\tT#\u0001\tsKF,Xm\u001d;fIJ+h\u000e^5nKB\u0011q\u0007O\u0007\u0002\u0015%\u0011\u0011H\u0003\u0002\u0014\u0007f\u0004\b.\u001a:Sk:$\u0018.\\3PaRLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007qjd\bE\u0002\u001b\u0001uAQ\u0001K\u0002A\u0002%BQ!N\u0002A\u0002Y\nAA\\1nKV\t\u0011\t\u0005\u0002C\r:\u00111\t\u0012\t\u0003YUI!!R\u000b\u0002\rA\u0013X\rZ3g\u0013\t9\u0005J\u0001\u0004TiJLgn\u001a\u0006\u0003\u000bV\t1\u0003];cY&\u001c7)\u00198o_R\u001cu.\u001c9jY\u0016$\"AI&\t\u000b1+\u0001\u0019A'\u0002#=\u0014\u0018nZ5oC2,\u0005pY3qi&|g\u000e\u0005\u0002+\u001d&\u0011q\n\u000e\u0002\n\u000bb\u001cW\r\u001d;j_:\f1cY8na&dW\rV8Fq\u0016\u001cW\u000f^1cY\u0016$2AU+[!\tQ2+\u0003\u0002U\u0011\tiQ\t_3dkRLwN\u001c)mC:DQA\u0016\u0004A\u0002]\u000bA\u0002\\8hS\u000e\fG.U;fef\u0004\"A\u0007-\n\u0005eC!\u0001\u0004'pO&\u001c\u0017\r\\)vKJL\b\"B.\u0007\u0001\u0004i\u0012aB2p]R,\u0007\u0010\u001e")
public class FallbackRuntime<CONTEXT extends RuntimeContext>
implements CypherRuntime<CONTEXT> {
    private final Seq<CypherRuntime<CONTEXT>> runtimes;
    private final CypherRuntimeOption requestedRuntime;

    @Override
    public String name() {
        return "fallback";
    }

    private Nothing$ publicCannotCompile(Exception originalException) {
        throw new RuntimeUnsupportedException(originalException.getMessage(), (Throwable)originalException);
    }

    @Override
    public ExecutionPlan compileToExecutable(LogicalQuery logicalQuery, CONTEXT context) {
        RecordingNotificationLogger logger = new RecordingNotificationLogger(RecordingNotificationLogger$.MODULE$.$lessinit$greater$default$1());
        Throwable lastException = null;
        for (int i = 0; i < this.runtimes.length(); ++i) {
            CypherRuntime runtime = (CypherRuntime)this.runtimes.apply(i);
            try {
                ExecutionPlan plan = runtime.compileToExecutable(logicalQuery, context);
                Set notifications = logger.notifications();
                ExecutionPlan notifiedPlan = notifications.isEmpty() ? plan : new ExecutionPlanWithNotifications(plan, (Set<InternalNotification>)notifications);
                return notifiedPlan;
            }
            catch (CantCompileQueryException e) {
                lastException = e;
                CypherRuntime cypherRuntime = runtime;
                SchemaCommandRuntime$ schemaCommandRuntime$ = SchemaCommandRuntime$.MODULE$;
                if (!(cypherRuntime == null ? schemaCommandRuntime$ != null : !cypherRuntime.equals(schemaCommandRuntime$))) continue;
                CypherRuntimeOption cypherRuntimeOption = this.requestedRuntime;
                CypherRuntimeOption$default$ cypherRuntimeOption$default$ = CypherRuntimeOption$default$.MODULE$;
                if (!(cypherRuntimeOption == null ? cypherRuntimeOption$default$ != null : !cypherRuntimeOption.equals(cypherRuntimeOption$default$))) continue;
                logger.log((InternalNotification)new RuntimeUnsupportedNotification(e.getMessage()));
                continue;
            }
            catch (Exception e) {
                lastException = e;
                ((RuntimeContext)context).log().debug(new StringBuilder(33).append("Runtime ").append(runtime.getClass().getSimpleName()).append(" failed to compile query ").append(logicalQuery.queryText()).toString(), (Throwable)e);
            }
        }
        Throwable throwable = lastException;
        if (throwable instanceof CantCompileQueryException) {
            CantCompileQueryException cantCompileQueryException = (CantCompileQueryException)throwable;
            throw this.publicCannotCompile((Exception)((Object)cantCompileQueryException));
        }
        throw throwable;
    }

    public FallbackRuntime(Seq<CypherRuntime<CONTEXT>> runtimes, CypherRuntimeOption requestedRuntime) {
        this.runtimes = runtimes;
        this.requestedRuntime = requestedRuntime;
    }
}

