/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Arrays;
import java.util.Collections;
import java.util.StringJoiner;
import org.neo4j.common.EntityType;
import org.neo4j.cypher.internal.CypherRuntime;
import org.neo4j.cypher.internal.ExecutionPlan;
import org.neo4j.cypher.internal.LogicalQuery;
import org.neo4j.cypher.internal.RuntimeContext;
import org.neo4j.cypher.internal.SchemaCommandRuntime$;
import org.neo4j.cypher.internal.SchemaCommandRuntime$Nonunique$;
import org.neo4j.cypher.internal.SchemaCommandRuntime$Unique$;
import org.neo4j.cypher.internal.ast.AllConstraints$;
import org.neo4j.cypher.internal.ast.ExistsConstraints$;
import org.neo4j.cypher.internal.ast.NodeExistsConstraints$;
import org.neo4j.cypher.internal.ast.NodeKeyConstraints$;
import org.neo4j.cypher.internal.ast.RelExistsConstraints$;
import org.neo4j.cypher.internal.ast.ShowConstraintType;
import org.neo4j.cypher.internal.ast.UniqueConstraints$;
import org.neo4j.cypher.internal.compiler.phases.LogicalPlanState;
import org.neo4j.cypher.internal.expressions.DoubleLiteral;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.LabelName;
import org.neo4j.cypher.internal.expressions.ListLiteral;
import org.neo4j.cypher.internal.expressions.MapExpression;
import org.neo4j.cypher.internal.expressions.Property;
import org.neo4j.cypher.internal.expressions.PropertyKeyName;
import org.neo4j.cypher.internal.expressions.RelTypeName;
import org.neo4j.cypher.internal.expressions.StringLiteral;
import org.neo4j.cypher.internal.logical.plans.ConstraintType;
import org.neo4j.cypher.internal.logical.plans.CreateIndex;
import org.neo4j.cypher.internal.logical.plans.CreateNodeKeyConstraint;
import org.neo4j.cypher.internal.logical.plans.CreateNodePropertyExistenceConstraint;
import org.neo4j.cypher.internal.logical.plans.CreateRelationshipPropertyExistenceConstraint;
import org.neo4j.cypher.internal.logical.plans.CreateUniquePropertyConstraint;
import org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForConstraint;
import org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForIndex;
import org.neo4j.cypher.internal.logical.plans.DropConstraintOnName;
import org.neo4j.cypher.internal.logical.plans.DropIndex;
import org.neo4j.cypher.internal.logical.plans.DropIndexOnName;
import org.neo4j.cypher.internal.logical.plans.DropNodeKeyConstraint;
import org.neo4j.cypher.internal.logical.plans.DropNodePropertyExistenceConstraint;
import org.neo4j.cypher.internal.logical.plans.DropRelationshipPropertyExistenceConstraint;
import org.neo4j.cypher.internal.logical.plans.DropUniquePropertyConstraint;
import org.neo4j.cypher.internal.logical.plans.LogicalPlan;
import org.neo4j.cypher.internal.logical.plans.NodeKey$;
import org.neo4j.cypher.internal.logical.plans.NodePropertyExistence$;
import org.neo4j.cypher.internal.logical.plans.RelationshipPropertyExistence$;
import org.neo4j.cypher.internal.logical.plans.ShowConstraints;
import org.neo4j.cypher.internal.logical.plans.ShowIndexes;
import org.neo4j.cypher.internal.logical.plans.Uniqueness$;
import org.neo4j.cypher.internal.procs.AssertConstraint$;
import org.neo4j.cypher.internal.procs.AssertIndex$;
import org.neo4j.cypher.internal.procs.IgnoredResult$;
import org.neo4j.cypher.internal.procs.SchemaReadExecutionPlan;
import org.neo4j.cypher.internal.procs.SchemaReadExecutionResult;
import org.neo4j.cypher.internal.procs.SchemaWriteExecutionPlan;
import org.neo4j.cypher.internal.procs.SchemaWriteExecutionPlan$;
import org.neo4j.cypher.internal.procs.SchemaWriteExecutionResult;
import org.neo4j.cypher.internal.procs.SuccessResult$;
import org.neo4j.cypher.internal.runtime.ConstraintInfo;
import org.neo4j.cypher.internal.runtime.IndexInfo;
import org.neo4j.cypher.internal.runtime.IndexStatus;
import org.neo4j.cypher.internal.runtime.InternalQueryType;
import org.neo4j.cypher.internal.runtime.ParameterMapping;
import org.neo4j.cypher.internal.runtime.QueryContext;
import org.neo4j.cypher.internal.runtime.SCHEMA_WRITE$;
import org.neo4j.cypher.internal.runtime.slottedParameters$;
import org.neo4j.cypher.internal.util.LabelId;
import org.neo4j.cypher.internal.util.NameId;
import org.neo4j.cypher.internal.util.NameId$;
import org.neo4j.cypher.internal.util.PropertyKeyId;
import org.neo4j.exceptions.CantCompileQueryException;
import org.neo4j.graphdb.schema.IndexSettingImpl;
import org.neo4j.graphdb.schema.IndexSettingUtil;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.impl.index.schema.FulltextIndexProviderFactory;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProvider;
import org.neo4j.kernel.impl.index.schema.fusion.NativeLuceneFusionIndexProviderFactory30;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.DoubleArray;
import org.neo4j.values.storable.IntValue;
import org.neo4j.values.storable.StringValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.ListMap$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.MapLike;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction2;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;

public final class SchemaCommandRuntime$
implements CypherRuntime<RuntimeContext> {
    public static SchemaCommandRuntime$ MODULE$;
    private final PartialFunction<LogicalPlan, Function2<RuntimeContext, ParameterMapping, ExecutionPlan>> logicalToExecutable;

    static {
        new SchemaCommandRuntime$();
    }

    @Override
    public String name() {
        return "schema";
    }

    @Override
    public ExecutionPlan compileToExecutable(LogicalQuery state, RuntimeContext context) {
        Tuple2 tuple2 = slottedParameters$.MODULE$.apply(state.logicalPlan());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        LogicalPlan withSlottedParameters = (LogicalPlan)tuple2._1();
        ParameterMapping parameterMapping = (ParameterMapping)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)withSlottedParameters, (Object)parameterMapping);
        Tuple2 tuple23 = tuple22;
        LogicalPlan withSlottedParameters2 = (LogicalPlan)tuple23._1();
        ParameterMapping parameterMapping2 = (ParameterMapping)tuple23._2();
        return (ExecutionPlan)((Function2)this.logicalToExecutable().applyOrElse((Object)withSlottedParameters2, (Function1 & Serializable & scala.Serializable)unknownPlan -> MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply((Object)context, (Object)parameterMapping2);
    }

    public Nothing$ throwCantCompile(LogicalPlan unknownPlan) {
        throw new CantCompileQueryException(new StringBuilder(30).append("Plan is not a schema command: ").append(unknownPlan.getClass().getSimpleName()).toString());
    }

    public Option<InternalQueryType> queryType(LogicalPlan logicalPlan) {
        return this.logicalToExecutable().isDefinedAt((Object)logicalPlan) ? new Some((Object)SCHEMA_WRITE$.MODULE$) : None$.MODULE$;
    }

    public PartialFunction<LogicalPlan, Function2<RuntimeContext, ParameterMapping, ExecutionPlan>> logicalToExecutable() {
        return this.logicalToExecutable;
    }

    public boolean isApplicable(LogicalPlanState logicalPlanState) {
        return this.logicalToExecutable().isDefinedAt(logicalPlanState.maybeLogicalPlan().get());
    }

    public Function1<ConstraintDescriptor, Object> convertConstraintTypeToConstraintMatcher(ConstraintType assertion) {
        Function1 & Serializable & scala.Serializable intersect;
        ConstraintType constraintType = assertion;
        if (NodePropertyExistence$.MODULE$.equals(constraintType)) {
            intersect = (Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.isNodePropertyExistenceConstraint());
        } else if (RelationshipPropertyExistence$.MODULE$.equals(constraintType)) {
            intersect = (Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.isRelationshipPropertyExistenceConstraint());
        } else if (Uniqueness$.MODULE$.equals(constraintType)) {
            intersect = (Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.isUniquenessConstraint());
        } else if (NodeKey$.MODULE$.equals(constraintType)) {
            intersect = (Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.isNodeKeyConstraint());
        } else {
            throw new MatchError((Object)constraintType);
        }
        return intersect;
    }

    public LabelId org$neo4j$cypher$internal$SchemaCommandRuntime$$labelToId(QueryContext ctx, LabelName label) {
        return new LabelId(ctx.getOrCreateLabelId(label.name()));
    }

    public PropertyKeyId org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(QueryContext ctx, PropertyKeyName property) {
        return new PropertyKeyId(ctx.getOrCreatePropertyKeyId(property.name()));
    }

    public Tuple2<Object, Object> org$neo4j$cypher$internal$SchemaCommandRuntime$$labelProp(QueryContext ctx, LabelName label, PropertyKeyName prop) {
        return new Tuple2.mcII.sp(ctx.getOrCreateLabelId(label.name()), ctx.getOrCreatePropertyKeyId(prop.name()));
    }

    public Tuple3<Object, Object, Option<String>> org$neo4j$cypher$internal$SchemaCommandRuntime$$labelPropWithName(QueryContext ctx, LabelName label, PropertyKeyName prop, Option<String> name) {
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)ctx.getOrCreateLabelId(label.name())), (Object)BoxesRunTime.boxToInteger((int)ctx.getOrCreatePropertyKeyId(prop.name())), name);
    }

    public Tuple2<Object, Object> org$neo4j$cypher$internal$SchemaCommandRuntime$$typeProp(QueryContext ctx, RelTypeName relType, PropertyKeyName prop) {
        return new Tuple2.mcII.sp(ctx.getOrCreateRelTypeId(relType.name()), ctx.getOrCreatePropertyKeyId(prop.name()));
    }

    public Tuple3<Object, Object, Option<String>> org$neo4j$cypher$internal$SchemaCommandRuntime$$typePropWithName(QueryContext ctx, RelTypeName relType, PropertyKeyName prop, Option<String> name) {
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)ctx.getOrCreateRelTypeId(relType.name())), (Object)BoxesRunTime.boxToInteger((int)ctx.getOrCreatePropertyKeyId(prop.name())), name);
    }

    public Tuple2<Option<String>, IndexConfig> org$neo4j$cypher$internal$SchemaCommandRuntime$$getValidProviderAndConfig(scala.collection.immutable.Map<String, Expression> options, String schemaType) {
        scala.collection.immutable.Map lowerCaseOptions = (scala.collection.immutable.Map)options.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            Expression v = (Expression)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)k.toLowerCase(), (Object)v);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        Option maybeIndexProvider = lowerCaseOptions.get((Object)"indexprovider");
        Option maybeConfig = lowerCaseOptions.get((Object)"indexconfig");
        None$ indexProvider = maybeIndexProvider.isDefined() ? new Some((Object)this.assertValidIndexProvider((Expression)maybeIndexProvider.get(), schemaType)) : None$.MODULE$;
        java.util.Map configMap = maybeConfig.isDefined() ? this.assertValidAndTransformConfig((Expression)maybeConfig.get(), schemaType) : Collections.emptyMap();
        IndexConfig indexConfig = IndexSettingUtil.toIndexConfigFromStringObjectMap(configMap);
        return new Tuple2((Object)indexProvider, (Object)indexConfig);
    }

    private String assertValidIndexProvider(Expression indexProvider, String schemaType) {
        String indexProviderValue;
        Expression expression = indexProvider;
        if (expression instanceof StringLiteral) {
            StringLiteral stringLiteral = (StringLiteral)expression;
            indexProviderValue = stringLiteral.value();
            if (indexProviderValue.equalsIgnoreCase(FulltextIndexProviderFactory.DESCRIPTOR.name())) {
                throw new InvalidArgumentsException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(186).append("Could not create ").append(schemaType).append(" with specified index provider '").append(indexProviderValue).append("'.\n             |To create fulltext index, please use 'db.index.fulltext.createNodeIndex' or 'db.index.fulltext.createRelationshipIndex'.").toString())).stripMargin());
            }
            if (!indexProviderValue.equalsIgnoreCase(GenericNativeIndexProvider.DESCRIPTOR.name()) && !indexProviderValue.equalsIgnoreCase(NativeLuceneFusionIndexProviderFactory30.DESCRIPTOR.name())) {
                throw new InvalidArgumentsException(new StringBuilder(51).append("Could not create ").append(schemaType).append(" with specified index provider '").append(indexProviderValue).append("'.").toString());
            }
        } else {
            throw new InvalidArgumentsException(new StringBuilder(74).append("Could not create ").append(schemaType).append(" with specified index provider '").append(indexProvider.asCanonicalStringVal()).append("'. Expected String value.").toString());
        }
        String string = indexProviderValue;
        return string;
    }

    private java.util.Map<String, Object> assertValidAndTransformConfig(Expression config, String schemaType) {
        Seq items;
        InvalidArgumentsException exceptionWrongType = new InvalidArgumentsException(new StringBuilder(89).append("Could not create ").append(schemaType).append(" with specified index config '").append(config.asCanonicalStringVal()).append("'. Expected a map from String to Double[].").toString());
        Expression expression = config;
        if (expression instanceof MapExpression) {
            MapExpression mapExpression = (MapExpression)expression;
            items = mapExpression.items();
            if (items.exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SchemaCommandRuntime$.$anonfun$assertValidAndTransformConfig$1(x0$1)))) {
                throw new InvalidArgumentsException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(220).append("Could not create ").append(schemaType).append(" with specified index config '").append(config.asCanonicalStringVal()).append("', contains fulltext config options.\n               |To create fulltext index, please use 'db.index.fulltext.createNodeIndex' or 'db.index.fulltext.createRelationshipIndex'.").toString())).stripMargin());
            }
        } else {
            throw exceptionWrongType;
        }
        java.util.Map map = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)items.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Expression e;
            PropertyKeyName p;
            block3: {
                block2: {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 == null) break block2;
                    p = (PropertyKeyName)tuple2._1();
                    e = (Expression)tuple2._2();
                    if (e instanceof ListLiteral) break block3;
                }
                throw exceptionWrongType;
            }
            ListLiteral listLiteral = (ListLiteral)e;
            Object configValue = ((TraversableOnce)listLiteral.expressions().map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Expression expression = x0$3;
                if (!(expression instanceof DoubleLiteral)) {
                    throw exceptionWrongType;
                }
                DoubleLiteral doubleLiteral = (DoubleLiteral)expression;
                Double d = doubleLiteral.value();
                return d;
            }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Double.class));
            Tuple2 tuple2 = new Tuple2((Object)p.name(), configValue);
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
        return map;
    }

    /*
     * Unable to fully structure code
     */
    public String org$neo4j$cypher$internal$SchemaCommandRuntime$$createIndexStatement(String name, IndexType indexType, EntityType entityType, List<String> labelsOrTypes, List<String> properties, String providerName, IndexConfig indexConfig, Option<ConstraintDescriptor> maybeConstraint) {
        block14: {
            block13: {
                var12_9 = indexType;
                if (!IndexType.BTREE.equals(var12_9)) break block13;
                escapedName = new StringBuilder(2).append("`").append(this.escapeBackticks(name)).append("`").toString();
                labelsOrTypesWithColons = this.asEscapedString(labelsOrTypes, this.colonStringJoiner());
                escapedProperties = this.asEscapedString(properties, this.propStringJoiner());
                btreeConfig = this.configAsString(indexConfig, (Function1<Value, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$createIndexStatement$1(org.neo4j.values.storable.Value ), (Lorg/neo4j/values/storable/Value;)Ljava/lang/String;)());
                optionsString = this.optionsAsString(providerName, btreeConfig);
                var18_15 = false;
                var19_16 = null;
                var20_17 = maybeConstraint;
                if (!(var20_17 instanceof Some)) ** GOTO lbl-1000
                var18_15 = true;
                var19_16 = (Some)var20_17;
                constraint = (ConstraintDescriptor)var19_16.value();
                if (constraint.isUniquenessConstraint()) {
                    var11_19 = new StringBuilder(54).append("CREATE CONSTRAINT ").append(escapedName).append(" ON (n").append(labelsOrTypesWithColons).append(") ASSERT (").append(escapedProperties).append(") IS UNIQUE OPTIONS ").append(optionsString).toString();
                } else if (var18_15 && (constraint = (ConstraintDescriptor)var19_16.value()).isNodeKeyConstraint()) {
                    var11_19 = new StringBuilder(56).append("CREATE CONSTRAINT ").append(escapedName).append(" ON (n").append(labelsOrTypesWithColons).append(") ASSERT (").append(escapedProperties).append(") IS NODE KEY OPTIONS ").append(optionsString).toString();
                } else {
                    if (var18_15) {
                        throw new IllegalArgumentException("Expected an index or index backed constraint, found another constraint.");
                    }
                    if (None$.MODULE$.equals(var20_17)) {
                        var11_19 = new StringBuilder(36).append("CREATE INDEX ").append(escapedName).append(" FOR (n").append(labelsOrTypesWithColons).append(") ON (").append(escapedProperties).append(") OPTIONS ").append(optionsString).toString();
                    } else {
                        throw new MatchError(var20_17);
                    }
                }
                var9_21 = var11_19;
                break block14;
            }
            if (IndexType.FULLTEXT.equals(var12_9)) {
                escapedName = new StringBuilder(2).append("'").append(this.escapeSingleQuotes(name)).append("'").toString();
                labelsOrTypesArray = this.asString(labelsOrTypes, this.arrayStringJoiner());
                propertiesArray = this.asString(properties, this.arrayStringJoiner());
                fulltextConfig = this.configAsString(indexConfig, (Function1<Value, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$createIndexStatement$2(org.neo4j.values.storable.Value ), (Lorg/neo4j/values/storable/Value;)Ljava/lang/String;)());
                var27_26 = entityType;
                if (EntityType.NODE.equals(var27_26)) {
                    var10_27 = new StringBuilder(46).append("CALL db.index.fulltext.createNodeIndex(").append(escapedName).append(", ").append(labelsOrTypesArray).append(", ").append(propertiesArray).append(", ").append(fulltextConfig).append(")").toString();
                } else if (EntityType.RELATIONSHIP.equals(var27_26)) {
                    var10_27 = new StringBuilder(54).append("CALL db.index.fulltext.createRelationshipIndex(").append(escapedName).append(", ").append(labelsOrTypesArray).append(", ").append(propertiesArray).append(", ").append(fulltextConfig).append(")").toString();
                } else {
                    throw new IllegalArgumentException(new StringBuilder(30).append("Did not recognize entity type ").append(entityType).toString());
                }
                var9_21 = var10_27;
            } else {
                throw new IllegalArgumentException(new StringBuilder(29).append("Did not recognize index type ").append(indexType).toString());
            }
        }
        return var9_21;
    }

    public String org$neo4j$cypher$internal$SchemaCommandRuntime$$createConstraintStatement(String name, ShowConstraintType constraintType, List<String> labelsOrTypes, List<String> properties, Option<String> providerName, Option<IndexConfig> indexConfig) {
        String string;
        String labelsOrTypesWithColons = this.asEscapedString(labelsOrTypes, this.colonStringJoiner());
        String escapedName = this.escapeBackticks(name);
        ShowConstraintType showConstraintType = constraintType;
        if (UniqueConstraints$.MODULE$.equals(showConstraintType)) {
            String escapedProperties = this.asEscapedString(properties, this.propStringJoiner());
            String options = this.extractOptionsString(providerName, indexConfig, UniqueConstraints$.MODULE$.prettyPrint());
            string = new StringBuilder(56).append("CREATE CONSTRAINT `").append(escapedName).append("` ON (n").append(labelsOrTypesWithColons).append(") ASSERT (").append(escapedProperties).append(") IS UNIQUE OPTIONS ").append(options).toString();
        } else if (NodeKeyConstraints$.MODULE$.equals(showConstraintType)) {
            String escapedProperties = this.asEscapedString(properties, this.propStringJoiner());
            String options = this.extractOptionsString(providerName, indexConfig, NodeKeyConstraints$.MODULE$.prettyPrint());
            string = new StringBuilder(58).append("CREATE CONSTRAINT `").append(escapedName).append("` ON (n").append(labelsOrTypesWithColons).append(") ASSERT (").append(escapedProperties).append(") IS NODE KEY OPTIONS ").append(options).toString();
        } else if (NodeExistsConstraints$.MODULE$.equals(showConstraintType)) {
            String escapedProperties = this.asEscapedString(properties, this.propStringJoiner());
            string = new StringBuilder(43).append("CREATE CONSTRAINT `").append(escapedName).append("` ON (n").append(labelsOrTypesWithColons).append(") ASSERT exists(").append(escapedProperties).append(")").toString();
        } else if (RelExistsConstraints$.MODULE$.equals(showConstraintType)) {
            String escapedProperties = this.asEscapedString(properties, this.relPropStringJoiner());
            string = new StringBuilder(49).append("CREATE CONSTRAINT `").append(escapedName).append("` ON ()-[r").append(labelsOrTypesWithColons).append("]-() ASSERT exists(").append(escapedProperties).append(")").toString();
        } else {
            throw new IllegalArgumentException(new StringBuilder(62).append("Did not expect constraint type ").append(constraintType.prettyPrint()).append(" for constraint create command.").toString());
        }
        return string;
    }

    public Option<String> org$neo4j$cypher$internal$SchemaCommandRuntime$$createConstraintStatement$default$5() {
        return None$.MODULE$;
    }

    public Option<IndexConfig> org$neo4j$cypher$internal$SchemaCommandRuntime$$createConstraintStatement$default$6() {
        return None$.MODULE$;
    }

    private String extractOptionsString(Option<String> maybeProviderName, Option<IndexConfig> maybeIndexConfig, String constraintType) {
        String providerName = (String)maybeProviderName.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(41).append("Expected a provider name for ").append(constraintType).append(" constraint.").toString());
        });
        IndexConfig indexConfig = (IndexConfig)maybeIndexConfig.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(48).append("Expected an index configuration for ").append(constraintType).append(" constraint.").toString());
        });
        String btreeConfig = this.configAsString(indexConfig, (Function1<Value, String>)(Function1 & Serializable & scala.Serializable)value -> MODULE$.btreeConfigValueAsString((Value)value));
        return this.optionsAsString(providerName, btreeConfig);
    }

    public MapValue org$neo4j$cypher$internal$SchemaCommandRuntime$$extractOptionsMap(String providerName, IndexConfig indexConfig) {
        Tuple2 tuple2 = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(indexConfig.asMap()).asScala()).toSeq().unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq configKeys = (Seq)tuple2._1();
        Seq configValues = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)configKeys, (Object)configValues);
        Tuple2 tuple23 = tuple22;
        Seq configKeys2 = (Seq)tuple23._1();
        Seq configValues2 = (Seq)tuple23._2();
        String[] optionKeys = (String[])((Object[])new String[]{"indexConfig", "indexProvider"});
        AnyValue[] optionValues = (AnyValue[])((Object[])new AnyValue[]{VirtualValues.map((String[])((String[])configKeys2.toArray(ClassTag$.MODULE$.apply(String.class))), (AnyValue[])((AnyValue[])configValues2.toArray(ClassTag$.MODULE$.apply(AnyValue.class)))), Values.stringValue((String)providerName)});
        return VirtualValues.map((String[])optionKeys, (AnyValue[])optionValues);
    }

    private String asEscapedString(List<String> list, StringJoiner stringJoiner) {
        list.foreach((Function1 & Serializable & scala.Serializable)elem -> stringJoiner.add(new StringBuilder(2).append("`").append(MODULE$.escapeBackticks((String)elem)).append("`").toString()));
        return stringJoiner.toString();
    }

    private String asString(List<String> list, StringJoiner stringJoiner) {
        list.foreach((Function1 & Serializable & scala.Serializable)elem -> stringJoiner.add(new StringBuilder(2).append("'").append(MODULE$.escapeSingleQuotes((String)elem)).append("'").toString()));
        return stringJoiner.toString();
    }

    private String optionsAsString(String providerString, String configString) {
        return new StringBuilder(34).append("{indexConfig: ").append(configString).append(", indexProvider: '").append(providerString).append("'}").toString();
    }

    private String configAsString(IndexConfig indexConfig, Function1<Value, String> configValueAsString) {
        StringJoiner configString = this.configStringJoiner();
        ListMap sortedIndexConfig = (ListMap)ListMap$.MODULE$.apply((Seq)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(indexConfig.asMap()).asScala()).toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$37 -> (String)x$37._1(), (Ordering)Ordering.String$.MODULE$));
        sortedIndexConfig.foldLeft((Object)configString, (Function2 & Serializable & scala.Serializable)(acc, entry) -> {
            String singleConfig = new StringBuilder(4).append("`").append(entry._1()).append("`: ").append(configValueAsString.apply(entry._2())).toString();
            return acc.add(singleConfig);
        });
        return configString.toString();
    }

    private String btreeConfigValueAsString(Value configValue) {
        String string;
        Value value = configValue;
        if (value instanceof DoubleArray) {
            DoubleArray doubleArray = (DoubleArray)value;
            string = Arrays.toString(doubleArray.asObjectCopy());
        } else if (value instanceof IntValue) {
            IntValue intValue = (IntValue)value;
            string = String.valueOf(BoxesRunTime.boxToInteger((int)intValue.value()));
        } else if (value instanceof BooleanValue) {
            BooleanValue booleanValue = (BooleanValue)value;
            string = String.valueOf(BoxesRunTime.boxToBoolean((boolean)booleanValue.booleanValue()));
        } else if (value instanceof StringValue) {
            StringValue stringValue = (StringValue)value;
            string = new StringBuilder(2).append("'").append(stringValue.stringValue()).append("'").toString();
        } else {
            throw new IllegalArgumentException(new StringBuilder(51).append("Could not convert config value '").append(configValue).append("' to config string.").toString());
        }
        return string;
    }

    private String fullTextConfigValueAsString(Value configValue) {
        String string;
        Value value = configValue;
        if (value instanceof BooleanValue) {
            BooleanValue booleanValue = (BooleanValue)value;
            string = new StringBuilder(2).append("'").append(booleanValue.booleanValue()).append("'").toString();
        } else if (value instanceof StringValue) {
            StringValue stringValue = (StringValue)value;
            string = new StringBuilder(2).append("'").append(stringValue.stringValue()).append("'").toString();
        } else {
            throw new IllegalArgumentException(new StringBuilder(51).append("Could not convert config value '").append(configValue).append("' to config string.").toString());
        }
        return string;
    }

    private StringJoiner colonStringJoiner() {
        return new StringJoiner(":", ":", "");
    }

    private StringJoiner propStringJoiner() {
        return new StringJoiner(", n.", "n.", "");
    }

    private StringJoiner relPropStringJoiner() {
        return new StringJoiner(", r.", "r.", "");
    }

    private StringJoiner arrayStringJoiner() {
        return new StringJoiner(", ", "[", "]");
    }

    private StringJoiner configStringJoiner() {
        return new StringJoiner(",", "{", "}");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ShowConstraintType org$neo4j$cypher$internal$SchemaCommandRuntime$$getConstraintType(org.neo4j.internal.schema.ConstraintType internalConstraintType, EntityType entityType) {
        Tuple2 tuple2 = new Tuple2((Object)internalConstraintType, (Object)entityType);
        if (tuple2 != null) {
            org.neo4j.internal.schema.ConstraintType constraintType = (org.neo4j.internal.schema.ConstraintType)tuple2._1();
            EntityType entityType2 = (EntityType)tuple2._2();
            if (org.neo4j.internal.schema.ConstraintType.UNIQUE.equals(constraintType) && EntityType.NODE.equals(entityType2)) {
                return UniqueConstraints$.MODULE$;
            }
        }
        if (tuple2 != null) {
            org.neo4j.internal.schema.ConstraintType constraintType = (org.neo4j.internal.schema.ConstraintType)tuple2._1();
            EntityType entityType3 = (EntityType)tuple2._2();
            if (org.neo4j.internal.schema.ConstraintType.UNIQUE_EXISTS.equals(constraintType) && EntityType.NODE.equals(entityType3)) {
                return NodeKeyConstraints$.MODULE$;
            }
        }
        if (tuple2 != null) {
            org.neo4j.internal.schema.ConstraintType constraintType = (org.neo4j.internal.schema.ConstraintType)tuple2._1();
            EntityType entityType4 = (EntityType)tuple2._2();
            if (org.neo4j.internal.schema.ConstraintType.EXISTS.equals(constraintType) && EntityType.NODE.equals(entityType4)) {
                return NodeExistsConstraints$.MODULE$;
            }
        }
        if (tuple2 == null) throw new IllegalStateException(new StringBuilder(64).append("Invalid constraint combination: ConstraintType ").append(internalConstraintType).append(" and EntityType ").append(entityType).append(".").toString());
        org.neo4j.internal.schema.ConstraintType constraintType = (org.neo4j.internal.schema.ConstraintType)tuple2._1();
        EntityType entityType5 = (EntityType)tuple2._2();
        if (!org.neo4j.internal.schema.ConstraintType.EXISTS.equals(constraintType)) throw new IllegalStateException(new StringBuilder(64).append("Invalid constraint combination: ConstraintType ").append(internalConstraintType).append(" and EntityType ").append(entityType).append(".").toString());
        if (!EntityType.RELATIONSHIP.equals(entityType5)) throw new IllegalStateException(new StringBuilder(64).append("Invalid constraint combination: ConstraintType ").append(internalConstraintType).append(" and EntityType ").append(entityType).append(".").toString());
        return RelExistsConstraints$.MODULE$;
    }

    private String escapeBackticks(String str) {
        return new StringOps(Predef$.MODULE$.augmentString(str)).replaceAllLiterally("`", "``");
    }

    private String escapeSingleQuotes(String str) {
        return new StringOps(Predef$.MODULE$.augmentString(str)).replaceAllLiterally("'", "\\'");
    }

    public static final /* synthetic */ boolean $anonfun$assertValidAndTransformConfig$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        PropertyKeyName p = (PropertyKeyName)tuple2._1();
        boolean bl = p.name().equalsIgnoreCase(IndexSettingImpl.FULLTEXT_ANALYZER.getSettingName()) || p.name().equalsIgnoreCase(IndexSettingImpl.FULLTEXT_EVENTUALLY_CONSISTENT.getSettingName());
        return bl;
    }

    public static final /* synthetic */ String $anonfun$createIndexStatement$1(Value value) {
        return MODULE$.btreeConfigValueAsString(value);
    }

    public static final /* synthetic */ String $anonfun$createIndexStatement$2(Value value) {
        return MODULE$.fullTextConfigValueAsString(value);
    }

    private SchemaCommandRuntime$() {
        MODULE$ = this;
        this.logicalToExecutable = new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Function2 & Serializable & scala.Serializable intersect;
                A1 A1 = x1;
                if (A1 instanceof CreateNodeKeyConstraint) {
                    CreateNodeKeyConstraint createNodeKeyConstraint = (CreateNodeKeyConstraint)A1;
                    Option source = createNodeKeyConstraint.source();
                    LabelName label = createNodeKeyConstraint.label();
                    Seq props = createNodeKeyConstraint.props();
                    Option name = createNodeKeyConstraint.name();
                    scala.collection.immutable.Map options = createNodeKeyConstraint.options();
                    intersect = (Function2 & Serializable & scala.Serializable)(context, parameterMapping) -> new SchemaWriteExecutionPlan("CreateNodeKeyConstraint", (Function1<QueryContext, SchemaWriteExecutionResult>)(Function1 & Serializable & scala.Serializable)ctx -> {
                        Tuple2<Option<String>, IndexConfig> tuple2 = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$getValidProviderAndConfig((scala.collection.immutable.Map<String, Expression>)options, "node key constraint");
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        Option indexProvider = (Option)tuple2._1();
                        IndexConfig indexConfig = (IndexConfig)tuple2._2();
                        Tuple2 tuple22 = new Tuple2((Object)indexProvider, (Object)indexConfig);
                        Tuple2 tuple23 = tuple22;
                        Option indexProvider2 = (Option)tuple23._1();
                        IndexConfig indexConfig2 = (IndexConfig)tuple23._2();
                        int labelId = ctx.getOrCreateLabelId(label.name());
                        Seq propertyKeyIds = (Seq)props.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$3(ctx, p)), Seq$.MODULE$.canBuildFrom());
                        ctx.createNodeKeyConstraint(labelId, propertyKeyIds, name, indexProvider2, indexConfig2);
                        return SuccessResult$.MODULE$;
                    }, (Option<ExecutionPlan>)source.map((Function1 & Serializable & scala.Serializable)x$3 -> (ExecutionPlan)((Function2)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$3, (Function1 & Serializable & scala.Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context, parameterMapping)));
                } else if (A1 instanceof DropNodeKeyConstraint) {
                    DropNodeKeyConstraint dropNodeKeyConstraint = (DropNodeKeyConstraint)A1;
                    LabelName label = dropNodeKeyConstraint.label();
                    Seq props = dropNodeKeyConstraint.props();
                    intersect = (Function2 & Serializable & scala.Serializable)(x$4, x$5) -> new SchemaWriteExecutionPlan("DropNodeKeyConstraint", (Function1<QueryContext, SchemaWriteExecutionResult>)(Function1 & Serializable & scala.Serializable)ctx -> {
                        int labelId = ctx.getOrCreateLabelId(label.name());
                        Seq propertyKeyIds = (Seq)props.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$8(ctx, p)), Seq$.MODULE$.canBuildFrom());
                        ctx.dropNodeKeyConstraint(labelId, propertyKeyIds);
                        return SuccessResult$.MODULE$;
                    }, SchemaWriteExecutionPlan$.MODULE$.apply$default$3());
                } else if (A1 instanceof CreateUniquePropertyConstraint) {
                    CreateUniquePropertyConstraint createUniquePropertyConstraint = (CreateUniquePropertyConstraint)A1;
                    Option source = createUniquePropertyConstraint.source();
                    LabelName label = createUniquePropertyConstraint.label();
                    Seq props = createUniquePropertyConstraint.props();
                    Option name = createUniquePropertyConstraint.name();
                    scala.collection.immutable.Map options = createUniquePropertyConstraint.options();
                    intersect = (Function2 & Serializable & scala.Serializable)(context, parameterMapping) -> new SchemaWriteExecutionPlan("CreateUniqueConstraint", (Function1<QueryContext, SchemaWriteExecutionResult>)(Function1 & Serializable & scala.Serializable)ctx -> {
                        Tuple2<Option<String>, IndexConfig> tuple2 = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$getValidProviderAndConfig((scala.collection.immutable.Map<String, Expression>)options, "uniqueness constraint");
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        Option indexProvider = (Option)tuple2._1();
                        IndexConfig indexConfig = (IndexConfig)tuple2._2();
                        Tuple2 tuple22 = new Tuple2((Object)indexProvider, (Object)indexConfig);
                        Tuple2 tuple23 = tuple22;
                        Option indexProvider2 = (Option)tuple23._1();
                        IndexConfig indexConfig2 = (IndexConfig)tuple23._2();
                        int labelId = ctx.getOrCreateLabelId(label.name());
                        Seq propertyKeyIds = (Seq)props.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$11(ctx, p)), Seq$.MODULE$.canBuildFrom());
                        ctx.createUniqueConstraint(labelId, propertyKeyIds, name, indexProvider2, indexConfig2);
                        return SuccessResult$.MODULE$;
                    }, (Option<ExecutionPlan>)source.map((Function1 & Serializable & scala.Serializable)x$7 -> (ExecutionPlan)((Function2)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$7, (Function1 & Serializable & scala.Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context, parameterMapping)));
                } else if (A1 instanceof DropUniquePropertyConstraint) {
                    DropUniquePropertyConstraint dropUniquePropertyConstraint = (DropUniquePropertyConstraint)A1;
                    LabelName label = dropUniquePropertyConstraint.label();
                    Seq props = dropUniquePropertyConstraint.props();
                    intersect = (Function2 & Serializable & scala.Serializable)(x$8, x$9) -> new SchemaWriteExecutionPlan("DropUniqueConstraint", (Function1<QueryContext, SchemaWriteExecutionResult>)(Function1 & Serializable & scala.Serializable)ctx -> {
                        int labelId = ctx.getOrCreateLabelId(label.name());
                        Seq propertyKeyIds = (Seq)props.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$16(ctx, p)), Seq$.MODULE$.canBuildFrom());
                        ctx.dropUniqueConstraint(labelId, propertyKeyIds);
                        return SuccessResult$.MODULE$;
                    }, SchemaWriteExecutionPlan$.MODULE$.apply$default$3());
                } else if (A1 instanceof CreateNodePropertyExistenceConstraint) {
                    CreateNodePropertyExistenceConstraint createNodePropertyExistenceConstraint = (CreateNodePropertyExistenceConstraint)A1;
                    Option source = createNodePropertyExistenceConstraint.source();
                    LabelName label = createNodePropertyExistenceConstraint.label();
                    Property prop = createNodePropertyExistenceConstraint.prop();
                    Option name = createNodePropertyExistenceConstraint.name();
                    intersect = (Function2 & Serializable & scala.Serializable)(context, parameterMapping) -> new SchemaWriteExecutionPlan("CreateNodePropertyExistenceConstraint", (Function1<QueryContext, SchemaWriteExecutionResult>)(Function1 & Serializable & scala.Serializable)ctx -> {
                        ((Function3 & Serializable & scala.Serializable)(Function3 & Serializable & scala.Serializable)(labelId, propertyKeyId, name) -> {
                            anonfun.1.$anonfun$applyOrElse$19(ctx, BoxesRunTime.unboxToInt((Object)labelId), BoxesRunTime.unboxToInt((Object)propertyKeyId), name);
                            return BoxedUnit.UNIT;
                        }).tupled().apply(SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$labelPropWithName((QueryContext)ctx, label, prop.propertyKey(), (Option<String>)name));
                        return SuccessResult$.MODULE$;
                    }, (Option<ExecutionPlan>)source.map((Function1 & Serializable & scala.Serializable)x$10 -> (ExecutionPlan)((Function2)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$10, (Function1 & Serializable & scala.Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context, parameterMapping)));
                } else if (A1 instanceof DropNodePropertyExistenceConstraint) {
                    DropNodePropertyExistenceConstraint dropNodePropertyExistenceConstraint = (DropNodePropertyExistenceConstraint)A1;
                    LabelName label = dropNodePropertyExistenceConstraint.label();
                    Property prop = dropNodePropertyExistenceConstraint.prop();
                    intersect = (Function2 & Serializable & scala.Serializable)(x$11, x$12) -> new SchemaWriteExecutionPlan("DropNodePropertyExistenceConstraint", (Function1<QueryContext, SchemaWriteExecutionResult>)(Function1 & Serializable & scala.Serializable)ctx -> {
                        ((JFunction2.mcVII.sp & Serializable & scala.Serializable)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(labelId, propertyKeyId) -> ctx.dropNodePropertyExistenceConstraint(labelId, propertyKeyId)).tupled().apply(SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$labelProp((QueryContext)ctx, label, prop.propertyKey()));
                        return SuccessResult$.MODULE$;
                    }, SchemaWriteExecutionPlan$.MODULE$.apply$default$3());
                } else if (A1 instanceof CreateRelationshipPropertyExistenceConstraint) {
                    CreateRelationshipPropertyExistenceConstraint createRelationshipPropertyExistenceConstraint = (CreateRelationshipPropertyExistenceConstraint)A1;
                    Option source = createRelationshipPropertyExistenceConstraint.source();
                    RelTypeName relType = createRelationshipPropertyExistenceConstraint.typeName();
                    Property prop = createRelationshipPropertyExistenceConstraint.prop();
                    Option name = createRelationshipPropertyExistenceConstraint.name();
                    intersect = (Function2 & Serializable & scala.Serializable)(context, parameterMapping) -> new SchemaWriteExecutionPlan("CreateRelationshipPropertyExistenceConstraint", (Function1<QueryContext, SchemaWriteExecutionResult>)(Function1 & Serializable & scala.Serializable)ctx -> {
                        ((Function3 & Serializable & scala.Serializable)(Function3 & Serializable & scala.Serializable)(relTypeId, propertyKeyId, name) -> {
                            anonfun.1.$anonfun$applyOrElse$27(ctx, BoxesRunTime.unboxToInt((Object)relTypeId), BoxesRunTime.unboxToInt((Object)propertyKeyId), name);
                            return BoxedUnit.UNIT;
                        }).tupled().apply(SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$typePropWithName((QueryContext)ctx, relType, prop.propertyKey(), (Option<String>)name));
                        return SuccessResult$.MODULE$;
                    }, (Option<ExecutionPlan>)source.map((Function1 & Serializable & scala.Serializable)x$13 -> (ExecutionPlan)((Function2)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$13, (Function1 & Serializable & scala.Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context, parameterMapping)));
                } else if (A1 instanceof DropRelationshipPropertyExistenceConstraint) {
                    DropRelationshipPropertyExistenceConstraint dropRelationshipPropertyExistenceConstraint = (DropRelationshipPropertyExistenceConstraint)A1;
                    RelTypeName relType = dropRelationshipPropertyExistenceConstraint.typeName();
                    Property prop = dropRelationshipPropertyExistenceConstraint.prop();
                    intersect = (Function2 & Serializable & scala.Serializable)(x$14, x$15) -> new SchemaWriteExecutionPlan("DropRelationshipPropertyExistenceConstraint", (Function1<QueryContext, SchemaWriteExecutionResult>)(Function1 & Serializable & scala.Serializable)ctx -> {
                        ((JFunction2.mcVII.sp & Serializable & scala.Serializable)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(relTypeId, propertyKeyId) -> ctx.dropRelationshipPropertyExistenceConstraint(relTypeId, propertyKeyId)).tupled().apply(SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$typeProp((QueryContext)ctx, relType, prop.propertyKey()));
                        return SuccessResult$.MODULE$;
                    }, SchemaWriteExecutionPlan$.MODULE$.apply$default$3());
                } else if (A1 instanceof DropConstraintOnName) {
                    DropConstraintOnName dropConstraintOnName = (DropConstraintOnName)A1;
                    String name = dropConstraintOnName.name();
                    boolean ifExists = dropConstraintOnName.ifExists();
                    intersect = (Function2 & Serializable & scala.Serializable)(x$16, x$17) -> new SchemaWriteExecutionPlan("DropConstraint", (Function1<QueryContext, SchemaWriteExecutionResult>)(Function1 & Serializable & scala.Serializable)ctx -> {
                        block0: {
                            if (ifExists && !ctx.constraintExists(name)) break block0;
                            ctx.dropNamedConstraint(name);
                        }
                        return SuccessResult$.MODULE$;
                    }, SchemaWriteExecutionPlan$.MODULE$.apply$default$3());
                } else if (A1 instanceof ShowConstraints) {
                    ShowConstraints showConstraints = (ShowConstraints)A1;
                    ShowConstraintType constraintType = showConstraints.constraintType();
                    boolean verbose = showConstraints.verbose();
                    List defaultColumnNames = showConstraints.defaultColumnNames();
                    intersect = (Function2 & Serializable & scala.Serializable)(x$18, x$19) -> new SchemaReadExecutionPlan("ShowConstraints", AssertConstraint$.MODULE$, (Function1<QueryContext, SchemaReadExecutionResult>)(Function1 & Serializable & scala.Serializable)ctx -> {
                        Function1 & Serializable & scala.Serializable intersect;
                        scala.collection.immutable.Map constraints = ctx.getAllConstraints();
                        ShowConstraintType showConstraintType = constraintType;
                        if (UniqueConstraints$.MODULE$.equals(showConstraintType)) {
                            intersect = (Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)anonfun.1.$anonfun$applyOrElse$37(c));
                        } else if (NodeKeyConstraints$.MODULE$.equals(showConstraintType)) {
                            intersect = (Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)anonfun.1.$anonfun$applyOrElse$38(c));
                        } else if (ExistsConstraints$.MODULE$.equals(showConstraintType)) {
                            intersect = (Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)anonfun.1.$anonfun$applyOrElse$39(c));
                        } else if (NodeExistsConstraints$.MODULE$.equals(showConstraintType)) {
                            intersect = (Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)anonfun.1.$anonfun$applyOrElse$40(c));
                        } else if (RelExistsConstraints$.MODULE$.equals(showConstraintType)) {
                            intersect = (Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)anonfun.1.$anonfun$applyOrElse$41(c));
                        } else if (AllConstraints$.MODULE$.equals(showConstraintType)) {
                            intersect = (Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)anonfun.1.$anonfun$applyOrElse$42(x$20));
                        } else {
                            throw new IllegalStateException(new StringBuilder(25).append("Unknown constraint type: ").append(showConstraintType).toString());
                        }
                        Function1 & Serializable & scala.Serializable predicate = intersect;
                        scala.collection.immutable.Map relevantConstraints = (scala.collection.immutable.Map)constraints.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)anonfun.1.$anonfun$applyOrElse$43(predicate, x0$1)));
                        ListMap sortedRelevantConstraints = (ListMap)ListMap$.MODULE$.apply((Seq)relevantConstraints.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$21 -> ((SchemaRule)x$21._1()).getName(), (Ordering)Ordering.String$.MODULE$));
                        List result = ((TraversableOnce)sortedRelevantConstraints.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                            scala.collection.immutable.Map map;
                            Tuple2 tuple2 = x0$2;
                            if (tuple2 == null) throw new MatchError((Object)tuple2);
                            ConstraintDescriptor constraintDescriptor = (ConstraintDescriptor)tuple2._1();
                            ConstraintInfo constraintInfo = (ConstraintInfo)tuple2._2();
                            if (constraintDescriptor == null) throw new MatchError((Object)tuple2);
                            ConstraintDescriptor constraintDescriptor2 = constraintDescriptor;
                            if (constraintInfo == null) throw new MatchError((Object)tuple2);
                            ConstraintInfo constraintInfo2 = constraintInfo;
                            String name = constraintDescriptor2.getName();
                            List labels = constraintInfo2.labelsOrTypes();
                            List properties = constraintInfo2.properties();
                            boolean isIndexBacked = constraintDescriptor2.isIndexBackedConstraint();
                            EntityType entityType = constraintDescriptor2.schema().entityType();
                            ShowConstraintType constraintType = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$getConstraintType(constraintDescriptor2.type(), entityType);
                            scala.collection.immutable.Map briefResult = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Values.longValue((long)constraintDescriptor2.getId())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)Values.stringValue((String)name)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)Values.stringValue((String)constraintType.output())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entityType"), (Object)Values.stringValue((String)entityType.name())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"labelsOrTypes"), (Object)VirtualValues.fromList((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)labels.map((Function1 & Serializable & scala.Serializable)elem -> Values.of((Object)elem), List$.MODULE$.canBuildFrom())).asJava()))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"properties"), (Object)VirtualValues.fromList((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)properties.map((Function1 & Serializable & scala.Serializable)prop -> Values.of((Object)prop), List$.MODULE$.canBuildFrom())).asJava()))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ownedIndexId"), isIndexBacked ? Values.longValue((long)constraintDescriptor2.asIndexBackedConstraint().ownedIndexId()) : Values.NO_VALUE)}));
                            if (verbose) {
                                Tuple2 tuple22;
                                if (isIndexBacked) {
                                    IndexDescriptor index = (IndexDescriptor)constraintInfo2.maybeIndex().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                                        throw new IllegalStateException(new StringBuilder(54).append("Expected to find an index for index backed constraint ").append(name).toString());
                                    });
                                    String providerName = index.getIndexProvider().name();
                                    IndexConfig indexConfig = index.getIndexConfig();
                                    MapValue options = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$extractOptionsMap(providerName, indexConfig);
                                    String createWithOptions = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$createConstraintStatement(name, constraintType, (List<String>)labels, (List<String>)properties, (Option<String>)new Some((Object)providerName), (Option<IndexConfig>)new Some((Object)indexConfig));
                                    tuple22 = new Tuple2((Object)options, (Object)createWithOptions);
                                } else {
                                    String createWithoutOptions = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$createConstraintStatement(name, constraintType, (List<String>)labels, (List<String>)properties, SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$createConstraintStatement$default$5(), SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$createConstraintStatement$default$6());
                                    tuple22 = new Tuple2((Object)Values.NO_VALUE, (Object)createWithoutOptions);
                                }
                                Tuple2 tuple23 = tuple22;
                                if (tuple23 == null) throw new MatchError((Object)tuple23);
                                AnyValue options = (AnyValue)tuple23._1();
                                String createString = (String)tuple23._2();
                                Tuple2 tuple24 = new Tuple2((Object)options, (Object)createString);
                                Tuple2 tuple25 = tuple24;
                                AnyValue options2 = (AnyValue)tuple25._1();
                                String createString2 = (String)tuple25._2();
                                map = briefResult.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"options"), (Object)options2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"createStatement"), (Object)Values.stringValue((String)createString2))})));
                                return map;
                            } else {
                                map = briefResult;
                            }
                            return map;
                        }, Iterable$.MODULE$.canBuildFrom())).toList();
                        return new SchemaReadExecutionResult((String[])defaultColumnNames.toArray(ClassTag$.MODULE$.apply(String.class)), (List<scala.collection.immutable.Map<String, AnyValue>>)result);
                    });
                } else if (A1 instanceof CreateIndex) {
                    CreateIndex createIndex = (CreateIndex)A1;
                    Option source = createIndex.source();
                    LabelName label = createIndex.label();
                    List props = createIndex.propertyKeyNames();
                    Option name = createIndex.name();
                    scala.collection.immutable.Map options = createIndex.options();
                    intersect = (Function2 & Serializable & scala.Serializable)(context, parameterMapping) -> new SchemaWriteExecutionPlan("CreateIndex", (Function1<QueryContext, SchemaWriteExecutionResult>)(Function1 & Serializable & scala.Serializable)ctx -> {
                        Tuple2<Option<String>, IndexConfig> tuple2 = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$getValidProviderAndConfig((scala.collection.immutable.Map<String, Expression>)options, "index");
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        Option indexProvider = (Option)tuple2._1();
                        IndexConfig indexConfig = (IndexConfig)tuple2._2();
                        Tuple2 tuple22 = new Tuple2((Object)indexProvider, (Object)indexConfig);
                        Tuple2 tuple23 = tuple22;
                        Option indexProvider2 = (Option)tuple23._1();
                        IndexConfig indexConfig2 = (IndexConfig)tuple23._2();
                        int labelId = ctx.getOrCreateLabelId(label.name());
                        List propertyKeyIds = (List)props.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$51(ctx, p)), List$.MODULE$.canBuildFrom());
                        ctx.addIndexRule(labelId, (Seq)propertyKeyIds, name, indexProvider2, indexConfig2);
                        return SuccessResult$.MODULE$;
                    }, (Option<ExecutionPlan>)source.map((Function1 & Serializable & scala.Serializable)x$24 -> (ExecutionPlan)((Function2)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$24, (Function1 & Serializable & scala.Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context, parameterMapping)));
                } else if (A1 instanceof DropIndex) {
                    DropIndex dropIndex = (DropIndex)A1;
                    LabelName label = dropIndex.label();
                    List props = dropIndex.propertyKeyNames();
                    intersect = (Function2 & Serializable & scala.Serializable)(x$25, x$26) -> new SchemaWriteExecutionPlan("DropIndex", (Function1<QueryContext, SchemaWriteExecutionResult>)(Function1 & Serializable & scala.Serializable)ctx -> {
                        LabelId labelId = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$labelToId((QueryContext)ctx, label);
                        List propertyKeyIds = (List)props.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$56(ctx, p)), List$.MODULE$.canBuildFrom());
                        ctx.dropIndexRule(NameId$.MODULE$.toKernelEncode((NameId)labelId), (Seq)propertyKeyIds);
                        return SuccessResult$.MODULE$;
                    }, SchemaWriteExecutionPlan$.MODULE$.apply$default$3());
                } else if (A1 instanceof DropIndexOnName) {
                    DropIndexOnName dropIndexOnName = (DropIndexOnName)A1;
                    String name = dropIndexOnName.name();
                    boolean ifExists = dropIndexOnName.ifExists();
                    intersect = (Function2 & Serializable & scala.Serializable)(x$27, x$28) -> new SchemaWriteExecutionPlan("DropIndex", (Function1<QueryContext, SchemaWriteExecutionResult>)(Function1 & Serializable & scala.Serializable)ctx -> {
                        block0: {
                            if (ifExists && !ctx.indexExists(name)) break block0;
                            ctx.dropIndexRule(name);
                        }
                        return SuccessResult$.MODULE$;
                    }, SchemaWriteExecutionPlan$.MODULE$.apply$default$3());
                } else if (A1 instanceof ShowIndexes) {
                    ShowIndexes showIndexes = (ShowIndexes)A1;
                    boolean all = showIndexes.all();
                    boolean verbose = showIndexes.verbose();
                    List defaultColumnNames = showIndexes.defaultColumnNames();
                    intersect = (Function2 & Serializable & scala.Serializable)(x$29, x$30) -> new SchemaReadExecutionPlan("ShowIndexes", AssertIndex$.MODULE$, (Function1<QueryContext, SchemaReadExecutionResult>)(Function1 & Serializable & scala.Serializable)ctx -> {
                        scala.collection.immutable.Map indexes = ctx.getAllIndexes();
                        scala.collection.immutable.Map relevantIndexes = all ? indexes : (scala.collection.immutable.Map)indexes.filter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)anonfun.1.$anonfun$applyOrElse$61(x0$3)));
                        ListMap sortedRelevantIndexes = (ListMap)ListMap$.MODULE$.apply((Seq)relevantIndexes.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$31 -> ((IndexDescriptor)x$31._1()).getName(), (Ordering)Ordering.String$.MODULE$));
                        List result = ((TraversableOnce)sortedRelevantIndexes.map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                            scala.collection.immutable.Map map;
                            Tuple2 tuple2 = x0$4;
                            if (tuple2 == null) throw new MatchError((Object)tuple2);
                            IndexDescriptor indexDescriptor = (IndexDescriptor)tuple2._1();
                            IndexInfo indexInfo = (IndexInfo)tuple2._2();
                            if (indexDescriptor == null) throw new MatchError((Object)tuple2);
                            IndexDescriptor indexDescriptor2 = indexDescriptor;
                            if (indexInfo == null) throw new MatchError((Object)tuple2);
                            IndexInfo indexInfo2 = indexInfo;
                            IndexStatus indexStatus = indexInfo2.indexStatus();
                            String uniqueness = indexDescriptor2.isUnique() ? SchemaCommandRuntime$Unique$.MODULE$.toString() : SchemaCommandRuntime$Nonunique$.MODULE$.toString();
                            IndexType indexType = indexDescriptor2.getIndexType();
                            String name = indexDescriptor2.getName();
                            EntityType entityType = indexDescriptor2.schema().entityType();
                            List labels = indexInfo2.labelsOrTypes();
                            List properties = indexInfo2.properties();
                            String providerName = indexDescriptor2.getIndexProvider().name();
                            scala.collection.immutable.Map briefResult = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Values.longValue((long)indexDescriptor2.getId())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)Values.stringValue((String)name)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"state"), (Object)Values.stringValue((String)indexStatus.state())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"populationPercent"), (Object)Values.doubleValue((double)indexStatus.populationProgress())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"uniqueness"), (Object)Values.stringValue((String)uniqueness)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)Values.stringValue((String)indexType.name())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entityType"), (Object)Values.stringValue((String)entityType.name())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"labelsOrTypes"), (Object)VirtualValues.fromList((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)labels.map((Function1 & Serializable & scala.Serializable)elem -> Values.of((Object)elem), List$.MODULE$.canBuildFrom())).asJava()))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"properties"), (Object)VirtualValues.fromList((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)properties.map((Function1 & Serializable & scala.Serializable)prop -> Values.of((Object)prop), List$.MODULE$.canBuildFrom())).asJava()))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"indexProvider"), (Object)Values.stringValue((String)providerName))}));
                            if (verbose) {
                                IndexConfig indexConfig = indexDescriptor2.getIndexConfig();
                                map = briefResult.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"options"), (Object)SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$extractOptionsMap(providerName, indexConfig)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"failureMessage"), (Object)Values.stringValue((String)indexInfo2.indexStatus().failureMessage())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"createStatement"), (Object)Values.stringValue((String)SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$createIndexStatement(name, indexType, entityType, (List<String>)labels, (List<String>)properties, providerName, indexConfig, (Option<ConstraintDescriptor>)indexStatus.maybeConstraint())))})));
                                return map;
                            } else {
                                map = briefResult;
                            }
                            return map;
                        }, Iterable$.MODULE$.canBuildFrom())).toList();
                        return new SchemaReadExecutionResult((String[])defaultColumnNames.toArray(ClassTag$.MODULE$.apply(String.class)), (List<scala.collection.immutable.Map<String, AnyValue>>)result);
                    });
                } else if (A1 instanceof DoNothingIfExistsForIndex) {
                    DoNothingIfExistsForIndex doNothingIfExistsForIndex = (DoNothingIfExistsForIndex)A1;
                    LabelName label = doNothingIfExistsForIndex.label();
                    List propertyKeyNames = doNothingIfExistsForIndex.propertyKeyNames();
                    Option name = doNothingIfExistsForIndex.name();
                    intersect = (Function2 & Serializable & scala.Serializable)(x$32, x$33) -> new SchemaWriteExecutionPlan("DoNothingIfNotExist", (Function1<QueryContext, SchemaWriteExecutionResult>)(Function1 & Serializable & scala.Serializable)ctx -> {
                        List propertyKeyIds;
                        int labelId = ctx.getOrCreateLabelId(label.name());
                        return Try$.MODULE$.apply(() -> anonfun.1.$anonfun$applyOrElse$69(ctx, labelId, propertyKeyIds = (List)propertyKeyNames.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$68(ctx, p)), List$.MODULE$.canBuildFrom()))).isSuccess() ? IgnoredResult$.MODULE$ : (name.exists((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)anonfun.1.$anonfun$applyOrElse$70(ctx, name))) ? IgnoredResult$.MODULE$ : SuccessResult$.MODULE$);
                    }, (Option<ExecutionPlan>)None$.MODULE$);
                } else if (A1 instanceof DoNothingIfExistsForConstraint) {
                    DoNothingIfExistsForConstraint doNothingIfExistsForConstraint = (DoNothingIfExistsForConstraint)A1;
                    Either entityType = doNothingIfExistsForConstraint.entityType();
                    Seq props = doNothingIfExistsForConstraint.props();
                    ConstraintType assertion = doNothingIfExistsForConstraint.assertion();
                    Option name = doNothingIfExistsForConstraint.name();
                    intersect = (Function2 & Serializable & scala.Serializable)(x$34, x$35) -> new SchemaWriteExecutionPlan("DoNothingIfNotExist", (Function1<QueryContext, SchemaWriteExecutionResult>)(Function1 & Serializable & scala.Serializable)ctx -> {
                        int n;
                        Either either = entityType;
                        if (either instanceof Left) {
                            Left left = (Left)either;
                            LabelName label = (LabelName)left.value();
                            n = ctx.getOrCreateLabelId(label.name());
                        } else if (either instanceof Right) {
                            Right right = (Right)either;
                            RelTypeName relType = (RelTypeName)right.value();
                            n = ctx.getOrCreateRelTypeId(relType.name());
                        } else {
                            throw new MatchError((Object)either);
                        }
                        int entityId = n;
                        Seq propertyKeyIds = (Seq)props.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$73(ctx, p)), Seq$.MODULE$.canBuildFrom());
                        return ctx.constraintExists(SchemaCommandRuntime$.MODULE$.convertConstraintTypeToConstraintMatcher(assertion), entityId, propertyKeyIds) ? IgnoredResult$.MODULE$ : (name.exists((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)anonfun.1.$anonfun$applyOrElse$74(ctx, name))) ? IgnoredResult$.MODULE$ : SuccessResult$.MODULE$);
                    }, (Option<ExecutionPlan>)None$.MODULE$);
                } else {
                    intersect = function1.apply(x1);
                }
                return (B1)intersect;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                boolean bl = logicalPlan instanceof CreateNodeKeyConstraint ? true : (logicalPlan instanceof DropNodeKeyConstraint ? true : (logicalPlan instanceof CreateUniquePropertyConstraint ? true : (logicalPlan instanceof DropUniquePropertyConstraint ? true : (logicalPlan instanceof CreateNodePropertyExistenceConstraint ? true : (logicalPlan instanceof DropNodePropertyExistenceConstraint ? true : (logicalPlan instanceof CreateRelationshipPropertyExistenceConstraint ? true : (logicalPlan instanceof DropRelationshipPropertyExistenceConstraint ? true : (logicalPlan instanceof DropConstraintOnName ? true : (logicalPlan instanceof ShowConstraints ? true : (logicalPlan instanceof CreateIndex ? true : (logicalPlan instanceof DropIndex ? true : (logicalPlan instanceof DropIndexOnName ? true : (logicalPlan instanceof ShowIndexes ? true : (logicalPlan instanceof DoNothingIfExistsForIndex ? true : logicalPlan instanceof DoNothingIfExistsForConstraint))))))))))))));
                return bl;
            }

            public static final /* synthetic */ int $anonfun$applyOrElse$3(QueryContext ctx$1, Property p) {
                return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$1, p.propertyKey()).id();
            }

            public static final /* synthetic */ int $anonfun$applyOrElse$8(QueryContext ctx$2, Property p) {
                return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$2, p.propertyKey()).id();
            }

            public static final /* synthetic */ int $anonfun$applyOrElse$11(QueryContext ctx$3, Property p) {
                return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$3, p.propertyKey()).id();
            }

            public static final /* synthetic */ int $anonfun$applyOrElse$16(QueryContext ctx$4, Property p) {
                return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$4, p.propertyKey()).id();
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$19(QueryContext ctx$5, int labelId, int propertyKeyId, Option name) {
                ctx$5.createNodePropertyExistenceConstraint(labelId, propertyKeyId, name);
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$27(QueryContext ctx$7, int relTypeId, int propertyKeyId, Option name) {
                ctx$7.createRelationshipPropertyExistenceConstraint(relTypeId, propertyKeyId, name);
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$37(ConstraintDescriptor c) {
                return c.type().equals((Object)org.neo4j.internal.schema.ConstraintType.UNIQUE);
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$38(ConstraintDescriptor c) {
                return c.type().equals((Object)org.neo4j.internal.schema.ConstraintType.UNIQUE_EXISTS);
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$39(ConstraintDescriptor c) {
                return c.type().equals((Object)org.neo4j.internal.schema.ConstraintType.EXISTS);
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$40(ConstraintDescriptor c) {
                return c.type().equals((Object)org.neo4j.internal.schema.ConstraintType.EXISTS) && c.schema().entityType().equals((Object)EntityType.NODE);
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$41(ConstraintDescriptor c) {
                return c.type().equals((Object)org.neo4j.internal.schema.ConstraintType.EXISTS) && c.schema().entityType().equals((Object)EntityType.RELATIONSHIP);
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$42(ConstraintDescriptor x$20) {
                return true;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$43(Function1 predicate$1, Tuple2 x0$1) {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                ConstraintDescriptor constraintDescriptor = (ConstraintDescriptor)tuple2._1();
                boolean bl = BoxesRunTime.unboxToBoolean((Object)predicate$1.apply((Object)constraintDescriptor));
                return bl;
            }

            public static final /* synthetic */ int $anonfun$applyOrElse$51(QueryContext ctx$9, PropertyKeyName p) {
                return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$9, p).id();
            }

            public static final /* synthetic */ int $anonfun$applyOrElse$56(QueryContext ctx$10, PropertyKeyName p) {
                return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$10, p).id();
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$61(Tuple2 x0$3) {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                IndexDescriptor indexDescriptor = (IndexDescriptor)tuple2._1();
                boolean bl = indexDescriptor.getIndexType().equals((Object)IndexType.BTREE);
                return bl;
            }

            public static final /* synthetic */ int $anonfun$applyOrElse$68(QueryContext ctx$11, PropertyKeyName p) {
                return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$11, p).id();
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$69(QueryContext ctx$11, int labelId$1, List propertyKeyIds$1) {
                return ctx$11.indexReference(labelId$1, (Seq)propertyKeyIds$1).getName();
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$70(QueryContext ctx$11, String name) {
                return ctx$11.indexExists(name);
            }

            public static final /* synthetic */ int $anonfun$applyOrElse$73(QueryContext ctx$12, Property p) {
                return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$12, p.propertyKey()).id();
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$74(QueryContext ctx$12, String name) {
                return ctx$12.constraintExists(name);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(scala.collection.immutable.Map org.neo4j.cypher.internal.expressions.LabelName scala.collection.Seq scala.Option scala.Option org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.runtime.ParameterMapping ), $anonfun$applyOrElse$6(org.neo4j.cypher.internal.expressions.LabelName scala.collection.Seq org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.runtime.ParameterMapping ), $anonfun$applyOrElse$9(scala.collection.immutable.Map org.neo4j.cypher.internal.expressions.LabelName scala.collection.Seq scala.Option scala.Option org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.runtime.ParameterMapping ), $anonfun$applyOrElse$14(org.neo4j.cypher.internal.expressions.LabelName scala.collection.Seq org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.runtime.ParameterMapping ), $anonfun$applyOrElse$17(org.neo4j.cypher.internal.expressions.LabelName org.neo4j.cypher.internal.expressions.Property scala.Option scala.Option org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.runtime.ParameterMapping ), $anonfun$applyOrElse$22(org.neo4j.cypher.internal.expressions.LabelName org.neo4j.cypher.internal.expressions.Property org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.runtime.ParameterMapping ), $anonfun$applyOrElse$25(org.neo4j.cypher.internal.expressions.RelTypeName org.neo4j.cypher.internal.expressions.Property scala.Option scala.Option org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.runtime.ParameterMapping ), $anonfun$applyOrElse$30(org.neo4j.cypher.internal.expressions.RelTypeName org.neo4j.cypher.internal.expressions.Property org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.runtime.ParameterMapping ), $anonfun$applyOrElse$33(boolean java.lang.String org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.runtime.ParameterMapping ), $anonfun$applyOrElse$35(org.neo4j.cypher.internal.ast.ShowConstraintType boolean scala.collection.immutable.List org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.runtime.ParameterMapping ), $anonfun$applyOrElse$49(scala.collection.immutable.Map org.neo4j.cypher.internal.expressions.LabelName scala.collection.immutable.List scala.Option scala.Option org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.runtime.ParameterMapping ), $anonfun$applyOrElse$54(org.neo4j.cypher.internal.expressions.LabelName scala.collection.immutable.List org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.runtime.ParameterMapping ), $anonfun$applyOrElse$57(boolean java.lang.String org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.runtime.ParameterMapping ), $anonfun$applyOrElse$59(boolean boolean scala.collection.immutable.List org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.runtime.ParameterMapping ), $anonfun$applyOrElse$66(org.neo4j.cypher.internal.expressions.LabelName scala.collection.immutable.List scala.Option org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.runtime.ParameterMapping ), $anonfun$applyOrElse$71(scala.util.Either scala.collection.Seq org.neo4j.cypher.internal.logical.plans.ConstraintType scala.Option org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.runtime.ParameterMapping ), $anonfun$applyOrElse$3$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.Property ), $anonfun$applyOrElse$5(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$2(scala.collection.immutable.Map org.neo4j.cypher.internal.expressions.LabelName scala.collection.Seq scala.Option org.neo4j.cypher.internal.runtime.QueryContext ), $anonfun$applyOrElse$4(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.runtime.ParameterMapping org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForConstraint ), $anonfun$applyOrElse$8$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.Property ), $anonfun$applyOrElse$7(org.neo4j.cypher.internal.expressions.LabelName scala.collection.Seq org.neo4j.cypher.internal.runtime.QueryContext ), $anonfun$applyOrElse$11$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.Property ), $anonfun$applyOrElse$13(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$10(scala.collection.immutable.Map org.neo4j.cypher.internal.expressions.LabelName scala.collection.Seq scala.Option org.neo4j.cypher.internal.runtime.QueryContext ), $anonfun$applyOrElse$12(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.runtime.ParameterMapping org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForConstraint ), $anonfun$applyOrElse$16$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.Property ), $anonfun$applyOrElse$15(org.neo4j.cypher.internal.expressions.LabelName scala.collection.Seq org.neo4j.cypher.internal.runtime.QueryContext ), $anonfun$applyOrElse$19$adapted(org.neo4j.cypher.internal.runtime.QueryContext java.lang.Object java.lang.Object scala.Option ), $anonfun$applyOrElse$21(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$18(org.neo4j.cypher.internal.expressions.LabelName org.neo4j.cypher.internal.expressions.Property scala.Option org.neo4j.cypher.internal.runtime.QueryContext ), $anonfun$applyOrElse$20(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.runtime.ParameterMapping org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForConstraint ), $anonfun$applyOrElse$24(org.neo4j.cypher.internal.runtime.QueryContext int int ), $anonfun$applyOrElse$23(org.neo4j.cypher.internal.expressions.LabelName org.neo4j.cypher.internal.expressions.Property org.neo4j.cypher.internal.runtime.QueryContext ), $anonfun$applyOrElse$27$adapted(org.neo4j.cypher.internal.runtime.QueryContext java.lang.Object java.lang.Object scala.Option ), $anonfun$applyOrElse$29(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$26(org.neo4j.cypher.internal.expressions.RelTypeName org.neo4j.cypher.internal.expressions.Property scala.Option org.neo4j.cypher.internal.runtime.QueryContext ), $anonfun$applyOrElse$28(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.runtime.ParameterMapping org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForConstraint ), $anonfun$applyOrElse$32(org.neo4j.cypher.internal.runtime.QueryContext int int ), $anonfun$applyOrElse$31(org.neo4j.cypher.internal.expressions.RelTypeName org.neo4j.cypher.internal.expressions.Property org.neo4j.cypher.internal.runtime.QueryContext ), $anonfun$applyOrElse$34(boolean java.lang.String org.neo4j.cypher.internal.runtime.QueryContext ), $anonfun$applyOrElse$46(java.lang.String ), $anonfun$applyOrElse$47(java.lang.String ), $anonfun$applyOrElse$48(java.lang.String ), $anonfun$applyOrElse$37$adapted(org.neo4j.internal.schema.ConstraintDescriptor ), $anonfun$applyOrElse$38$adapted(org.neo4j.internal.schema.ConstraintDescriptor ), $anonfun$applyOrElse$39$adapted(org.neo4j.internal.schema.ConstraintDescriptor ), $anonfun$applyOrElse$40$adapted(org.neo4j.internal.schema.ConstraintDescriptor ), $anonfun$applyOrElse$41$adapted(org.neo4j.internal.schema.ConstraintDescriptor ), $anonfun$applyOrElse$42$adapted(org.neo4j.internal.schema.ConstraintDescriptor ), $anonfun$applyOrElse$43$adapted(scala.Function1 scala.Tuple2 ), $anonfun$applyOrElse$44(scala.Tuple2 ), $anonfun$applyOrElse$45(boolean scala.Tuple2 ), $anonfun$applyOrElse$36(org.neo4j.cypher.internal.ast.ShowConstraintType boolean scala.collection.immutable.List org.neo4j.cypher.internal.runtime.QueryContext ), $anonfun$applyOrElse$51$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.PropertyKeyName ), $anonfun$applyOrElse$53(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$50(scala.collection.immutable.Map org.neo4j.cypher.internal.expressions.LabelName scala.collection.immutable.List scala.Option org.neo4j.cypher.internal.runtime.QueryContext ), $anonfun$applyOrElse$52(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.runtime.ParameterMapping org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForIndex ), $anonfun$applyOrElse$56$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.PropertyKeyName ), $anonfun$applyOrElse$55(org.neo4j.cypher.internal.expressions.LabelName scala.collection.immutable.List org.neo4j.cypher.internal.runtime.QueryContext ), $anonfun$applyOrElse$58(boolean java.lang.String org.neo4j.cypher.internal.runtime.QueryContext ), $anonfun$applyOrElse$64(java.lang.String ), $anonfun$applyOrElse$65(java.lang.String ), $anonfun$applyOrElse$61$adapted(scala.Tuple2 ), $anonfun$applyOrElse$62(scala.Tuple2 ), $anonfun$applyOrElse$63(boolean scala.Tuple2 ), $anonfun$applyOrElse$60(boolean boolean scala.collection.immutable.List org.neo4j.cypher.internal.runtime.QueryContext ), $anonfun$applyOrElse$68$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.PropertyKeyName ), $anonfun$applyOrElse$69(org.neo4j.cypher.internal.runtime.QueryContext int scala.collection.immutable.List ), $anonfun$applyOrElse$70$adapted(org.neo4j.cypher.internal.runtime.QueryContext java.lang.String ), $anonfun$applyOrElse$67(org.neo4j.cypher.internal.expressions.LabelName scala.collection.immutable.List scala.Option org.neo4j.cypher.internal.runtime.QueryContext ), $anonfun$applyOrElse$73$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.Property ), $anonfun$applyOrElse$74$adapted(org.neo4j.cypher.internal.runtime.QueryContext java.lang.String ), $anonfun$applyOrElse$72(scala.util.Either scala.collection.Seq org.neo4j.cypher.internal.logical.plans.ConstraintType scala.Option org.neo4j.cypher.internal.runtime.QueryContext )}, serializedLambda);
            }
        };
    }
}

