/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.rendering;

import java.io.Serializable;
import org.neo4j.cypher.CypherExecutionMode;
import org.neo4j.cypher.CypherExecutionMode$explain$;
import org.neo4j.cypher.CypherExecutionMode$profile$;
import org.neo4j.cypher.internal.QueryOptions;
import org.neo4j.cypher.internal.ast.Clause;
import org.neo4j.cypher.internal.ast.Query;
import org.neo4j.cypher.internal.ast.QueryPart;
import org.neo4j.cypher.internal.ast.SingleQuery;
import org.neo4j.cypher.internal.ast.Statement;
import org.neo4j.cypher.internal.ast.prettifier.ExpressionStringifier;
import org.neo4j.cypher.internal.ast.prettifier.Prettifier;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.util.InputPosition;
import org.neo4j.cypher.internal.util.InputPosition$;
import org.neo4j.cypher.rendering.QueryRenderer$clauseExtension$;
import org.neo4j.cypher.rendering.QueryRenderer$exprExtension$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.collection.Seq;

public final class QueryRenderer$ {
    public static QueryRenderer$ MODULE$;
    private final Prettifier renderStrict;
    private final Prettifier renderPretty;
    private final InputPosition pos;
    private final String NL;

    static {
        new QueryRenderer$();
    }

    private Prettifier renderStrict() {
        return this.renderStrict;
    }

    private Prettifier renderPretty() {
        return this.renderPretty;
    }

    private InputPosition pos() {
        return this.pos;
    }

    private String NL() {
        return this.NL;
    }

    public String render(Seq<Clause> clauses) {
        return this.render((Statement)new Query((Option)None$.MODULE$, (QueryPart)new SingleQuery(clauses, this.pos()), this.pos()));
    }

    public String render(Statement statement) {
        return this.renderStrict().asString(statement);
    }

    public String addOptions(String statement, QueryOptions options) {
        return new StringBuilder(0).append(this.renderOptions(options)).append(statement).toString();
    }

    public String renderOptions(QueryOptions options) {
        return new StringBuilder(0).append(this.renderExecutionMode(options.executionMode())).append(options.render().map((Function1 & Serializable & scala.Serializable)x$1 -> new StringBuilder(0).append((String)x$1).append(MODULE$.NL()).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString();
    }

    private String renderExecutionMode(CypherExecutionMode executionMode) {
        CypherExecutionMode cypherExecutionMode = executionMode;
        String string = CypherExecutionMode$explain$.MODULE$.equals(cypherExecutionMode) ? new StringBuilder(8).append("EXPLAIN ").append(this.NL()).toString() : (CypherExecutionMode$profile$.MODULE$.equals(cypherExecutionMode) ? new StringBuilder(8).append("PROFILE ").append(this.NL()).toString() : "");
        return string;
    }

    public String pretty(Expression expression) {
        return this.renderPretty().expr().apply(expression);
    }

    public String pretty(Statement statement) {
        return this.renderPretty().asString(statement);
    }

    private QueryRenderer$() {
        MODULE$ = this;
        this.renderStrict = new Prettifier(new ExpressionStringifier((ExpressionStringifier.Extension)QueryRenderer$exprExtension$.MODULE$, true, true, false, true), (Prettifier.ClausePrettifier)QueryRenderer$clauseExtension$.MODULE$, false);
        boolean x$1 = false;
        boolean x$2 = false;
        boolean x$3 = false;
        ExpressionStringifier.Extension x$4 = this.renderStrict().expr().copy$default$1();
        boolean x$5 = this.renderStrict().expr().copy$default$4();
        ExpressionStringifier x$6 = this.renderStrict().expr().copy(x$4, x$1, x$2, x$5, x$3);
        boolean x$7 = true;
        Prettifier.ClausePrettifier x$8 = this.renderStrict().copy$default$2();
        this.renderPretty = this.renderStrict().copy(x$6, x$8, x$7);
        this.pos = InputPosition$.MODULE$.NONE();
        this.NL = System.lineSeparator();
    }
}

