/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.spi;

import java.io.Serializable;
import java.util.Iterator;
import org.neo4j.cypher.internal.planner.spi.GraphStatistics;
import org.neo4j.cypher.internal.planner.spi.IndexDescriptor;
import org.neo4j.cypher.internal.planner.spi.MinimumGraphStatistics;
import org.neo4j.cypher.internal.runtime.interpreted.TransactionBoundTokenContext;
import org.neo4j.cypher.internal.spi.IndexDescriptorCompatibility;
import org.neo4j.cypher.internal.spi.TransactionBoundGraphStatistics$;
import org.neo4j.cypher.internal.util.Cardinality;
import org.neo4j.cypher.internal.util.LabelId;
import org.neo4j.cypher.internal.util.NameId;
import org.neo4j.cypher.internal.util.NameId$;
import org.neo4j.cypher.internal.util.RelTypeId;
import org.neo4j.cypher.internal.util.Selectivity;
import org.neo4j.cypher.internal.util.Selectivity$;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.IndexBehaviour;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.logging.Log;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005}q!B\b\u0011\u0011\u0003Yb!B\u000f\u0011\u0011\u0003q\u0002\"B\u0013\u0002\t\u00031\u0003\"B\u0014\u0002\t\u0003A\u0003\"B\u0014\u0002\t\u0003!e\u0001B+\u0002\tYC\u0001BR\u0003\u0003\u0002\u0003\u0006Ia\u0012\u0005\t!\u0016\u0011\t\u0011)A\u0005#\"AQ(\u0002B\u0001B\u0003%a\bC\u0003&\u000b\u0011\u0005Q\fC\u0003d\u000b\u0011\u0005C\rC\u0003t\u000b\u0011\u0005C\u000fC\u0003w\u000b\u0011\u0005s\u000fC\u0003|\u000b\u0011\u0005C\u0010C\u0004\u0002\b\u0015!\t%!\u0003\u0002?Q\u0013\u0018M\\:bGRLwN\u001c\"pk:$wI]1qQN#\u0018\r^5ti&\u001c7O\u0003\u0002\u0012%\u0005\u00191\u000f]5\u000b\u0005M!\u0012\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005U1\u0012AB2za\",'O\u0003\u0002\u00181\u0005)a.Z85U*\t\u0011$A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002\u001d\u00035\t\u0001CA\u0010Ue\u0006t7/Y2uS>t'i\\;oI\u001e\u0013\u0018\r\u001d5Ti\u0006$\u0018n\u001d;jGN\u001c\"!A\u0010\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t1$A\u0003baBd\u0017\u0010F\u0002*aq\u0002\"A\u000b\u0018\u000e\u0003-R!!\u0005\u0017\u000b\u00055\u0012\u0012a\u00029mC:tWM]\u0005\u0003_-\u0012a#T5oS6,Xn\u0012:ba\"\u001cF/\u0019;jgRL7m\u001d\u0005\u0006c\r\u0001\rAM\u0001\u0015iJ\fgn]1di&|g.\u00197D_:$X\r\u001f;\u0011\u0005MRT\"\u0001\u001b\u000b\u0005U2\u0014!B9vKJL(BA\u001c9\u0003\u0011IW\u000e\u001d7\u000b\u0005e2\u0012AB6fe:,G.\u0003\u0002<i\t!BK]1og\u0006\u001cG/[8oC2\u001cuN\u001c;fqRDQ!P\u0002A\u0002y\n1\u0001\\8h!\ty$)D\u0001A\u0015\t\te#A\u0004m_\u001e<\u0017N\\4\n\u0005\r\u0003%a\u0001'pOR!\u0011&R(U\u0011\u00151E\u00011\u0001H\u0003\u0011\u0011X-\u00193\u0011\u0005!kU\"A%\u000b\u0005)[\u0015aA1qS*\u0011\u0011\b\u0014\u0006\u0003'YI!AT%\u0003\tI+\u0017\r\u001a\u0005\u0006!\u0012\u0001\r!U\u0001\u000bg\u000eDW-\\1SK\u0006$\u0007C\u0001%S\u0013\t\u0019\u0016J\u0001\u0006TG\",W.\u0019*fC\u0012DQ!\u0010\u0003A\u0002y\u00121EQ1tKR\u0013\u0018M\\:bGRLwN\u001c\"pk:$wI]1qQN#\u0018\r^5ti&\u001c7o\u0005\u0003\u0006?]S\u0006C\u0001\u0016Y\u0013\tI6FA\bHe\u0006\u0004\bn\u0015;bi&\u001cH/[2t!\ta2,\u0003\u0002]!\ta\u0012J\u001c3fq\u0012+7o\u0019:jaR|'oQ8na\u0006$\u0018NY5mSRLH\u0003\u00020aC\n\u0004\"aX\u0003\u000e\u0003\u0005AQAR\u0005A\u0002\u001dCQ\u0001U\u0005A\u0002ECQ!P\u0005A\u0002y\na#\u001e8jcV,g+\u00197vKN+G.Z2uSZLG/\u001f\u000b\u0003K:\u00042\u0001\t4i\u0013\t9\u0017E\u0001\u0004PaRLwN\u001c\t\u0003S2l\u0011A\u001b\u0006\u0003WJ\tA!\u001e;jY&\u0011QN\u001b\u0002\f'\u0016dWm\u0019;jm&$\u0018\u0010C\u0003p\u0015\u0001\u0007\u0001/A\u0003j]\u0012,\u0007\u0010\u0005\u0002+c&\u0011!o\u000b\u0002\u0010\u0013:$W\r\u001f#fg\u000e\u0014\u0018\u000e\u001d;pe\u0006q\u0012N\u001c3fqB\u0013x\u000e]3sif,\u00050[:ugN+G.Z2uSZLG/\u001f\u000b\u0003KVDQa\\\u0006A\u0002A\f1C\\8eKN\fE\u000e\\\"be\u0012Lg.\u00197jif$\u0012\u0001\u001f\t\u0003SfL!A\u001f6\u0003\u0017\r\u000b'\u000fZ5oC2LG/_\u0001\u001a]>$Wm],ji\"d\u0015MY3m\u0007\u0006\u0014H-\u001b8bY&$\u0018\u0010\u0006\u0002y{\")a0\u0004a\u0001\u007f\u0006aQ.Y=cK2\u000b'-\u001a7JIB!\u0001EZA\u0001!\rI\u00171A\u0005\u0004\u0003\u000bQ'a\u0002'bE\u0016d\u0017\nZ\u0001\u0017a\u0006$H/\u001a:o'R,\u0007oQ1sI&t\u0017\r\\5usR9\u00010a\u0003\u0002\u0010\u0005m\u0001BBA\u0007\u001d\u0001\u0007q0A\u0005ge>lG*\u00192fY\"9\u0011\u0011\u0003\bA\u0002\u0005M\u0011!\u0003:fYRK\b/Z%e!\u0011\u0001c-!\u0006\u0011\u0007%\f9\"C\u0002\u0002\u001a)\u0014\u0011BU3m)f\u0004X-\u00133\t\r\u0005ua\u00021\u0001\u0000\u0003\u001d!x\u000eT1cK2\u0004")
public final class TransactionBoundGraphStatistics {
    public static MinimumGraphStatistics apply(Read read, SchemaRead schemaRead, Log log) {
        return TransactionBoundGraphStatistics$.MODULE$.apply(read, schemaRead, log);
    }

    public static MinimumGraphStatistics apply(TransactionalContext transactionalContext, Log log) {
        return TransactionBoundGraphStatistics$.MODULE$.apply(transactionalContext, log);
    }

    private static class BaseTransactionBoundGraphStatistics
    implements GraphStatistics,
    IndexDescriptorCompatibility {
        private final Read read;
        private final SchemaRead schemaRead;
        private final Log log;

        @Override
        public org.neo4j.cypher.internal.planner.spi.IndexBehaviour kernelToCypher(IndexBehaviour behaviour) {
            return IndexDescriptorCompatibility.kernelToCypher$(this, behaviour);
        }

        @Override
        public SchemaDescriptor cypherToKernelSchema(IndexDescriptor index) {
            return IndexDescriptorCompatibility.cypherToKernelSchema$(this, index);
        }

        @Override
        public LabelSchemaDescriptor toLabelSchemaDescriptor(TransactionBoundTokenContext tc, String labelName, Seq<String> propertyKeys) {
            return IndexDescriptorCompatibility.toLabelSchemaDescriptor$(this, tc, labelName, propertyKeys);
        }

        @Override
        public RelationTypeSchemaDescriptor toRelTypeSchemaDescriptor(TransactionBoundTokenContext tc, String relTypeName, Seq<String> propertyKeys) {
            return IndexDescriptorCompatibility.toRelTypeSchemaDescriptor$(this, tc, relTypeName, propertyKeys);
        }

        public Option<Selectivity> uniqueValueSelectivity(IndexDescriptor index) {
            None$ none$;
            try {
                Option maybeIndexDescriptor = Option$.MODULE$.apply(Iterators.singleOrNull((Iterator)this.schemaRead.index(this.cypherToKernelSchema(index))));
                none$ = maybeIndexDescriptor.flatMap((Function1 & Serializable & scala.Serializable)indexDescriptor -> {
                    Some some;
                    long indexSize = $this.schemaRead.indexSize(indexDescriptor);
                    if (indexSize == 0L) {
                        some = new Some((Object)Selectivity$.MODULE$.ZERO());
                    } else {
                        double indexEntrySelectivity = $this.schemaRead.indexUniqueValuesSelectivity(indexDescriptor);
                        if (indexEntrySelectivity == 0.0) {
                            some = new Some((Object)Selectivity$.MODULE$.ZERO());
                        } else {
                            double frequencyOfEntitiesWithSameValue = 1.0 / indexEntrySelectivity;
                            double indexSelectivity = frequencyOfEntitiesWithSameValue / (double)indexSize;
                            some = Selectivity$.MODULE$.of(Math.min(indexSelectivity, 1.0));
                        }
                    }
                    return some;
                });
            }
            catch (IndexNotFoundKernelException e) {
                this.log.debug("Index not found for uniqueValueSelectivity", (Throwable)e);
                none$ = None$.MODULE$;
            }
            return none$;
        }

        public Option<Selectivity> indexPropertyExistsSelectivity(IndexDescriptor index) {
            None$ none$;
            block7: {
                try {
                    double d;
                    IndexDescriptor.EntityType entityType = index.entityType();
                    if (entityType instanceof IndexDescriptor.EntityType$.Node) {
                        IndexDescriptor.EntityType$.Node node = (IndexDescriptor.EntityType$.Node)entityType;
                        LabelId label = node.label();
                        d = this.read.countsForNodeWithoutTxState(NameId$.MODULE$.toKernelEncode((NameId)label));
                    } else if (entityType instanceof IndexDescriptor.EntityType$.Relationship) {
                        IndexDescriptor.EntityType$.Relationship relationship = (IndexDescriptor.EntityType$.Relationship)entityType;
                        RelTypeId relType = relationship.relType();
                        d = this.read.countsForRelationshipWithoutTxState(-1, NameId$.MODULE$.toKernelEncode((NameId)relType), -1);
                    } else {
                        throw new MatchError((Object)entityType);
                    }
                    double entitiesCount = d;
                    if (entitiesCount == 0.0) {
                        none$ = new Some((Object)Selectivity$.MODULE$.ZERO());
                        break block7;
                    }
                    Option maybeIndexDescriptor = Option$.MODULE$.apply(Iterators.singleOrNull((Iterator)this.schemaRead.index(this.cypherToKernelSchema(index))));
                    none$ = maybeIndexDescriptor.flatMap((Function1 & Serializable & scala.Serializable)indexDescriptor -> {
                        long indexSize = $this.schemaRead.indexSize(indexDescriptor);
                        double indexSelectivity = (double)indexSize / entitiesCount;
                        return Selectivity$.MODULE$.of(Math.min(indexSelectivity, 1.0));
                    });
                }
                catch (IndexNotFoundKernelException e) {
                    this.log.debug("Index not found for indexPropertyExistsSelectivity", (Throwable)e);
                    none$ = None$.MODULE$;
                }
            }
            return none$;
        }

        public Cardinality nodesAllCardinality() {
            return new Cardinality((double)this.read.countsForNodeWithoutTxState(-1));
        }

        public Cardinality nodesWithLabelCardinality(Option<LabelId> maybeLabelId) {
            long count = BoxesRunTime.unboxToLong((Object)maybeLabelId.map((Function1 & Serializable & scala.Serializable)labelId -> BoxesRunTime.boxToLong((long)this.read.countsForNodeWithoutTxState(labelId.id()))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
            return new Cardinality((double)count);
        }

        public Cardinality patternStepCardinality(Option<LabelId> fromLabel, Option<RelTypeId> relTypeId, Option<LabelId> toLabel) {
            return new Cardinality((double)this.read.countsForRelationshipWithoutTxState(NameId$.MODULE$.toKernelEncode(fromLabel), NameId$.MODULE$.toKernelEncode(relTypeId), NameId$.MODULE$.toKernelEncode(toLabel)));
        }

        public BaseTransactionBoundGraphStatistics(Read read, SchemaRead schemaRead, Log log) {
            this.read = read;
            this.schemaRead = schemaRead;
            this.log = log;
            IndexDescriptorCompatibility.$init$(this);
        }
    }
}

