/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.spi;

import java.io.Serializable;
import org.neo4j.cypher.internal.planner.spi.GraphStatistics;
import org.neo4j.cypher.internal.planner.spi.IndexDescriptor;
import org.neo4j.cypher.internal.planner.spi.MinimumGraphStatistics;
import org.neo4j.cypher.internal.runtime.interpreted.TransactionBoundReadTokenContext;
import org.neo4j.cypher.internal.spi.IndexDescriptorCompatibility;
import org.neo4j.cypher.internal.spi.TransactionBoundGraphStatistics$;
import org.neo4j.cypher.internal.util.Cardinality;
import org.neo4j.cypher.internal.util.LabelId;
import org.neo4j.cypher.internal.util.NameId;
import org.neo4j.cypher.internal.util.NameId$;
import org.neo4j.cypher.internal.util.RelTypeId;
import org.neo4j.cypher.internal.util.Selectivity;
import org.neo4j.cypher.internal.util.Selectivity$;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.IndexBehaviour;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.logging.Log;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Ur!\u0002\t\u0012\u0011\u0003ab!\u0002\u0010\u0012\u0011\u0003y\u0002\"\u0002\u0014\u0002\t\u00039\u0003\"\u0002\u0015\u0002\t\u0003I\u0003\"\u0002\u0015\u0002\t\u0003)e\u0001\u0002,\u0002\t]C\u0001bR\u0003\u0003\u0002\u0003\u0006I\u0001\u0013\u0005\t#\u0016\u0011\t\u0011)A\u0005%\"Aa(\u0002B\u0001B\u0003%q\bC\u0003'\u000b\u0011\u0005a\fC\u0003e\u000b\u0011\u0005S\rC\u0003u\u000b\u0011\u0005S\u000fC\u0003x\u000b\u0011\u0005\u0003\u0010C\u0003}\u000b\u0011\u0005S\u0010C\u0004\u0002\n\u0015!\t%a\u0003\t\u000f\u0005\u0005R\u0001\"\u0003\u0002$\u0005yBK]1og\u0006\u001cG/[8o\u0005>,h\u000eZ$sCBD7\u000b^1uSN$\u0018nY:\u000b\u0005I\u0019\u0012aA:qS*\u0011A#F\u0001\tS:$XM\u001d8bY*\u0011acF\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005aI\u0012!\u00028f_RR'\"\u0001\u000e\u0002\u0007=\u0014xm\u0001\u0001\u0011\u0005u\tQ\"A\t\u0003?Q\u0013\u0018M\\:bGRLwN\u001c\"pk:$wI]1qQN#\u0018\r^5ti&\u001c7o\u0005\u0002\u0002AA\u0011\u0011\u0005J\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u000f\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007)\nT\b\u0005\u0002,_5\tAF\u0003\u0002\u0013[)\u0011afE\u0001\ba2\fgN\\3s\u0013\t\u0001DF\u0001\fNS:LW.^7He\u0006\u0004\bn\u0015;bi&\u001cH/[2t\u0011\u0015\u00114\u00011\u00014\u0003Q!(/\u00198tC\u000e$\u0018n\u001c8bY\u000e{g\u000e^3yiB\u0011AgO\u0007\u0002k)\u0011agN\u0001\u0006cV,'/\u001f\u0006\u0003qe\nA![7qY*\u0011!hF\u0001\u0007W\u0016\u0014h.\u001a7\n\u0005q*$\u0001\u0006+sC:\u001c\u0018m\u0019;j_:\fGnQ8oi\u0016DH\u000fC\u0003?\u0007\u0001\u0007q(A\u0002m_\u001e\u0004\"\u0001Q\"\u000e\u0003\u0005S!AQ\f\u0002\u000f1|wmZ5oO&\u0011A)\u0011\u0002\u0004\u0019><G\u0003\u0002\u0016G!VCQa\u0012\u0003A\u0002!\u000bAA]3bIB\u0011\u0011JT\u0007\u0002\u0015*\u00111\nT\u0001\u0004CBL'B\u0001\u001eN\u0015\t!r#\u0003\u0002P\u0015\n!!+Z1e\u0011\u0015\tF\u00011\u0001S\u0003)\u00198\r[3nCJ+\u0017\r\u001a\t\u0003\u0013NK!\u0001\u0016&\u0003\u0015M\u001b\u0007.Z7b%\u0016\fG\rC\u0003?\t\u0001\u0007qHA\u0012CCN,GK]1og\u0006\u001cG/[8o\u0005>,h\u000eZ$sCBD7\u000b^1uSN$\u0018nY:\u0014\t\u0015\u0001\u0003l\u0017\t\u0003WeK!A\u0017\u0017\u0003\u001f\u001d\u0013\u0018\r\u001d5Ti\u0006$\u0018n\u001d;jGN\u0004\"!\b/\n\u0005u\u000b\"\u0001H%oI\u0016DH)Z:de&\u0004Ho\u001c:D_6\u0004\u0018\r^5cS2LG/\u001f\u000b\u0005?\u0006\u00147\r\u0005\u0002a\u000b5\t\u0011\u0001C\u0003H\u0013\u0001\u0007\u0001\nC\u0003R\u0013\u0001\u0007!\u000bC\u0003?\u0013\u0001\u0007q(\u0001\fv]&\fX/\u001a,bYV,7+\u001a7fGRLg/\u001b;z)\t1w\u000eE\u0002\"O&L!\u0001\u001b\u0012\u0003\r=\u0003H/[8o!\tQW.D\u0001l\u0015\ta7#\u0001\u0003vi&d\u0017B\u00018l\u0005-\u0019V\r\\3di&4\u0018\u000e^=\t\u000bAT\u0001\u0019A9\u0002\u000b%tG-\u001a=\u0011\u0005-\u0012\u0018BA:-\u0005=Ie\u000eZ3y\t\u0016\u001c8M]5qi>\u0014\u0018!I5oI\u0016D\bK]8qKJ$\u00180S:O_RtU\u000f\u001c7TK2,7\r^5wSRLHC\u00014w\u0011\u0015\u00018\u00021\u0001r\u0003Mqw\u000eZ3t\u00032d7)\u0019:eS:\fG.\u001b;z)\u0005I\bC\u00016{\u0013\tY8NA\u0006DCJ$\u0017N\\1mSRL\u0018!\u00078pI\u0016\u001cx+\u001b;i\u0019\u0006\u0014W\r\\\"be\u0012Lg.\u00197jif$\"!\u001f@\t\r}l\u0001\u0019AA\u0001\u00031i\u0017-\u001f2f\u0019\u0006\u0014W\r\\%e!\u0011\ts-a\u0001\u0011\u0007)\f)!C\u0002\u0002\b-\u0014q\u0001T1cK2LE-\u0001\fqCR$XM\u001d8Ti\u0016\u00048)\u0019:eS:\fG.\u001b;z)\u001dI\u0018QBA\t\u0003;Aq!a\u0004\u000f\u0001\u0004\t\t!A\u0005ge>lG*\u00192fY\"9\u00111\u0003\bA\u0002\u0005U\u0011!\u0003:fYRK\b/Z%e!\u0011\ts-a\u0006\u0011\u0007)\fI\"C\u0002\u0002\u001c-\u0014\u0011BU3m)f\u0004X-\u00133\t\u000f\u0005}a\u00021\u0001\u0002\u0002\u00059Ao\u001c'bE\u0016d\u0017AG7bs\n,7*\u001a:oK2Le\u000eZ3y\t\u0016\u001c8M]5qi>\u0014H\u0003BA\u0013\u0003c\u0001B!I4\u0002(A!\u0011\u0011FA\u0018\u001b\t\tYCC\u0002\u0002.5\u000baa]2iK6\f\u0017bA:\u0002,!1\u00111G\bA\u0002E\fq\"\u001b8eKb$Um]2sSB$xN\u001d")
public final class TransactionBoundGraphStatistics {
    public static MinimumGraphStatistics apply(Read read, SchemaRead schemaRead, Log log) {
        return TransactionBoundGraphStatistics$.MODULE$.apply(read, schemaRead, log);
    }

    public static MinimumGraphStatistics apply(TransactionalContext transactionalContext, Log log) {
        return TransactionBoundGraphStatistics$.MODULE$.apply(transactionalContext, log);
    }

    private static class BaseTransactionBoundGraphStatistics
    implements GraphStatistics,
    IndexDescriptorCompatibility {
        private final Read read;
        private final SchemaRead schemaRead;
        private final Log log;

        @Override
        public org.neo4j.cypher.internal.planner.spi.IndexBehaviour kernelToCypher(IndexBehaviour behaviour) {
            return IndexDescriptorCompatibility.kernelToCypher$((IndexDescriptorCompatibility)this, behaviour);
        }

        @Override
        public Option<IndexDescriptor.IndexType> kernelToCypher(IndexType indexType) {
            return IndexDescriptorCompatibility.kernelToCypher$((IndexDescriptorCompatibility)this, indexType);
        }

        @Override
        public SchemaDescriptor cypherToKernelSchema(org.neo4j.cypher.internal.planner.spi.IndexDescriptor index) {
            return IndexDescriptorCompatibility.cypherToKernelSchema$(this, index);
        }

        @Override
        public IndexType cypherToKernel(IndexDescriptor.IndexType indexType) {
            return IndexDescriptorCompatibility.cypherToKernel$(this, indexType);
        }

        @Override
        public Option<LabelSchemaDescriptor> toLabelSchemaDescriptor(TransactionBoundReadTokenContext tc, String labelName, Seq<String> propertyKeys) {
            return IndexDescriptorCompatibility.toLabelSchemaDescriptor$(this, tc, labelName, propertyKeys);
        }

        @Override
        public Option<RelationTypeSchemaDescriptor> toRelTypeSchemaDescriptor(TransactionBoundReadTokenContext tc, String relTypeName, Seq<String> propertyKeys) {
            return IndexDescriptorCompatibility.toRelTypeSchemaDescriptor$(this, tc, relTypeName, propertyKeys);
        }

        public Option<Selectivity> uniqueValueSelectivity(org.neo4j.cypher.internal.planner.spi.IndexDescriptor index) {
            Option option;
            try {
                Option<IndexDescriptor> maybeIndexDescriptor = this.maybeKernelIndexDescriptor(index);
                option = maybeIndexDescriptor.map((Function1 & Serializable & scala.Serializable)indexDescriptor -> {
                    Selectivity selectivity;
                    long indexSize = $this.schemaRead.indexSize(indexDescriptor);
                    if (indexSize == 0L) {
                        selectivity = Selectivity$.MODULE$.ZERO();
                    } else {
                        double indexEntrySelectivity = $this.schemaRead.indexUniqueValuesSelectivity(indexDescriptor);
                        if (indexEntrySelectivity == 0.0) {
                            selectivity = Selectivity$.MODULE$.ZERO();
                        } else {
                            double frequencyOfEntitiesWithSameValue = 1.0 / indexEntrySelectivity;
                            double indexSelectivity = frequencyOfEntitiesWithSameValue / (double)indexSize;
                            selectivity = Selectivity$.MODULE$.apply(Math.min(indexSelectivity, 1.0));
                        }
                    }
                    return selectivity;
                });
            }
            catch (IndexNotFoundKernelException e) {
                this.log.debug("Index not found for uniqueValueSelectivity", (Throwable)e);
                option = None$.MODULE$;
            }
            return option;
        }

        public Option<Selectivity> indexPropertyIsNotNullSelectivity(org.neo4j.cypher.internal.planner.spi.IndexDescriptor index) {
            None$ none$;
            block7: {
                try {
                    double d;
                    IndexDescriptor.EntityType entityType = index.entityType();
                    if (entityType instanceof IndexDescriptor.EntityType$.Node) {
                        IndexDescriptor.EntityType$.Node node = (IndexDescriptor.EntityType$.Node)entityType;
                        LabelId label = node.label();
                        d = this.read.countsForNodeWithoutTxState(NameId$.MODULE$.toKernelEncode((NameId)label));
                    } else if (entityType instanceof IndexDescriptor.EntityType$.Relationship) {
                        IndexDescriptor.EntityType$.Relationship relationship = (IndexDescriptor.EntityType$.Relationship)entityType;
                        RelTypeId relType = relationship.relType();
                        d = this.read.countsForRelationshipWithoutTxState(-1, NameId$.MODULE$.toKernelEncode((NameId)relType), -1);
                    } else {
                        throw new MatchError((Object)entityType);
                    }
                    double entitiesCount = d;
                    if (entitiesCount == 0.0) {
                        none$ = new Some((Object)Selectivity$.MODULE$.ZERO());
                        break block7;
                    }
                    Option<IndexDescriptor> maybeIndexDescriptor = this.maybeKernelIndexDescriptor(index);
                    none$ = maybeIndexDescriptor.map((Function1 & Serializable & scala.Serializable)indexDescriptor -> {
                        long indexSize = $this.schemaRead.indexSize(indexDescriptor);
                        double indexSelectivity = (double)indexSize / entitiesCount;
                        return Selectivity$.MODULE$.apply(Math.min(indexSelectivity, 1.0));
                    });
                }
                catch (IndexNotFoundKernelException e) {
                    this.log.debug("Index not found for indexPropertyExistsSelectivity", (Throwable)e);
                    none$ = None$.MODULE$;
                }
            }
            return none$;
        }

        public Cardinality nodesAllCardinality() {
            return new Cardinality((double)this.read.countsForNodeWithoutTxState(-1));
        }

        public Cardinality nodesWithLabelCardinality(Option<LabelId> maybeLabelId) {
            long count = BoxesRunTime.unboxToLong((Object)maybeLabelId.map((Function1 & Serializable & scala.Serializable)labelId -> BoxesRunTime.boxToLong((long)this.read.countsForNodeWithoutTxState(labelId.id()))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
            return new Cardinality((double)count);
        }

        public Cardinality patternStepCardinality(Option<LabelId> fromLabel, Option<RelTypeId> relTypeId, Option<LabelId> toLabel) {
            return new Cardinality((double)this.read.countsForRelationshipWithoutTxState(NameId$.MODULE$.toKernelEncode(fromLabel), NameId$.MODULE$.toKernelEncode(relTypeId), NameId$.MODULE$.toKernelEncode(toLabel)));
        }

        private Option<IndexDescriptor> maybeKernelIndexDescriptor(org.neo4j.cypher.internal.planner.spi.IndexDescriptor indexDescriptor) {
            return Option$.MODULE$.apply((Object)this.schemaRead.index(this.cypherToKernelSchema(indexDescriptor), this.cypherToKernel(indexDescriptor.indexType()))).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BaseTransactionBoundGraphStatistics.$anonfun$maybeKernelIndexDescriptor$1(x$1)));
        }

        public static final /* synthetic */ boolean $anonfun$maybeKernelIndexDescriptor$1(IndexDescriptor x$1) {
            IndexDescriptor indexDescriptor = x$1;
            IndexDescriptor indexDescriptor2 = IndexDescriptor.NO_INDEX;
            return indexDescriptor == null ? indexDescriptor2 != null : !indexDescriptor.equals(indexDescriptor2);
        }

        public BaseTransactionBoundGraphStatistics(Read read, SchemaRead schemaRead, Log log) {
            this.read = read;
            this.schemaRead = schemaRead;
            this.log = log;
            IndexDescriptorCompatibility.$init$(this);
        }
    }
}

