/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Serializable;
import java.util.Iterator;
import java.util.UUID;
import org.neo4j.cypher.internal.AdministrationCommandRuntime;
import org.neo4j.cypher.internal.AdministrationCommandRuntime$IdentityConverter$;
import org.neo4j.cypher.internal.ExecutionEngine;
import org.neo4j.cypher.internal.ExecutionPlan;
import org.neo4j.cypher.internal.ast.DatabaseName;
import org.neo4j.cypher.internal.ast.HomeDatabaseAction;
import org.neo4j.cypher.internal.ast.NamespacedName;
import org.neo4j.cypher.internal.ast.ParameterName;
import org.neo4j.cypher.internal.ast.RemoveHomeDatabaseAction$;
import org.neo4j.cypher.internal.ast.SetHomeDatabaseAction;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.Parameter;
import org.neo4j.cypher.internal.logical.plans.NameValidator$;
import org.neo4j.cypher.internal.procs.Continue$;
import org.neo4j.cypher.internal.procs.InitAndFinallyFunctions;
import org.neo4j.cypher.internal.procs.InitAndFinallyFunctions$;
import org.neo4j.cypher.internal.procs.QueryHandler$;
import org.neo4j.cypher.internal.procs.QueryHandlerBuilder;
import org.neo4j.cypher.internal.procs.QueryHandlerResult;
import org.neo4j.cypher.internal.procs.ThrowException;
import org.neo4j.cypher.internal.procs.UpdatingSystemCommandExecutionPlan;
import org.neo4j.cypher.internal.procs.UpdatingSystemCommandExecutionPlan$;
import org.neo4j.cypher.internal.security.SecureHasher;
import org.neo4j.cypher.internal.security.SystemGraphCredential;
import org.neo4j.cypher.internal.util.DeprecatedDatabaseNameNotification;
import org.neo4j.cypher.internal.util.HomeDatabaseNotPresent;
import org.neo4j.cypher.internal.util.InternalNotification;
import org.neo4j.cypher.internal.util.symbols.CypherType;
import org.neo4j.cypher.internal.util.symbols.StringType;
import org.neo4j.cypher.internal.util.symbols.package$;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.exceptions.DatabaseAdministrationOnFollowerException;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.exceptions.ParameterNotFoundException;
import org.neo4j.exceptions.ParameterWrongTypeException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.security.SecurityAuthorizationHandler;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.schema.UniquePropertyValueValidationException;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.string.UTF8;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.ByteArray;
import org.neo4j.values.storable.StringValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Using;
import scala.util.Using$;

public final class AdministrationCommandRuntime$ {
    public static final AdministrationCommandRuntime$ MODULE$ = new AdministrationCommandRuntime$();
    private static final String followerError = "Administration commands must be executed on the LEADER server.";
    private static final SecureHasher secureHasher = new SecureHasher();
    private static final String internalPrefix = "__internal_";

    public String followerError() {
        return followerError;
    }

    private SecureHasher secureHasher() {
        return secureHasher;
    }

    private String internalPrefix() {
        return internalPrefix;
    }

    public String internalKey(String name) {
        return this.internalPrefix() + name;
    }

    public byte[] validatePassword(byte[] password) {
        if (password == null || password.length == 0) {
            throw new InvalidArgumentException("A password cannot be empty.");
        }
        return password;
    }

    public TextValue hashPassword(byte[] initialPassword) {
        TextValue textValue = Values.utf8Value((String)SystemGraphCredential.createCredentialForPassword(initialPassword, this.secureHasher()).serialize());
        return textValue;
    }

    public TextValue validateAndFormatEncryptedPassword(byte[] password) {
        TextValue textValue;
        try {
            textValue = Values.utf8Value((String)SystemGraphCredential.serialize(password));
        }
        catch (IllegalArgumentException e) {
            throw new InvalidArgumentException(e.getMessage(), (Throwable)e);
        }
        return textValue;
    }

    public AdministrationCommandRuntime.PasswordExpression getPasswordExpression(Expression password, boolean isEncryptedPassword, String[] otherParams) {
        Expression expression = password;
        if (!(expression instanceof Parameter)) {
            throw new IllegalStateException("Internal error when processing password.");
        }
        Parameter parameter = (Parameter)expression;
        this.validateStringParameterType(parameter);
        String hashedPwKey = this.ensureUniqueParamName(this.internalKey(parameter.name()) + "_hashed", otherParams);
        String passwordByteKey = this.ensureUniqueParamName(this.internalKey(parameter.name()) + "_bytes", otherParams);
        AdministrationCommandRuntime.PasswordExpression passwordExpression = new AdministrationCommandRuntime.PasswordExpression(hashedPwKey, Values.NO_VALUE, passwordByteKey, Values.NO_VALUE, (Function2<Transaction, MapValue, MapValue>)(Function2 & Serializable)(x$1, params) -> this.convertPasswordParameters$1((MapValue)params, parameter, isEncryptedPassword, hashedPwKey, passwordByteKey));
        return passwordExpression;
    }

    public byte[] getValidPasswordParameter(MapValue params, String passwordParameter) {
        byte[] byArray;
        AnyValue anyValue = params.get(passwordParameter);
        if (anyValue instanceof ByteArray) {
            ByteArray byteArray = (ByteArray)anyValue;
            byArray = byteArray.asObject();
        } else if (anyValue instanceof StringValue) {
            StringValue stringValue = (StringValue)anyValue;
            byArray = UTF8.encode((String)stringValue.stringValue());
        } else {
            Value value = Values.NO_VALUE;
            AnyValue anyValue2 = anyValue;
            if (!(value != null ? !value.equals(anyValue2) : anyValue2 != null)) {
                throw new ParameterNotFoundException("Expected parameter(s): " + passwordParameter);
            }
            throw new ParameterWrongTypeException("Expected password parameter $" + passwordParameter + " to have type String but was " + anyValue.getTypeName());
        }
        return byArray;
    }

    public String ensureUniqueParamName(String originalName, String[] otherParams) {
        ObjectRef uniqueName = ObjectRef.create((Object)originalName);
        IndexedSeq params = Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.refArrayOps((Object[])otherParams), (Ordering)Ordering.String$.MODULE$));
        params.foreach((Function1 & Serializable)otherParamName -> {
            AdministrationCommandRuntime$.$anonfun$ensureUniqueParamName$1(uniqueName, otherParamName);
            return BoxedUnit.UNIT;
        });
        return (String)uniqueName.elem;
    }

    public void validateStringParameterType(Parameter param) {
        CypherType cypherType = param.parameterType();
        if (!(cypherType instanceof StringType)) {
            throw new ParameterWrongTypeException("Only " + package$.MODULE$.CTString() + " values are accepted as password, got: " + param.parameterType());
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public ExecutionPlan makeCreateUserExecutionPlan(Either<String, Parameter> userName, boolean isEncryptedPassword, Expression password, boolean requirePasswordChange, boolean suspended, Option<HomeDatabaseAction> defaultDatabase, Option<ExecutionPlan> sourcePlan, ExecutionEngine normalExecutionEngine, SecurityAuthorizationHandler securityAuthorizationHandler) {
        String passwordChangeRequiredKey = this.internalKey("passwordChangeRequired");
        String suspendedKey = this.internalKey("suspended");
        String uuidKey = this.internalKey("uuid");
        Option homeDatabaseFields = defaultDatabase.map((Function1 & Serializable)x0$1 -> {
            AdministrationCommandRuntime.NameFields nameFields;
            HomeDatabaseAction homeDatabaseAction = x0$1;
            if (RemoveHomeDatabaseAction$.MODULE$.equals(homeDatabaseAction)) {
                nameFields = new AdministrationCommandRuntime.NameFields(MODULE$.internalPrefix() + "homeDatabase", Values.NO_VALUE, AdministrationCommandRuntime$IdentityConverter$.MODULE$);
            } else if (homeDatabaseAction instanceof SetHomeDatabaseAction) {
                SetHomeDatabaseAction setHomeDatabaseAction = (SetHomeDatabaseAction)homeDatabaseAction;
                DatabaseName name = setHomeDatabaseAction.name();
                nameFields = MODULE$.getNameFields("homeDatabase", (Either<String, Parameter>)name.asLegacyName(), (Function1<String, String>)(Function1 & Serializable)s -> new NormalizedDatabaseName(s).name());
            } else {
                throw new MatchError((Object)homeDatabaseAction);
            }
            return nameFields;
        });
        AdministrationCommandRuntime.NameFields userNameFields = this.getNameFields("username", userName, this.getNameFields$default$3());
        String[] nonPasswordParameterNames = (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])new String[]{userNameFields.nameKey(), uuidKey, passwordChangeRequiredKey, suspendedKey}), (IterableOnce)homeDatabaseFields.map((Function1 & Serializable)x$2 -> x$2.nameKey()), ClassTag$.MODULE$.apply(String.class));
        AdministrationCommandRuntime.PasswordExpression credentials = this.getPasswordExpression(password, isEncryptedPassword, nonPasswordParameterNames);
        String homeDatabaseCypher = (String)homeDatabaseFields.map((Function1 & Serializable)ddf -> ", homeDatabase: $`" + ddf.nameKey() + "`").getOrElse((Function0 & Serializable)() -> "");
        Function2 & Serializable mapValueConverter = (Function2 & Serializable)(tx, p) -> {
            Option newHomeDatabaseFields = homeDatabaseFields.map((Function1 & Serializable)x$3 -> (MapValue)x$3.nameConverter().apply(tx, userNameFields.nameConverter().apply(tx, p)));
            return (MapValue)credentials.mapValueConverter().apply(tx, newHomeDatabaseFields.getOrElse((Function0 & Serializable)() -> (MapValue)userNameFields.nameConverter().apply(tx, p)));
        };
        String x$1 = "CreateUser";
        ExecutionEngine x$22 = normalExecutionEngine;
        SecurityAuthorizationHandler x$3 = securityAuthorizationHandler;
        String x$42 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("CREATE (u:User {name: $`" + userNameFields.nameKey() + "`, id: $`" + uuidKey + "`, credentials: $`" + credentials.key() + "`,\n         |passwordChangeRequired: $`" + passwordChangeRequiredKey + "`, suspended: $`" + suspendedKey + "`\n         |" + homeDatabaseCypher + " })\n         |RETURN u.name"));
        MapValue x$5 = VirtualValues.map((String[])((String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])new String[]{credentials.key(), credentials.bytesKey()}), (Object)nonPasswordParameterNames, ClassTag$.MODULE$.apply(String.class))), (AnyValue[])((AnyValue[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])new AnyValue[]{credentials.value(), credentials.bytesValue(), userNameFields.nameValue(), Values.utf8Value((String)UUID.randomUUID().toString()), Values.booleanValue((boolean)requirePasswordChange), Values.booleanValue((boolean)suspended)}), (IterableOnce)homeDatabaseFields.map((Function1 & Serializable)x$4 -> x$4.nameValue()), ClassTag$.MODULE$.apply(AnyValue.class))));
        QueryHandlerBuilder x$6 = QueryHandler$.MODULE$.handleNoResult((Function1<MapValue, Option<Throwable>>)(Function1 & Serializable)params -> new Some((Object)new IllegalStateException("Failed to create the specified user '" + MODULE$.runtimeStringValue(userName, (MapValue)params) + "'."))).handleError((Function2<Throwable, MapValue, Throwable>)(Function2 & Serializable)(error, params) -> {
            Throwable e;
            void var3_7;
            Tuple2 tuple2 = new Tuple2(error, (Object)error.getCause());
            if (tuple2 != null && tuple2._2() instanceof UniquePropertyValueValidationException) {
                InvalidArgumentException invalidArgumentException = new InvalidArgumentException("Failed to create the specified user '" + MODULE$.runtimeStringValue(userName, (MapValue)params) + "': User already exists.", error);
                return var3_7;
            }
            if (tuple2 != null && (e = (Throwable)tuple2._1()) instanceof Status.HasStatus) {
                Throwable throwable = e;
                Status status = ((Status.HasStatus)throwable).status();
                Status.Cluster cluster = Status.Cluster.NotALeader;
                if (!(status != null ? !status.equals(cluster) : cluster != null)) {
                    DatabaseAdministrationOnFollowerException databaseAdministrationOnFollowerException = new DatabaseAdministrationOnFollowerException("Failed to create the specified user '" + MODULE$.runtimeStringValue(userName, (MapValue)params) + "': " + MODULE$.followerError(), error);
                    return var3_7;
                }
            }
            IllegalStateException illegalStateException = new IllegalStateException("Failed to create the specified user '" + MODULE$.runtimeStringValue(userName, (MapValue)params) + "'.", (Throwable)error);
            return var3_7;
        });
        Option<ExecutionPlan> x$7 = sourcePlan;
        InitAndFinallyFunctions x$8 = new InitAndFinallyFunctions((Function1<MapValue, Object>)(Function1 & Serializable)params -> BoxesRunTime.boxToBoolean((boolean)NameValidator$.MODULE$.assertValidUsername(AdministrationCommandRuntime$.MODULE$.runtimeStringValue((Either<String, Parameter>)userName, params))), (Function1<MapValue, BoxedUnit>)(Function1 & Serializable)p -> {
            AdministrationCommandRuntime$.$anonfun$makeCreateUserExecutionPlan$13(credentials, p);
            return BoxedUnit.UNIT;
        });
        Function2 & Serializable x$9 = mapValueConverter;
        Function2 & Serializable x$10 = (Function2 & Serializable)(tx, params) -> MODULE$.isHomeDatabasePresent((Option<AdministrationCommandRuntime.NameFields>)homeDatabaseFields, (Transaction)tx, (MapValue)params);
        boolean x$11 = UpdatingSystemCommandExecutionPlan$.MODULE$.apply$default$8();
        Function2<Transaction, SecurityContext, MapValue> x$12 = UpdatingSystemCommandExecutionPlan$.MODULE$.apply$default$10();
        Function1<Transaction, BoxedUnit> x$13 = UpdatingSystemCommandExecutionPlan$.MODULE$.apply$default$13();
        return new UpdatingSystemCommandExecutionPlan("CreateUser", x$22, x$3, x$42, x$5, x$6, x$7, x$11, x$8, x$12, (Function2<Transaction, MapValue, MapValue>)x$9, (Function2<Transaction, MapValue, Tuple2<MapValue, Set<InternalNotification>>>)x$10, x$13);
    }

    public Option<HomeDatabaseAction> makeCreateUserExecutionPlan$default$6() {
        return None$.MODULE$;
    }

    public ExecutionPlan makeAlterUserExecutionPlan(Either<String, Parameter> userName, Option<Object> isEncryptedPassword, Option<Expression> password, Option<Object> requirePasswordChange, Option<Object> suspended, Option<HomeDatabaseAction> homeDatabase, Option<ExecutionPlan> sourcePlan, ExecutionEngine normalExecutionEngine, SecurityAuthorizationHandler securityAuthorizationHandler) {
        AdministrationCommandRuntime.NameFields userNameFields = this.getNameFields("username", userName, this.getNameFields$default$3());
        Option homeDatabaseFields = homeDatabase.map((Function1 & Serializable)x0$1 -> {
            AdministrationCommandRuntime.NameFields nameFields;
            HomeDatabaseAction homeDatabaseAction = x0$1;
            if (RemoveHomeDatabaseAction$.MODULE$.equals(homeDatabaseAction)) {
                nameFields = new AdministrationCommandRuntime.NameFields(MODULE$.internalPrefix() + "homeDatabase", Values.NO_VALUE, AdministrationCommandRuntime$IdentityConverter$.MODULE$);
            } else if (homeDatabaseAction instanceof SetHomeDatabaseAction) {
                SetHomeDatabaseAction setHomeDatabaseAction = (SetHomeDatabaseAction)homeDatabaseAction;
                DatabaseName name = setHomeDatabaseAction.name();
                nameFields = MODULE$.getNameFields("homeDatabase", (Either<String, Parameter>)name.asLegacyName(), (Function1<String, String>)(Function1 & Serializable)s -> new NormalizedDatabaseName(s).name());
            } else {
                throw new MatchError((Object)homeDatabaseAction);
            }
            return nameFields;
        });
        String[] nonPasswordParameterNames = (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])new String[]{userNameFields.nameKey()}), (IterableOnce)homeDatabaseFields.map((Function1 & Serializable)x$5 -> x$5.nameKey()), ClassTag$.MODULE$.apply(String.class));
        Option maybePw = password.map((Function1 & Serializable)p -> MODULE$.getPasswordExpression((Expression)p, BoxesRunTime.unboxToBoolean((Object)isEncryptedPassword.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false)), nonPasswordParameterNames));
        Seq params2 = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)maybePw), (Object)"credentials"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(requirePasswordChange), (Object)"passwordChangeRequired"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(suspended), (Object)"suspended"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)homeDatabaseFields), (Object)"homeDatabase")})).flatMap((Function1 & Serializable)param -> {
            Object nameFields;
            Object passwordExpression;
            boolean bl = false;
            Some some = null;
            Option option = (Option)param._1();
            if (None$.MODULE$.equals(option)) {
                return (Seq)scala.package$.MODULE$.Seq().empty();
            }
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                Object boolExpr = some.value();
                if (boolExpr instanceof Boolean) {
                    boolean bl2 = BoxesRunTime.unboxToBoolean((Object)boolExpr);
                    return (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3(param._2(), (Object)MODULE$.internalKey((String)param._2()), (Object)Values.booleanValue((boolean)bl2))}));
                }
            }
            if (bl && (passwordExpression = some.value()) instanceof AdministrationCommandRuntime.PasswordExpression) {
                AdministrationCommandRuntime.PasswordExpression passwordExpression2 = (AdministrationCommandRuntime.PasswordExpression)passwordExpression;
                return (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3(param._2(), (Object)passwordExpression2.key(), (Object)passwordExpression2.value())}));
            }
            if (bl && (nameFields = some.value()) instanceof AdministrationCommandRuntime.NameFields) {
                AdministrationCommandRuntime.NameFields nameFields2 = (AdministrationCommandRuntime.NameFields)nameFields;
                return (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3(param._2(), (Object)nameFields2.nameKey(), (Object)nameFields2.nameValue())}));
            }
            if (!bl) throw new MatchError((Object)option);
            Object p = some.value();
            throw new InvalidArgumentException("Invalid option type for ALTER USER, expected PasswordExpression, Boolean, String or Parameter but got: " + p.getClass().getSimpleName());
        });
        Tuple3 tuple3 = (Tuple3)params2.foldLeft((Object)new Tuple3((Object)("MATCH (user:User {name: $`" + userNameFields.nameKey() + "`}) WITH user, user.credentials AS oldCredentials"), (Object)scala.package$.MODULE$.Seq().empty(), (Object)scala.package$.MODULE$.Seq().empty()), (Function2 & Serializable)(acc, param) -> {
            String propertyName = (String)param._1();
            String key = (String)param._2();
            Value value = (Value)param._3();
            return new Tuple3((Object)((String)acc._1() + (" SET user." + propertyName + " = $`" + key + "`")), ((SeqOps)acc._2()).$colon$plus((Object)key), ((SeqOps)acc._3()).$colon$plus((Object)value));
        });
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        String query = (String)tuple3._1();
        Seq keys = (Seq)tuple3._2();
        Seq values = (Seq)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)query, (Object)keys, (Object)values);
        Tuple3 tuple33 = tuple32;
        String query2 = (String)tuple33._1();
        Seq keys2 = (Seq)tuple33._2();
        Seq values2 = (Seq)tuple33._3();
        Seq parameterKeys = (Seq)((SeqOps)keys2.$plus$plus((IterableOnce)Option$.MODULE$.option2Iterable(maybePw.map((Function1 & Serializable)x$7 -> x$7.bytesKey())).toSeq())).$colon$plus((Object)userNameFields.nameKey());
        Seq parameterValues = (Seq)((SeqOps)values2.$plus$plus((IterableOnce)Option$.MODULE$.option2Iterable(maybePw.map((Function1 & Serializable)x$8 -> x$8.bytesValue())).toSeq())).$colon$plus((Object)userNameFields.nameValue());
        Function2 & Serializable mapper = (Function2 & Serializable)(tx, p) -> {
            Option newHomeDatabaseFields = homeDatabaseFields.map((Function1 & Serializable)x$9 -> (MapValue)x$9.nameConverter().apply(tx, userNameFields.nameConverter().apply(tx, p)));
            return (MapValue)((Function2)maybePw.map((Function1 & Serializable)x$10 -> x$10.mapValueConverter()).getOrElse((Function0 & Serializable)() -> AdministrationCommandRuntime$IdentityConverter$.MODULE$)).apply(tx, newHomeDatabaseFields.getOrElse((Function0 & Serializable)() -> (MapValue)userNameFields.nameConverter().apply(tx, p)));
        };
        String x$3 = "AlterUser";
        ExecutionEngine x$4 = normalExecutionEngine;
        SecurityAuthorizationHandler x$52 = securityAuthorizationHandler;
        String x$6 = query2 + " RETURN oldCredentials";
        MapValue x$72 = VirtualValues.map((String[])((String[])parameterKeys.toArray(ClassTag$.MODULE$.apply(String.class))), (AnyValue[])((AnyValue[])parameterValues.toArray(ClassTag$.MODULE$.apply(AnyValue.class))));
        QueryHandlerBuilder x$82 = QueryHandler$.MODULE$.handleNoResult((Function1<MapValue, Option<Throwable>>)(Function1 & Serializable)p -> new Some((Object)new InvalidArgumentException("Failed to alter the specified user '" + MODULE$.runtimeStringValue(userName, (MapValue)p) + "': User does not exist."))).handleError((Function2<Throwable, MapValue, Throwable>)(Function2 & Serializable)(x0$2, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$2, x1$1);
            if (tuple2 != null) {
                Throwable error = (Throwable)tuple2._1();
                MapValue p = (MapValue)tuple2._2();
                if (error instanceof Status.HasStatus) {
                    Throwable throwable = error;
                    Status status = ((Status.HasStatus)throwable).status();
                    Status.Cluster cluster = Status.Cluster.NotALeader;
                    if (status == null) {
                        if (cluster == null) return new DatabaseAdministrationOnFollowerException("Failed to alter the specified user '" + MODULE$.runtimeStringValue(userName, p) + "': " + MODULE$.followerError(), throwable);
                    } else if (status.equals(cluster)) {
                        return new DatabaseAdministrationOnFollowerException("Failed to alter the specified user '" + MODULE$.runtimeStringValue(userName, p) + "': " + MODULE$.followerError(), throwable);
                    }
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Throwable error = (Throwable)tuple2._1();
            MapValue p = (MapValue)tuple2._2();
            return new IllegalStateException("Failed to alter the specified user '" + MODULE$.runtimeStringValue(userName, p) + "'.", error);
        }).handleResult((Function3<Object, AnyValue, MapValue, QueryHandlerResult>)(Function3 & Serializable)(x$11, value, p) -> AdministrationCommandRuntime$.$anonfun$makeAlterUserExecutionPlan$17(maybePw, userName, BoxesRunTime.unboxToInt((Object)x$11), value, p));
        Option<ExecutionPlan> x$9 = sourcePlan;
        Function1 & Serializable x$1 = (Function1 & Serializable)p -> {
            maybePw.foreach((Function1 & Serializable)newPw -> {
                AdministrationCommandRuntime$.$anonfun$makeAlterUserExecutionPlan$21(p, newPw);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        };
        Function1<MapValue, Object> x$2 = InitAndFinallyFunctions$.MODULE$.apply$default$1();
        InitAndFinallyFunctions x$10 = new InitAndFinallyFunctions(x$2, (Function1<MapValue, BoxedUnit>)x$1);
        Function2 & Serializable x$112 = mapper;
        Function2 & Serializable x$12 = (Function2 & Serializable)(tx, params) -> MODULE$.isHomeDatabasePresent((Option<AdministrationCommandRuntime.NameFields>)homeDatabaseFields, (Transaction)tx, (MapValue)params);
        boolean x$13 = UpdatingSystemCommandExecutionPlan$.MODULE$.apply$default$8();
        Function2<Transaction, SecurityContext, MapValue> x$14 = UpdatingSystemCommandExecutionPlan$.MODULE$.apply$default$10();
        Function1<Transaction, BoxedUnit> x$15 = UpdatingSystemCommandExecutionPlan$.MODULE$.apply$default$13();
        return new UpdatingSystemCommandExecutionPlan("AlterUser", x$4, x$52, x$6, x$72, x$82, x$9, x$13, x$10, x$14, (Function2<Transaction, MapValue, MapValue>)x$112, (Function2<Transaction, MapValue, Tuple2<MapValue, Set<InternalNotification>>>)x$12, x$15);
    }

    public Option<HomeDatabaseAction> makeAlterUserExecutionPlan$default$6() {
        return None$.MODULE$;
    }

    private Tuple2<MapValue, Set<InternalNotification>> isHomeDatabasePresent(Option<AdministrationCommandRuntime.NameFields> homeDatabaseFields, Transaction tx, MapValue params) {
        return (Tuple2)homeDatabaseFields.map((Function1 & Serializable)ddf -> {
            Tuple2 tuple2;
            AnyValue anyValue = params.get(ddf.nameKey());
            if (anyValue instanceof TextValue) {
                TextValue textValue = (TextValue)anyValue;
                Set notifications = Iterators.asList((Iterator)tx.findNodes(TopologyGraphDbmsModel.DATABASE_NAME_LABEL, "displayName", (Object)textValue.stringValue())).isEmpty() ? (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InternalNotification[]{new HomeDatabaseNotPresent(textValue.stringValue())})) : Predef$.MODULE$.Set().empty();
                tuple2 = new Tuple2((Object)params, (Object)notifications);
            } else {
                tuple2 = new Tuple2((Object)params, (Object)Predef$.MODULE$.Set().empty());
            }
            return tuple2;
        }).getOrElse((Function0 & Serializable)() -> new Tuple2((Object)params, (Object)Predef$.MODULE$.Set().empty()));
    }

    public ExecutionPlan makeRenameExecutionPlan(String entity, Either<String, Parameter> fromName, Either<String, Parameter> toName, Function1<MapValue, Object> initFunction, Option<ExecutionPlan> sourcePlan, ExecutionEngine normalExecutionEngine, SecurityAuthorizationHandler securityAuthorizationHandler) {
        AdministrationCommandRuntime.NameFields fromNameFields = this.getNameFields("fromName", fromName, this.getNameFields$default$3());
        AdministrationCommandRuntime.NameFields toNameFields = this.getNameFields("toName", toName, this.getNameFields$default$3());
        Function2 & Serializable mapValueConverter = (Function2 & Serializable)(tx, p) -> (MapValue)toNameFields.nameConverter().apply(tx, fromNameFields.nameConverter().apply(tx, p));
        String x$1 = "Create" + entity;
        ExecutionEngine x$2 = normalExecutionEngine;
        SecurityAuthorizationHandler x$3 = securityAuthorizationHandler;
        String x$4 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("MATCH (old:" + entity + " {name: $`" + fromNameFields.nameKey() + "`})\n         |SET old.name = $`" + toNameFields.nameKey() + "`\n         |RETURN old.name\n        "));
        MapValue x$5 = VirtualValues.map((String[])((String[])((Object[])new String[]{fromNameFields.nameKey(), toNameFields.nameKey()})), (AnyValue[])((AnyValue[])((Object[])new AnyValue[]{fromNameFields.nameValue(), toNameFields.nameValue()})));
        QueryHandlerBuilder x$6 = QueryHandler$.MODULE$.handleNoResult((Function1<MapValue, Option<Throwable>>)(Function1 & Serializable)p -> new Some((Object)new InvalidArgumentException("Failed to rename the specified " + entity.toLowerCase() + " '" + MODULE$.runtimeStringValue(fromName, (MapValue)p) + "' to " + ("'" + MODULE$.runtimeStringValue(toName, (MapValue)p) + "': The " + entity.toLowerCase() + " '" + MODULE$.runtimeStringValue(fromName, (MapValue)p) + "' does not exist.")))).handleError((Function2<Throwable, MapValue, Throwable>)(Function2 & Serializable)(error, p) -> {
            Tuple2 tuple2 = new Tuple2(error, (Object)error.getCause());
            if (tuple2 != null && tuple2._2() instanceof UniquePropertyValueValidationException) {
                return new InvalidArgumentException("Failed to rename the specified " + entity.toLowerCase() + " '" + MODULE$.runtimeStringValue(fromName, (MapValue)p) + "' to " + ("'" + MODULE$.runtimeStringValue(toName, (MapValue)p) + "': ") + (entity + " '" + MODULE$.runtimeStringValue(toName, (MapValue)p) + "' already exists."), error);
            }
            if (tuple2 == null) return new IllegalStateException("Failed to rename the specified " + entity.toLowerCase() + " '" + MODULE$.runtimeStringValue(fromName, (MapValue)p) + "' to '" + MODULE$.runtimeStringValue(toName, (MapValue)p) + "'.", (Throwable)error);
            Throwable e = (Throwable)tuple2._1();
            if (!(e instanceof Status.HasStatus)) return new IllegalStateException("Failed to rename the specified " + entity.toLowerCase() + " '" + MODULE$.runtimeStringValue(fromName, (MapValue)p) + "' to '" + MODULE$.runtimeStringValue(toName, (MapValue)p) + "'.", (Throwable)error);
            Throwable throwable = e;
            Status status = ((Status.HasStatus)throwable).status();
            Status.Cluster cluster = Status.Cluster.NotALeader;
            if (status != null) {
                if (!status.equals(cluster)) return new IllegalStateException("Failed to rename the specified " + entity.toLowerCase() + " '" + MODULE$.runtimeStringValue(fromName, (MapValue)p) + "' to '" + MODULE$.runtimeStringValue(toName, (MapValue)p) + "'.", (Throwable)error);
                return new DatabaseAdministrationOnFollowerException("Failed to rename the specified " + entity.toLowerCase() + " '" + MODULE$.runtimeStringValue(fromName, (MapValue)p) + "': " + MODULE$.followerError(), error);
            }
            if (cluster == null) return new DatabaseAdministrationOnFollowerException("Failed to rename the specified " + entity.toLowerCase() + " '" + MODULE$.runtimeStringValue(fromName, (MapValue)p) + "': " + MODULE$.followerError(), error);
            return new IllegalStateException("Failed to rename the specified " + entity.toLowerCase() + " '" + MODULE$.runtimeStringValue(fromName, (MapValue)p) + "' to '" + MODULE$.runtimeStringValue(toName, (MapValue)p) + "'.", (Throwable)error);
        });
        Option<ExecutionPlan> x$7 = sourcePlan;
        InitAndFinallyFunctions x$8 = new InitAndFinallyFunctions(initFunction, InitAndFinallyFunctions$.MODULE$.apply$default$2());
        Function2 & Serializable x$9 = mapValueConverter;
        boolean x$10 = UpdatingSystemCommandExecutionPlan$.MODULE$.apply$default$8();
        Function2<Transaction, SecurityContext, MapValue> x$11 = UpdatingSystemCommandExecutionPlan$.MODULE$.apply$default$10();
        Function2<Transaction, MapValue, Tuple2<MapValue, Set<InternalNotification>>> x$12 = UpdatingSystemCommandExecutionPlan$.MODULE$.apply$default$12();
        Function1<Transaction, BoxedUnit> x$13 = UpdatingSystemCommandExecutionPlan$.MODULE$.apply$default$13();
        return new UpdatingSystemCommandExecutionPlan(x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$10, x$8, x$11, (Function2<Transaction, MapValue, MapValue>)x$9, x$12, x$13);
    }

    public AdministrationCommandRuntime.NameFields getNameFields(String key, Either<String, Parameter> name, Function1<String, String> valueMapper) {
        AdministrationCommandRuntime.NameFields nameFields;
        Either<String, Parameter> either = name;
        if (either instanceof Left) {
            Left left = (Left)either;
            String u = (String)left.value();
            nameFields = new AdministrationCommandRuntime.NameFields(this.internalPrefix() + key, (Value)Values.utf8Value((String)((String)valueMapper.apply((Object)u))), AdministrationCommandRuntime$IdentityConverter$.MODULE$);
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Parameter parameter = (Parameter)right.value();
            nameFields = new AdministrationCommandRuntime.NameFields((String)AdministrationCommandRuntime$.rename$1().apply((Object)parameter.name()), Values.NO_VALUE, new AdministrationCommandRuntime.RenamingStringParameterConverter(parameter.name(), (Function1<String, String>)AdministrationCommandRuntime$.rename$1(), (Function1<TextValue, TextValue>)(Function1 & Serializable)v -> Values.utf8Value((String)((String)valueMapper.apply((Object)v.stringValue())))));
        } else {
            throw new MatchError(either);
        }
        return nameFields;
    }

    public Function1<String, String> getNameFields$default$3() {
        return (Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AdministrationCommandRuntime.DatabaseNameFields getDatabaseNameFields(String nameKey, DatabaseName name) {
        Option option;
        Function1 & Serializable valueMapper = (Function1 & Serializable)x$12 -> new NormalizedDatabaseName(x$12).name();
        boolean bl = false;
        NamespacedName namespacedName = null;
        DatabaseName databaseName = name;
        if (databaseName instanceof NamespacedName) {
            bl = true;
            namespacedName = (NamespacedName)databaseName;
            Option option2 = namespacedName.namespace();
            if (None$.MODULE$.equals(option2)) {
                return new AdministrationCommandRuntime.DatabaseNameFields(this.internalPrefix() + nameKey, (Value)Values.utf8Value((String)((String)valueMapper.apply((Object)namespacedName.name()))), this.internalPrefix() + nameKey + "_namespace", (Value)Values.utf8Value((String)"system-root"), this.internalPrefix() + nameKey + "_displayName", (Value)Values.utf8Value((String)((String)valueMapper.apply((Object)namespacedName.name()))), false, AdministrationCommandRuntime$IdentityConverter$.MODULE$);
            }
        }
        if (bl && (option = namespacedName.namespace()) instanceof Some) {
            Some some = (Some)option;
            String namespace = (String)some.value();
            String string = namespace;
            String string2 = "system-root";
            return new AdministrationCommandRuntime.DatabaseNameFields(this.internalPrefix() + nameKey, (Value)Values.utf8Value((String)((String)valueMapper.apply((Object)namespacedName.name()))), this.internalPrefix() + nameKey + "_namespace", (Value)Values.utf8Value((String)((String)valueMapper.apply((Object)namespace))), this.internalPrefix() + nameKey + "_displayName", (Value)Values.utf8Value((String)(!(string != null ? !string.equals(string2) : string2 != null) ? (String)valueMapper.apply((Object)namespacedName.name()) : (String)valueMapper.apply((Object)namespace) + "." + valueMapper.apply((Object)namespacedName.name()))), false, AdministrationCommandRuntime$IdentityConverter$.MODULE$);
        }
        if (!(databaseName instanceof ParameterName)) throw new MatchError((Object)databaseName);
        ParameterName parameterName = (ParameterName)databaseName;
        Parameter parameter = parameterName.parameter();
        String displayNameKey = this.internalKey(parameter.name() + "_displayName");
        return new AdministrationCommandRuntime.DatabaseNameFields((String)AdministrationCommandRuntime$.rename$2().apply((Object)parameter.name()), Values.NO_VALUE, this.internalKey(parameter.name() + "_namespace"), (Value)Values.utf8Value((String)"system-root"), displayNameKey, Values.NO_VALUE, true, (Function2<Transaction, MapValue, MapValue>)(Function2 & Serializable)(x$13, params) -> {
            MapValue mapValue;
            AnyValue paramValue = params.get(parameter.name());
            if (!(paramValue instanceof TextValue)) {
                throw new ParameterWrongTypeException("Expected parameter $" + parameter.name() + " to have type String but was " + paramValue);
            }
            String[] nameParts = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(((TextValue)paramValue).stringValue()), '.');
            if (nameParts.length == 1) {
                mapValue = params.updatedWith((String)AdministrationCommandRuntime$.rename$2().apply((Object)parameter.name()), (AnyValue)Values.utf8Value((String)((String)valueMapper.apply((Object)nameParts[0])))).updatedWith(displayNameKey, (AnyValue)Values.utf8Value((String)((String)valueMapper.apply((Object)nameParts[0]))));
            } else {
                AnyValue displayName = nameParts[0].equals("system-root") ? Values.utf8Value((String)((String)valueMapper.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.tail$extension(Predef$.MODULE$.refArrayOps((Object[])nameParts))).mkString(".")))) : paramValue;
                mapValue = params.updatedWith(MODULE$.internalKey(parameter.name() + "_namespace"), (AnyValue)Values.utf8Value((String)((String)valueMapper.apply((Object)nameParts[0])))).updatedWith(MODULE$.internalKey(parameter.name()), (AnyValue)Values.utf8Value((String)((String)valueMapper.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.tail$extension(Predef$.MODULE$.refArrayOps((Object[])nameParts))).mkString("."))))).updatedWith(displayNameKey, displayName);
            }
            return mapValue;
        });
    }

    public String runtimeStringValue(DatabaseName field, MapValue params) {
        String string;
        DatabaseName databaseName = field;
        if (databaseName instanceof NamespacedName) {
            NamespacedName namespacedName = (NamespacedName)databaseName;
            string = namespacedName.toString();
        } else if (databaseName instanceof ParameterName) {
            ParameterName parameterName = (ParameterName)databaseName;
            Parameter p = parameterName.parameter();
            string = this.runtimeStringValue(p.name(), params);
        } else {
            throw new MatchError((Object)databaseName);
        }
        return string;
    }

    public String runtimeStringValue(Either<String, Parameter> field, MapValue params) {
        String string;
        Either<String, Parameter> either = field;
        if (either instanceof Left) {
            String s;
            Left left = (Left)either;
            string = s = (String)left.value();
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Parameter p = (Parameter)right.value();
            string = this.runtimeStringValue(p.name(), params);
        } else {
            throw new MatchError(either);
        }
        return string;
    }

    public String runtimeStringValue(String parameter, MapValue params) {
        AnyValue value = params.containsKey(parameter) ? params.get(parameter) : params.get(this.internalKey(parameter));
        AnyValue anyValue = value;
        if (!(anyValue instanceof TextValue)) {
            throw new ParameterWrongTypeException("Expected parameter $" + parameter + " to have type String but was " + value);
        }
        TextValue textValue = (TextValue)anyValue;
        String string = textValue.stringValue();
        return string;
    }

    public Tuple2<MapValue, Set<InternalNotification>> checkNamespaceExists(AdministrationCommandRuntime.DatabaseNameFields aliasNameFields, Transaction tx, MapValue params) {
        Tuple2 tuple2;
        String string = AdministrationCommandRuntime$.paramString$1(aliasNameFields.namespaceKey(), params);
        String string2 = "system-root";
        if (string == null ? string2 != null : !string.equals(string2)) {
            boolean compositeDatabaseExists = BoxesRunTime.unboxToBoolean((Object)Using$.MODULE$.resource((Object)tx.findNodes(TopologyGraphDbmsModel.DATABASE_NAME_LABEL, "name", (Object)AdministrationCommandRuntime$.paramString$1(aliasNameFields.namespaceKey(), params)), (Function1 & Serializable)nodes -> BoxesRunTime.boxToBoolean((boolean)AdministrationCommandRuntime$.$anonfun$checkNamespaceExists$1(nodes)), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$));
            if (!compositeDatabaseExists) {
                String aliasName = AdministrationCommandRuntime$.paramString$1(aliasNameFields.namespaceKey(), params) + "." + AdministrationCommandRuntime$.paramString$1(aliasNameFields.nameKey(), params);
                tuple2 = new Tuple2((Object)params.updatedWith(aliasNameFields.nameKey(), (AnyValue)Values.utf8Value((String)aliasName)).updatedWith(aliasNameFields.namespaceKey(), (AnyValue)Values.utf8Value((String)"system-root")), aliasNameFields.wasParameter() ? Predef$.MODULE$.Set().empty() : Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InternalNotification[]{new DeprecatedDatabaseNameNotification(aliasName, (Option)None$.MODULE$)})));
            } else {
                tuple2 = new Tuple2((Object)params, (Object)Predef$.MODULE$.Set().empty());
            }
        } else {
            tuple2 = new Tuple2((Object)params, (Object)Predef$.MODULE$.Set().empty());
        }
        return tuple2;
    }

    private final MapValue convertPasswordParameters$1(MapValue params, Parameter x2$1, boolean isEncryptedPassword$1, String hashedPwKey$1, String passwordByteKey$1) {
        byte[] encodedPassword = this.getValidPasswordParameter(params, x2$1.name());
        TextValue hashedPassword = isEncryptedPassword$1 ? this.validateAndFormatEncryptedPassword(encodedPassword) : this.hashPassword(this.validatePassword(encodedPassword));
        return params.updatedWith(hashedPwKey$1, (AnyValue)hashedPassword).updatedWith(passwordByteKey$1, (AnyValue)Values.byteArray((byte[])encodedPassword));
    }

    public static final /* synthetic */ void $anonfun$ensureUniqueParamName$1(ObjectRef uniqueName$1, String otherParamName) {
        block0: {
            if (!otherParamName.equals((String)uniqueName$1.elem)) break block0;
            uniqueName$1.elem = (String)uniqueName$1.elem + "_";
        }
    }

    public static final /* synthetic */ void $anonfun$makeCreateUserExecutionPlan$13(AdministrationCommandRuntime.PasswordExpression credentials$1, MapValue p) {
        ((ByteArray)p.get(credentials$1.bytesKey())).zero();
    }

    public static final /* synthetic */ Product $anonfun$makeAlterUserExecutionPlan$17(Option maybePw$1, Either userName$2, int x$11, AnyValue value, MapValue p) {
        return (Product)maybePw$1.map((Function1 & Serializable)newPw -> {
            byte[] newValue;
            SystemGraphCredential oldCredentials = SystemGraphCredential.deserialize(((TextValue)value).stringValue(), MODULE$.secureHasher());
            return oldCredentials.matchesPassword(newValue = ((ByteArray)p.get(newPw.bytesKey())).asObject()) ? new ThrowException((Throwable)new InvalidArgumentException("Failed to alter the specified user '" + MODULE$.runtimeStringValue((Either<String, Parameter>)userName$2, p) + "': Old password and new password cannot be the same.")) : Continue$.MODULE$;
        }).getOrElse((Function0 & Serializable)() -> Continue$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$makeAlterUserExecutionPlan$21(MapValue p$4, AdministrationCommandRuntime.PasswordExpression newPw) {
        ((ByteArray)p$4.get(newPw.bytesKey())).zero();
    }

    private static final Function1 rename$1() {
        return (Function1 & Serializable)paramName -> MODULE$.internalKey((String)paramName);
    }

    private static final Function1 rename$2() {
        return (Function1 & Serializable)paramName -> MODULE$.internalKey((String)paramName);
    }

    private static final String paramString$1(String key, MapValue params$2) {
        return ((StringValue)params$2.get(key)).stringValue();
    }

    public static final /* synthetic */ boolean $anonfun$checkNamespaceExists$2(Node n) {
        return n.getProperty("namespace").equals("system-root") && n.getSingleRelationship(TopologyGraphDbmsModel.TARGETS_RELATIONSHIP, Direction.OUTGOING).getEndNode().hasLabel(TopologyGraphDbmsModel.COMPOSITE_DATABASE_LABEL);
    }

    public static final /* synthetic */ boolean $anonfun$checkNamespaceExists$1(ResourceIterator nodes) {
        return CollectionConverters$.MODULE$.IteratorHasAsScala((Iterator)nodes).asScala().exists((Function1 & Serializable)n -> BoxesRunTime.boxToBoolean((boolean)AdministrationCommandRuntime$.$anonfun$checkNamespaceExists$2(n)));
    }

    private AdministrationCommandRuntime$() {
    }
}

