/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Serializable;
import java.time.Clock;
import org.neo4j.cypher.internal.FineToReuse$;
import org.neo4j.cypher.internal.MaybeReusable;
import org.neo4j.cypher.internal.NeedsReplan;
import org.neo4j.cypher.internal.NotStale$;
import org.neo4j.cypher.internal.PlanFingerprint;
import org.neo4j.cypher.internal.PlanFingerprintReference;
import org.neo4j.cypher.internal.PlanStalenessCaller;
import org.neo4j.cypher.internal.ReusabilityState;
import org.neo4j.cypher.internal.Stale;
import org.neo4j.cypher.internal.Staleness;
import org.neo4j.cypher.internal.compiler.StatsDivergenceCalculator;
import org.neo4j.cypher.internal.planner.spi.DivergenceState;
import org.neo4j.cypher.internal.planner.spi.GraphStatistics;
import org.neo4j.cypher.internal.planner.spi.GraphStatisticsSnapshot;
import org.neo4j.cypher.internal.spi.TransactionBoundGraphStatistics$;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.logging.InternalLog;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.reflect.ScalaSignature;
import scala.runtime.LazyLong;

@ScalaSignature(bytes="\u0006\u0005u4A!\u0003\u0006\u0001'!A!\u0006\u0001B\u0001B\u0003%1\u0006\u0003\u00054\u0001\t\u0005\t\u0015!\u00035\u0011!Q\u0004A!A!\u0002\u0013Y\u0004\u0002C!\u0001\u0005\u0003\u0005\u000b\u0011\u0002\"\t\u0011I\u0003!\u0011!Q\u0001\nMCQ!\u0017\u0001\u0005\u0002iCQ!\u0019\u0001\u0005B\tDa!\u0019\u0001\u0005\u0002)Q'A\u0007#fM\u0006,H\u000e\u001e)mC:\u001cF/\u00197f]\u0016\u001c8oQ1mY\u0016\u0014(BA\u0006\r\u0003!Ig\u000e^3s]\u0006d'BA\u0007\u000f\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011q\u0002E\u0001\u0006]\u0016|GG\u001b\u0006\u0002#\u0005\u0019qN]4\u0004\u0001U\u0011A#I\n\u0004\u0001UY\u0002C\u0001\f\u001a\u001b\u00059\"\"\u0001\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005i9\"AB!osJ+g\rE\u0002\u001d;}i\u0011AC\u0005\u0003=)\u00111\u0003\u00157b]N#\u0018\r\\3oKN\u001c8)\u00197mKJ\u0004\"\u0001I\u0011\r\u0001\u0011)!\u0005\u0001b\u0001G\t\u0001R\tW#D+R\u000b%\tT#`#V+%+W\t\u0003I\u001d\u0002\"AF\u0013\n\u0005\u0019:\"a\u0002(pi\"Lgn\u001a\t\u0003-!J!!K\f\u0003\u0007\u0005s\u00170A\u0003dY>\u001c7\u000e\u0005\u0002-c5\tQF\u0003\u0002/_\u0005!A/[7f\u0015\u0005\u0001\u0014\u0001\u00026bm\u0006L!AM\u0017\u0003\u000b\rcwnY6\u0002)\u0011Lg/\u001a:hK:\u001cWmQ1mGVd\u0017\r^8s!\t)\u0004(D\u00017\u0015\t9$\"\u0001\u0005d_6\u0004\u0018\u000e\\3s\u0013\tIdGA\rTi\u0006$8\u000fR5wKJ<WM\\2f\u0007\u0006d7-\u001e7bi>\u0014\u0018!\u00077bgR\u001cu.\\7jiR,G\r\u0016=JIB\u0013xN^5eKJ\u00042A\u0006\u001f?\u0013\titCA\u0005Gk:\u001cG/[8oaA\u0011acP\u0005\u0003\u0001^\u0011A\u0001T8oO\u0006y!/Z;tC\nLG.\u001b;z\u0013:4w\u000eE\u0003\u0017\u0007~)u*\u0003\u0002E/\tIa)\u001e8di&|gN\r\t\u0003\r6k\u0011a\u0012\u0006\u0003\u0011&\u000bQ!];fefT!AS&\u0002\t%l\u0007\u000f\u001c\u0006\u0003\u0019:\taa[3s]\u0016d\u0017B\u0001(H\u0005Q!&/\u00198tC\u000e$\u0018n\u001c8bY\u000e{g\u000e^3yiB\u0011A\u0004U\u0005\u0003#*\u0011\u0001CU3vg\u0006\u0014\u0017\u000e\\5usN#\u0018\r^3\u0002\u00071|w\r\u0005\u0002U/6\tQK\u0003\u0002W\u001d\u00059An\\4hS:<\u0017B\u0001-V\u0005-Ie\u000e^3s]\u0006dGj\\4\u0002\rqJg.\u001b;?)\u0019YF,\u00180`AB\u0019A\u0004A\u0010\t\u000b)2\u0001\u0019A\u0016\t\u000bM2\u0001\u0019\u0001\u001b\t\u000bi2\u0001\u0019A\u001e\t\u000b\u00053\u0001\u0019\u0001\"\t\u000bI3\u0001\u0019A*\u0002\u0013M$\u0018\r\\3oKN\u001cHcA2gQB\u0011A\u0004Z\u0005\u0003K*\u0011\u0011b\u0015;bY\u0016tWm]:\t\u000b\u001d<\u0001\u0019A#\u0002)Q\u0014\u0018M\\:bGRLwN\\1m\u0007>tG/\u001a=u\u0011\u0015Iw\u00011\u0001 \u0003U\u0019\u0017m\u00195fI\u0016CXmY;uC\ndW-U;fef$2aY6q\u0011\u0015a\u0007\u00021\u0001n\u0003\r\u0011XM\u001a\t\u000399L!a\u001c\u0006\u00031Ac\u0017M\u001c$j]\u001e,'\u000f\u001d:j]R\u0014VMZ3sK:\u001cW\r\u0003\u0004r\u0011\u0011\u0005\rA]\u0001\u000bgR\fG/[:uS\u000e\u001c\bc\u0001\ftk&\u0011Ao\u0006\u0002\ty\tLh.Y7f}A\u0011ao_\u0007\u0002o*\u0011\u00010_\u0001\u0004gBL'B\u0001>\u000b\u0003\u001d\u0001H.\u00198oKJL!\u0001`<\u0003\u001f\u001d\u0013\u0018\r\u001d5Ti\u0006$\u0018n\u001d;jGN\u0004")
public class DefaultPlanStalenessCaller<EXECUTABLE_QUERY>
implements PlanStalenessCaller<EXECUTABLE_QUERY> {
    private final Clock clock;
    private final StatsDivergenceCalculator divergenceCalculator;
    private final Function0<Object> lastCommittedTxIdProvider;
    private final Function2<EXECUTABLE_QUERY, TransactionalContext, ReusabilityState> reusabilityInfo;
    private final InternalLog log;

    @Override
    public Staleness staleness(TransactionalContext transactionalContext, EXECUTABLE_QUERY cachedExecutableQuery) {
        Staleness staleness;
        ReusabilityState reusability = (ReusabilityState)this.reusabilityInfo.apply(cachedExecutableQuery, (Object)transactionalContext);
        ReusabilityState reusabilityState = reusability;
        if (reusabilityState instanceof MaybeReusable) {
            MaybeReusable maybeReusable = (MaybeReusable)reusabilityState;
            PlanFingerprintReference ref = maybeReusable.fingerprint();
            KernelTransaction ktx = transactionalContext.kernelTransaction();
            staleness = this.staleness(ref, (Function0<GraphStatistics>)(Function0 & Serializable)() -> TransactionBoundGraphStatistics$.MODULE$.apply(ktx.dataRead(), ktx.schemaRead(), $this.log));
        } else if (FineToReuse$.MODULE$.equals(reusabilityState)) {
            staleness = NotStale$.MODULE$;
        } else if (reusabilityState instanceof NeedsReplan) {
            NeedsReplan needsReplan = (NeedsReplan)reusabilityState;
            int x = needsReplan.secondsSincePlan();
            staleness = new Stale(x, (Option<String>)None$.MODULE$);
        } else {
            throw new MatchError((Object)reusabilityState);
        }
        return staleness;
    }

    public Staleness staleness(PlanFingerprintReference ref, Function0<GraphStatistics> statistics) {
        Product product;
        LazyLong currentTimeMillis$lzy = new LazyLong();
        LazyLong lastCommittedTxId$lzy = new LazyLong();
        PlanFingerprint f = ref.fingerprint();
        if (this.divergenceCalculator.shouldCheck(this.currentTimeMillis$1(currentTimeMillis$lzy), f.lastCheckTimeMillis()) && this.lastCommittedTxId$1(lastCommittedTxId$lzy) != f.lastCommittedTxId()) {
            double threshold = this.divergenceCalculator.decay(this.currentTimeMillis$1(currentTimeMillis$lzy) - f.creationTimeMillis());
            DivergenceState divergence = f.snapshot().diverges(f.snapshot().recompute((GraphStatistics)statistics.apply()));
            if (divergence.divergence() > threshold) {
                product = new Stale((int)((this.currentTimeMillis$1(currentTimeMillis$lzy) - f.creationTimeMillis()) / 1000L), (Option<String>)Option$.MODULE$.apply((Object)(divergence.key() + " changed from " + divergence.before() + " to " + divergence.after() + ", " + ("which is a divergence of " + divergence.divergence() + " which is greater than ") + ("threshold " + threshold))));
            } else {
                long x$1 = this.currentTimeMillis$1(currentTimeMillis$lzy);
                long x$2 = this.lastCommittedTxId$1(lastCommittedTxId$lzy);
                long x$3 = f.copy$default$1();
                GraphStatisticsSnapshot x$4 = f.copy$default$4();
                ref.fingerprint_$eq(f.copy(x$3, x$1, x$2, x$4));
                product = NotStale$.MODULE$;
            }
        } else {
            long x$5 = this.currentTimeMillis$1(currentTimeMillis$lzy);
            long x$6 = f.copy$default$1();
            long x$7 = f.copy$default$3();
            GraphStatisticsSnapshot x$8 = f.copy$default$4();
            ref.fingerprint_$eq(f.copy(x$6, x$5, x$7, x$8));
            product = NotStale$.MODULE$;
        }
        return product;
    }

    private final /* synthetic */ long currentTimeMillis$lzycompute$1(LazyLong currentTimeMillis$lzy$1) {
        long l;
        LazyLong lazyLong = currentTimeMillis$lzy$1;
        synchronized (lazyLong) {
            l = currentTimeMillis$lzy$1.initialized() ? currentTimeMillis$lzy$1.value() : currentTimeMillis$lzy$1.initialize(this.clock.millis());
        }
        return l;
    }

    private final long currentTimeMillis$1(LazyLong currentTimeMillis$lzy$1) {
        return currentTimeMillis$lzy$1.initialized() ? currentTimeMillis$lzy$1.value() : this.currentTimeMillis$lzycompute$1(currentTimeMillis$lzy$1);
    }

    private final /* synthetic */ long lastCommittedTxId$lzycompute$1(LazyLong lastCommittedTxId$lzy$1) {
        long l;
        LazyLong lazyLong = lastCommittedTxId$lzy$1;
        synchronized (lazyLong) {
            l = lastCommittedTxId$lzy$1.initialized() ? lastCommittedTxId$lzy$1.value() : lastCommittedTxId$lzy$1.initialize(this.lastCommittedTxIdProvider.apply$mcJ$sp());
        }
        return l;
    }

    private final long lastCommittedTxId$1(LazyLong lastCommittedTxId$lzy$1) {
        return lastCommittedTxId$lzy$1.initialized() ? lastCommittedTxId$lzy$1.value() : this.lastCommittedTxId$lzycompute$1(lastCommittedTxId$lzy$1);
    }

    public DefaultPlanStalenessCaller(Clock clock, StatsDivergenceCalculator divergenceCalculator, Function0<Object> lastCommittedTxIdProvider, Function2<EXECUTABLE_QUERY, TransactionalContext, ReusabilityState> reusabilityInfo, InternalLog log) {
        this.clock = clock;
        this.divergenceCalculator = divergenceCalculator;
        this.lastCommittedTxIdProvider = lastCommittedTxIdProvider;
        this.reusabilityInfo = reusabilityInfo;
        this.log = log;
    }
}

