/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Serializable;
import org.neo4j.cypher.internal.MapValueOps$;
import org.neo4j.cypher.internal.OptionsConverter;
import org.neo4j.cypher.internal.ServerOptions;
import org.neo4j.cypher.internal.ast.Options;
import org.neo4j.cypher.internal.evaluator.ExpressionEvaluator;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.dbms.systemgraph.InstanceModeConstraint;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class ServerOptionsConverter$
implements OptionsConverter<ServerOptions>,
Product,
Serializable {
    public static final ServerOptionsConverter$ MODULE$ = new ServerOptionsConverter$();
    private static final String ALLOWED_DATABASES;
    private static final String DENIED_DATABASES;
    private static final String MODE_CONSTRAINT;
    private static final String VISIBLE_PERMITTED_OPTIONS;
    private static ExpressionEvaluator evaluator;

    static {
        OptionsConverter.$init$(MODULE$);
        Product.$init$((Product)MODULE$);
        ALLOWED_DATABASES = "allowedDatabases";
        DENIED_DATABASES = "deniedDatabases";
        MODE_CONSTRAINT = "modeConstraint";
        VISIBLE_PERMITTED_OPTIONS = "'" + MODULE$.ALLOWED_DATABASES() + "', '" + MODULE$.DENIED_DATABASES() + "', '" + MODULE$.MODE_CONSTRAINT() + "'";
    }

    public String productElementName(int n) {
        return Product.productElementName$((Product)this, (int)n);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    @Override
    public AnyValue evaluate(Expression expression, MapValue params) {
        return OptionsConverter.evaluate$(this, expression, params);
    }

    @Override
    public Option<ServerOptions> convert(Options options, MapValue params) {
        return OptionsConverter.convert$(this, options, params);
    }

    @Override
    public ExpressionEvaluator evaluator() {
        return evaluator;
    }

    @Override
    public void org$neo4j$cypher$internal$OptionsConverter$_setter_$evaluator_$eq(ExpressionEvaluator x$1) {
        evaluator = x$1;
    }

    private String ALLOWED_DATABASES() {
        return ALLOWED_DATABASES;
    }

    private String DENIED_DATABASES() {
        return DENIED_DATABASES;
    }

    private String MODE_CONSTRAINT() {
        return MODE_CONSTRAINT;
    }

    public String VISIBLE_PERMITTED_OPTIONS() {
        return VISIBLE_PERMITTED_OPTIONS;
    }

    @Override
    public String operation() {
        return "enable server";
    }

    @Override
    public ServerOptions convert(MapValue map) {
        return MapValueOps$.MODULE$.Ops(map).foldLeft(new ServerOptions((Option<Set<NormalizedDatabaseName>>)None$.MODULE$, (Option<Set<NormalizedDatabaseName>>)None$.MODULE$, (Option<InstanceModeConstraint>)None$.MODULE$), (Function2 & Serializable)(x0$1, x1$1) -> {
            ServerOptions serverOptions;
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            ServerOptions ops = (ServerOptions)tuple2._1();
            Tuple2 tuple22 = (Tuple2)tuple2._2();
            if (tuple22 == null) throw new MatchError((Object)tuple2);
            String key = (String)tuple22._1();
            AnyValue value = (AnyValue)tuple22._2();
            if (key.equalsIgnoreCase(MODULE$.ALLOWED_DATABASES())) {
                ServerOptions serverOptions2;
                AnyValue anyValue = value;
                if (anyValue instanceof ListValue) {
                    ListValue listValue = (ListValue)anyValue;
                    Set databases = CollectionConverters$.MODULE$.IteratorHasAsScala(listValue.iterator()).asScala().map((Function1 & Serializable)x0$2 -> {
                        AnyValue anyValue = x0$2;
                        if (!(anyValue instanceof TextValue)) {
                            throw new InvalidArgumentsException(MODULE$.ALLOWED_DATABASES() + " expects a list of database names but got '" + listValue + "'.");
                        }
                        TextValue textValue = (TextValue)anyValue;
                        NormalizedDatabaseName normalizedDatabaseName = new NormalizedDatabaseName(textValue.stringValue());
                        return normalizedDatabaseName;
                    }).toSet();
                    serverOptions2 = ops.copy((Option<Set<NormalizedDatabaseName>>)new Some((Object)databases), ops.copy$default$2(), ops.copy$default$3());
                } else if (anyValue instanceof TextValue) {
                    TextValue textValue = (TextValue)anyValue;
                    serverOptions2 = ops.copy((Option<Set<NormalizedDatabaseName>>)new Some(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NormalizedDatabaseName[]{new NormalizedDatabaseName(textValue.stringValue())}))), ops.copy$default$2(), ops.copy$default$3());
                } else {
                    if (anyValue == null) throw new MatchError((Object)anyValue);
                    AnyValue anyValue2 = anyValue;
                    throw new InvalidArgumentsException(MODULE$.ALLOWED_DATABASES() + " expects a list of database names but got '" + anyValue2 + "'.");
                }
                serverOptions = serverOptions2;
                return serverOptions;
            } else if (key.equalsIgnoreCase(MODULE$.DENIED_DATABASES())) {
                ServerOptions serverOptions3;
                AnyValue anyValue = value;
                if (anyValue instanceof ListValue) {
                    ListValue listValue = (ListValue)anyValue;
                    Set databases = CollectionConverters$.MODULE$.IteratorHasAsScala(listValue.iterator()).asScala().map((Function1 & Serializable)x0$3 -> {
                        AnyValue anyValue = x0$3;
                        if (!(anyValue instanceof TextValue)) {
                            throw new InvalidArgumentsException(MODULE$.DENIED_DATABASES() + " expects a list of database names but got '" + listValue + "'.");
                        }
                        TextValue textValue = (TextValue)anyValue;
                        NormalizedDatabaseName normalizedDatabaseName = new NormalizedDatabaseName(textValue.stringValue());
                        return normalizedDatabaseName;
                    }).toSet();
                    Some x$1 = new Some((Object)databases);
                    Option<Set<NormalizedDatabaseName>> x$2 = ops.copy$default$1();
                    Option<InstanceModeConstraint> x$3 = ops.copy$default$3();
                    serverOptions3 = ops.copy(x$2, (Option<Set<NormalizedDatabaseName>>)x$1, x$3);
                } else if (anyValue instanceof TextValue) {
                    TextValue textValue = (TextValue)anyValue;
                    Some x$4 = new Some(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NormalizedDatabaseName[]{new NormalizedDatabaseName(textValue.stringValue())})));
                    Option<Set<NormalizedDatabaseName>> x$5 = ops.copy$default$1();
                    Option<InstanceModeConstraint> x$6 = ops.copy$default$3();
                    serverOptions3 = ops.copy(x$5, (Option<Set<NormalizedDatabaseName>>)x$4, x$6);
                } else {
                    if (anyValue == null) throw new MatchError((Object)anyValue);
                    AnyValue anyValue3 = anyValue;
                    throw new InvalidArgumentsException(MODULE$.DENIED_DATABASES() + " expects a list of database names but got '" + anyValue3 + "'.");
                }
                serverOptions = serverOptions3;
                return serverOptions;
            } else {
                InstanceModeConstraint instanceModeConstraint;
                if (!key.equalsIgnoreCase(MODULE$.MODE_CONSTRAINT())) throw new InvalidArgumentsException("Unrecognised option '" + key + "', expected " + MODULE$.VISIBLE_PERMITTED_OPTIONS() + ".");
                AnyValue anyValue = value;
                if (anyValue instanceof TextValue) {
                    TextValue textValue = (TextValue)anyValue;
                    try {
                        instanceModeConstraint = InstanceModeConstraint.valueOf((String)textValue.stringValue().toUpperCase());
                    }
                    catch (Exception exception) {
                        throw new InvalidArgumentsException(MODULE$.MODE_CONSTRAINT() + " expects 'NONE', 'PRIMARY' or 'SECONDARY' but got '" + value + "'.");
                    }
                } else {
                    if (anyValue == null) throw new MatchError((Object)anyValue);
                    AnyValue anyValue4 = anyValue;
                    throw new InvalidArgumentsException(MODULE$.MODE_CONSTRAINT() + " expects 'NONE', 'PRIMARY' or 'SECONDARY' but got '" + anyValue4 + "'.");
                }
                InstanceModeConstraint mode = instanceModeConstraint;
                Some x$7 = new Some((Object)mode);
                Option<Set<NormalizedDatabaseName>> x$8 = ops.copy$default$1();
                Option<Set<NormalizedDatabaseName>> x$9 = ops.copy$default$2();
                ServerOptions serverOptions4 = ops.copy(x$8, x$9, (Option<InstanceModeConstraint>)x$7);
                serverOptions = serverOptions4;
            }
            return serverOptions;
        });
    }

    public String productPrefix() {
        return "ServerOptionsConverter";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        Object object = Statics.ioobe((int)x$1);
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ServerOptionsConverter$;
    }

    public int hashCode() {
        return -1985745371;
    }

    public String toString() {
        return "ServerOptionsConverter";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ServerOptionsConverter$.class);
    }

    private ServerOptionsConverter$() {
    }
}

