/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.spi;

import java.io.Serializable;
import java.util.Optional;
import org.neo4j.cypher.internal.frontend.phases.DeprecationInfo;
import org.neo4j.cypher.internal.frontend.phases.FieldSignature;
import org.neo4j.cypher.internal.frontend.phases.FieldSignature$;
import org.neo4j.cypher.internal.frontend.phases.ProcedureAccessMode;
import org.neo4j.cypher.internal.frontend.phases.ProcedureDbmsAccess$;
import org.neo4j.cypher.internal.frontend.phases.ProcedureReadOnlyAccess$;
import org.neo4j.cypher.internal.frontend.phases.ProcedureReadWriteAccess$;
import org.neo4j.cypher.internal.frontend.phases.ProcedureSchemaWriteAccess$;
import org.neo4j.cypher.internal.frontend.phases.ProcedureSignature;
import org.neo4j.cypher.internal.frontend.phases.QualifiedName;
import org.neo4j.cypher.internal.util.symbols.CypherType;
import org.neo4j.cypher.internal.util.symbols.package$;
import org.neo4j.exceptions.CypherExecutionException;
import org.neo4j.internal.kernel.api.procs.DefaultParameterValue;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.procedure.Mode;
import org.neo4j.values.AnyValue;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.IndexedSeq;
import scala.jdk.CollectionConverters$;

public final class procsHelpers$ {
    public static final procsHelpers$ MODULE$ = new procsHelpers$();

    public <T> Option<T> asOption(Optional<T> optional) {
        if (optional.isPresent()) {
            return new Some(optional.get());
        }
        return None$.MODULE$;
    }

    public ProcedureAccessMode asCypherProcMode(Mode mode) {
        Mode mode2 = mode;
        if (Mode.READ.equals(mode2)) {
            return ProcedureReadOnlyAccess$.MODULE$;
        }
        if (Mode.DEFAULT.equals(mode2)) {
            return ProcedureReadOnlyAccess$.MODULE$;
        }
        if (Mode.WRITE.equals(mode2)) {
            return ProcedureReadWriteAccess$.MODULE$;
        }
        if (Mode.SCHEMA.equals(mode2)) {
            return ProcedureSchemaWriteAccess$.MODULE$;
        }
        if (Mode.DBMS.equals(mode2)) {
            return ProcedureDbmsAccess$.MODULE$;
        }
        throw new CypherExecutionException("Unable to execute procedure, because it requires an unrecognized execution mode: " + mode.name(), null);
    }

    public AnyValue asCypherValue(DefaultParameterValue neo4jValue) {
        return ValueUtils.of((Object)neo4jValue.value());
    }

    public CypherType asCypherType(Neo4jTypes.AnyType neoType) {
        Neo4jTypes.AnyType anyType = neoType;
        Neo4jTypes.TextType textType = Neo4jTypes.NTString;
        Neo4jTypes.AnyType anyType2 = anyType;
        if (!(textType != null ? !textType.equals(anyType2) : anyType2 != null)) {
            return package$.MODULE$.CTString();
        }
        Neo4jTypes.IntegerType integerType = Neo4jTypes.NTInteger;
        Neo4jTypes.AnyType anyType3 = anyType;
        if (!(integerType != null ? !integerType.equals(anyType3) : anyType3 != null)) {
            return package$.MODULE$.CTInteger();
        }
        Neo4jTypes.FloatType floatType = Neo4jTypes.NTFloat;
        Neo4jTypes.AnyType anyType4 = anyType;
        if (!(floatType != null ? !floatType.equals(anyType4) : anyType4 != null)) {
            return package$.MODULE$.CTFloat();
        }
        Neo4jTypes.NumberType numberType = Neo4jTypes.NTNumber;
        Neo4jTypes.AnyType anyType5 = anyType;
        if (!(numberType != null ? !numberType.equals(anyType5) : anyType5 != null)) {
            return package$.MODULE$.CTNumber();
        }
        Neo4jTypes.BooleanType booleanType = Neo4jTypes.NTBoolean;
        Neo4jTypes.AnyType anyType6 = anyType;
        if (!(booleanType != null ? !booleanType.equals(anyType6) : anyType6 != null)) {
            return package$.MODULE$.CTBoolean();
        }
        if (anyType instanceof Neo4jTypes.ListType) {
            Neo4jTypes.ListType listType = (Neo4jTypes.ListType)anyType;
            return package$.MODULE$.CTList(this.asCypherType(listType.innerType()));
        }
        Neo4jTypes.ByteArrayType byteArrayType = Neo4jTypes.NTByteArray;
        Neo4jTypes.AnyType anyType7 = anyType;
        if (!(byteArrayType != null ? !byteArrayType.equals(anyType7) : anyType7 != null)) {
            return package$.MODULE$.CTList((CypherType)package$.MODULE$.CTAny());
        }
        Neo4jTypes.DateTimeType dateTimeType = Neo4jTypes.NTDateTime;
        Neo4jTypes.AnyType anyType8 = anyType;
        if (!(dateTimeType != null ? !dateTimeType.equals(anyType8) : anyType8 != null)) {
            return package$.MODULE$.CTDateTime();
        }
        Neo4jTypes.LocalDateTimeType localDateTimeType = Neo4jTypes.NTLocalDateTime;
        Neo4jTypes.AnyType anyType9 = anyType;
        if (!(localDateTimeType != null ? !localDateTimeType.equals(anyType9) : anyType9 != null)) {
            return package$.MODULE$.CTLocalDateTime();
        }
        Neo4jTypes.DateType dateType = Neo4jTypes.NTDate;
        Neo4jTypes.AnyType anyType10 = anyType;
        if (!(dateType != null ? !dateType.equals(anyType10) : anyType10 != null)) {
            return package$.MODULE$.CTDate();
        }
        Neo4jTypes.TimeType timeType = Neo4jTypes.NTTime;
        Neo4jTypes.AnyType anyType11 = anyType;
        if (!(timeType != null ? !timeType.equals(anyType11) : anyType11 != null)) {
            return package$.MODULE$.CTTime();
        }
        Neo4jTypes.LocalTimeType localTimeType = Neo4jTypes.NTLocalTime;
        Neo4jTypes.AnyType anyType12 = anyType;
        if (!(localTimeType != null ? !localTimeType.equals(anyType12) : anyType12 != null)) {
            return package$.MODULE$.CTLocalTime();
        }
        Neo4jTypes.DurationType durationType = Neo4jTypes.NTDuration;
        Neo4jTypes.AnyType anyType13 = anyType;
        if (!(durationType != null ? !durationType.equals(anyType13) : anyType13 != null)) {
            return package$.MODULE$.CTDuration();
        }
        Neo4jTypes.PointType pointType = Neo4jTypes.NTPoint;
        Neo4jTypes.AnyType anyType14 = anyType;
        if (!(pointType != null ? !pointType.equals(anyType14) : anyType14 != null)) {
            return package$.MODULE$.CTPoint();
        }
        Neo4jTypes.NodeType nodeType = Neo4jTypes.NTNode;
        Neo4jTypes.AnyType anyType15 = anyType;
        if (!(nodeType != null ? !nodeType.equals(anyType15) : anyType15 != null)) {
            return package$.MODULE$.CTNode();
        }
        Neo4jTypes.RelationshipType relationshipType = Neo4jTypes.NTRelationship;
        Neo4jTypes.AnyType anyType16 = anyType;
        if (!(relationshipType != null ? !relationshipType.equals(anyType16) : anyType16 != null)) {
            return package$.MODULE$.CTRelationship();
        }
        Neo4jTypes.PathType pathType = Neo4jTypes.NTPath;
        Neo4jTypes.AnyType anyType17 = anyType;
        if (!(pathType != null ? !pathType.equals(anyType17) : anyType17 != null)) {
            return package$.MODULE$.CTPath();
        }
        Neo4jTypes.GeometryType geometryType = Neo4jTypes.NTGeometry;
        Neo4jTypes.AnyType anyType18 = anyType;
        if (!(geometryType != null ? !geometryType.equals(anyType18) : anyType18 != null)) {
            return package$.MODULE$.CTGeometry();
        }
        Neo4jTypes.MapType mapType = Neo4jTypes.NTMap;
        Neo4jTypes.AnyType anyType19 = anyType;
        if (!(mapType != null ? !mapType.equals(anyType19) : anyType19 != null)) {
            return package$.MODULE$.CTMap();
        }
        Neo4jTypes.AnyType anyType20 = Neo4jTypes.NTAny;
        Neo4jTypes.AnyType anyType21 = anyType;
        if (!(anyType20 != null ? !anyType20.equals(anyType21) : anyType21 != null)) {
            return package$.MODULE$.CTAny();
        }
        throw new IllegalArgumentException("Could not find a valid mapping for the type " + anyType);
    }

    public ProcedureSignature asCypherProcedureSignature(QualifiedName name, int id, org.neo4j.internal.kernel.api.procs.ProcedureSignature signature) {
        IndexedSeq input = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(signature.inputSignature()).asScala().map((Function1 & Serializable)s -> new FieldSignature(s.name(), MODULE$.asCypherType(s.neo4jType()), MODULE$.asOption(s.defaultValue()).map((Function1 & Serializable)neo4jValue -> MODULE$.asCypherValue((DefaultParameterValue)neo4jValue)), s.isDeprecated(), s.isSensitive()))).toIndexedSeq();
        None$ output = signature.isVoid() ? None$.MODULE$ : new Some((Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(signature.outputSignature()).asScala().map((Function1 & Serializable)s -> {
            String x$1 = s.name();
            CypherType x$2 = MODULE$.asCypherType(s.neo4jType());
            boolean x$3 = s.isDeprecated();
            boolean x$4 = s.isSensitive();
            Option x$5 = FieldSignature$.MODULE$.apply$default$3();
            return new FieldSignature(x$1, x$2, x$5, x$3, x$4);
        })).toIndexedSeq());
        Option deprecatedBy = this.asOption(signature.deprecated());
        ProcedureAccessMode mode = this.asCypherProcMode(signature.mode());
        Option description = this.asOption(signature.description());
        Option warning = this.asOption(signature.warning());
        boolean threadSafe = signature.threadSafe();
        return new ProcedureSignature(name, input, (Option)output, (Option)new Some((Object)new DeprecationInfo(signature.isDeprecated(), deprecatedBy)), mode, description, warning, signature.eager(), id, signature.systemProcedure(), signature.allowedExpiredCredentials(), threadSafe);
    }

    private procsHelpers$() {
    }
}

