/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Serializable;
import org.neo4j.cypher.internal.CypherQueryObfuscator$;
import org.neo4j.cypher.internal.util.LiteralOffset;
import org.neo4j.cypher.internal.util.ObfuscationMetadata;
import org.neo4j.kernel.api.query.QueryObfuscator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.MapValue;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005a4AAD\b\u00011!A1\u0006\u0001B\u0001B\u0003%A\u0006C\u00033\u0001\u0011\u00051\u0007C\u00038\u0001\u0011\u0005\u0003\bC\u0003O\u0001\u0011\u0005s\nC\u0003[\u0001\u0011%1lB\u0003`\u001f!\u0005\u0001MB\u0003\u000f\u001f!\u0005\u0011\rC\u00033\u000f\u0011\u0005Q\rC\u0004g\u000f\t\u0007I\u0011B4\t\r)<\u0001\u0015!\u0003i\u0011\u001dYwA1A\u0005\n1Daa]\u0004!\u0002\u0013i\u0007\"\u0002;\b\t\u0003)(!F\"za\",'/U;fef|%MZ;tG\u0006$xN\u001d\u0006\u0003!E\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003%M\taaY=qQ\u0016\u0014(B\u0001\u000b\u0016\u0003\u0015qWm\u001c\u001bk\u0015\u00051\u0012aA8sO\u000e\u00011c\u0001\u0001\u001aCA\u0011!dH\u0007\u00027)\u0011A$H\u0001\u0005Y\u0006twMC\u0001\u001f\u0003\u0011Q\u0017M^1\n\u0005\u0001Z\"AB(cU\u0016\u001cG\u000f\u0005\u0002#S5\t1E\u0003\u0002%K\u0005)\u0011/^3ss*\u0011aeJ\u0001\u0004CBL'B\u0001\u0015\u0014\u0003\u0019YWM\u001d8fY&\u0011!f\t\u0002\u0010#V,'/_(cMV\u001c8-\u0019;pe\u0006)1\u000f^1uKB\u0011Q\u0006M\u0007\u0002])\u0011qfD\u0001\u0005kRLG.\u0003\u00022]\t\u0019rJ\u00194vg\u000e\fG/[8o\u001b\u0016$\u0018\rZ1uC\u00061A(\u001b8jiz\"\"\u0001\u000e\u001c\u0011\u0005U\u0002Q\"A\b\t\u000b-\u0012\u0001\u0019\u0001\u0017\u0002\u001b=\u0014g-^:dCR,G+\u001a=u)\rId\t\u0013\t\u0003u\rs!aO!\u0011\u0005qzT\"A\u001f\u000b\u0005y:\u0012A\u0002\u001fs_>$hHC\u0001A\u0003\u0015\u00198-\u00197b\u0013\t\u0011u(\u0001\u0004Qe\u0016$WMZ\u0005\u0003\t\u0016\u0013aa\u0015;sS:<'B\u0001\"@\u0011\u001595\u00011\u0001:\u00031\u0011\u0018m^)vKJLH+\u001a=u\u0011\u0015I5\u00011\u0001K\u0003=\u0001(/\u001a)beN,'o\u00144gg\u0016$\bCA&M\u001b\u0005y\u0014BA'@\u0005\rIe\u000e^\u0001\u0014_\n4Wo]2bi\u0016\u0004\u0016M]1nKR,'o\u001d\u000b\u0003!b\u0003\"!\u0015,\u000e\u0003IS!a\u0015+\u0002\u000fYL'\u000f^;bY*\u0011QkE\u0001\u0007m\u0006dW/Z:\n\u0005]\u0013&\u0001C'baZ\u000bG.^3\t\u000be#\u0001\u0019\u0001)\u0002%I\fw/U;fef\u0004\u0016M]1nKR,'o]\u0001\u0014Y&$XM]1m'R\u0014\u0018N\\4MK:<G\u000f\u001b\u000b\u0004\u0015rk\u0006\"B$\u0006\u0001\u0004I\u0004\"\u00020\u0006\u0001\u0004Q\u0015!\u00034s_6Le\u000eZ3y\u0003U\u0019\u0015\u0010\u001d5feF+XM]=PE\u001a,8oY1u_J\u0004\"!N\u0004\u0014\u0005\u001d\u0011\u0007CA&d\u0013\t!wH\u0001\u0004B]f\u0014VM\u001a\u000b\u0002A\u0006\u0011rJ\u0011$V'\u000e\u000bE+\u0012#`\u0019&#VIU!M+\u0005A\u0007C\u0001\u000ej\u0013\t!5$A\nP\u0005\u001a+6kQ!U\u000b\u0012{F*\u0013+F%\u0006c\u0005%\u0001\u0006P\u0005\u001a+6kQ!U\u000b\u0012+\u0012!\u001c\t\u0003]Fl\u0011a\u001c\u0006\u0003aR\u000b\u0001b\u001d;pe\u0006\u0014G.Z\u0005\u0003e>\u0014\u0011\u0002V3yiZ\u000bG.^3\u0002\u0017=\u0013e)V*D\u0003R+E\tI\u0001\u0006CB\u0004H.\u001f\u000b\u0003CYDQa^\u0007A\u00021\n1c\u001c2gkN\u001c\u0017\r^5p]6+G/\u00193bi\u0006\u0004")
public class CypherQueryObfuscator
implements QueryObfuscator {
    private final ObfuscationMetadata state;

    public static QueryObfuscator apply(ObfuscationMetadata obfuscationMetadata) {
        return CypherQueryObfuscator$.MODULE$.apply(obfuscationMetadata);
    }

    public String obfuscateText(String rawQueryText, int preParserOffset) {
        if (this.state.sensitiveLiteralOffsets().isEmpty()) {
            return rawQueryText;
        }
        StringBuilder sb = new StringBuilder();
        IntRef i = IntRef.create((int)0);
        this.state.sensitiveLiteralOffsets().foreach((Function1 & Serializable)literalOffset -> {
            CypherQueryObfuscator.$anonfun$obfuscateText$1(this, preParserOffset, rawQueryText, i, sb, literalOffset);
            return BoxedUnit.UNIT;
        });
        Object object = i.elem < rawQueryText.length() ? sb.append(rawQueryText.substring(i.elem)) : BoxedUnit.UNIT;
        return sb.toString();
    }

    public MapValue obfuscateParameters(MapValue rawQueryParameters) {
        if (this.state.sensitiveParameterNames().isEmpty()) {
            return rawQueryParameters;
        }
        ObjectRef params = ObjectRef.create((Object)rawQueryParameters);
        this.state.sensitiveParameterNames().foreach((Function1 & Serializable)p -> {
            params.elem = ((MapValue)params.elem).updatedWith(p, (AnyValue)CypherQueryObfuscator$.MODULE$.org$neo4j$cypher$internal$CypherQueryObfuscator$$OBFUSCATED());
            return BoxedUnit.UNIT;
        });
        return (MapValue)params.elem;
    }

    private int literalStringLength(String rawQueryText, int fromIndex) {
        char first = rawQueryText.charAt(fromIndex);
        if (first == '\"' || first == '\'') {
            for (int lastCharacterIndex = fromIndex; lastCharacterIndex < rawQueryText.length() - 1; ++lastCharacterIndex) {
                if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(rawQueryText), lastCharacterIndex) == '\\' || StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(rawQueryText), lastCharacterIndex + 1) != first) continue;
                return lastCharacterIndex - fromIndex + 2;
            }
            throw new IllegalStateException("Expected to find closing quote.");
        }
        return rawQueryText.length() - fromIndex;
    }

    public static final /* synthetic */ void $anonfun$obfuscateText$1(CypherQueryObfuscator $this, int preParserOffset$1, String rawQueryText$1, IntRef i$1, StringBuilder sb$1, LiteralOffset literalOffset) {
        int start = literalOffset.start(preParserOffset$1);
        if (start >= rawQueryText$1.length() || start < i$1.elem) {
            throw new IllegalStateException("Literal offset out of bounds: " + literalOffset + ".");
        }
        sb$1.append(rawQueryText$1.substring(i$1.elem, start));
        sb$1.append(CypherQueryObfuscator$.MODULE$.org$neo4j$cypher$internal$CypherQueryObfuscator$$OBFUSCATED_LITERAL());
        i$1.elem = start + BoxesRunTime.unboxToInt((Object)literalOffset.length().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> $this.literalStringLength(rawQueryText$1, start)));
    }

    public CypherQueryObfuscator(ObfuscationMetadata state) {
        this.state = state;
    }
}

