/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.spi;

import java.io.Serializable;
import org.neo4j.common.EntityType;
import org.neo4j.cypher.internal.LastCommittedTxIdProvider;
import org.neo4j.cypher.internal.frontend.phases.ProcedureSignature;
import org.neo4j.cypher.internal.frontend.phases.QualifiedName;
import org.neo4j.cypher.internal.frontend.phases.UserFunctionSignature;
import org.neo4j.cypher.internal.logical.plans.CanGetValue$;
import org.neo4j.cypher.internal.logical.plans.DoNotGetValue$;
import org.neo4j.cypher.internal.logical.plans.GetValueFromIndexBehavior;
import org.neo4j.cypher.internal.planner.spi.DatabaseMode$;
import org.neo4j.cypher.internal.planner.spi.EventuallyConsistent$;
import org.neo4j.cypher.internal.planner.spi.IndexDescriptor;
import org.neo4j.cypher.internal.planner.spi.IndexOrderCapability;
import org.neo4j.cypher.internal.planner.spi.InstrumentedGraphStatistics;
import org.neo4j.cypher.internal.planner.spi.PlanContext;
import org.neo4j.cypher.internal.planner.spi.TokenIndexDescriptor;
import org.neo4j.cypher.internal.runtime.QueryTransactionalContext;
import org.neo4j.cypher.internal.runtime.interpreted.TransactionBoundReadTokenContext;
import org.neo4j.cypher.internal.runtime.interpreted.TransactionalContextWrapper;
import org.neo4j.cypher.internal.spi.IndexDescriptorCompatibility;
import org.neo4j.cypher.internal.spi.TransactionBoundPlanContext$;
import org.neo4j.cypher.internal.util.InternalNotificationLogger;
import org.neo4j.cypher.internal.util.LabelId;
import org.neo4j.cypher.internal.util.PropertyKeyId;
import org.neo4j.cypher.internal.util.PropertyKeyId$;
import org.neo4j.cypher.internal.util.RelTypeId;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexBehaviour;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.schema.constraints.SchemaValueType;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.logging.InternalLog;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\ret!\u0002 @\u0011\u0003Qe!\u0002'@\u0011\u0003i\u0005\"\u0002+\u0002\t\u0003)\u0006\"\u0002,\u0002\t\u00039\u0006b\u0002Bm\u0003\u0011\u000511\f\u0005\b\u0005o\fA\u0011AB:\r\u0011au\bA-\t\u001114!\u0011!Q\u0001\n5D\u0001\u0002\u001d\u0004\u0003\u0002\u0003\u0006I!\u001d\u0005\to\u001a\u0011\t\u0011)A\u0005q\")AK\u0002C\u0001w\"1qP\u0002C!\u0003\u0003Aq!a\u000b\u0007\t\u0003\ni\u0003C\u0004\u00024\u0019!\t%!\u000e\t\u000f\u0005eb\u0001\"\u0011\u0002<!9\u0011q\b\u0004\u0005B\u0005\u0005\u0003bBA#\r\u0011\u0005\u0013q\t\u0005\b\u0003\u00172A\u0011BA'\u0011\u001d\tIG\u0002C\u0005\u0003WBq!!\u001d\u0007\t\u0003\n\u0019\bC\u0004\u0002v\u0019!\t%a\u001e\t\u000f\u0005\u0005e\u0001\"\u0011\u0002\u0004\"9\u0011q\u0011\u0004\u0005B\u0005%\u0005bBAV\r\u0011\u0005\u0013Q\u0016\u0005\b\u0003g3A\u0011IA[\u0011\u001d\tYL\u0002C!\u0003{Cq!!2\u0007\t\u0003\n9\rC\u0004\u0002N\u001a!\t%a4\t\u000f\u0005Ug\u0001\"\u0003\u0002X\"9\u0011q\u001c\u0004\u0005\n\u0005\u0005\bbBAu\r\u0011%\u00111\u001e\u0005\b\u0003w4A\u0011IA\u007f\u0011\u001d\u0011)A\u0002C!\u0005\u000fAqA!\u0004\u0007\t\u0003\u0012y\u0001C\u0004\u0003\u0016\u0019!\tEa\u0006\t\u000f\tua\u0001\"\u0011\u0003 !9!Q\u0005\u0004\u0005B\t\u001d\u0002b\u0002B\u0017\r\u0011%!q\u0006\u0005\b\u0005s1A\u0011\u0002B\u001e\u0011\u001d\u0011)F\u0002C!\u0005/BqA!\u0017\u0007\t\u0003\u00129\u0006C\u0004\u0003\\\u0019!\tE!\u0018\t\u000f\t\rd\u0001\"\u0011\u0003f!9!q\u000e\u0004\u0005\n\tE\u0004b\u0002B@\r\u0011\u0005#\u0011\u0011\u0005\b\u0005\u000f3A\u0011\tBE\u0011\u001d\u0011iI\u0002C!\u0005\u001fCqA!%\u0007\t\u0003\u0012\u0019\nC\u0004\u0003(\u001a!\tE!+\t\u000f\tUf\u0001\"\u0011\u00038\"9!q\u0018\u0004\u0005B\t\u0005\u0007\"\u0003Bc\r\t\u0007I\u0011\tBd\u0011\u001d\u0011IM\u0002Q\u0001\naD\u0011Ba3\u0007\u0005\u0004%\tE!4\t\u0011\t]g\u0001)A\u0005\u0005\u001fDqA!7\u0007\t\u0003\u0012Y\u000eC\u0004\u0003x\u001a!\tE!?\t\u000f\r\u0015a\u0001\"\u0011\u0004\b!91\u0011\u0002\u0004\u0005B\r-\u0001bBB\u0007\r\u0011\u00053q\u0002\u0005\b\u0007/1A\u0011IB\r\u0011\u001d\u0019iB\u0002C!\u0007?\t1\u0004\u0016:b]N\f7\r^5p]\n{WO\u001c3QY\u0006t7i\u001c8uKb$(B\u0001!B\u0003\r\u0019\b/\u001b\u0006\u0003\u0005\u000e\u000b\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\t\u0016\u000baaY=qQ\u0016\u0014(B\u0001$H\u0003\u0015qWm\u001c\u001bk\u0015\u0005A\u0015aA8sO\u000e\u0001\u0001CA&\u0002\u001b\u0005y$a\u0007+sC:\u001c\u0018m\u0019;j_:\u0014u.\u001e8e!2\fgnQ8oi\u0016DHo\u0005\u0002\u0002\u001dB\u0011qJU\u0007\u0002!*\t\u0011+A\u0003tG\u0006d\u0017-\u0003\u0002T!\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001&\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000fa\u001b9e!\u0013\u0004LA\u00111JB\n\u0005\ri\u0013\u0017\u000e\u0005\u0002\\A6\tAL\u0003\u0002^=\u0006Y\u0011N\u001c;feB\u0014X\r^3e\u0015\ty\u0016)A\u0004sk:$\u0018.\\3\n\u0005\u0005d&\u0001\t+sC:\u001c\u0018m\u0019;j_:\u0014u.\u001e8e%\u0016\fG\rV8lK:\u001cuN\u001c;fqR\u0004\"aY4\u000e\u0003\u0011T!\u0001Q3\u000b\u0005\u0019\f\u0015a\u00029mC:tWM]\u0005\u0003Q\u0012\u00141\u0002\u00157b]\u000e{g\u000e^3yiB\u00111J[\u0005\u0003W~\u0012A$\u00138eKb$Um]2sSB$xN]\"p[B\fG/\u001b2jY&$\u00180\u0001\u0002uGB\u00111L\\\u0005\u0003_r\u00131\u0004\u0016:b]N\f7\r^5p]\u0006d7i\u001c8uKb$xK]1qa\u0016\u0014\u0018A\u00027pO\u001e,'\u000f\u0005\u0002sk6\t1O\u0003\u0002u\u0003\u0006!Q\u000f^5m\u0013\t18O\u0001\u000eJ]R,'O\\1m\u001d>$\u0018NZ5dCRLwN\u001c'pO\u001e,'/A\bhe\u0006\u0004\bn\u0015;bi&\u001cH/[2t!\t\u0019\u00170\u0003\u0002{I\nY\u0012J\\:ueVlWM\u001c;fI\u001e\u0013\u0018\r\u001d5Ti\u0006$\u0018n\u001d;jGN$B\u0001\u0017?~}\")AN\u0003a\u0001[\")\u0001O\u0003a\u0001c\")qO\u0003a\u0001q\u00069\"/\u00198hK&sG-\u001a=fg\u001e+GOR8s\u0019\u0006\u0014W\r\u001c\u000b\u0005\u0003\u0007\t\t\u0003\u0005\u0004\u0002\u0006\u0005U\u00111\u0004\b\u0005\u0003\u000f\t\tB\u0004\u0003\u0002\n\u0005=QBAA\u0006\u0015\r\ti!S\u0001\u0007yI|w\u000e\u001e \n\u0003EK1!a\u0005Q\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0006\u0002\u001a\tA\u0011\n^3sCR|'OC\u0002\u0002\u0014A\u00032aYA\u000f\u0013\r\ty\u0002\u001a\u0002\u0010\u0013:$W\r\u001f#fg\u000e\u0014\u0018\u000e\u001d;pe\"9\u00111E\u0006A\u0002\u0005\u0015\u0012a\u00027bE\u0016d\u0017\n\u001a\t\u0004\u001f\u0006\u001d\u0012bAA\u0015!\n\u0019\u0011J\u001c;\u00023I\fgnZ3J]\u0012,\u00070Z:HKR4uN\u001d*fYRK\b/\u001a\u000b\u0005\u0003\u0007\ty\u0003C\u0004\u000221\u0001\r!!\n\u0002\u0013I,G\u000eV=qK&#\u0017A\u0006;fqRLe\u000eZ3yKN<U\r\u001e$pe2\u000b'-\u001a7\u0015\t\u0005\r\u0011q\u0007\u0005\b\u0003Gi\u0001\u0019AA\u0013\u0003a!X\r\u001f;J]\u0012,\u00070Z:HKR4uN\u001d*fYRK\b/\u001a\u000b\u0005\u0003\u0007\ti\u0004C\u0004\u000229\u0001\r!!\n\u0002/A|\u0017N\u001c;J]\u0012,\u00070Z:HKR4uN\u001d'bE\u0016dG\u0003BA\u0002\u0003\u0007Bq!a\t\u0010\u0001\u0004\t)#A\rq_&tG/\u00138eKb,7oR3u\r>\u0014(+\u001a7UsB,G\u0003BA\u0002\u0003\u0013Bq!!\r\u0011\u0001\u0004\t)#\u0001\nj]\u0012,\u00070Z:HKR4uN\u001d'bE\u0016dGCBA\u0002\u0003\u001f\n\t\u0006C\u0004\u0002$E\u0001\r!!\n\t\u000f\u0005M\u0013\u00031\u0001\u0002V\u0005I\u0011N\u001c3fqRK\b/\u001a\t\u0006\u001f\u0006]\u00131L\u0005\u0004\u00033\u0002&AB(qi&|g\u000e\u0005\u0003\u0002^\u0005\u0015TBAA0\u0015\u0011\t\t'a\u0019\u0002\rM\u001c\u0007.Z7b\u0015\t\u0011U)\u0003\u0003\u0002h\u0005}#!C%oI\u0016DH+\u001f9f\u0003QIg\u000eZ3yKN<U\r\u001e$peJ+G\u000eV=qKR1\u00111AA7\u0003_Bq!!\r\u0013\u0001\u0004\t)\u0003C\u0004\u0002TI\u0001\r!!\u0016\u0002+A\u0014x\u000e]3sifLe\u000eZ3yKN<U\r^!mYR\u0011\u00111A\u0001\u0014S:$W\r_#ySN$8OR8s\u0019\u0006\u0014W\r\u001c\u000b\u0005\u0003s\ny\bE\u0002P\u0003wJ1!! Q\u0005\u001d\u0011un\u001c7fC:Dq!a\t\u0015\u0001\u0004\t)#A\u000bj]\u0012,\u00070\u0012=jgR\u001chi\u001c:SK2$\u0016\u0010]3\u0015\t\u0005e\u0014Q\u0011\u0005\b\u0003c)\u0002\u0019AA\u0013\u0003\u0005\"X\r\u001f;J]\u0012,\u0007pR3u\r>\u0014H*\u00192fY\u0006sG\r\u0015:pa\u0016\u0014H/[3t)\u0019\tY)!$\u0002\"B)q*a\u0016\u0002\u001c!9\u0011q\u0012\fA\u0002\u0005E\u0015!\u00037bE\u0016dg*Y7f!\u0011\t\u0019*a'\u000f\t\u0005U\u0015q\u0013\t\u0004\u0003\u0013\u0001\u0016bAAM!\u00061\u0001K]3eK\u001aLA!!(\u0002 \n11\u000b\u001e:j]\u001eT1!!'Q\u0011\u001d\t\u0019K\u0006a\u0001\u0003K\u000bA\u0002\u001d:pa\u0016\u0014H/_&fsN\u0004b!!\u0002\u0002(\u0006E\u0015\u0002BAU\u00033\u00111aU3r\u0003\t\u0012\u0018M\\4f\u0013:$W\r_$fi\u001a{'\u000fT1cK2\fe\u000e\u001a)s_B,'\u000f^5fgR1\u00111RAX\u0003cCq!a$\u0018\u0001\u0004\t\t\nC\u0004\u0002$^\u0001\r!!*\u0002EA|\u0017N\u001c;J]\u0012,\u0007pR3u\r>\u0014H*\u00192fY\u0006sG\r\u0015:pa\u0016\u0014H/[3t)\u0019\tY)a.\u0002:\"9\u0011q\u0012\rA\u0002\u0005E\u0005bBAR1\u0001\u0007\u0011QU\u0001$i\u0016DH/\u00138eKb<U\r\u001e$peJ+G\u000eV=qK\u0006sG\r\u0015:pa\u0016\u0014H/[3t)\u0019\tY)a0\u0002D\"9\u0011\u0011Y\rA\u0002\u0005E\u0015a\u0003:fYRK\b/\u001a(b[\u0016Dq!a)\u001a\u0001\u0004\t)+\u0001\u0013sC:<W-\u00138eKb<U\r\u001e$peJ+G\u000eV=qK\u0006sG\r\u0015:pa\u0016\u0014H/[3t)\u0019\tY)!3\u0002L\"9\u0011\u0011\u0019\u000eA\u0002\u0005E\u0005bBAR5\u0001\u0007\u0011QU\u0001%a>Lg\u000e^%oI\u0016Dx)\u001a;G_J\u0014V\r\u001c+za\u0016\fe\u000e\u001a)s_B,'\u000f^5fgR1\u00111RAi\u0003'Dq!!1\u001c\u0001\u0004\t\t\nC\u0004\u0002$n\u0001\r!!*\u0002;%tG-\u001a=HKR4uN\u001d'bE\u0016d\u0017I\u001c3Qe>\u0004XM\u001d;jKN$\u0002\"a#\u0002Z\u0006m\u0017Q\u001c\u0005\b\u0003'b\u0002\u0019AA.\u0011\u001d\ty\t\ba\u0001\u0003#Cq!a)\u001d\u0001\u0004\t)+A\u0010j]\u0012,\u0007pR3u\r>\u0014(+\u001a7UsB,\u0017I\u001c3Qe>\u0004XM\u001d;jKN$\u0002\"a#\u0002d\u0006\u0015\u0018q\u001d\u0005\b\u0003'j\u0002\u0019AA.\u0011\u001d\t\t-\ba\u0001\u0003#Cq!a)\u001e\u0001\u0004\t)+A\u000ej]\u0012,\u0007pR3u\r>\u00148k\u00195f[\u0006$Um]2sSB$xN\u001d\u000b\u0005\u0003[\fI\u0010\u0006\u0003\u0002\f\u0006=\bbBAy=\u0001\u0007\u00111_\u0001\u000bI\u0016\u001c8M]5qi>\u0014\b\u0003BA/\u0003kLA!a>\u0002`\t\u00012k\u00195f[\u0006$Um]2sSB$xN\u001d\u0005\b\u0003'r\u0002\u0019AA.\u0003\u0011\"X\r\u001f;J]\u0012,\u00070\u0012=jgR\u001chi\u001c:MC\n,G.\u00118e!J|\u0007/\u001a:uS\u0016\u001cHCBA=\u0003\u007f\u0014\t\u0001C\u0004\u0002\u0010~\u0001\r!!%\t\u000f\t\rq\u00041\u0001\u0002&\u0006Y\u0001O]8qKJ$\u0018pS3z\u0003\u0015\u0012\u0018M\\4f\u0013:$W\r_#ySN$8OR8s\u0019\u0006\u0014W\r\\!oIB\u0013x\u000e]3si&,7\u000f\u0006\u0004\u0002z\t%!1\u0002\u0005\b\u0003\u001f\u0003\u0003\u0019AAI\u0011\u001d\u0011\u0019\u0001\ta\u0001\u0003K\u000bQ\u0005]8j]RLe\u000eZ3y\u000bbL7\u000f^:G_Jd\u0015MY3m\u0003:$\u0007K]8qKJ$\u0018.Z:\u0015\r\u0005e$\u0011\u0003B\n\u0011\u001d\ty)\ta\u0001\u0003#CqAa\u0001\"\u0001\u0004\t)+\u0001\u0014uKb$\u0018J\u001c3fq\u0016C\u0018n\u001d;t\r>\u0014(+\u001a7UsB,\u0017I\u001c3Qe>\u0004XM\u001d;jKN$b!!\u001f\u0003\u001a\tm\u0001bBAaE\u0001\u0007\u0011\u0011\u0013\u0005\b\u0005\u0007\u0011\u0003\u0019AAS\u0003\u001d\u0012\u0018M\\4f\u0013:$W\r_#ySN$8OR8s%\u0016dG+\u001f9f\u0003:$\u0007K]8qKJ$\u0018.Z:\u0015\r\u0005e$\u0011\u0005B\u0012\u0011\u001d\t\tm\ta\u0001\u0003#CqAa\u0001$\u0001\u0004\t)+A\u0014q_&tG/\u00138eKb,\u00050[:ug\u001a{'OU3m)f\u0004X-\u00118e!J|\u0007/\u001a:uS\u0016\u001cHCBA=\u0005S\u0011Y\u0003C\u0004\u0002B\u0012\u0002\r!!%\t\u000f\t\rA\u00051\u0001\u0002&\u0006qq-\u001a;P]2Lg.Z%oI\u0016DH\u0003BAF\u0005cAqAa\r&\u0001\u0004\u0011)$A\u0005sK\u001a,'/\u001a8dKB!\u0011Q\fB\u001c\u0013\u0011\ty\"a\u0018\u0002/\u001d,G\u000fV8lK:Le\u000eZ3y\t\u0016\u001c8M]5qi>\u0014H\u0003\u0002B\u001f\u0005\u000b\u0002RaTA,\u0005\u007f\u00012a\u0019B!\u0013\r\u0011\u0019\u0005\u001a\u0002\u0015)>\\WM\\%oI\u0016DH)Z:de&\u0004Ho\u001c:\t\u000f\t\u001dc\u00051\u0001\u0003J\u00059\u0011N\u001c3fq\u0016\u001c\bC\u0002B&\u0005'\u0012)$\u0004\u0002\u0003N)\u0019AOa\u0014\u000b\u0005\tE\u0013\u0001\u00026bm\u0006LA!a\u0006\u0003N\u0005qan\u001c3f)>\\WM\\%oI\u0016DXC\u0001B\u001f\u0003Y\u0011X\r\\1uS>t7\u000f[5q)>\\WM\\%oI\u0016D\u0018A\t5bg:{G-\u001a)s_B,'\u000f^=Fq&\u001cH/\u001a8dK\u000e{gn\u001d;sC&tG\u000f\u0006\u0004\u0002z\t}#\u0011\r\u0005\b\u0003\u001fK\u0003\u0019AAI\u0011\u001d\u0011\u0019!\u000ba\u0001\u0003#\u000b\u0001fZ3u\u001d>$W\r\u0015:pa\u0016\u0014H/[3t/&$\b.\u0012=jgR,gnY3D_:\u001cHO]1j]R$BAa\u001a\u0003nA1\u00111\u0013B5\u0003#KAAa\u001b\u0002 \n\u00191+\u001a;\t\u000f\u0005=%\u00061\u0001\u0002\u0012\u0006)s-\u001a;Qe>\u0004XM\u001d;jKN4%o\\7Fq&\u001cH/\u001a8dK\u000e{gn\u001d;sC&tGo\u001d\u000b\u0005\u0005O\u0012\u0019\bC\u0004\u0003v-\u0002\rAa\u001e\u0002\u0017\r|gn\u001d;sC&tGo\u001d\t\u0007\u0003\u000b\t)B!\u001f\u0011\t\u0005u#1P\u0005\u0005\u0005{\nyF\u0001\u000bD_:\u001cHO]1j]R$Um]2sSB$xN]\u0001+Q\u0006\u001c(+\u001a7bi&|gn\u001d5jaB\u0013x\u000e]3sif,\u00050[:uK:\u001cWmQ8ogR\u0014\u0018-\u001b8u)\u0019\tIHa!\u0003\u0006\"9\u0011\u0011\u0019\u0017A\u0002\u0005E\u0005b\u0002B\u0002Y\u0001\u0007\u0011\u0011S\u00011O\u0016$(+\u001a7bi&|gn\u001d5jaB\u0013x\u000e]3si&,7oV5uQ\u0016C\u0018n\u001d;f]\u000e,7i\u001c8tiJ\f\u0017N\u001c;\u0015\t\t\u001d$1\u0012\u0005\b\u0003\u0003l\u0003\u0019AAI\u0003\u0011:W\r\u001e)s_B,'\u000f^5fg^KG\u000f[#ySN$XM\\2f\u0007>t7\u000f\u001e:bS:$XC\u0001B4\u0003uA\u0017m\u001d(pI\u0016\u0004&o\u001c9feRLH+\u001f9f\u0007>t7\u000f\u001e:bS:$H\u0003CA=\u0005+\u00139J!'\t\u000f\u0005=u\u00061\u0001\u0002\u0012\"9!1A\u0018A\u0002\u0005E\u0005b\u0002BN_\u0001\u0007!QT\u0001\u000bGf\u0004\b.\u001a:UsB,\u0007\u0003\u0002BP\u0005Gk!A!)\u000b\t\tU\u0014qL\u0005\u0005\u0005K\u0013\tKA\bTG\",W.\u0019,bYV,G+\u001f9f\u0003\r:W\r\u001e(pI\u0016\u0004&o\u001c9feRLWm],ji\"$\u0016\u0010]3D_:\u001cHO]1j]R$BAa+\u00034BA\u00111\u0013BW\u0003#\u0013\t,\u0003\u0003\u00030\u0006}%aA'baB1\u0011QAAT\u0005;Cq!a$1\u0001\u0004\t\t*A\u0013iCN\u0014V\r\\1uS>t7\u000f[5q!J|\u0007/\u001a:usRK\b/Z\"p]N$(/Y5oiRA\u0011\u0011\u0010B]\u0005w\u0013i\fC\u0004\u0002BF\u0002\r!!%\t\u000f\t\r\u0011\u00071\u0001\u0002\u0012\"9!1T\u0019A\u0002\tu\u0015aK4fiJ+G.\u0019;j_:\u001c\b.\u001b9Qe>\u0004XM\u001d;jKN<\u0016\u000e\u001e5UsB,7i\u001c8tiJ\f\u0017N\u001c;\u0015\t\t-&1\u0019\u0005\b\u0003\u0003\u0014\u0004\u0019AAI\u0003)\u0019H/\u0019;jgRL7m]\u000b\u0002q\u0006Y1\u000f^1uSN$\u0018nY:!\u0003ea\u0017m\u001d;D_6l\u0017\u000e\u001e;fIRC\u0018\n\u001a)s_ZLG-\u001a:\u0016\u0005\t=\u0007\u0003\u0002Bi\u0005'l\u0011!Q\u0005\u0004\u0005+\f%!\u0007'bgR\u001cu.\\7jiR,G\r\u0016=JIB\u0013xN^5eKJ\f!\u0004\\1ti\u000e{W.\\5ui\u0016$G\u000b_%e!J|g/\u001b3fe\u0002\n!\u0003\u001d:pG\u0016$WO]3TS\u001et\u0017\r^;sKR!!Q\u001cBw!\u0011\u0011yN!;\u000e\u0005\t\u0005(\u0002\u0002Br\u0005K\fa\u0001\u001d5bg\u0016\u001c(b\u0001Bt\u0003\u0006AaM]8oi\u0016tG-\u0003\u0003\u0003l\n\u0005(A\u0005)s_\u000e,G-\u001e:f'&<g.\u0019;ve\u0016DqAa<8\u0001\u0004\u0011\t0\u0001\u0003oC6,\u0007\u0003\u0002Bp\u0005gLAA!>\u0003b\ni\u0011+^1mS\u001aLW\r\u001a(b[\u0016\f\u0011CZ;oGRLwN\\*jO:\fG/\u001e:f)\u0011\u0011Ypa\u0001\u0011\u000b=\u000b9F!@\u0011\t\t}'q`\u0005\u0005\u0007\u0003\u0011\tOA\u000bVg\u0016\u0014h)\u001e8di&|gnU5h]\u0006$XO]3\t\u000f\t=\b\b1\u0001\u0003r\u0006\u0011bn\u001c;jM&\u001c\u0017\r^5p]2{wmZ3s)\u0005\t\u0018!\u0005;y'R\fG/\u001a%bg\u000eC\u0017M\\4fgR\u0011\u0011\u0011P\u0001\u001aaJ|7-\u001a3ve\u0016\u001c\u0016n\u001a8biV\u0014XMV3sg&|g.\u0006\u0002\u0004\u0012A\u0019qja\u0005\n\u0007\rU\u0001K\u0001\u0003M_:<\u0017AF<ji\"tu\u000e^5gS\u000e\fG/[8o\u0019><w-\u001a:\u0015\u0007\t\u001cY\u0002\u0003\u0004\u0004\u0006q\u0002\r!]\u0001\rI\u0006$\u0018MY1tK6{G-Z\u000b\u0003\u0007C\u0001Baa\t\u0004B9!1QEB\u001f\u001d\u0011\u00199ca\u000f\u000f\t\r%2\u0011\b\b\u0005\u0007W\u00199D\u0004\u0003\u0004.\rUb\u0002BB\u0018\u0007gqA!!\u0003\u00042%\t\u0001*\u0003\u0002G\u000f&\u0011A)R\u0005\u0003\u0005\u000eK!AZ!\n\u0005\u0001+\u0017bAB I\u0006aA)\u0019;bE\u0006\u001cX-T8eK&!11IB#\u00051!\u0015\r^1cCN,Wj\u001c3f\u0015\r\u0019y\u0004\u001a\u0005\u0006Y\u000e\u0001\r!\u001c\u0005\u0006a\u000e\u0001\r!\u001d\u0005\b\u0007\u001b\u001a\u0001\u0019AB(\u0003\rawn\u001a\t\u0005\u0007#\u001a9&\u0004\u0002\u0004T)\u00191QK#\u0002\u000f1|wmZ5oO&!1\u0011LB*\u0005-Ie\u000e^3s]\u0006dGj\\4\u0015\r\tu7QLB9\u0011\u001d\u0019y\u0006\u0002a\u0001\u0007C\n!\u0001\u001e=\u0011\t\r\r4QN\u0007\u0003\u0007KRAaa\u001a\u0004j\u0005\u0019\u0011\r]5\u000b\u0007\r-T)\u0001\u0004lKJtW\r\\\u0005\u0005\u0007_\u001a)GA\tLKJtW\r\u001c+sC:\u001c\u0018m\u0019;j_:DqAa<\u0005\u0001\u0004\u0011\t\u0010\u0006\u0004\u0003|\u000eU4q\u000f\u0005\b\u0007?*\u0001\u0019AB1\u0011\u001d\u0011y/\u0002a\u0001\u0005c\u0004")
public class TransactionBoundPlanContext
extends TransactionBoundReadTokenContext
implements PlanContext,
IndexDescriptorCompatibility {
    private final TransactionalContextWrapper tc;
    private final InternalNotificationLogger logger;
    private final InstrumentedGraphStatistics graphStatistics;
    private final InstrumentedGraphStatistics statistics;
    private final LastCommittedTxIdProvider lastCommittedTxIdProvider;

    public static TransactionBoundPlanContext apply(TransactionalContextWrapper tc, InternalNotificationLogger logger, InternalLog log) {
        return TransactionBoundPlanContext$.MODULE$.apply(tc, logger, log);
    }

    @Override
    public org.neo4j.cypher.internal.planner.spi.IndexBehaviour kernelToCypher(IndexBehaviour behaviour) {
        return IndexDescriptorCompatibility.kernelToCypher$((IndexDescriptorCompatibility)this, behaviour);
    }

    @Override
    public Option<IndexDescriptor.IndexType> kernelToCypher(IndexType indexType) {
        return IndexDescriptorCompatibility.kernelToCypher$((IndexDescriptorCompatibility)this, indexType);
    }

    @Override
    public SchemaDescriptor cypherToKernelSchema(org.neo4j.cypher.internal.planner.spi.IndexDescriptor index) {
        return IndexDescriptorCompatibility.cypherToKernelSchema$(this, index);
    }

    @Override
    public IndexType cypherToKernel(IndexDescriptor.IndexType indexType) {
        return IndexDescriptorCompatibility.cypherToKernel$(this, indexType);
    }

    @Override
    public Option<LabelSchemaDescriptor> toLabelSchemaDescriptor(TransactionBoundReadTokenContext tc, String labelName, Seq<String> propertyKeys) {
        return IndexDescriptorCompatibility.toLabelSchemaDescriptor$(this, tc, labelName, propertyKeys);
    }

    @Override
    public Option<RelationTypeSchemaDescriptor> toRelTypeSchemaDescriptor(TransactionBoundReadTokenContext tc, String relTypeName, Seq<String> propertyKeys) {
        return IndexDescriptorCompatibility.toRelTypeSchemaDescriptor$(this, tc, relTypeName, propertyKeys);
    }

    public Iterator<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> rangeIndexesGetForLabel(int labelId) {
        return this.indexesGetForLabel(labelId, (Option<IndexType>)new Some((Object)IndexType.RANGE));
    }

    public Iterator<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> rangeIndexesGetForRelType(int relTypeId) {
        return this.indexesGetForRelType(relTypeId, (Option<IndexType>)new Some((Object)IndexType.RANGE));
    }

    public Iterator<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> textIndexesGetForLabel(int labelId) {
        return this.indexesGetForLabel(labelId, (Option<IndexType>)new Some((Object)IndexType.TEXT));
    }

    public Iterator<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> textIndexesGetForRelType(int relTypeId) {
        return this.indexesGetForRelType(relTypeId, (Option<IndexType>)new Some((Object)IndexType.TEXT));
    }

    public Iterator<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> pointIndexesGetForLabel(int labelId) {
        return this.indexesGetForLabel(labelId, (Option<IndexType>)new Some((Object)IndexType.POINT));
    }

    public Iterator<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> pointIndexesGetForRelType(int relTypeId) {
        return this.indexesGetForRelType(relTypeId, (Option<IndexType>)new Some((Object)IndexType.POINT));
    }

    private Iterator<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> indexesGetForLabel(int labelId, Option<IndexType> indexType) {
        Function1 & Serializable intersect;
        Option<IndexType> option = indexType;
        if (option instanceof Some) {
            Some some = (Some)option;
            IndexType it = (IndexType)some.value();
            intersect = (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionBoundPlanContext.$anonfun$indexesGetForLabel$1(it, x$2));
        } else if (None$.MODULE$.equals(option)) {
            intersect = (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TransactionBoundPlanContext.$anonfun$indexesGetForLabel$2(x$3));
        } else {
            throw new MatchError(option);
        }
        Function1 & Serializable selector = intersect;
        return CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().getLabelIndexesNonLocking(labelId)).asScala().filter((Function1)selector).flatMap((Function1 & Serializable)reference -> this.getOnlineIndex((IndexDescriptor)reference));
    }

    private Iterator<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> indexesGetForRelType(int relTypeId, Option<IndexType> indexType) {
        Function1 & Serializable intersect;
        Option<IndexType> option = indexType;
        if (option instanceof Some) {
            Some some = (Some)option;
            IndexType it = (IndexType)some.value();
            intersect = (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TransactionBoundPlanContext.$anonfun$indexesGetForRelType$1(it, x$4));
        } else if (None$.MODULE$.equals(option)) {
            intersect = (Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TransactionBoundPlanContext.$anonfun$indexesGetForRelType$2(x$5));
        } else {
            throw new MatchError(option);
        }
        Function1 & Serializable selector = intersect;
        return CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().getRelTypeIndexesNonLocking(relTypeId)).asScala().filter((Function1)selector).flatMap((Function1 & Serializable)reference -> this.getOnlineIndex((IndexDescriptor)reference));
    }

    public Iterator<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> propertyIndexesGetAll() {
        return CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().indexesGetAllNonLocking()).asScala().flatMap((Function1 & Serializable)reference -> this.getOnlineIndex((IndexDescriptor)reference));
    }

    public boolean indexExistsForLabel(int labelId) {
        return this.indexesGetForLabel(labelId, (Option<IndexType>)None$.MODULE$).nonEmpty();
    }

    public boolean indexExistsForRelType(int relTypeId) {
        return this.indexesGetForRelType(relTypeId, (Option<IndexType>)None$.MODULE$).nonEmpty();
    }

    public Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> textIndexGetForLabelAndProperties(String labelName, Seq<String> propertyKeys) {
        return this.indexGetForLabelAndProperties(IndexType.TEXT, labelName, propertyKeys);
    }

    public Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> rangeIndexGetForLabelAndProperties(String labelName, Seq<String> propertyKeys) {
        return this.indexGetForLabelAndProperties(IndexType.RANGE, labelName, propertyKeys);
    }

    public Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> pointIndexGetForLabelAndProperties(String labelName, Seq<String> propertyKeys) {
        return this.indexGetForLabelAndProperties(IndexType.POINT, labelName, propertyKeys);
    }

    public Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> textIndexGetForRelTypeAndProperties(String relTypeName, Seq<String> propertyKeys) {
        return this.indexGetForRelTypeAndProperties(IndexType.TEXT, relTypeName, propertyKeys);
    }

    public Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> rangeIndexGetForRelTypeAndProperties(String relTypeName, Seq<String> propertyKeys) {
        return this.indexGetForRelTypeAndProperties(IndexType.RANGE, relTypeName, propertyKeys);
    }

    public Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> pointIndexGetForRelTypeAndProperties(String relTypeName, Seq<String> propertyKeys) {
        return this.indexGetForRelTypeAndProperties(IndexType.POINT, relTypeName, propertyKeys);
    }

    private Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> indexGetForLabelAndProperties(IndexType indexType, String labelName, Seq<String> propertyKeys) {
        Option<LabelSchemaDescriptor> descriptor2 = this.toLabelSchemaDescriptor(this, labelName, propertyKeys);
        return descriptor2.flatMap((Function1 & Serializable)descriptor -> this.indexGetForSchemaDescriptor(indexType, (SchemaDescriptor)descriptor));
    }

    private Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> indexGetForRelTypeAndProperties(IndexType indexType, String relTypeName, Seq<String> propertyKeys) {
        Option<RelationTypeSchemaDescriptor> descriptor2 = this.toRelTypeSchemaDescriptor(this, relTypeName, propertyKeys);
        return descriptor2.flatMap((Function1 & Serializable)descriptor -> this.indexGetForSchemaDescriptor(indexType, (SchemaDescriptor)descriptor));
    }

    private Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> indexGetForSchemaDescriptor(IndexType indexType, SchemaDescriptor descriptor) {
        Iterator itr = CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().indexForSchemaNonLocking(descriptor)).asScala().filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)TransactionBoundPlanContext.$anonfun$indexGetForSchemaDescriptor$1(indexType, x$6))).flatMap((Function1 & Serializable)reference -> this.getOnlineIndex((IndexDescriptor)reference));
        if (itr.hasNext()) {
            return new Some(itr.next());
        }
        return None$.MODULE$;
    }

    public boolean textIndexExistsForLabelAndProperties(String labelName, Seq<String> propertyKey) {
        return this.textIndexGetForLabelAndProperties(labelName, propertyKey).isDefined();
    }

    public boolean rangeIndexExistsForLabelAndProperties(String labelName, Seq<String> propertyKey) {
        return this.rangeIndexGetForLabelAndProperties(labelName, propertyKey).isDefined();
    }

    public boolean pointIndexExistsForLabelAndProperties(String labelName, Seq<String> propertyKey) {
        return this.pointIndexGetForLabelAndProperties(labelName, propertyKey).isDefined();
    }

    public boolean textIndexExistsForRelTypeAndProperties(String relTypeName, Seq<String> propertyKey) {
        return this.textIndexGetForRelTypeAndProperties(relTypeName, propertyKey).isDefined();
    }

    public boolean rangeIndexExistsForRelTypeAndProperties(String relTypeName, Seq<String> propertyKey) {
        return this.rangeIndexGetForRelTypeAndProperties(relTypeName, propertyKey).isDefined();
    }

    public boolean pointIndexExistsForRelTypeAndProperties(String relTypeName, Seq<String> propertyKey) {
        return this.pointIndexGetForRelTypeAndProperties(relTypeName, propertyKey).isDefined();
    }

    private Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> getOnlineIndex(IndexDescriptor reference) {
        Object object;
        block7: {
            try {
                InternalIndexState internalIndexState = this.tc.schemaRead().indexGetStateNonLocking(reference);
                if (InternalIndexState.ONLINE.equals(internalIndexState) && ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.intArrayOps(reference.schema().getPropertyIds()))) {
                    CanGetValue$ valueCapability;
                    IndexDescriptor.EntityType$.Node node;
                    int tokenId = reference.schema().getEntityTokenIds()[0];
                    EntityType entityType = reference.schema().entityType();
                    if (EntityType.NODE.equals(entityType)) {
                        node = new IndexDescriptor.EntityType$.Node(new LabelId(tokenId));
                    } else if (EntityType.RELATIONSHIP.equals(entityType)) {
                        node = new IndexDescriptor.EntityType$.Relationship(new RelTypeId(tokenId));
                    } else {
                        throw new MatchError((Object)entityType);
                    }
                    IndexDescriptor.EntityType$.Node entityType2 = node;
                    PropertyKeyId[] properties = (PropertyKeyId[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(reference.schema().getPropertyIds()), (Function1)PropertyKeyId$.MODULE$, ClassTag$.MODULE$.apply(PropertyKeyId.class));
                    boolean isUnique = reference.isUnique();
                    Set behaviours = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])reference.getCapability().behaviours()), (Function1 & Serializable)behaviour -> this.kernelToCypher((IndexBehaviour)behaviour), ClassTag$.MODULE$.apply(org.neo4j.cypher.internal.planner.spi.IndexBehaviour.class))).toSet();
                    IndexOrderCapability.BOTH$ orderCapability = reference.getCapability().supportsOrdering() ? IndexOrderCapability.BOTH$.MODULE$ : IndexOrderCapability.NONE$.MODULE$;
                    Object object2 = valueCapability = reference.getCapability().supportsReturningValues() ? CanGetValue$.MODULE$ : DoNotGetValue$.MODULE$;
                    object = behaviours.contains((Object)EventuallyConsistent$.MODULE$) ? None$.MODULE$ : (isUnique && this.tc.schemaRead().indexGetOwningUniquenessConstraintIdNonLocking(reference) == null ? None$.MODULE$ : this.kernelToCypher(reference.getIndexType()).map(arg_0 -> TransactionBoundPlanContext.$anonfun$getOnlineIndex$2((Product)entityType2, properties, behaviours, (Product)orderCapability, (Product)valueCapability, reference, isUnique, arg_0)));
                    break block7;
                }
                object = None$.MODULE$;
            }
            catch (IndexNotFoundKernelException indexNotFoundKernelException) {
                object = None$.MODULE$;
            }
        }
        return object;
    }

    private Option<TokenIndexDescriptor> getTokenIndexDescriptor(java.util.Iterator<IndexDescriptor> indexes) {
        return CollectionConverters$.MODULE$.IteratorHasAsScala(indexes).asScala().nextOption().map((Function1 & Serializable)kernelIndexDescriptor -> {
            EntityType typ = kernelIndexDescriptor.schema().entityType();
            IndexOrderCapability.BOTH$ orderCapability = kernelIndexDescriptor.getCapability().supportsOrdering() ? IndexOrderCapability.BOTH$.MODULE$ : IndexOrderCapability.NONE$.MODULE$;
            return new TokenIndexDescriptor(typ, (IndexOrderCapability)orderCapability);
        });
    }

    public Option<TokenIndexDescriptor> nodeTokenIndex() {
        return this.getTokenIndexDescriptor(this.tc.schemaRead().indexForSchemaNonTransactional((SchemaDescriptor)SchemaDescriptors.ANY_TOKEN_NODE_SCHEMA_DESCRIPTOR));
    }

    public Option<TokenIndexDescriptor> relationshipTokenIndex() {
        return this.getTokenIndexDescriptor(this.tc.schemaRead().indexForSchemaNonTransactional((SchemaDescriptor)SchemaDescriptors.ANY_TOKEN_RELATIONSHIP_SCHEMA_DESCRIPTOR));
    }

    public boolean hasNodePropertyExistenceConstraint(String labelName, String propertyKey) {
        boolean bl;
        try {
            int labelId = this.getLabelId(labelName);
            int propertyKeyId = this.getPropertyKeyId(propertyKey);
            bl = CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().constraintsGetForSchemaNonLocking((SchemaDescriptor)SchemaDescriptors.forLabel((int)labelId, (int[])new int[]{propertyKeyId}))).asScala().filter((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.enforcesPropertyExistence())).hasNext();
        }
        catch (KernelException kernelException) {
            bl = false;
        }
        return bl;
    }

    public Set<String> getNodePropertiesWithExistenceConstraint(String labelName) {
        Set<String> set;
        try {
            int labelId = this.getLabelId(labelName);
            Iterator constraints = CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().constraintsGetForLabelNonLocking(labelId)).asScala();
            set = this.getPropertiesFromExistenceConstraints((Iterator<ConstraintDescriptor>)constraints);
        }
        catch (KernelException kernelException) {
            set = Predef$.MODULE$.Set().empty();
        }
        return set;
    }

    private Set<String> getPropertiesFromExistenceConstraints(Iterator<ConstraintDescriptor> constraints) {
        Iterator existsConstraints = constraints.filter((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.enforcesPropertyExistence()));
        Set distinctPropertyIds = existsConstraints.flatMap((Function1 & Serializable)x$7 -> Predef$.MODULE$.wrapIntArray(x$7.schema().getPropertyIds())).toSet();
        return (Set)distinctPropertyIds.map((Function1 & Serializable)id -> TransactionBoundPlanContext.$anonfun$getPropertiesFromExistenceConstraints$3(this, BoxesRunTime.unboxToInt((Object)id)));
    }

    public boolean hasRelationshipPropertyExistenceConstraint(String relTypeName, String propertyKey) {
        boolean bl;
        try {
            int relTypeId = this.getRelTypeId(relTypeName);
            int propertyKeyId = this.getPropertyKeyId(propertyKey);
            bl = CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().constraintsGetForSchemaNonLocking((SchemaDescriptor)SchemaDescriptors.forRelType((int)relTypeId, (int[])new int[]{propertyKeyId}))).asScala().filter((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.enforcesPropertyExistence())).hasNext();
        }
        catch (KernelException kernelException) {
            bl = false;
        }
        return bl;
    }

    public Set<String> getRelationshipPropertiesWithExistenceConstraint(String relTypeName) {
        Set<String> set;
        try {
            int relTypeId = this.getRelTypeId(relTypeName);
            Iterator constraints = CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().constraintsGetForRelationshipTypeNonLocking(relTypeId)).asScala();
            set = this.getPropertiesFromExistenceConstraints((Iterator<ConstraintDescriptor>)constraints);
        }
        catch (KernelException kernelException) {
            set = Predef$.MODULE$.Set().empty();
        }
        return set;
    }

    public Set<String> getPropertiesWithExistenceConstraint() {
        Set<String> set;
        try {
            Iterator constraints = CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().constraintsGetAllNonLocking()).asScala();
            set = this.getPropertiesFromExistenceConstraints((Iterator<ConstraintDescriptor>)constraints);
        }
        catch (KernelException kernelException) {
            set = Predef$.MODULE$.Set().empty();
        }
        return set;
    }

    public boolean hasNodePropertyTypeConstraint(String labelName, String propertyKey, SchemaValueType cypherType) {
        SeqOps seqOps;
        Some some;
        Seq seq;
        Option option = this.getNodePropertiesWithTypeConstraint(labelName).get((Object)propertyKey);
        if (option instanceof Some && (seq = (Seq)(some = (Some)option).value()) != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
            SchemaValueType schemaValueType = (SchemaValueType)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            SchemaValueType schemaValueType2 = cypherType;
            SchemaValueType schemaValueType3 = schemaValueType;
            if (!(schemaValueType2 != null ? !schemaValueType2.equals(schemaValueType3) : schemaValueType3 != null)) {
                return true;
            }
        }
        return false;
    }

    public Map<String, Seq<SchemaValueType>> getNodePropertiesWithTypeConstraint(String labelName) {
        Map map;
        try {
            int labelId = this.getLabelId(labelName);
            Iterator constraints = CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().constraintsGetForLabelNonLocking(labelId)).asScala();
            Iterator typeConstraints = constraints.filter((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.enforcesPropertyType())).map((Function1 & Serializable)x$8 -> x$8.asPropertyTypeConstraint());
            map = typeConstraints.map((Function1 & Serializable)typeConstraint -> new Tuple2((Object)$this.tc.tokenRead().propertyKeyName(typeConstraint.schema().getPropertyId()), (Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])typeConstraint.propertyType().values())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        catch (KernelException kernelException) {
            map = Predef$.MODULE$.Map().empty();
        }
        return map;
    }

    public boolean hasRelationshipPropertyTypeConstraint(String relTypeName, String propertyKey, SchemaValueType cypherType) {
        SeqOps seqOps;
        Some some;
        Seq seq;
        Option option = this.getRelationshipPropertiesWithTypeConstraint(relTypeName).get((Object)propertyKey);
        if (option instanceof Some && (seq = (Seq)(some = (Some)option).value()) != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
            SchemaValueType schemaValueType = (SchemaValueType)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            SchemaValueType schemaValueType2 = cypherType;
            SchemaValueType schemaValueType3 = schemaValueType;
            if (!(schemaValueType2 != null ? !schemaValueType2.equals(schemaValueType3) : schemaValueType3 != null)) {
                return true;
            }
        }
        return false;
    }

    public Map<String, Seq<SchemaValueType>> getRelationshipPropertiesWithTypeConstraint(String relTypeName) {
        Map map;
        try {
            int relTypeId = this.getRelTypeId(relTypeName);
            Iterator constraints = CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().constraintsGetForRelationshipTypeNonLocking(relTypeId)).asScala();
            Iterator typeConstraints = constraints.filter((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.enforcesPropertyType())).map((Function1 & Serializable)x$9 -> x$9.asPropertyTypeConstraint());
            map = typeConstraints.map((Function1 & Serializable)typeConstraint -> new Tuple2((Object)$this.tc.tokenRead().propertyKeyName(typeConstraint.schema().getPropertyId()), (Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])typeConstraint.propertyType().values())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        catch (KernelException kernelException) {
            map = Predef$.MODULE$.Map().empty();
        }
        return map;
    }

    public InstrumentedGraphStatistics statistics() {
        return this.statistics;
    }

    public LastCommittedTxIdProvider lastCommittedTxIdProvider() {
        return this.lastCommittedTxIdProvider;
    }

    public ProcedureSignature procedureSignature(QualifiedName name) {
        return TransactionBoundPlanContext$.MODULE$.procedureSignature(this.tc.kernelTransaction(), name);
    }

    public Option<UserFunctionSignature> functionSignature(QualifiedName name) {
        return TransactionBoundPlanContext$.MODULE$.functionSignature(this.tc.kernelTransaction(), name);
    }

    public InternalNotificationLogger notificationLogger() {
        return this.logger;
    }

    public boolean txStateHasChanges() {
        return this.tc.dataRead().transactionStateHasChanges();
    }

    public long procedureSignatureVersion() {
        return this.tc.procedures().signatureVersion();
    }

    public PlanContext withNotificationLogger(InternalNotificationLogger notificationLogger) {
        return new TransactionBoundPlanContext(this.tc, notificationLogger, this.graphStatistics);
    }

    public Enumeration.Value databaseMode() {
        TransactionalContext.DatabaseMode databaseMode = this.tc.kernelTransactionalContext().databaseMode();
        if (TransactionalContext.DatabaseMode.SINGLE.equals(databaseMode)) {
            return DatabaseMode$.MODULE$.SINGLE();
        }
        if (TransactionalContext.DatabaseMode.COMPOSITE.equals(databaseMode)) {
            return DatabaseMode$.MODULE$.COMPOSITE();
        }
        if (TransactionalContext.DatabaseMode.SHARDED.equals(databaseMode)) {
            return DatabaseMode$.MODULE$.SHARDED();
        }
        throw new MatchError((Object)databaseMode);
    }

    public static final /* synthetic */ boolean $anonfun$indexesGetForLabel$1(IndexType it$1, IndexDescriptor x$2) {
        IndexType indexType = x$2.getIndexType();
        IndexType indexType2 = it$1;
        return !(indexType != null ? !indexType.equals(indexType2) : indexType2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$indexesGetForLabel$2(IndexDescriptor x$3) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$indexesGetForRelType$1(IndexType it$2, IndexDescriptor x$4) {
        IndexType indexType = x$4.getIndexType();
        IndexType indexType2 = it$2;
        return !(indexType != null ? !indexType.equals(indexType2) : indexType2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$indexesGetForRelType$2(IndexDescriptor x$5) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$indexGetForSchemaDescriptor$1(IndexType indexType$3, IndexDescriptor x$6) {
        IndexType indexType = x$6.getIndexType();
        IndexType indexType2 = indexType$3;
        return !(indexType != null ? !indexType.equals(indexType2) : indexType2 != null);
    }

    public static final /* synthetic */ org.neo4j.cypher.internal.planner.spi.IndexDescriptor $anonfun$getOnlineIndex$2(Product entityType$1, PropertyKeyId[] properties$1, Set behaviours$1, Product orderCapability$1, Product valueCapability$1, IndexDescriptor reference$1, boolean isUnique$1, IndexDescriptor.IndexType indexType) {
        return new org.neo4j.cypher.internal.planner.spi.IndexDescriptor(indexType, (IndexDescriptor.EntityType)entityType$1, (Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)properties$1), behaviours$1, (IndexOrderCapability)orderCapability$1, (GetValueFromIndexBehavior)valueCapability$1, (Option)new Some((Object)reference$1.getCapability()), isUnique$1);
    }

    public static final /* synthetic */ String $anonfun$getPropertiesFromExistenceConstraints$3(TransactionBoundPlanContext $this, int id) {
        return $this.tc.tokenRead().propertyKeyName(id);
    }

    public TransactionBoundPlanContext(TransactionalContextWrapper tc, InternalNotificationLogger logger, InstrumentedGraphStatistics graphStatistics) {
        this.tc = tc;
        this.logger = logger;
        this.graphStatistics = graphStatistics;
        super((QueryTransactionalContext)tc);
        IndexDescriptorCompatibility.$init$(this);
        this.statistics = graphStatistics;
        this.lastCommittedTxIdProvider = new LastCommittedTxIdProvider(tc.graph());
    }
}

