/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.neo4j.common.EntityType;
import org.neo4j.configuration.Config;
import org.neo4j.cypher.internal.CypherRuntime;
import org.neo4j.cypher.internal.CypherVersion;
import org.neo4j.cypher.internal.ExecutionPlan;
import org.neo4j.cypher.internal.LogicalQuery;
import org.neo4j.cypher.internal.RuntimeContext;
import org.neo4j.cypher.internal.SchemaCommandRuntime$;
import org.neo4j.cypher.internal.ast.CreateConstraintType;
import org.neo4j.cypher.internal.ast.NodeKey$;
import org.neo4j.cypher.internal.ast.NodePropertyExistence$;
import org.neo4j.cypher.internal.ast.NodePropertyType;
import org.neo4j.cypher.internal.ast.NodePropertyUniqueness$;
import org.neo4j.cypher.internal.ast.Options;
import org.neo4j.cypher.internal.ast.RelationshipKey$;
import org.neo4j.cypher.internal.ast.RelationshipPropertyExistence$;
import org.neo4j.cypher.internal.ast.RelationshipPropertyType;
import org.neo4j.cypher.internal.ast.RelationshipPropertyUniqueness$;
import org.neo4j.cypher.internal.ast.prettifier.Prettifier$;
import org.neo4j.cypher.internal.compiler.phases.LogicalPlanState;
import org.neo4j.cypher.internal.expressions.ElementTypeName;
import org.neo4j.cypher.internal.expressions.LabelName;
import org.neo4j.cypher.internal.expressions.Parameter;
import org.neo4j.cypher.internal.expressions.Property;
import org.neo4j.cypher.internal.expressions.PropertyKeyName;
import org.neo4j.cypher.internal.expressions.RelTypeName;
import org.neo4j.cypher.internal.expressions.SymbolicName;
import org.neo4j.cypher.internal.expressions.functions.Labels$;
import org.neo4j.cypher.internal.expressions.functions.Type$;
import org.neo4j.cypher.internal.logical.plans.CreateConstraint;
import org.neo4j.cypher.internal.logical.plans.CreateFulltextIndex;
import org.neo4j.cypher.internal.logical.plans.CreateIndex;
import org.neo4j.cypher.internal.logical.plans.CreateLookupIndex;
import org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForConstraint;
import org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForFulltextIndex;
import org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForIndex;
import org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForLookupIndex;
import org.neo4j.cypher.internal.logical.plans.DropConstraintOnName;
import org.neo4j.cypher.internal.logical.plans.DropIndexOnName;
import org.neo4j.cypher.internal.logical.plans.LogicalPlan;
import org.neo4j.cypher.internal.options.CypherRuntimeOption;
import org.neo4j.cypher.internal.optionsmap.CreateFulltextIndexOptionsConverter;
import org.neo4j.cypher.internal.optionsmap.CreateIndexWithFullOptions;
import org.neo4j.cypher.internal.optionsmap.CreateLookupIndexOptionsConverter;
import org.neo4j.cypher.internal.optionsmap.CreatePointIndexOptionsConverter;
import org.neo4j.cypher.internal.optionsmap.CreatePointIndexOptionsConverter$;
import org.neo4j.cypher.internal.optionsmap.CreateRangeIndexOptionsConverter;
import org.neo4j.cypher.internal.optionsmap.CreateTextIndexOptionsConverter;
import org.neo4j.cypher.internal.optionsmap.CreateTextIndexOptionsConverter$;
import org.neo4j.cypher.internal.optionsmap.CreateVectorIndexOptionsConverter;
import org.neo4j.cypher.internal.optionsmap.IndexBackedConstraintsOptionsConverter;
import org.neo4j.cypher.internal.optionsmap.IndexOptionsConverter;
import org.neo4j.cypher.internal.optionsmap.PropertyExistenceOrTypeConstraintOptionsConverter;
import org.neo4j.cypher.internal.plandescription.LogicalPlan2PlanDescription$;
import org.neo4j.cypher.internal.plandescription.PrettyString;
import org.neo4j.cypher.internal.plandescription.asPrettyString$;
import org.neo4j.cypher.internal.plandescription.asPrettyString$PrettyStringInterpolator$;
import org.neo4j.cypher.internal.procs.IgnoredResult;
import org.neo4j.cypher.internal.procs.PropertyTypeMapper$;
import org.neo4j.cypher.internal.procs.SchemaExecutionPlan;
import org.neo4j.cypher.internal.procs.SchemaExecutionPlan$;
import org.neo4j.cypher.internal.procs.SchemaExecutionResult;
import org.neo4j.cypher.internal.procs.SuccessResult;
import org.neo4j.cypher.internal.procs.SuccessResult$;
import org.neo4j.cypher.internal.runtime.ConstraintInformation;
import org.neo4j.cypher.internal.runtime.IndexInformation;
import org.neo4j.cypher.internal.runtime.IndexProviderContext;
import org.neo4j.cypher.internal.runtime.InternalQueryType;
import org.neo4j.cypher.internal.runtime.QueryContext;
import org.neo4j.cypher.internal.runtime.SCHEMA_WRITE$;
import org.neo4j.cypher.internal.util.IndexOrConstraintAlreadyExistsNotification;
import org.neo4j.cypher.internal.util.IndexOrConstraintDoesNotExistNotification;
import org.neo4j.cypher.internal.util.InternalNotification;
import org.neo4j.cypher.internal.util.PropertyKeyId;
import org.neo4j.cypher.internal.util.symbols.CypherType;
import org.neo4j.exceptions.CantCompileQueryException;
import org.neo4j.exceptions.ParameterWrongTypeException;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.ConstraintType;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.constraints.PropertyTypeSet;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexVersion;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.StringValue;
import org.neo4j.values.virtual.MapValue;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.Tuple6;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try;
import scala.util.Try$;

public final class SchemaCommandRuntime$
implements CypherRuntime<RuntimeContext> {
    public static final SchemaCommandRuntime$ MODULE$ = new SchemaCommandRuntime$();
    private static final PartialFunction<LogicalPlan, Function1<RuntimeContext, ExecutionPlan>> logicalToExecutable = new Serializable(){
        private static final long serialVersionUID = 0L;

        public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
            boolean bl = false;
            CreateConstraint createConstraint = null;
            boolean bl2 = false;
            CreateIndex createIndex = null;
            A1 A1 = x1;
            if (A1 instanceof CreateConstraint) {
                bl = true;
                createConstraint = (CreateConstraint)A1;
                Option source = createConstraint.source();
                CreateConstraintType createConstraintType = createConstraint.constraintType();
                ElementTypeName label = createConstraint.entityName();
                Seq props = createConstraint.props();
                Option name = createConstraint.name();
                Options options = createConstraint.options();
                if (NodeKey$.MODULE$.equals(createConstraintType) && label instanceof LabelName) {
                    LabelName labelName = (LabelName)label;
                    return (B1)(Function1 & Serializable)context -> new SchemaExecutionPlan("CreateNodeKeyConstraint", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable)(ctx, params) -> {
                        Option<String> constraintName = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$getName((Option<Either<String, Parameter>>)name, (MapValue)params);
                        IndexBackedConstraintsOptionsConverter qual$1 = new IndexBackedConstraintsOptionsConverter("node key constraint", SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$indexContext((QueryContext)ctx));
                        CypherVersion x$12 = context.cypherVersion();
                        Options x$2 = options;
                        MapValue x$3 = params;
                        Option<Config> x$4 = qual$1.convert$default$4();
                        Option indexProvider = qual$1.convert(x$12, x$2, x$3, x$4).flatMap((Function1 & Serializable)x$1 -> x$1.provider());
                        int labelId = ctx.getOrCreateLabelId(labelName.name());
                        Seq propertyKeyIds = (Seq)props.map((Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$4(ctx, p)));
                        ctx.createNodeKeyConstraint(labelId, propertyKeyIds, constraintName, indexProvider);
                        return new SuccessResult(SuccessResult$.MODULE$.apply$default$1());
                    }, (Option<ExecutionPlan>)source.map((Function1 & Serializable)x$2 -> (ExecutionPlan)((Function1)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$2, (Function1 & Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context)));
                }
            }
            if (bl) {
                Option source = createConstraint.source();
                CreateConstraintType createConstraintType = createConstraint.constraintType();
                ElementTypeName relType = createConstraint.entityName();
                Seq props = createConstraint.props();
                Option name = createConstraint.name();
                Options options = createConstraint.options();
                if (RelationshipKey$.MODULE$.equals(createConstraintType) && relType instanceof RelTypeName) {
                    RelTypeName relTypeName = (RelTypeName)relType;
                    return (B1)(Function1 & Serializable)context -> new SchemaExecutionPlan("CreateRelationshipKeyConstraint", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable)(ctx, params) -> {
                        Option<String> constraintName = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$getName((Option<Either<String, Parameter>>)name, (MapValue)params);
                        IndexBackedConstraintsOptionsConverter qual$2 = new IndexBackedConstraintsOptionsConverter("relationship key constraint", SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$indexContext((QueryContext)ctx));
                        CypherVersion x$5 = context.cypherVersion();
                        Options x$6 = options;
                        MapValue x$7 = params;
                        Option<Config> x$8 = qual$2.convert$default$4();
                        Option indexProvider = qual$2.convert(x$5, x$6, x$7, x$8).flatMap((Function1 & Serializable)x$3 -> x$3.provider());
                        int relId = ctx.getOrCreateRelTypeId(relTypeName.name());
                        Seq propertyKeyIds = (Seq)props.map((Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$10(ctx, p)));
                        ctx.createRelationshipKeyConstraint(relId, propertyKeyIds, constraintName, indexProvider);
                        return new SuccessResult(SuccessResult$.MODULE$.apply$default$1());
                    }, (Option<ExecutionPlan>)source.map((Function1 & Serializable)x$4 -> (ExecutionPlan)((Function1)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$4, (Function1 & Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context)));
                }
            }
            if (bl) {
                Option source = createConstraint.source();
                CreateConstraintType createConstraintType = createConstraint.constraintType();
                ElementTypeName label = createConstraint.entityName();
                Seq props = createConstraint.props();
                Option name = createConstraint.name();
                Options options = createConstraint.options();
                if (NodePropertyUniqueness$.MODULE$.equals(createConstraintType) && label instanceof LabelName) {
                    LabelName labelName = (LabelName)label;
                    return (B1)(Function1 & Serializable)context -> new SchemaExecutionPlan("CreateNodePropertyUniquenessConstraint", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable)(ctx, params) -> {
                        Option<String> constraintName = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$getName((Option<Either<String, Parameter>>)name, (MapValue)params);
                        IndexBackedConstraintsOptionsConverter qual$3 = new IndexBackedConstraintsOptionsConverter("uniqueness constraint", SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$indexContext((QueryContext)ctx));
                        CypherVersion x$9 = context.cypherVersion();
                        Options x$10 = options;
                        MapValue x$11 = params;
                        Option<Config> x$12 = qual$3.convert$default$4();
                        Option indexProvider = qual$3.convert(x$9, x$10, x$11, x$12).flatMap((Function1 & Serializable)x$5 -> x$5.provider());
                        int labelId = ctx.getOrCreateLabelId(labelName.name());
                        Seq propertyKeyIds = (Seq)props.map((Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$16(ctx, p)));
                        ctx.createNodeUniqueConstraint(labelId, propertyKeyIds, constraintName, indexProvider);
                        return new SuccessResult(SuccessResult$.MODULE$.apply$default$1());
                    }, (Option<ExecutionPlan>)source.map((Function1 & Serializable)x$6 -> (ExecutionPlan)((Function1)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$6, (Function1 & Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context)));
                }
            }
            if (bl) {
                Option source = createConstraint.source();
                CreateConstraintType createConstraintType = createConstraint.constraintType();
                ElementTypeName relType = createConstraint.entityName();
                Seq props = createConstraint.props();
                Option name = createConstraint.name();
                Options options = createConstraint.options();
                if (RelationshipPropertyUniqueness$.MODULE$.equals(createConstraintType) && relType instanceof RelTypeName) {
                    RelTypeName relTypeName = (RelTypeName)relType;
                    return (B1)(Function1 & Serializable)context -> new SchemaExecutionPlan("CreateRelationshipPropertyUniquenessConstraint", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable)(ctx, params) -> {
                        Option<String> constraintName = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$getName((Option<Either<String, Parameter>>)name, (MapValue)params);
                        IndexBackedConstraintsOptionsConverter qual$4 = new IndexBackedConstraintsOptionsConverter("relationship uniqueness constraint", SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$indexContext((QueryContext)ctx));
                        CypherVersion x$13 = context.cypherVersion();
                        Options x$14 = options;
                        MapValue x$15 = params;
                        Option<Config> x$16 = qual$4.convert$default$4();
                        Option indexProvider = qual$4.convert(x$13, x$14, x$15, x$16).flatMap((Function1 & Serializable)x$7 -> x$7.provider());
                        int relTypeId = ctx.getOrCreateRelTypeId(relTypeName.name());
                        Seq propertyKeyIds = (Seq)props.map((Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$22(ctx, p)));
                        ctx.createRelationshipUniqueConstraint(relTypeId, propertyKeyIds, constraintName, indexProvider);
                        return new SuccessResult(SuccessResult$.MODULE$.apply$default$1());
                    }, (Option<ExecutionPlan>)source.map((Function1 & Serializable)x$8 -> (ExecutionPlan)((Function1)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$8, (Function1 & Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context)));
                }
            }
            if (bl) {
                Option source = createConstraint.source();
                CreateConstraintType createConstraintType = createConstraint.constraintType();
                ElementTypeName label = createConstraint.entityName();
                Seq prop = createConstraint.props();
                Option name = createConstraint.name();
                Options options = createConstraint.options();
                if (NodePropertyExistence$.MODULE$.equals(createConstraintType) && label instanceof LabelName) {
                    LabelName labelName = (LabelName)label;
                    return (B1)(Function1 & Serializable)context -> new SchemaExecutionPlan("CreateNodePropertyExistenceConstraint", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable)(ctx, params) -> {
                        Option<String> constraintName = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$getName((Option<Either<String, Parameter>>)name, (MapValue)params);
                        PropertyExistenceOrTypeConstraintOptionsConverter qual$5 = new PropertyExistenceOrTypeConstraintOptionsConverter("node", "existence", SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$indexContext((QueryContext)ctx));
                        CypherVersion x$17 = context.cypherVersion();
                        Options x$18 = options;
                        MapValue x$19 = params;
                        Option<Config> x$20 = qual$5.convert$default$4();
                        qual$5.convert(x$17, x$18, x$19, x$20);
                        ((Function3 & Serializable)(Function3 & Serializable)(labelId, propertyKeyId, name) -> {
                            anonfun.1.$anonfun$applyOrElse$27(ctx, BoxesRunTime.unboxToInt((Object)labelId), BoxesRunTime.unboxToInt((Object)propertyKeyId), name);
                            return BoxedUnit.UNIT;
                        }).tupled().apply(SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$labelPropWithName((QueryContext)ctx, labelName, ((Property)prop.head()).propertyKey(), constraintName));
                        return new SuccessResult(SuccessResult$.MODULE$.apply$default$1());
                    }, (Option<ExecutionPlan>)source.map((Function1 & Serializable)x$9 -> (ExecutionPlan)((Function1)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$9, (Function1 & Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context)));
                }
            }
            if (bl) {
                Option source = createConstraint.source();
                CreateConstraintType createConstraintType = createConstraint.constraintType();
                ElementTypeName relType = createConstraint.entityName();
                Seq prop = createConstraint.props();
                Option name = createConstraint.name();
                Options options = createConstraint.options();
                if (RelationshipPropertyExistence$.MODULE$.equals(createConstraintType) && relType instanceof RelTypeName) {
                    RelTypeName relTypeName = (RelTypeName)relType;
                    return (B1)(Function1 & Serializable)context -> new SchemaExecutionPlan("CreateRelationshipPropertyExistenceConstraint", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable)(ctx, params) -> {
                        Option<String> constraintName = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$getName((Option<Either<String, Parameter>>)name, (MapValue)params);
                        PropertyExistenceOrTypeConstraintOptionsConverter qual$6 = new PropertyExistenceOrTypeConstraintOptionsConverter("relationship", "existence", SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$indexContext((QueryContext)ctx));
                        CypherVersion x$21 = context.cypherVersion();
                        Options x$22 = options;
                        MapValue x$23 = params;
                        Option<Config> x$24 = qual$6.convert$default$4();
                        qual$6.convert(x$21, x$22, x$23, x$24);
                        ((Function3 & Serializable)(Function3 & Serializable)(relTypeId, propertyKeyId, name) -> {
                            anonfun.1.$anonfun$applyOrElse$32(ctx, BoxesRunTime.unboxToInt((Object)relTypeId), BoxesRunTime.unboxToInt((Object)propertyKeyId), name);
                            return BoxedUnit.UNIT;
                        }).tupled().apply(SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$typePropWithName((QueryContext)ctx, relTypeName, ((Property)prop.head()).propertyKey(), constraintName));
                        return new SuccessResult(SuccessResult$.MODULE$.apply$default$1());
                    }, (Option<ExecutionPlan>)source.map((Function1 & Serializable)x$10 -> (ExecutionPlan)((Function1)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$10, (Function1 & Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context)));
                }
            }
            if (bl) {
                Option source = createConstraint.source();
                CreateConstraintType createConstraintType = createConstraint.constraintType();
                ElementTypeName label = createConstraint.entityName();
                Seq prop = createConstraint.props();
                Option name = createConstraint.name();
                Options options = createConstraint.options();
                if (createConstraintType instanceof NodePropertyType) {
                    NodePropertyType nodePropertyType = (NodePropertyType)createConstraintType;
                    CypherType propertyType = nodePropertyType.propType();
                    if (label instanceof LabelName) {
                        LabelName labelName = (LabelName)label;
                        return (B1)(Function1 & Serializable)context -> new SchemaExecutionPlan("CreateNodePropertyTypeConstraint", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable)(ctx, params) -> {
                            Option<String> constraintName = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$getName((Option<Either<String, Parameter>>)name, (MapValue)params);
                            PropertyExistenceOrTypeConstraintOptionsConverter qual$7 = new PropertyExistenceOrTypeConstraintOptionsConverter("node", "type", SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$indexContext((QueryContext)ctx));
                            CypherVersion x$25 = context.cypherVersion();
                            Options x$26 = options;
                            MapValue x$27 = params;
                            Option<Config> x$28 = qual$7.convert$default$4();
                            qual$7.convert(x$25, x$26, x$27, x$28);
                            Tuple3<Object, Object, Option<String>> tuple3 = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$labelPropWithName((QueryContext)ctx, labelName, ((Property)prop.head()).propertyKey(), constraintName);
                            if (tuple3 == null) {
                                throw new MatchError(tuple3);
                            }
                            int labelId = BoxesRunTime.unboxToInt((Object)tuple3._1());
                            int propId = BoxesRunTime.unboxToInt((Object)tuple3._2());
                            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(labelId, propId);
                            int labelId2 = sp2._1$mcI$sp();
                            int propId2 = sp2._2$mcI$sp();
                            ctx.createNodePropertyTypeConstraint(labelId2, propId2, PropertyTypeMapper$.MODULE$.asPropertyTypeSet(propertyType), constraintName);
                            return new SuccessResult(SuccessResult$.MODULE$.apply$default$1());
                        }, (Option<ExecutionPlan>)source.map((Function1 & Serializable)x$12 -> (ExecutionPlan)((Function1)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$12, (Function1 & Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context)));
                    }
                }
            }
            if (bl) {
                Option source = createConstraint.source();
                CreateConstraintType createConstraintType = createConstraint.constraintType();
                ElementTypeName relType = createConstraint.entityName();
                Seq prop = createConstraint.props();
                Option name = createConstraint.name();
                Options options = createConstraint.options();
                if (createConstraintType instanceof RelationshipPropertyType) {
                    RelationshipPropertyType relationshipPropertyType = (RelationshipPropertyType)createConstraintType;
                    CypherType propertyType = relationshipPropertyType.propType();
                    if (relType instanceof RelTypeName) {
                        RelTypeName relTypeName = (RelTypeName)relType;
                        return (B1)(Function1 & Serializable)context -> new SchemaExecutionPlan("CreateRelationshipPropertyTypeConstraint", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable)(ctx, params) -> {
                            Option<String> constraintName = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$getName((Option<Either<String, Parameter>>)name, (MapValue)params);
                            PropertyExistenceOrTypeConstraintOptionsConverter qual$8 = new PropertyExistenceOrTypeConstraintOptionsConverter("relationship", "type", SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$indexContext((QueryContext)ctx));
                            CypherVersion x$29 = context.cypherVersion();
                            Options x$30 = options;
                            MapValue x$31 = params;
                            Option<Config> x$32 = qual$8.convert$default$4();
                            qual$8.convert(x$29, x$30, x$31, x$32);
                            Tuple3<Object, Object, Option<String>> tuple3 = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$typePropWithName((QueryContext)ctx, relTypeName, ((Property)prop.head()).propertyKey(), constraintName);
                            if (tuple3 == null) {
                                throw new MatchError(tuple3);
                            }
                            int relTypeId = BoxesRunTime.unboxToInt((Object)tuple3._1());
                            int propId = BoxesRunTime.unboxToInt((Object)tuple3._2());
                            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(relTypeId, propId);
                            int relTypeId2 = sp2._1$mcI$sp();
                            int propId2 = sp2._2$mcI$sp();
                            ctx.createRelationshipPropertyTypeConstraint(relTypeId2, propId2, PropertyTypeMapper$.MODULE$.asPropertyTypeSet(propertyType), constraintName);
                            return new SuccessResult(SuccessResult$.MODULE$.apply$default$1());
                        }, (Option<ExecutionPlan>)source.map((Function1 & Serializable)x$14 -> (ExecutionPlan)((Function1)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$14, (Function1 & Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context)));
                    }
                }
            }
            if (A1 instanceof DropConstraintOnName) {
                DropConstraintOnName dropConstraintOnName = (DropConstraintOnName)A1;
                Either name = dropConstraintOnName.name();
                boolean ifExists = dropConstraintOnName.ifExists();
                return (B1)(Function1 & Serializable)x$15 -> new SchemaExecutionPlan("DropConstraint", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable)(ctx, params) -> {
                    Set set;
                    String constraintName = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$getName((Either<String, Parameter>)name, (MapValue)params);
                    if (!ifExists || ctx.constraintExists(constraintName)) {
                        ctx.dropNamedConstraint(constraintName);
                        set = Predef$.MODULE$.Set().empty();
                    } else {
                        set = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InternalNotification[]{new IndexOrConstraintDoesNotExistNotification("DROP CONSTRAINT " + Prettifier$.MODULE$.escapeName((Either)package$.MODULE$.Left().apply((Object)constraintName)) + " IF EXISTS", constraintName)}));
                    }
                    Set notifications = set;
                    return new SuccessResult((Set<InternalNotification>)notifications);
                }, SchemaExecutionPlan$.MODULE$.apply$default$3());
            }
            if (A1 instanceof CreateIndex) {
                bl2 = true;
                createIndex = (CreateIndex)A1;
                Option source = createIndex.source();
                org.neo4j.graphdb.schema.IndexType indexType = createIndex.indexType();
                ElementTypeName entityName = createIndex.entityName();
                List props = createIndex.propertyKeyNames();
                Option name = createIndex.name();
                Options options = createIndex.options();
                if (org.neo4j.graphdb.schema.IndexType.RANGE.equals(indexType)) {
                    return (B1)(Function1 & Serializable)context -> new SchemaExecutionPlan("CreateIndex", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable)(ctx, params) -> {
                        String string;
                        EntityType entityType;
                        Option<String> indexName = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$getName((Option<Either<String, Parameter>>)name, (MapValue)params);
                        Tuple2<Object, EntityType> tuple2 = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$getEntityInfo(entityName, (QueryContext)ctx);
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        int entityId = tuple2._1$mcI$sp();
                        EntityType entityType2 = (EntityType)tuple2._2();
                        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)entityId), (Object)entityType2);
                        int entityId2 = tuple22._1$mcI$sp();
                        EntityType entityType3 = entityType = (EntityType)tuple22._2();
                        if (EntityType.NODE.equals(entityType3)) {
                            string = "range node property index";
                        } else if (EntityType.RELATIONSHIP.equals(entityType3)) {
                            string = "range relationship property index";
                        } else {
                            throw new MatchError((Object)entityType3);
                        }
                        String schemaType = string;
                        CreateRangeIndexOptionsConverter qual$9 = new CreateRangeIndexOptionsConverter(schemaType, SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$indexContext((QueryContext)ctx));
                        CypherVersion x$33 = context.cypherVersion();
                        Options x$34 = options;
                        MapValue x$35 = params;
                        Option<Config> x$36 = qual$9.convert$default$4();
                        Option provider = qual$9.convert(x$33, x$34, x$35, x$36).flatMap((Function1 & Serializable)x$17 -> x$17.provider());
                        List propertyKeyIds = props.map((Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$48(ctx, p)));
                        ctx.addRangeIndexRule(entityId2, entityType, (Seq)propertyKeyIds, indexName, provider);
                        return new SuccessResult(SuccessResult$.MODULE$.apply$default$1());
                    }, (Option<ExecutionPlan>)source.map((Function1 & Serializable)x$18 -> (ExecutionPlan)((Function1)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$18, (Function1 & Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context)));
                }
            }
            if (A1 instanceof CreateLookupIndex) {
                CreateLookupIndex createLookupIndex = (CreateLookupIndex)A1;
                Option source = createLookupIndex.source();
                EntityType entityType = createLookupIndex.entityType();
                Option name = createLookupIndex.name();
                Options options = createLookupIndex.options();
                return (B1)(Function1 & Serializable)context -> new SchemaExecutionPlan("CreateIndex", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable)(ctx, params) -> {
                    Option<String> indexName = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$getName((Option<Either<String, Parameter>>)name, (MapValue)params);
                    CreateLookupIndexOptionsConverter qual$10 = new CreateLookupIndexOptionsConverter(SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$indexContext((QueryContext)ctx));
                    CypherVersion x$37 = context.cypherVersion();
                    Options x$38 = options;
                    MapValue x$39 = params;
                    Option<Config> x$40 = qual$10.convert$default$4();
                    Option provider = qual$10.convert(x$37, x$38, x$39, x$40).flatMap((Function1 & Serializable)x$19 -> x$19.provider());
                    ctx.addLookupIndexRule(entityType, indexName, provider);
                    return new SuccessResult(SuccessResult$.MODULE$.apply$default$1());
                }, (Option<ExecutionPlan>)source.map((Function1 & Serializable)x$20 -> (ExecutionPlan)((Function1)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$20, (Function1 & Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context)));
            }
            if (A1 instanceof CreateFulltextIndex) {
                CreateFulltextIndex createFulltextIndex = (CreateFulltextIndex)A1;
                Option source = createFulltextIndex.source();
                Either entityNames = createFulltextIndex.entityNames();
                List props = createFulltextIndex.propertyKeyNames();
                Option name = createFulltextIndex.name();
                Options options = createFulltextIndex.options();
                return (B1)(Function1 & Serializable)context -> new SchemaExecutionPlan("CreateIndex", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable)(ctx, params) -> {
                    Some some;
                    CreateIndexWithFullOptions createIndexWithFullOptions;
                    Tuple2 tuple2;
                    Option<Config> x$44;
                    MapValue x$43;
                    Options x$42;
                    CypherVersion x$41;
                    Option<String> indexName = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$getName((Option<Either<String, Parameter>>)name, (MapValue)params);
                    CreateFulltextIndexOptionsConverter qual$11 = new CreateFulltextIndexOptionsConverter(SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$indexContext((QueryContext)ctx));
                    Option<CreateIndexWithFullOptions> option = qual$11.convert(x$41 = context.cypherVersion(), x$42 = options, x$43 = params, x$44 = qual$11.convert$default$4());
                    if (None$.MODULE$.equals(option)) {
                        tuple2 = new Tuple2((Object)None$.MODULE$, (Object)IndexConfig.empty());
                    } else if (option instanceof Some && (createIndexWithFullOptions = (CreateIndexWithFullOptions)(some = (Some)option).value()) != null) {
                        Option<IndexProviderDescriptor> provider = createIndexWithFullOptions.provider();
                        IndexConfig config = createIndexWithFullOptions.config();
                        tuple2 = new Tuple2(provider, (Object)config);
                    } else {
                        throw new MatchError(option);
                    }
                    Tuple2 tuple22 = tuple2;
                    if (tuple22 == null) {
                        throw new MatchError((Object)tuple22);
                    }
                    Option indexProvider = (Option)tuple22._1();
                    IndexConfig indexConfig = (IndexConfig)tuple22._2();
                    Tuple2 tuple23 = new Tuple2((Object)indexProvider, (Object)indexConfig);
                    Option indexProvider2 = (Option)tuple23._1();
                    IndexConfig indexConfig2 = (IndexConfig)tuple23._2();
                    Tuple2<List<Object>, EntityType> tuple24 = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$getMultipleEntityInfo((Either<List<LabelName>, List<RelTypeName>>)entityNames, (QueryContext)ctx);
                    if (tuple24 == null) {
                        throw new MatchError(tuple24);
                    }
                    List entityIds = (List)tuple24._1();
                    EntityType entityType = (EntityType)tuple24._2();
                    Tuple2 tuple25 = new Tuple2((Object)entityIds, (Object)entityType);
                    List entityIds2 = (List)tuple25._1();
                    EntityType entityType2 = (EntityType)tuple25._2();
                    List propertyKeyIds = props.map((Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$58(ctx, p)));
                    ctx.addFulltextIndexRule(entityIds2, entityType2, (Seq)propertyKeyIds, indexName, indexProvider2, indexConfig2);
                    return new SuccessResult(SuccessResult$.MODULE$.apply$default$1());
                }, (Option<ExecutionPlan>)source.map((Function1 & Serializable)x$23 -> (ExecutionPlan)((Function1)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$23, (Function1 & Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context)));
            }
            if (bl2) {
                Option source = createIndex.source();
                org.neo4j.graphdb.schema.IndexType indexType = createIndex.indexType();
                ElementTypeName entityName = createIndex.entityName();
                List props = createIndex.propertyKeyNames();
                Option name = createIndex.name();
                Options options = createIndex.options();
                if (org.neo4j.graphdb.schema.IndexType.TEXT.equals(indexType)) {
                    return (B1)(Function1 & Serializable)context -> new SchemaExecutionPlan("CreateIndex", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable)(ctx, params) -> {
                        Option<String> indexName = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$getName((Option<Either<String, Parameter>>)name, (MapValue)params);
                        CreateTextIndexOptionsConverter qual$12 = new CreateTextIndexOptionsConverter(SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$indexContext((QueryContext)ctx));
                        CypherVersion x$45 = context.cypherVersion();
                        Options x$46 = options;
                        MapValue x$47 = params;
                        Option<Config> x$48 = qual$12.convert$default$4();
                        Option provider = qual$12.convert(x$45, x$46, x$47, x$48).flatMap((Function1 & Serializable)x$24 -> x$24.provider());
                        Tuple2<Object, EntityType> tuple2 = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$getEntityInfo(entityName, (QueryContext)ctx);
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        int entityId = tuple2._1$mcI$sp();
                        EntityType entityType = (EntityType)tuple2._2();
                        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)entityId), (Object)entityType);
                        int entityId2 = tuple22._1$mcI$sp();
                        EntityType entityType2 = (EntityType)tuple22._2();
                        List propertyKeyIds = props.map((Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$64(ctx, p)));
                        ctx.addTextIndexRule(entityId2, entityType2, (Seq)propertyKeyIds, indexName, provider);
                        return new SuccessResult(SuccessResult$.MODULE$.apply$default$1());
                    }, (Option<ExecutionPlan>)source.map((Function1 & Serializable)x$26 -> (ExecutionPlan)((Function1)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$26, (Function1 & Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context)));
                }
            }
            if (bl2) {
                Option source = createIndex.source();
                org.neo4j.graphdb.schema.IndexType indexType = createIndex.indexType();
                ElementTypeName entityName = createIndex.entityName();
                List props = createIndex.propertyKeyNames();
                Option name = createIndex.name();
                Options options = createIndex.options();
                if (org.neo4j.graphdb.schema.IndexType.POINT.equals(indexType)) {
                    return (B1)(Function1 & Serializable)context -> new SchemaExecutionPlan("CreateIndex", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable)(ctx, params) -> {
                        Some some;
                        CreateIndexWithFullOptions createIndexWithFullOptions;
                        Tuple2 tuple2;
                        Option<Config> x$52;
                        MapValue x$51;
                        Options x$50;
                        CypherVersion x$49;
                        Option<String> indexName = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$getName((Option<Either<String, Parameter>>)name, (MapValue)params);
                        CreatePointIndexOptionsConverter qual$13 = new CreatePointIndexOptionsConverter(SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$indexContext((QueryContext)ctx));
                        Option<CreateIndexWithFullOptions> option = qual$13.convert(x$49 = context.cypherVersion(), x$50 = options, x$51 = params, x$52 = qual$13.convert$default$4());
                        if (None$.MODULE$.equals(option)) {
                            tuple2 = new Tuple2((Object)None$.MODULE$, (Object)IndexConfig.empty());
                        } else if (option instanceof Some && (createIndexWithFullOptions = (CreateIndexWithFullOptions)(some = (Some)option).value()) != null) {
                            Option<IndexProviderDescriptor> provider = createIndexWithFullOptions.provider();
                            IndexConfig config = createIndexWithFullOptions.config();
                            tuple2 = new Tuple2(provider, (Object)config);
                        } else {
                            throw new MatchError(option);
                        }
                        Tuple2 tuple22 = tuple2;
                        if (tuple22 == null) {
                            throw new MatchError((Object)tuple22);
                        }
                        Option indexProvider = (Option)tuple22._1();
                        IndexConfig indexConfig = (IndexConfig)tuple22._2();
                        Tuple2 tuple23 = new Tuple2((Object)indexProvider, (Object)indexConfig);
                        Option indexProvider2 = (Option)tuple23._1();
                        IndexConfig indexConfig2 = (IndexConfig)tuple23._2();
                        Tuple2<Object, EntityType> tuple24 = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$getEntityInfo(entityName, (QueryContext)ctx);
                        if (tuple24 == null) {
                            throw new MatchError(tuple24);
                        }
                        int entityId = tuple24._1$mcI$sp();
                        EntityType entityType = (EntityType)tuple24._2();
                        Tuple2 tuple25 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)entityId), (Object)entityType);
                        int entityId2 = tuple25._1$mcI$sp();
                        EntityType entityType2 = (EntityType)tuple25._2();
                        List propertyKeyIds = props.map((Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$69(ctx, p)));
                        ctx.addPointIndexRule(entityId2, entityType2, (Seq)propertyKeyIds, indexName, indexProvider2, indexConfig2);
                        return new SuccessResult(SuccessResult$.MODULE$.apply$default$1());
                    }, (Option<ExecutionPlan>)source.map((Function1 & Serializable)x$29 -> (ExecutionPlan)((Function1)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$29, (Function1 & Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context)));
                }
            }
            if (bl2) {
                Option source = createIndex.source();
                org.neo4j.graphdb.schema.IndexType indexType = createIndex.indexType();
                ElementTypeName entityName = createIndex.entityName();
                List props = createIndex.propertyKeyNames();
                Option name = createIndex.name();
                Options options = createIndex.options();
                if (org.neo4j.graphdb.schema.IndexType.VECTOR.equals(indexType)) {
                    return (B1)(Function1 & Serializable)context -> new SchemaExecutionPlan("CreateIndex", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable)(ctx, params) -> {
                        Some some;
                        CreateIndexWithFullOptions createIndexWithFullOptions;
                        Tuple2 tuple2;
                        Option<String> indexName = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$getName((Option<Either<String, Parameter>>)name, (MapValue)params);
                        CreateVectorIndexOptionsConverter optionsConverter = new CreateVectorIndexOptionsConverter(SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$indexContext((QueryContext)ctx), SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$vectorIndexVersion((QueryContext)ctx));
                        Option<CreateIndexWithFullOptions> option = optionsConverter.convert(context.cypherVersion(), options, (MapValue)params, optionsConverter.convert$default$4());
                        if (None$.MODULE$.equals(option)) {
                            tuple2 = new Tuple2((Object)None$.MODULE$, (Object)IndexConfig.empty());
                        } else if (option instanceof Some && (createIndexWithFullOptions = (CreateIndexWithFullOptions)(some = (Some)option).value()) != null) {
                            Option<IndexProviderDescriptor> provider = createIndexWithFullOptions.provider();
                            IndexConfig config = createIndexWithFullOptions.config();
                            tuple2 = new Tuple2(provider, (Object)config);
                        } else {
                            throw new MatchError(option);
                        }
                        Tuple2 tuple22 = tuple2;
                        if (tuple22 == null) {
                            throw new MatchError((Object)tuple22);
                        }
                        Option indexProvider = (Option)tuple22._1();
                        IndexConfig indexConfig = (IndexConfig)tuple22._2();
                        Tuple2 tuple23 = new Tuple2((Object)indexProvider, (Object)indexConfig);
                        Option indexProvider2 = (Option)tuple23._1();
                        IndexConfig indexConfig2 = (IndexConfig)tuple23._2();
                        Tuple2<Object, EntityType> tuple24 = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$getEntityInfo(entityName, (QueryContext)ctx);
                        if (tuple24 == null) {
                            throw new MatchError(tuple24);
                        }
                        int entityId = tuple24._1$mcI$sp();
                        EntityType entityType = (EntityType)tuple24._2();
                        Tuple2 tuple25 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)entityId), (Object)entityType);
                        int entityId2 = tuple25._1$mcI$sp();
                        EntityType entityType2 = (EntityType)tuple25._2();
                        List propertyKeyIds = props.map((Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$74(ctx, p)));
                        ctx.addVectorIndexRule(entityId2, entityType2, (Seq)propertyKeyIds, indexName, indexProvider2, indexConfig2);
                        return new SuccessResult(SuccessResult$.MODULE$.apply$default$1());
                    }, (Option<ExecutionPlan>)source.map((Function1 & Serializable)x$32 -> (ExecutionPlan)((Function1)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$32, (Function1 & Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context)));
                }
            }
            if (A1 instanceof DropIndexOnName) {
                DropIndexOnName dropIndexOnName = (DropIndexOnName)A1;
                Either name = dropIndexOnName.name();
                boolean ifExists = dropIndexOnName.ifExists();
                return (B1)(Function1 & Serializable)x$33 -> new SchemaExecutionPlan("DropIndex", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable)(ctx, params) -> {
                    Set set;
                    String indexName = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$getName((Either<String, Parameter>)name, (MapValue)params);
                    if (!ifExists || ctx.indexExists(indexName)) {
                        ctx.dropIndexRule(indexName);
                        set = Predef$.MODULE$.Set().empty();
                    } else {
                        set = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InternalNotification[]{new IndexOrConstraintDoesNotExistNotification("DROP INDEX " + Prettifier$.MODULE$.escapeName((Either)package$.MODULE$.Left().apply((Object)indexName)) + " IF EXISTS", indexName)}));
                    }
                    Set notifications = set;
                    return new SuccessResult((Set<InternalNotification>)notifications);
                }, SchemaExecutionPlan$.MODULE$.apply$default$3());
            }
            if (A1 instanceof DoNothingIfExistsForIndex) {
                DoNothingIfExistsForIndex doNothingIfExistsForIndex = (DoNothingIfExistsForIndex)A1;
                ElementTypeName entityName = doNothingIfExistsForIndex.entityName();
                List propertyKeyNames = doNothingIfExistsForIndex.propertyKeyNames();
                org.neo4j.graphdb.schema.IndexType indexType = doNothingIfExistsForIndex.indexType();
                Option name = doNothingIfExistsForIndex.name();
                Options options = doNothingIfExistsForIndex.options();
                return (B1)(Function1 & Serializable)context -> {
                    Tuple2 tuple2;
                    org.neo4j.graphdb.schema.IndexType indexType = indexType;
                    if (org.neo4j.graphdb.schema.IndexType.POINT.equals(indexType)) {
                        tuple2 = new Tuple2((Object)IndexType.POINT, (Object)CreatePointIndexOptionsConverter$.MODULE$);
                    } else if (org.neo4j.graphdb.schema.IndexType.RANGE.equals(indexType)) {
                        tuple2 = new Tuple2((Object)IndexType.RANGE, (Function1 & Serializable)ctx -> new CreateRangeIndexOptionsConverter("range index", SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$indexContext((QueryContext)ctx)));
                    } else if (org.neo4j.graphdb.schema.IndexType.TEXT.equals(indexType)) {
                        tuple2 = new Tuple2((Object)IndexType.TEXT, (Object)CreateTextIndexOptionsConverter$.MODULE$);
                    } else if (org.neo4j.graphdb.schema.IndexType.VECTOR.equals(indexType)) {
                        tuple2 = new Tuple2((Object)IndexType.VECTOR, (Function1 & Serializable)ctx -> new CreateVectorIndexOptionsConverter(SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$indexContext((QueryContext)ctx), SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$vectorIndexVersion((QueryContext)ctx)));
                    } else {
                        throw new IllegalStateException("Did not expect index type " + indexType + " here: only point, range, text or vector indexes.");
                    }
                    Tuple2 tuple22 = tuple2;
                    if (tuple22 == null) {
                        throw new MatchError((Object)tuple22);
                    }
                    IndexType innerIndexType = (IndexType)tuple22._1();
                    Function1 optionsConverter = (Function1)tuple22._2();
                    Tuple2 tuple23 = new Tuple2((Object)innerIndexType, (Object)optionsConverter);
                    IndexType innerIndexType2 = (IndexType)tuple23._1();
                    Function1 optionsConverter2 = (Function1)tuple23._2();
                    return new SchemaExecutionPlan("DoNothingIfExist", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable)(ctx, params) -> {
                        Option<String> indexName = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$getName((Option<Either<String, Parameter>>)name, (MapValue)params);
                        IndexOptionsConverter qual$14 = (IndexOptionsConverter)optionsConverter2.apply(ctx);
                        CypherVersion x$53 = context.cypherVersion();
                        Options x$54 = options;
                        MapValue x$55 = params;
                        Option<Config> x$56 = qual$14.convert$default$4();
                        qual$14.convert(x$53, x$54, x$55, x$56);
                        Tuple2<Object, EntityType> tuple2 = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$getEntityInfo(entityName, (QueryContext)ctx);
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        int entityId = tuple2._1$mcI$sp();
                        EntityType entityType = (EntityType)tuple2._2();
                        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)entityId), (Object)entityType);
                        int entityId2 = tuple22._1$mcI$sp();
                        EntityType entityType2 = (EntityType)tuple22._2();
                        List propertyKeyIds = propertyKeyNames.map((Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$83(ctx, p)));
                        Try existingIndexDescriptor = Try$.MODULE$.apply((Function0 & Serializable)() -> ctx.indexReference(innerIndexType2, entityId2, entityType2, (Seq)propertyKeyIds));
                        if (existingIndexDescriptor.isSuccess()) {
                            String indexDescription = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$indexInfo(indexType.name(), indexName, entityName, (Seq<PropertyKeyName>)propertyKeyNames, options);
                            String conflictingIndex = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$existingIndexInfo((QueryContext)ctx, (Function0<IndexInformation>)(Function0 & Serializable)() -> ctx.getIndexInformation((IndexDescriptor)existingIndexDescriptor.get()));
                            IndexOrConstraintAlreadyExistsNotification notification = new IndexOrConstraintAlreadyExistsNotification("CREATE " + indexDescription, conflictingIndex);
                            return new IgnoredResult((Set<InternalNotification>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InternalNotification[]{notification}))));
                        }
                        if (indexName.exists((Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)anonfun.1.$anonfun$applyOrElse$86(ctx, name)))) {
                            String indexDescription = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$indexInfo(indexType.name(), indexName, entityName, (Seq<PropertyKeyName>)propertyKeyNames, options);
                            String conflictingIndex = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$existingIndexInfo((QueryContext)ctx, (Function0<IndexInformation>)(Function0 & Serializable)() -> ctx.getIndexInformation((String)indexName.get()));
                            IndexOrConstraintAlreadyExistsNotification notification = new IndexOrConstraintAlreadyExistsNotification("CREATE " + indexDescription, conflictingIndex);
                            return new IgnoredResult((Set<InternalNotification>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InternalNotification[]{notification}))));
                        }
                        return new SuccessResult(SuccessResult$.MODULE$.apply$default$1());
                    }, (Option<ExecutionPlan>)None$.MODULE$);
                };
            }
            if (A1 instanceof DoNothingIfExistsForLookupIndex) {
                DoNothingIfExistsForLookupIndex doNothingIfExistsForLookupIndex = (DoNothingIfExistsForLookupIndex)A1;
                EntityType entityType = doNothingIfExistsForLookupIndex.entityType();
                Option name = doNothingIfExistsForLookupIndex.name();
                Options options = doNothingIfExistsForLookupIndex.options();
                return (B1)(Function1 & Serializable)context -> new SchemaExecutionPlan("DoNothingIfExist", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable)(ctx, params) -> {
                    Option<String> indexName = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$getName((Option<Either<String, Parameter>>)name, (MapValue)params);
                    CreateLookupIndexOptionsConverter qual$15 = new CreateLookupIndexOptionsConverter((IndexProviderContext)ctx);
                    CypherVersion x$57 = context.cypherVersion();
                    Options x$58 = options;
                    MapValue x$59 = params;
                    Option<Config> x$60 = qual$15.convert$default$4();
                    qual$15.convert(x$57, x$58, x$59, x$60);
                    Try existingIndexDescriptor = Try$.MODULE$.apply((Function0 & Serializable)() -> ctx.lookupIndexReference(entityType));
                    if (existingIndexDescriptor.isSuccess()) {
                        String indexDescription = SchemaCommandRuntime$.MODULE$.lookupIndexInfo(indexName, entityType, options);
                        String conflictingIndex = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$existingIndexInfo((QueryContext)ctx, (Function0<IndexInformation>)(Function0 & Serializable)() -> ctx.getIndexInformation((IndexDescriptor)existingIndexDescriptor.get()));
                        IndexOrConstraintAlreadyExistsNotification notification = new IndexOrConstraintAlreadyExistsNotification("CREATE " + indexDescription, conflictingIndex);
                        return new IgnoredResult((Set<InternalNotification>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InternalNotification[]{notification}))));
                    }
                    if (indexName.exists((Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)anonfun.1.$anonfun$applyOrElse$92(ctx, name)))) {
                        String indexDescription = SchemaCommandRuntime$.MODULE$.lookupIndexInfo(indexName, entityType, options);
                        String conflictingIndex = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$existingIndexInfo((QueryContext)ctx, (Function0<IndexInformation>)(Function0 & Serializable)() -> ctx.getIndexInformation((String)indexName.get()));
                        IndexOrConstraintAlreadyExistsNotification notification = new IndexOrConstraintAlreadyExistsNotification("CREATE " + indexDescription, conflictingIndex);
                        return new IgnoredResult((Set<InternalNotification>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InternalNotification[]{notification}))));
                    }
                    return new SuccessResult(SuccessResult$.MODULE$.apply$default$1());
                }, (Option<ExecutionPlan>)None$.MODULE$);
            }
            if (A1 instanceof DoNothingIfExistsForFulltextIndex) {
                DoNothingIfExistsForFulltextIndex doNothingIfExistsForFulltextIndex = (DoNothingIfExistsForFulltextIndex)A1;
                Either entityNames = doNothingIfExistsForFulltextIndex.entityNames();
                List propertyKeyNames = doNothingIfExistsForFulltextIndex.propertyKeyNames();
                Option name = doNothingIfExistsForFulltextIndex.name();
                Options options = doNothingIfExistsForFulltextIndex.options();
                return (B1)(Function1 & Serializable)context -> new SchemaExecutionPlan("DoNothingIfExist", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable)(ctx, params) -> {
                    Option<String> indexName = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$getName((Option<Either<String, Parameter>>)name, (MapValue)params);
                    CreateFulltextIndexOptionsConverter qual$16 = new CreateFulltextIndexOptionsConverter((IndexProviderContext)ctx);
                    CypherVersion x$61 = context.cypherVersion();
                    Options x$62 = options;
                    MapValue x$63 = params;
                    Option<Config> x$64 = qual$16.convert$default$4();
                    qual$16.convert(x$61, x$62, x$63, x$64);
                    Tuple2<List<Object>, EntityType> tuple2 = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$getMultipleEntityInfo((Either<List<LabelName>, List<RelTypeName>>)entityNames, (QueryContext)ctx);
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    List entityIds = (List)tuple2._1();
                    EntityType entityType = (EntityType)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)entityIds, (Object)entityType);
                    List entityIds2 = (List)tuple22._1();
                    EntityType entityType2 = (EntityType)tuple22._2();
                    List propertyKeyIds = propertyKeyNames.map((Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$96(ctx, p)));
                    Try existingIndexDescriptor = Try$.MODULE$.apply((Function0 & Serializable)() -> ctx.fulltextIndexReference(entityIds2, entityType2, (Seq)propertyKeyIds));
                    if (existingIndexDescriptor.isSuccess()) {
                        String indexDescription = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$fulltextIndexInfo(indexName, (Either<List<LabelName>, List<RelTypeName>>)entityNames, (Seq<PropertyKeyName>)propertyKeyNames, options);
                        String conflictingIndex = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$existingIndexInfo((QueryContext)ctx, (Function0<IndexInformation>)(Function0 & Serializable)() -> ctx.getIndexInformation((IndexDescriptor)existingIndexDescriptor.get()));
                        IndexOrConstraintAlreadyExistsNotification notification = new IndexOrConstraintAlreadyExistsNotification("CREATE " + indexDescription, conflictingIndex);
                        return new IgnoredResult((Set<InternalNotification>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InternalNotification[]{notification}))));
                    }
                    if (indexName.exists((Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)anonfun.1.$anonfun$applyOrElse$99(ctx, name)))) {
                        String indexDescription = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$fulltextIndexInfo(indexName, (Either<List<LabelName>, List<RelTypeName>>)entityNames, (Seq<PropertyKeyName>)propertyKeyNames, options);
                        String conflictingIndex = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$existingIndexInfo((QueryContext)ctx, (Function0<IndexInformation>)(Function0 & Serializable)() -> ctx.getIndexInformation((String)indexName.get()));
                        IndexOrConstraintAlreadyExistsNotification notification = new IndexOrConstraintAlreadyExistsNotification("CREATE " + indexDescription, conflictingIndex);
                        return new IgnoredResult((Set<InternalNotification>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InternalNotification[]{notification}))));
                    }
                    return new SuccessResult(SuccessResult$.MODULE$.apply$default$1());
                }, (Option<ExecutionPlan>)None$.MODULE$);
            }
            if (A1 instanceof DoNothingIfExistsForConstraint) {
                DoNothingIfExistsForConstraint doNothingIfExistsForConstraint = (DoNothingIfExistsForConstraint)A1;
                ElementTypeName entityName = doNothingIfExistsForConstraint.entityName();
                Seq props = doNothingIfExistsForConstraint.props();
                CreateConstraintType assertion = doNothingIfExistsForConstraint.assertion();
                Option name = doNothingIfExistsForConstraint.name();
                Options options = doNothingIfExistsForConstraint.options();
                return (B1)(Function1 & Serializable)context -> new SchemaExecutionPlan("DoNothingIfExist", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable)(ctx, params) -> {
                    Option<String> constraintName = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$getName((Option<Either<String, Parameter>>)name, (MapValue)params);
                    CreateConstraintType createConstraintType = assertion;
                    if (NodeKey$.MODULE$.equals(createConstraintType)) {
                        IndexBackedConstraintsOptionsConverter qual$17 = new IndexBackedConstraintsOptionsConverter("node key constraint", SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$indexContext((QueryContext)ctx));
                        CypherVersion x$65 = context.cypherVersion();
                        Options x$66 = options;
                        MapValue x$67 = params;
                        Option<Config> x$68 = qual$17.convert$default$4();
                        qual$17.convert(x$65, x$66, x$67, x$68);
                    } else if (RelationshipKey$.MODULE$.equals(createConstraintType)) {
                        IndexBackedConstraintsOptionsConverter qual$18 = new IndexBackedConstraintsOptionsConverter("relationship key constraint", SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$indexContext((QueryContext)ctx));
                        CypherVersion x$69 = context.cypherVersion();
                        Options x$70 = options;
                        MapValue x$71 = params;
                        Option<Config> x$72 = qual$18.convert$default$4();
                        qual$18.convert(x$69, x$70, x$71, x$72);
                    } else if (NodePropertyUniqueness$.MODULE$.equals(createConstraintType)) {
                        IndexBackedConstraintsOptionsConverter qual$19 = new IndexBackedConstraintsOptionsConverter("uniqueness constraint", SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$indexContext((QueryContext)ctx));
                        CypherVersion x$73 = context.cypherVersion();
                        Options x$74 = options;
                        MapValue x$75 = params;
                        Option<Config> x$76 = qual$19.convert$default$4();
                        qual$19.convert(x$73, x$74, x$75, x$76);
                    } else if (RelationshipPropertyUniqueness$.MODULE$.equals(createConstraintType)) {
                        IndexBackedConstraintsOptionsConverter qual$20 = new IndexBackedConstraintsOptionsConverter("relationship uniqueness constraint", SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$indexContext((QueryContext)ctx));
                        CypherVersion x$77 = context.cypherVersion();
                        Options x$78 = options;
                        MapValue x$79 = params;
                        Option<Config> x$80 = qual$20.convert$default$4();
                        qual$20.convert(x$77, x$78, x$79, x$80);
                    } else if (NodePropertyExistence$.MODULE$.equals(createConstraintType)) {
                        PropertyExistenceOrTypeConstraintOptionsConverter qual$21 = new PropertyExistenceOrTypeConstraintOptionsConverter("node", "existence", SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$indexContext((QueryContext)ctx));
                        CypherVersion x$81 = context.cypherVersion();
                        Options x$82 = options;
                        MapValue x$83 = params;
                        Option<Config> x$84 = qual$21.convert$default$4();
                        qual$21.convert(x$81, x$82, x$83, x$84);
                    } else if (RelationshipPropertyExistence$.MODULE$.equals(createConstraintType)) {
                        PropertyExistenceOrTypeConstraintOptionsConverter qual$22 = new PropertyExistenceOrTypeConstraintOptionsConverter("relationship", "existence", SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$indexContext((QueryContext)ctx));
                        CypherVersion x$85 = context.cypherVersion();
                        Options x$86 = options;
                        MapValue x$87 = params;
                        Option<Config> x$88 = qual$22.convert$default$4();
                        qual$22.convert(x$85, x$86, x$87, x$88);
                    } else if (createConstraintType instanceof NodePropertyType) {
                        PropertyExistenceOrTypeConstraintOptionsConverter qual$23 = new PropertyExistenceOrTypeConstraintOptionsConverter("node", "type", SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$indexContext((QueryContext)ctx));
                        CypherVersion x$89 = context.cypherVersion();
                        Options x$90 = options;
                        MapValue x$91 = params;
                        Option<Config> x$92 = qual$23.convert$default$4();
                        qual$23.convert(x$89, x$90, x$91, x$92);
                    } else if (createConstraintType instanceof RelationshipPropertyType) {
                        PropertyExistenceOrTypeConstraintOptionsConverter qual$24 = new PropertyExistenceOrTypeConstraintOptionsConverter("relationship", "type", SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$indexContext((QueryContext)ctx));
                        CypherVersion x$93 = context.cypherVersion();
                        Options x$94 = options;
                        MapValue x$95 = params;
                        Option<Config> x$96 = qual$24.convert$default$4();
                        qual$24.convert(x$93, x$94, x$95, x$96);
                    } else {
                        throw new MatchError((Object)createConstraintType);
                    }
                    Tuple2<Object, EntityType> tuple2 = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$getEntityInfo(entityName, (QueryContext)ctx);
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    int entityId = tuple2._1$mcI$sp();
                    int entityId2 = entityId;
                    Seq propertyKeyIds = (Seq)props.map((Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$103(ctx, p)));
                    Function1<ConstraintDescriptor, Object> constraintMatcher = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$convertConstraintTypeToConstraintMatcher(assertion);
                    if (ctx.constraintExists(constraintMatcher, entityId2, propertyKeyIds)) {
                        String constraintDescription = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$constraintInfo(constraintName, entityName, (Seq<Property>)props, assertion, options);
                        String conflictingConstraint = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$existingConstraintInfo((QueryContext)ctx, (Function0<ConstraintInformation>)(Function0 & Serializable)() -> ctx.getConstraintInformation(constraintMatcher, entityId2, propertyKeyIds));
                        IndexOrConstraintAlreadyExistsNotification notification = new IndexOrConstraintAlreadyExistsNotification("CREATE " + constraintDescription, conflictingConstraint);
                        return new IgnoredResult((Set<InternalNotification>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InternalNotification[]{notification}))));
                    }
                    if (constraintName.exists((Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)anonfun.1.$anonfun$applyOrElse$105(ctx, name)))) {
                        String constraintDescription = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$constraintInfo(constraintName, entityName, (Seq<Property>)props, assertion, options);
                        String conflictingConstraint = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$existingConstraintInfo((QueryContext)ctx, (Function0<ConstraintInformation>)(Function0 & Serializable)() -> ctx.getConstraintInformation((String)constraintName.get()));
                        IndexOrConstraintAlreadyExistsNotification notification = new IndexOrConstraintAlreadyExistsNotification("CREATE " + constraintDescription, conflictingConstraint);
                        return new IgnoredResult((Set<InternalNotification>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InternalNotification[]{notification}))));
                    }
                    return new SuccessResult(SuccessResult$.MODULE$.apply$default$1());
                }, (Option<ExecutionPlan>)None$.MODULE$);
            }
            return (B1)function1.apply(x1);
        }

        public final boolean isDefinedAt(LogicalPlan x1) {
            org.neo4j.graphdb.schema.IndexType indexType;
            org.neo4j.graphdb.schema.IndexType indexType2;
            org.neo4j.graphdb.schema.IndexType indexType3;
            boolean bl = false;
            CreateConstraint createConstraint = null;
            boolean bl2 = false;
            CreateIndex createIndex = null;
            LogicalPlan logicalPlan = x1;
            if (logicalPlan instanceof CreateConstraint) {
                bl = true;
                createConstraint = (CreateConstraint)logicalPlan;
                CreateConstraintType createConstraintType = createConstraint.constraintType();
                ElementTypeName label = createConstraint.entityName();
                if (NodeKey$.MODULE$.equals(createConstraintType) && label instanceof LabelName) {
                    return true;
                }
            }
            if (bl) {
                CreateConstraintType createConstraintType = createConstraint.constraintType();
                ElementTypeName relType = createConstraint.entityName();
                if (RelationshipKey$.MODULE$.equals(createConstraintType) && relType instanceof RelTypeName) {
                    return true;
                }
            }
            if (bl) {
                CreateConstraintType createConstraintType = createConstraint.constraintType();
                ElementTypeName label = createConstraint.entityName();
                if (NodePropertyUniqueness$.MODULE$.equals(createConstraintType) && label instanceof LabelName) {
                    return true;
                }
            }
            if (bl) {
                CreateConstraintType createConstraintType = createConstraint.constraintType();
                ElementTypeName relType = createConstraint.entityName();
                if (RelationshipPropertyUniqueness$.MODULE$.equals(createConstraintType) && relType instanceof RelTypeName) {
                    return true;
                }
            }
            if (bl) {
                CreateConstraintType createConstraintType = createConstraint.constraintType();
                ElementTypeName label = createConstraint.entityName();
                if (NodePropertyExistence$.MODULE$.equals(createConstraintType) && label instanceof LabelName) {
                    return true;
                }
            }
            if (bl) {
                CreateConstraintType createConstraintType = createConstraint.constraintType();
                ElementTypeName relType = createConstraint.entityName();
                if (RelationshipPropertyExistence$.MODULE$.equals(createConstraintType) && relType instanceof RelTypeName) {
                    return true;
                }
            }
            if (bl) {
                CreateConstraintType createConstraintType = createConstraint.constraintType();
                ElementTypeName label = createConstraint.entityName();
                if (createConstraintType instanceof NodePropertyType && label instanceof LabelName) {
                    return true;
                }
            }
            if (bl) {
                CreateConstraintType createConstraintType = createConstraint.constraintType();
                ElementTypeName relType = createConstraint.entityName();
                if (createConstraintType instanceof RelationshipPropertyType && relType instanceof RelTypeName) {
                    return true;
                }
            }
            if (logicalPlan instanceof DropConstraintOnName) {
                return true;
            }
            if (logicalPlan instanceof CreateIndex) {
                bl2 = true;
                createIndex = (CreateIndex)logicalPlan;
                org.neo4j.graphdb.schema.IndexType indexType4 = createIndex.indexType();
                if (org.neo4j.graphdb.schema.IndexType.RANGE.equals(indexType4)) {
                    return true;
                }
            }
            if (logicalPlan instanceof CreateLookupIndex) {
                return true;
            }
            if (logicalPlan instanceof CreateFulltextIndex) {
                return true;
            }
            if (bl2 && org.neo4j.graphdb.schema.IndexType.TEXT.equals(indexType3 = createIndex.indexType())) {
                return true;
            }
            if (bl2 && org.neo4j.graphdb.schema.IndexType.POINT.equals(indexType2 = createIndex.indexType())) {
                return true;
            }
            if (bl2 && org.neo4j.graphdb.schema.IndexType.VECTOR.equals(indexType = createIndex.indexType())) {
                return true;
            }
            if (logicalPlan instanceof DropIndexOnName) {
                return true;
            }
            if (logicalPlan instanceof DoNothingIfExistsForIndex) {
                return true;
            }
            if (logicalPlan instanceof DoNothingIfExistsForLookupIndex) {
                return true;
            }
            if (logicalPlan instanceof DoNothingIfExistsForFulltextIndex) {
                return true;
            }
            return logicalPlan instanceof DoNothingIfExistsForConstraint;
        }

        public static final /* synthetic */ int $anonfun$applyOrElse$4(QueryContext ctx$1, Property p) {
            return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$1, p.propertyKey()).id();
        }

        public static final /* synthetic */ int $anonfun$applyOrElse$10(QueryContext ctx$2, Property p) {
            return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$2, p.propertyKey()).id();
        }

        public static final /* synthetic */ int $anonfun$applyOrElse$16(QueryContext ctx$3, Property p) {
            return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$3, p.propertyKey()).id();
        }

        public static final /* synthetic */ int $anonfun$applyOrElse$22(QueryContext ctx$4, Property p) {
            return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$4, p.propertyKey()).id();
        }

        public static final /* synthetic */ void $anonfun$applyOrElse$27(QueryContext ctx$5, int labelId, int propertyKeyId, Option name) {
            ctx$5.createNodePropertyExistenceConstraint(labelId, propertyKeyId, name);
        }

        public static final /* synthetic */ void $anonfun$applyOrElse$32(QueryContext ctx$6, int relTypeId, int propertyKeyId, Option name) {
            ctx$6.createRelationshipPropertyExistenceConstraint(relTypeId, propertyKeyId, name);
        }

        public static final /* synthetic */ int $anonfun$applyOrElse$48(QueryContext ctx$7, PropertyKeyName p) {
            return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$7, p).id();
        }

        public static final /* synthetic */ int $anonfun$applyOrElse$58(QueryContext ctx$8, PropertyKeyName p) {
            return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$8, p).id();
        }

        public static final /* synthetic */ int $anonfun$applyOrElse$64(QueryContext ctx$9, PropertyKeyName p) {
            return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$9, p).id();
        }

        public static final /* synthetic */ int $anonfun$applyOrElse$69(QueryContext ctx$10, PropertyKeyName p) {
            return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$10, p).id();
        }

        public static final /* synthetic */ int $anonfun$applyOrElse$74(QueryContext ctx$11, PropertyKeyName p) {
            return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$11, p).id();
        }

        public static final /* synthetic */ int $anonfun$applyOrElse$83(QueryContext ctx$12, PropertyKeyName p) {
            return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$12, p).id();
        }

        public static final /* synthetic */ boolean $anonfun$applyOrElse$86(QueryContext ctx$12, String name) {
            return ctx$12.indexExists(name);
        }

        public static final /* synthetic */ boolean $anonfun$applyOrElse$92(QueryContext ctx$13, String name) {
            return ctx$13.indexExists(name);
        }

        public static final /* synthetic */ int $anonfun$applyOrElse$96(QueryContext ctx$14, PropertyKeyName p) {
            return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$14, p).id();
        }

        public static final /* synthetic */ boolean $anonfun$applyOrElse$99(QueryContext ctx$14, String name) {
            return ctx$14.indexExists(name);
        }

        public static final /* synthetic */ int $anonfun$applyOrElse$103(QueryContext ctx$15, Property p) {
            return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$15, p.propertyKey()).id();
        }

        public static final /* synthetic */ boolean $anonfun$applyOrElse$105(QueryContext ctx$15, String name) {
            return ctx$15.constraintExists(name);
        }

        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(scala.Option org.neo4j.cypher.internal.ast.Options org.neo4j.cypher.internal.expressions.LabelName scala.collection.immutable.Seq scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$10$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.Property ), $anonfun$applyOrElse$100(org.neo4j.cypher.internal.runtime.QueryContext scala.Option ), $anonfun$applyOrElse$101(scala.Option org.neo4j.cypher.internal.ast.CreateConstraintType org.neo4j.cypher.internal.ast.Options org.neo4j.cypher.internal.expressions.ElementTypeName scala.collection.immutable.Seq org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$102(scala.Option org.neo4j.cypher.internal.ast.CreateConstraintType org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.ast.Options org.neo4j.cypher.internal.expressions.ElementTypeName scala.collection.immutable.Seq org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$103$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.Property ), $anonfun$applyOrElse$104(org.neo4j.cypher.internal.runtime.QueryContext scala.Function1 int scala.collection.immutable.Seq ), $anonfun$applyOrElse$105$adapted(org.neo4j.cypher.internal.runtime.QueryContext java.lang.String ), $anonfun$applyOrElse$106(org.neo4j.cypher.internal.runtime.QueryContext scala.Option ), $anonfun$applyOrElse$11(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForConstraint ), $anonfun$applyOrElse$12(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$13(scala.Option org.neo4j.cypher.internal.ast.Options org.neo4j.cypher.internal.expressions.LabelName scala.collection.immutable.Seq scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$14(scala.Option org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.ast.Options org.neo4j.cypher.internal.expressions.LabelName scala.collection.immutable.Seq org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$15(org.neo4j.cypher.internal.optionsmap.CreateIndexProviderOnlyOptions ), $anonfun$applyOrElse$16$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.Property ), $anonfun$applyOrElse$17(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForConstraint ), $anonfun$applyOrElse$18(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$19(scala.Option org.neo4j.cypher.internal.ast.Options org.neo4j.cypher.internal.expressions.RelTypeName scala.collection.immutable.Seq scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$2(scala.Option org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.ast.Options org.neo4j.cypher.internal.expressions.LabelName scala.collection.immutable.Seq org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$20(scala.Option org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.ast.Options org.neo4j.cypher.internal.expressions.RelTypeName scala.collection.immutable.Seq org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$21(org.neo4j.cypher.internal.optionsmap.CreateIndexProviderOnlyOptions ), $anonfun$applyOrElse$22$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.Property ), $anonfun$applyOrElse$23(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForConstraint ), $anonfun$applyOrElse$24(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$25(scala.Option org.neo4j.cypher.internal.ast.Options org.neo4j.cypher.internal.expressions.LabelName scala.collection.immutable.Seq scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$26(scala.Option org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.ast.Options org.neo4j.cypher.internal.expressions.LabelName scala.collection.immutable.Seq org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$27$adapted(org.neo4j.cypher.internal.runtime.QueryContext java.lang.Object java.lang.Object scala.Option ), $anonfun$applyOrElse$28(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForConstraint ), $anonfun$applyOrElse$29(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$3(org.neo4j.cypher.internal.optionsmap.CreateIndexProviderOnlyOptions ), $anonfun$applyOrElse$30(scala.Option org.neo4j.cypher.internal.ast.Options org.neo4j.cypher.internal.expressions.RelTypeName scala.collection.immutable.Seq scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$31(scala.Option org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.ast.Options org.neo4j.cypher.internal.expressions.RelTypeName scala.collection.immutable.Seq org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$32$adapted(org.neo4j.cypher.internal.runtime.QueryContext java.lang.Object java.lang.Object scala.Option ), $anonfun$applyOrElse$33(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForConstraint ), $anonfun$applyOrElse$34(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$35(scala.Option org.neo4j.cypher.internal.ast.Options org.neo4j.cypher.internal.expressions.LabelName scala.collection.immutable.Seq org.neo4j.cypher.internal.util.symbols.CypherType scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$36(scala.Option org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.ast.Options org.neo4j.cypher.internal.expressions.LabelName scala.collection.immutable.Seq org.neo4j.cypher.internal.util.symbols.CypherType org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$37(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForConstraint ), $anonfun$applyOrElse$38(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$39(scala.Option org.neo4j.cypher.internal.ast.Options org.neo4j.cypher.internal.expressions.RelTypeName scala.collection.immutable.Seq org.neo4j.cypher.internal.util.symbols.CypherType scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$4$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.Property ), $anonfun$applyOrElse$40(scala.Option org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.ast.Options org.neo4j.cypher.internal.expressions.RelTypeName scala.collection.immutable.Seq org.neo4j.cypher.internal.util.symbols.CypherType org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$41(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForConstraint ), $anonfun$applyOrElse$42(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$43(scala.util.Either boolean org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$44(scala.util.Either boolean org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$45(scala.Option org.neo4j.cypher.internal.expressions.ElementTypeName org.neo4j.cypher.internal.ast.Options scala.collection.immutable.List scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$46(scala.Option org.neo4j.cypher.internal.expressions.ElementTypeName org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.ast.Options scala.collection.immutable.List org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$47(org.neo4j.cypher.internal.optionsmap.CreateIndexProviderOnlyOptions ), $anonfun$applyOrElse$48$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.PropertyKeyName ), $anonfun$applyOrElse$49(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForIndex ), $anonfun$applyOrElse$5(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForConstraint ), $anonfun$applyOrElse$50(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$51(scala.Option org.neo4j.cypher.internal.ast.Options org.neo4j.common.EntityType scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$52(scala.Option org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.ast.Options org.neo4j.common.EntityType org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$53(org.neo4j.cypher.internal.optionsmap.CreateIndexProviderOnlyOptions ), $anonfun$applyOrElse$54(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForLookupIndex ), $anonfun$applyOrElse$55(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$56(scala.Option org.neo4j.cypher.internal.ast.Options scala.util.Either scala.collection.immutable.List scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$57(scala.Option org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.ast.Options scala.util.Either scala.collection.immutable.List org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$58$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.PropertyKeyName ), $anonfun$applyOrElse$59(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForFulltextIndex ), $anonfun$applyOrElse$6(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$60(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$61(scala.Option org.neo4j.cypher.internal.ast.Options org.neo4j.cypher.internal.expressions.ElementTypeName scala.collection.immutable.List scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$62(scala.Option org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.ast.Options org.neo4j.cypher.internal.expressions.ElementTypeName scala.collection.immutable.List org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$63(org.neo4j.cypher.internal.optionsmap.CreateIndexProviderOnlyOptions ), $anonfun$applyOrElse$64$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.PropertyKeyName ), $anonfun$applyOrElse$65(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForIndex ), $anonfun$applyOrElse$66(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$67(scala.Option org.neo4j.cypher.internal.ast.Options org.neo4j.cypher.internal.expressions.ElementTypeName scala.collection.immutable.List scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$68(scala.Option org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.ast.Options org.neo4j.cypher.internal.expressions.ElementTypeName scala.collection.immutable.List org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$69$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.PropertyKeyName ), $anonfun$applyOrElse$7(scala.Option org.neo4j.cypher.internal.ast.Options org.neo4j.cypher.internal.expressions.RelTypeName scala.collection.immutable.Seq scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$70(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForIndex ), $anonfun$applyOrElse$71(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$72(scala.Option org.neo4j.cypher.internal.ast.Options org.neo4j.cypher.internal.expressions.ElementTypeName scala.collection.immutable.List scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$73(scala.Option org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.ast.Options org.neo4j.cypher.internal.expressions.ElementTypeName scala.collection.immutable.List org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$74$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.PropertyKeyName ), $anonfun$applyOrElse$75(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForIndex ), $anonfun$applyOrElse$76(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$77(scala.util.Either boolean org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$78(scala.util.Either boolean org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$79(org.neo4j.graphdb.schema.IndexType scala.Option org.neo4j.cypher.internal.ast.Options org.neo4j.cypher.internal.expressions.ElementTypeName scala.collection.immutable.List org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$8(scala.Option org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.ast.Options org.neo4j.cypher.internal.expressions.RelTypeName scala.collection.immutable.Seq org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$80(org.neo4j.cypher.internal.runtime.QueryContext ), $anonfun$applyOrElse$81(org.neo4j.cypher.internal.runtime.QueryContext ), $anonfun$applyOrElse$82(scala.Option scala.Function1 org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.ast.Options org.neo4j.cypher.internal.expressions.ElementTypeName scala.collection.immutable.List org.neo4j.internal.schema.IndexType org.neo4j.graphdb.schema.IndexType org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$83$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.PropertyKeyName ), $anonfun$applyOrElse$84(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.internal.schema.IndexType int org.neo4j.common.EntityType scala.collection.immutable.List ), $anonfun$applyOrElse$85(org.neo4j.cypher.internal.runtime.QueryContext scala.util.Try ), $anonfun$applyOrElse$86$adapted(org.neo4j.cypher.internal.runtime.QueryContext java.lang.String ), $anonfun$applyOrElse$87(org.neo4j.cypher.internal.runtime.QueryContext scala.Option ), $anonfun$applyOrElse$88(scala.Option org.neo4j.cypher.internal.ast.Options org.neo4j.common.EntityType org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$89(scala.Option org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.ast.Options org.neo4j.common.EntityType org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$9(org.neo4j.cypher.internal.optionsmap.CreateIndexProviderOnlyOptions ), $anonfun$applyOrElse$90(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.common.EntityType ), $anonfun$applyOrElse$91(org.neo4j.cypher.internal.runtime.QueryContext scala.util.Try ), $anonfun$applyOrElse$92$adapted(org.neo4j.cypher.internal.runtime.QueryContext java.lang.String ), $anonfun$applyOrElse$93(org.neo4j.cypher.internal.runtime.QueryContext scala.Option ), $anonfun$applyOrElse$94(scala.Option org.neo4j.cypher.internal.ast.Options scala.util.Either scala.collection.immutable.List org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$95(scala.Option org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.ast.Options scala.util.Either scala.collection.immutable.List org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$96$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.PropertyKeyName ), $anonfun$applyOrElse$97(org.neo4j.cypher.internal.runtime.QueryContext scala.collection.immutable.List org.neo4j.common.EntityType scala.collection.immutable.List ), $anonfun$applyOrElse$98(org.neo4j.cypher.internal.runtime.QueryContext scala.util.Try ), $anonfun$applyOrElse$99$adapted(org.neo4j.cypher.internal.runtime.QueryContext java.lang.String )}, serializedLambda);
        }
    };

    @Override
    public String name() {
        return "schema";
    }

    @Override
    public Option<CypherRuntimeOption> correspondingRuntimeOption() {
        return None$.MODULE$;
    }

    @Override
    public ExecutionPlan compileToExecutable(LogicalQuery state, RuntimeContext context, TransactionalContext.DatabaseMode databaseMode) {
        return (ExecutionPlan)((Function1)this.logicalToExecutable().applyOrElse((Object)state.logicalPlan(), (Function1 & Serializable)unknownPlan -> MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply((Object)context);
    }

    public Nothing$ throwCantCompile(LogicalPlan unknownPlan) {
        throw new CantCompileQueryException("Plan is not a schema command: " + unknownPlan.getClass().getSimpleName());
    }

    public Option<InternalQueryType> queryType(LogicalPlan logicalPlan) {
        if (this.logicalToExecutable().isDefinedAt((Object)logicalPlan)) {
            return new Some((Object)SCHEMA_WRITE$.MODULE$);
        }
        return None$.MODULE$;
    }

    public PartialFunction<LogicalPlan, Function1<RuntimeContext, ExecutionPlan>> logicalToExecutable() {
        return logicalToExecutable;
    }

    public Option<String> org$neo4j$cypher$internal$SchemaCommandRuntime$$getName(Option<Either<String, Parameter>> name, MapValue params) {
        return name.map((Function1 & Serializable)x$37 -> MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$getName((Either<String, Parameter>)x$37, params));
    }

    public String org$neo4j$cypher$internal$SchemaCommandRuntime$$getName(Either<String, Parameter> name, MapValue params) {
        Either<String, Parameter> either = name;
        if (either instanceof Left) {
            Left left = (Left)either;
            String stringName = (String)left.value();
            return stringName;
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Parameter paramName = (Parameter)right.value();
            AnyValue anyValue = params.get(paramName.name());
            if (anyValue instanceof StringValue) {
                StringValue stringValue = (StringValue)anyValue;
                return stringValue.stringValue();
            }
            throw new ParameterWrongTypeException("Expected String, but got: " + anyValue.getTypeName());
        }
        throw new MatchError(either);
    }

    public Tuple2<Object, EntityType> org$neo4j$cypher$internal$SchemaCommandRuntime$$getEntityInfo(ElementTypeName entityName, QueryContext ctx) {
        ElementTypeName elementTypeName = entityName;
        if (elementTypeName instanceof LabelName) {
            LabelName labelName = (LabelName)elementTypeName;
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)ctx.getOrCreateLabelId(labelName.name())), (Object)EntityType.NODE);
        }
        if (elementTypeName instanceof RelTypeName) {
            RelTypeName relTypeName = (RelTypeName)elementTypeName;
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)ctx.getOrCreateRelTypeId(relTypeName.name())), (Object)EntityType.RELATIONSHIP);
        }
        throw new MatchError((Object)elementTypeName);
    }

    public Tuple2<List<Object>, EntityType> org$neo4j$cypher$internal$SchemaCommandRuntime$$getMultipleEntityInfo(Either<List<LabelName>, List<RelTypeName>> entityName, QueryContext ctx) {
        Either<List<LabelName>, List<RelTypeName>> either = entityName;
        if (either instanceof Left) {
            Left left = (Left)either;
            List labels = (List)left.value();
            return new Tuple2((Object)labels.map((Function1 & Serializable)label -> BoxesRunTime.boxToInteger((int)ctx.getOrCreateLabelId(label.name()))), (Object)EntityType.NODE);
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            List relTypes = (List)right.value();
            return new Tuple2((Object)relTypes.map((Function1 & Serializable)relType -> BoxesRunTime.boxToInteger((int)ctx.getOrCreateRelTypeId(relType.name()))), (Object)EntityType.RELATIONSHIP);
        }
        throw new MatchError(either);
    }

    public boolean isApplicable(LogicalPlanState logicalPlanState) {
        return this.logicalToExecutable().isDefinedAt(logicalPlanState.maybeLogicalPlan().get());
    }

    public Function1<ConstraintDescriptor, Object> org$neo4j$cypher$internal$SchemaCommandRuntime$$convertConstraintTypeToConstraintMatcher(CreateConstraintType assertion) {
        CreateConstraintType createConstraintType = assertion;
        if (NodePropertyExistence$.MODULE$.equals(createConstraintType)) {
            return (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.isNodePropertyExistenceConstraint());
        }
        if (RelationshipPropertyExistence$.MODULE$.equals(createConstraintType)) {
            return (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.isRelationshipPropertyExistenceConstraint());
        }
        if (NodePropertyUniqueness$.MODULE$.equals(createConstraintType)) {
            return (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.isNodeUniquenessConstraint());
        }
        if (RelationshipPropertyUniqueness$.MODULE$.equals(createConstraintType)) {
            return (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.isRelationshipUniquenessConstraint());
        }
        if (NodeKey$.MODULE$.equals(createConstraintType)) {
            return (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.isNodeKeyConstraint());
        }
        if (RelationshipKey$.MODULE$.equals(createConstraintType)) {
            return (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.isRelationshipKeyConstraint());
        }
        if (createConstraintType instanceof NodePropertyType) {
            NodePropertyType nodePropertyType = (NodePropertyType)createConstraintType;
            CypherType propType = nodePropertyType.propType();
            return (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)SchemaCommandRuntime$.$anonfun$convertConstraintTypeToConstraintMatcher$7(propType, c));
        }
        if (createConstraintType instanceof RelationshipPropertyType) {
            RelationshipPropertyType relationshipPropertyType = (RelationshipPropertyType)createConstraintType;
            CypherType propType = relationshipPropertyType.propType();
            return (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)SchemaCommandRuntime$.$anonfun$convertConstraintTypeToConstraintMatcher$8(propType, c));
        }
        throw new MatchError((Object)createConstraintType);
    }

    private boolean checkTypes(CypherType askedForType, PropertyTypeSet preExistingTypes) {
        return preExistingTypes.equals((Object)PropertyTypeMapper$.MODULE$.asPropertyTypeSet(askedForType));
    }

    public PropertyKeyId org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(QueryContext ctx, PropertyKeyName property) {
        return new PropertyKeyId(ctx.getOrCreatePropertyKeyId(property.name()));
    }

    public Tuple3<Object, Object, Option<String>> org$neo4j$cypher$internal$SchemaCommandRuntime$$labelPropWithName(QueryContext ctx, LabelName label, PropertyKeyName prop, Option<String> name) {
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)ctx.getOrCreateLabelId(label.name())), (Object)BoxesRunTime.boxToInteger((int)ctx.getOrCreatePropertyKeyId(prop.name())), name);
    }

    public Tuple3<Object, Object, Option<String>> org$neo4j$cypher$internal$SchemaCommandRuntime$$typePropWithName(QueryContext ctx, RelTypeName relType, PropertyKeyName prop, Option<String> name) {
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)ctx.getOrCreateRelTypeId(relType.name())), (Object)BoxesRunTime.boxToInteger((int)ctx.getOrCreatePropertyKeyId(prop.name())), name);
    }

    public String org$neo4j$cypher$internal$SchemaCommandRuntime$$indexInfo(String indexType, Option<String> nameOption, ElementTypeName entityName, Seq<PropertyKeyName> properties, Options options) {
        PrettyString name = this.getPrettyName(nameOption);
        PrettyString pattern = this.getPrettyEntityPattern(entityName);
        PrettyString propertyString = this.getPrettyPropertyPattern(properties, "(", ")");
        return asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " INDEX", " IF NOT EXISTS FOR ", " ON ", "", ""}))), (Seq<PrettyString>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrettyString[]{asPrettyString$.MODULE$.raw(indexType), name, pattern, propertyString, LogicalPlan2PlanDescription$.MODULE$.prettyOptions(options)})).prettifiedString();
    }

    public String org$neo4j$cypher$internal$SchemaCommandRuntime$$fulltextIndexInfo(Option<String> nameOption, Either<List<LabelName>, List<RelTypeName>> entityNames, Seq<PropertyKeyName> properties, Options options) {
        PrettyString prettyString;
        PrettyString name = this.getPrettyName(nameOption);
        Either<List<LabelName>, List<RelTypeName>> either = entityNames;
        if (either instanceof Left) {
            Left left = (Left)either;
            List labels = (List)left.value();
            PrettyString innerPattern = asPrettyString$.MODULE$.PrettyStringMaker((IterableOnce<PrettyString>)labels.map((Function1 & Serializable)l -> asPrettyString$.MODULE$.apply(l.name()))).mkPrettyString("e:", "|", "");
            prettyString = asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(", ")"}))), (Seq<PrettyString>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrettyString[]{innerPattern}));
        } else if (either instanceof Right) {
            Right right = (Right)either;
            List relTypes = (List)right.value();
            PrettyString innerPattern = asPrettyString$.MODULE$.PrettyStringMaker((IterableOnce<PrettyString>)relTypes.map((Function1 & Serializable)r -> asPrettyString$.MODULE$.apply(r.name()))).mkPrettyString("e:", "|", "");
            prettyString = asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"()-[", "]-()"}))), (Seq<PrettyString>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrettyString[]{innerPattern}));
        } else {
            throw new MatchError(either);
        }
        PrettyString pattern = prettyString;
        PrettyString propertyString = this.getPrettyPropertyPattern(properties, "[", "]");
        return asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"FULLTEXT INDEX", " IF NOT EXISTS FOR ", " ON EACH ", "", ""}))), (Seq<PrettyString>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrettyString[]{name, pattern, propertyString, LogicalPlan2PlanDescription$.MODULE$.prettyOptions(options)})).prettifiedString();
    }

    public String lookupIndexInfo(Option<String> nameOption, EntityType entityType, Options options) {
        PrettyString name = this.getPrettyName(nameOption);
        EntityType entityType2 = entityType;
        EntityType entityType3 = EntityType.NODE;
        Tuple2<PrettyString, PrettyString> tuple2 = this.getPrettyLookupIndexPatternAndFunction(!(entityType2 != null ? !entityType2.equals(entityType3) : entityType3 != null));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        PrettyString pattern = (PrettyString)tuple2._1();
        PrettyString function = (PrettyString)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)pattern, (Object)function);
        PrettyString pattern2 = (PrettyString)tuple22._1();
        PrettyString function2 = (PrettyString)tuple22._2();
        return asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"LOOKUP INDEX", " IF NOT EXISTS FOR ", " ON EACH ", "", ""}))), (Seq<PrettyString>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrettyString[]{name, pattern2, function2, LogicalPlan2PlanDescription$.MODULE$.prettyOptions(options)})).prettifiedString();
    }

    public String org$neo4j$cypher$internal$SchemaCommandRuntime$$existingIndexInfo(QueryContext ctx, Function0<IndexInformation> getInfoParts) {
        String string;
        try {
            Tuple2 tuple2;
            ctx.assertShowIndexAllowed();
            IndexInformation indexInformation = (IndexInformation)getInfoParts.apply();
            if (indexInformation == null) {
                throw new MatchError((Object)indexInformation);
            }
            boolean isNode = indexInformation.isNode();
            IndexType indexType = indexInformation.indexType();
            String name = indexInformation.name();
            List entityNames = indexInformation.labelsOrRelTypes();
            List properties = indexInformation.properties();
            Tuple5 tuple5 = new Tuple5((Object)BoxesRunTime.boxToBoolean((boolean)isNode), (Object)indexType, (Object)name, (Object)entityNames, (Object)properties);
            boolean isNode2 = BoxesRunTime.unboxToBoolean((Object)tuple5._1());
            IndexType indexType2 = (IndexType)tuple5._2();
            String name2 = (String)tuple5._3();
            List entityNames2 = (List)tuple5._4();
            List properties2 = (List)tuple5._5();
            PrettyString nameString = this.getPrettyName((Option<String>)new Some((Object)name2));
            IndexType indexType3 = indexType2;
            if (IndexType.LOOKUP.equals(indexType3)) {
                Tuple2<PrettyString, PrettyString> tuple22 = this.getPrettyLookupIndexPatternAndFunction(isNode2);
                if (tuple22 == null) {
                    throw new MatchError(tuple22);
                }
                PrettyString pattern = (PrettyString)tuple22._1();
                PrettyString function = (PrettyString)tuple22._2();
                Tuple2 tuple23 = new Tuple2((Object)pattern, (Object)function);
                PrettyString pattern2 = (PrettyString)tuple23._1();
                PrettyString function2 = (PrettyString)tuple23._2();
                v0 = new Tuple2((Object)pattern2, (Object)asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"EACH ", ""}))), (Seq<PrettyString>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrettyString[]{function2})));
            } else if (IndexType.FULLTEXT.equals(indexType3)) {
                PrettyString innerPattern = asPrettyString$.MODULE$.PrettyStringMaker((IterableOnce<PrettyString>)entityNames2.map((Function1 & Serializable)e -> asPrettyString$.MODULE$.apply((String)e))).mkPrettyString("e:", "|", "");
                PrettyString pattern = isNode2 ? asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(", ")"}))), (Seq<PrettyString>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrettyString[]{innerPattern})) : asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"()-[", "]-()"}))), (Seq<PrettyString>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrettyString[]{innerPattern}));
                PrettyString propertyString = this.getPrettyPropertyPattern((List<String>)properties2, "[", "]");
                v0 = new Tuple2((Object)pattern, (Object)asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"EACH ", ""}))), (Seq<PrettyString>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrettyString[]{propertyString})));
            } else {
                PrettyString pattern = this.getPrettyEntityPattern(isNode2, (String)entityNames2.head());
                PrettyString propertyString = this.getPrettyPropertyPattern((List<String>)properties2, "(", ")");
                v0 = tuple2 = new Tuple2((Object)pattern, (Object)propertyString);
            }
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            PrettyString pattern = (PrettyString)tuple2._1();
            PrettyString on = (PrettyString)tuple2._2();
            Tuple2 tuple24 = new Tuple2((Object)pattern, (Object)on);
            PrettyString pattern3 = (PrettyString)tuple24._1();
            PrettyString on2 = (PrettyString)tuple24._2();
            string = asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " INDEX", " FOR ", " ON ", ""}))), (Seq<PrettyString>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrettyString[]{asPrettyString$.MODULE$.raw(indexType2.name()), nameString, pattern3, on2})).prettifiedString();
        }
        catch (AuthorizationViolationException authorizationViolationException) {
            string = "index";
        }
        return string;
    }

    public String org$neo4j$cypher$internal$SchemaCommandRuntime$$constraintInfo(Option<String> nameOption, ElementTypeName entityName, Seq<Property> properties, CreateConstraintType constraintType, Options options) {
        Object object;
        PrettyString name = this.getPrettyName(nameOption);
        PrettyString pattern = this.getPrettyEntityPattern(entityName);
        PrettyString propertyString = this.getPrettyPropertyPattern((Seq<PropertyKeyName>)((Seq)properties.map((Function1 & Serializable)p -> p.propertyKey())), "(", ")");
        CreateConstraintType createConstraintType = constraintType;
        if (NodePropertyExistence$.MODULE$.equals(createConstraintType) ? true : RelationshipPropertyExistence$.MODULE$.equals(createConstraintType)) {
            object = "IS NOT NULL";
        } else if (NodeKey$.MODULE$.equals(createConstraintType)) {
            object = "IS NODE KEY";
        } else if (RelationshipKey$.MODULE$.equals(createConstraintType)) {
            object = "IS RELATIONSHIP KEY";
        } else if (NodePropertyUniqueness$.MODULE$.equals(createConstraintType) ? true : RelationshipPropertyUniqueness$.MODULE$.equals(createConstraintType)) {
            object = "IS UNIQUE";
        } else if (createConstraintType instanceof NodePropertyType) {
            NodePropertyType nodePropertyType = (NodePropertyType)createConstraintType;
            CypherType t = nodePropertyType.propType();
            object = "IS :: " + t.description();
        } else if (createConstraintType instanceof RelationshipPropertyType) {
            RelationshipPropertyType relationshipPropertyType = (RelationshipPropertyType)createConstraintType;
            CypherType t = relationshipPropertyType.propType();
            object = "IS :: " + t.description();
        } else {
            throw new MatchError((Object)createConstraintType);
        }
        String assertion = object;
        PrettyString prettyAssertion = asPrettyString$.MODULE$.raw(assertion);
        return asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"CONSTRAINT", " IF NOT EXISTS FOR ", " REQUIRE ", " ", "", ""}))), (Seq<PrettyString>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrettyString[]{name, pattern, propertyString, prettyAssertion, LogicalPlan2PlanDescription$.MODULE$.prettyOptions(options)})).prettifiedString();
    }

    public String org$neo4j$cypher$internal$SchemaCommandRuntime$$existingConstraintInfo(QueryContext ctx, Function0<ConstraintInformation> getInfoParts) {
        String string;
        block16: {
            try {
                PrettyString prettyAssertion;
                PrettyString propertyString;
                PrettyString pattern;
                PrettyString nameString;
                block18: {
                    block17: {
                        Object object;
                        ctx.assertShowConstraintAllowed();
                        ConstraintInformation constraintInformation = (ConstraintInformation)getInfoParts.apply();
                        if (constraintInformation == null) {
                            throw new MatchError((Object)constraintInformation);
                        }
                        boolean isNode = constraintInformation.isNode();
                        ConstraintType constraintType = constraintInformation.constraintType();
                        String name = constraintInformation.name();
                        String entityName = constraintInformation.labelOrRelType();
                        List properties = constraintInformation.properties();
                        Option propertyType = constraintInformation.propertyType();
                        Tuple6 tuple6 = new Tuple6((Object)BoxesRunTime.boxToBoolean((boolean)isNode), (Object)constraintType, (Object)name, (Object)entityName, (Object)properties, (Object)propertyType);
                        boolean isNode2 = BoxesRunTime.unboxToBoolean((Object)tuple6._1());
                        ConstraintType constraintType2 = (ConstraintType)tuple6._2();
                        String name2 = (String)tuple6._3();
                        String entityName2 = (String)tuple6._4();
                        List properties2 = (List)tuple6._5();
                        Option propertyType2 = (Option)tuple6._6();
                        nameString = this.getPrettyName((Option<String>)new Some((Object)name2));
                        pattern = this.getPrettyEntityPattern(isNode2, entityName2);
                        propertyString = this.getPrettyPropertyPattern((List<String>)properties2, "(", ")");
                        ConstraintType constraintType3 = constraintType2;
                        if (ConstraintType.EXISTS.equals(constraintType3)) {
                            object = "IS NOT NULL";
                        } else if (ConstraintType.UNIQUE_EXISTS.equals(constraintType3)) {
                            object = isNode2 ? "IS NODE KEY" : "IS RELATIONSHIP KEY";
                        } else if (ConstraintType.UNIQUE.equals(constraintType3)) {
                            object = "IS UNIQUE";
                        } else if (ConstraintType.PROPERTY_TYPE.equals(constraintType3)) {
                            object = "IS :: " + propertyType2.get();
                        } else if (ConstraintType.ENDPOINT.equals(constraintType3)) {
                            object = "";
                        } else if (ConstraintType.LABEL_COEXISTENCE.equals(constraintType3)) {
                            object = "";
                        } else {
                            throw new MatchError((Object)constraintType3);
                        }
                        String assertion = object;
                        prettyAssertion = asPrettyString$.MODULE$.raw(assertion);
                        ConstraintType constraintType4 = constraintType2;
                        ConstraintType constraintType5 = ConstraintType.ENDPOINT;
                        if (!(constraintType4 == null ? constraintType5 != null : !constraintType4.equals(constraintType5))) break block17;
                        ConstraintType constraintType6 = constraintType2;
                        ConstraintType constraintType7 = ConstraintType.LABEL_COEXISTENCE;
                        if (constraintType6 != null ? !constraintType6.equals(constraintType7) : constraintType7 != null) break block18;
                    }
                    string = "constraint";
                    break block16;
                }
                string = asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"CONSTRAINT", " FOR ", " REQUIRE ", " ", ""}))), (Seq<PrettyString>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrettyString[]{nameString, pattern, propertyString, prettyAssertion})).prettifiedString();
            }
            catch (AuthorizationViolationException authorizationViolationException) {
                string = "constraint";
            }
        }
        return string;
    }

    public VectorIndexVersion org$neo4j$cypher$internal$SchemaCommandRuntime$$vectorIndexVersion(QueryContext ctx) {
        return VectorIndexVersion.latestSupportedVersion((KernelVersion)KernelVersion.getLatestVersion((Config)ctx.getConfig()));
    }

    private PrettyString getPrettyName(Option<String> nameOption) {
        return LogicalPlan2PlanDescription$.MODULE$.getPrettyStringName((Option<Either<String, Parameter>>)nameOption.map((Function1 & Serializable)x$43 -> package$.MODULE$.Left().apply(x$43)));
    }

    private PrettyString getPrettyEntityPattern(ElementTypeName entityName) {
        ElementTypeName elementTypeName = entityName;
        if (elementTypeName instanceof LabelName) {
            LabelName labelName = (LabelName)elementTypeName;
            return asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(e:", ")"}))), (Seq<PrettyString>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrettyString[]{asPrettyString$.MODULE$.apply((SymbolicName)labelName)}));
        }
        if (elementTypeName instanceof RelTypeName) {
            RelTypeName relTypeName = (RelTypeName)elementTypeName;
            return asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"()-[e:", "]-()"}))), (Seq<PrettyString>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrettyString[]{asPrettyString$.MODULE$.apply((SymbolicName)relTypeName)}));
        }
        throw new MatchError((Object)elementTypeName);
    }

    private PrettyString getPrettyEntityPattern(boolean isNode, String entityName) {
        if (isNode) {
            return asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(e:", ")"}))), (Seq<PrettyString>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrettyString[]{asPrettyString$.MODULE$.apply(entityName)}));
        }
        return asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"()-[e:", "]-()"}))), (Seq<PrettyString>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrettyString[]{asPrettyString$.MODULE$.apply(entityName)}));
    }

    private Tuple2<PrettyString, PrettyString> getPrettyLookupIndexPatternAndFunction(boolean isNode) {
        if (isNode) {
            return new Tuple2((Object)asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(e)"}))), (Seq<PrettyString>)Nil$.MODULE$), (Object)asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "(e)"}))), (Seq<PrettyString>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrettyString[]{asPrettyString$.MODULE$.raw(Labels$.MODULE$.name())})));
        }
        return new Tuple2((Object)asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"()-[e]-()"}))), (Seq<PrettyString>)Nil$.MODULE$), (Object)asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "(e)"}))), (Seq<PrettyString>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrettyString[]{asPrettyString$.MODULE$.raw(Type$.MODULE$.name())})));
    }

    private PrettyString getPrettyPropertyPattern(Seq<PropertyKeyName> properties, String start, String end) {
        return asPrettyString$.MODULE$.PrettyStringMaker((IterableOnce<PrettyString>)((IterableOnce)properties.map((Function1 & Serializable)x$44 -> asPrettyString$.MODULE$.apply((SymbolicName)x$44)))).mkPrettyString(start + "e.", ", e.", end);
    }

    private PrettyString getPrettyPropertyPattern(List<String> properties, String start, String end) {
        return asPrettyString$.MODULE$.PrettyStringMaker((IterableOnce<PrettyString>)properties.map((Function1 & Serializable)x$45 -> asPrettyString$.MODULE$.apply((String)x$45))).mkPrettyString(start + "e.", ", e.", end);
    }

    public IndexProviderContext org$neo4j$cypher$internal$SchemaCommandRuntime$$indexContext(QueryContext ctx) {
        return ctx;
    }

    public static final /* synthetic */ boolean $anonfun$convertConstraintTypeToConstraintMatcher$7(CypherType propType$1, ConstraintDescriptor c) {
        return c.isNodePropertyTypeConstraint() && MODULE$.checkTypes(propType$1, c.asPropertyTypeConstraint().propertyType());
    }

    public static final /* synthetic */ boolean $anonfun$convertConstraintTypeToConstraintMatcher$8(CypherType propType$2, ConstraintDescriptor c) {
        return c.isRelationshipPropertyTypeConstraint() && MODULE$.checkTypes(propType$2, c.asPropertyTypeConstraint().propertyType());
    }

    private SchemaCommandRuntime$() {
    }
}

