/* CypherPreParser.java */
/* Generated by: ParserGeneratorCC: Do not edit this line. CypherPreParser.java */
/*
 * Copyright (c) "Neo4j"
 * Neo4j Sweden AB [https://neo4j.com]
 *
 * This file is part of Neo4j.
 *
 * Neo4j is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package org.neo4j.cypher.internal.preparser.javacc;

import org.neo4j.cypher.internal.PreParsedStatement;
import org.neo4j.cypher.internal.PreParserOption;
import org.neo4j.cypher.internal.parser.common.ast.factory.ASTExceptionFactory;
import org.neo4j.cypher.internal.parser.common.InvalidUnicodeLiteral;
import org.neo4j.cypher.internal.util.InputPosition;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.gqlstatus.GqlHelper;


public class CypherPreParser implements CypherPreParserConstants {
    public ASTExceptionFactory exceptionFactory;

    public CypherPreParser(ASTExceptionFactory exceptionFactory, CharStream stream)
    {
        this(stream);
        this.exceptionFactory = exceptionFactory;
    }

    private InputPosition pos(Token t) {
        return InputPosition.apply(t.beginOffset, t.beginLine, t.beginColumn);
    }

    private InputPosition getPosition() {
        PreParserCharStream stream = (PreParserCharStream) token_source.input_stream;
        return InputPosition.apply( stream.getBeginOffset(), stream.getBeginLine(), stream.getBeginColumn() );
    }

/** Root production. */
  final public PreParserResult parse() throws ParseException, Exception {List<PreParserOption> options = new ArrayList<>();
  String query;
  Token queryStart = null;
    try {
      label_1:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case EXPLAIN:
        case PROFILE:
        case CYPHER:{
          break;
          }
        default:
          jj_la1[0] = jj_gen;
          break label_1;
        }
        Option(options);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case VERSION:
      case NUMBER:
      case EQ:
      case SLASH:
      case IDENTIFIER:
      case UNKNOWN:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case IDENTIFIER:{
          queryStart = jj_consume_token(IDENTIFIER);
          break;
          }
        case UNKNOWN:{
          queryStart = jj_consume_token(UNKNOWN);
          break;
          }
        case EQ:{
          queryStart = jj_consume_token(EQ);
          break;
          }
        case SLASH:{
          queryStart = jj_consume_token(SLASH);
          break;
          }
        case NUMBER:{
          queryStart = jj_consume_token(NUMBER);
          break;
          }
        case VERSION:{
          queryStart = jj_consume_token(VERSION);
          break;
          }
        default:
          jj_la1[1] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[2] = jj_gen;
        ;
      }
if ( queryStart == null )
            {
                 var gql = GqlHelper.getGql42001_42N45(token.endLine, token.endColumn + 1, token.endOffset + 1);
                 throw exceptionFactory.syntaxException(gql, new IllegalStateException( PreParserResult.getEmptyQueryExceptionMsg() ),
                    token.endOffset + 1, token.endLine, token.endColumn + 1);
            }
            {if ("" != null) return new PreParserResult( options, queryStart != null ? pos(queryStart) : InputPosition.apply(1, 0, 0) );}
    } catch (ParseException e) {
Token t = e.currentToken.next;
        if ( e.getMessage().contains( "Encountered \"<EOF>\"" ) )
        {
            var gql = GqlHelper.getGql42001_42N45(t.endLine, t.endColumn + 1, t.endOffset + 1);
            throw exceptionFactory.syntaxException(gql, e, t.endOffset + 1, t.endLine, t.endColumn + 1 );
        }
        else
        {
            var gql = GqlHelper.getGql42001_42I47(e.getMessage(), t.beginLine, t.beginColumn, t.beginOffset);
            throw exceptionFactory.syntaxException(gql, e, t.beginOffset, t.beginLine, t.beginColumn );
        }
    } catch (InvalidUnicodeLiteral e) {
var gql = GqlHelper.getGql42001_42I47(e.getMessage(), e.line, e.column, e.offset);
       throw exceptionFactory.syntaxException(gql, e, e.offset, e.line, e.column );
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public void Option(List<PreParserOption> options) throws ParseException, Exception {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case CYPHER:{
      CypherOption(options);
      break;
      }
    case EXPLAIN:{
      ExplainOption(options);
      break;
      }
    case PROFILE:{
      ProfileOption(options);
      break;
      }
    default:
      jj_la1[3] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void CypherOption(List<PreParserOption> options) throws ParseException, Exception {Token version = null;
  Token key;
  Token value = null;
  Token cypher = null;
    cypher = jj_consume_token(CYPHER);
    if (jj_2_1(2)) {
      version = jj_consume_token(VERSION);
options.add(PreParserOption.version(version.image, pos(version)));
    } else {
      ;
    }
    label_2:
    while (true) {
      if (jj_2_2(2147483647)) {
      } else {
        break label_2;
      }
      key = jj_consume_token(IDENTIFIER);
      jj_consume_token(EQ);
      value = jj_consume_token(IDENTIFIER);
options.add(PreParserOption.generic(key.image, value.image, pos(key)));
    }
}

  final public void ExplainOption(List<PreParserOption> options) throws ParseException {Token t;
    t = jj_consume_token(EXPLAIN);
options.add(PreParserOption.explain(pos(t)));
}

  final public void ProfileOption(List<PreParserOption> options) throws ParseException {Token t;
    t = jj_consume_token(PROFILE);
options.add(PreParserOption.profile(pos(t)));
}

  private boolean jj_2_1(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_1()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_2()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_3_2()
 {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(EQ)) return true;
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_scan_token(VERSION)) return true;
    return false;
  }

  /** Generated Token Manager. */
  public CypherPreParserTokenManager token_source;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[4];
  static private int[] jj_la1_0;
  static {
	   jj_la1_init_0();
	}
	private static void jj_la1_init_0() {
	   jj_la1_0 = new int[] {0xe,0x120f0,0x120f0,0xe,};
	}
  private final JJCalls[] jj_2_rtns = new JJCalls[2];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /**
   * Constructor with user supplied CharStream.
   * @param stream stream to init with
   */
  public CypherPreParser(final CharStream stream) {
	 token_source = new CypherPreParserTokenManager(stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 4; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Reinitialise.
   * @param stream stream to init with
   */
  public void ReInit(final CharStream stream) {
	 token_source.ReInit(stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
   for (int i = 0; i < 4; i++)
     jj_la1[i] = -1;
   for (int i = 0; i < jj_2_rtns.length; i++)
     jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Constructor with generated Token Manager.
   * @param tm Token manager to use
   */
  public CypherPreParser(final CypherPreParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 4; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Reinitialise
   * @param tm Token manager to use
   */
  public void ReInit(final CypherPreParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 4; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(final int kind) throws ParseException {
    final Token oldToken = token;
    if (token.next != null)
      token = token.next;
    else {
      token.next = token_source.getNextToken();
      token = token.next;
    }
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen)
              c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  private static final class LookaheadSuccess extends IllegalStateException {}
  private final LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
	 if (jj_scanpos == jj_lastpos) {
	   jj_la--;
	   if (jj_scanpos.next == null) {
		   jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
	   } else {
		   jj_lastpos = jj_scanpos = jj_scanpos.next;
	   }
	 } else {
	   jj_scanpos = jj_scanpos.next;
	 }
	 if (jj_rescan) {
	   int i = 0; Token tok = token;
	   while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
	   if (tok != null) jj_add_error_token(kind, i);
	 }
	 if (jj_scanpos.kind != kind) return true;
	 if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
	 return false;
  }


  /**
   * @return the next Token.
   */
  public final Token getNextToken() {
   if (token.next != null)
     token = token.next;
   else
     token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 jj_gen++;
	 return token;
  }

  /**
   * @param index index to be retrieved
   * @return the specific Token.
   */
  public final Token getToken(final int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next == null)
        t.next = token_source.getNextToken();
      t = t.next;
    }
    return t;
  }

  private int jj_ntk_f() {
    final Token nt = jj_nt = token.next;
    final int ret;
    if (nt == null) {
      token.next = token_source.getNextToken();
      ret = jj_ntk = token.next.kind;
    }
    else
      ret = jj_ntk = nt.kind;
    return ret;
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
  if (pos >= 100) {
    return;
  }

  if (pos == jj_endpos + 1) {
    jj_lasttokens[jj_endpos++] = kind;
  } else if (jj_endpos != 0) {
    jj_expentry = new int[jj_endpos];

    for (int i = 0; i < jj_endpos; i++) {
      jj_expentry[i] = jj_lasttokens[i];
    }

    for (final int[] oldentry : jj_expentries) {
      if (oldentry.length == jj_expentry.length) {
        boolean isMatched = true;
        for (int i = 0; i < jj_expentry.length; i++) {
          if (oldentry[i] != jj_expentry[i]) {
            isMatched = false;
            break;
          }
        }
        if (isMatched) {
          jj_expentries.add(jj_expentry);
          break;
        }
      }
    }

    if (pos != 0) {
      jj_endpos = pos;
      jj_lasttokens[jj_endpos - 1] = kind;
    }
  }
}

  /**
   * Generate ParseException.
   * @return new Exception object. Never <code>null</code>
   */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[17];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 4; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 17; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /**
   * @return Always <code>false</code>.
   */
  public final boolean trace_enabled() {
    return false;
  }

  /** Enable tracing. */
  public final void enable_tracing() {}

  /** Disable tracing. */
  public final void disable_tracing() {}

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 2; i++) {
      try {
        JJCalls p = jj_2_rtns[i];
        do {
          if (p.gen > jj_gen) {
            jj_la = p.arg;
            jj_scanpos = p.first;
            jj_lastpos = p.first;
            switch (i) {
              case 0: jj_3_1(); break;
              case 1: jj_3_2(); break;
            }
          }
          p = p.next;
        } while (p != null);
      } catch(LookaheadSuccess ls) { /* ignore */ }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) {
        p.next = new JJCalls();
        p = p.next;
        break;
      }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; 
    p.first = token;
    p.arg = xla;
  }

  static final class JJCalls {
	 int gen;
	 Token first;
	 int arg;
	 JJCalls next;
  }

}
