/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Serializable;
import java.lang.invoke.StringConcatFactory;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Locale;
import java.util.UUID;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.cypher.internal.AdministrationCommandRuntime;
import org.neo4j.cypher.internal.AdministrationCommandRuntime$IdentityConverter$;
import org.neo4j.cypher.internal.ExecutionEngine;
import org.neo4j.cypher.internal.ExecutionPlan;
import org.neo4j.cypher.internal.PrivilegeGQLCodeEntity;
import org.neo4j.cypher.internal.PrivilegeGQLCodeEntity$;
import org.neo4j.cypher.internal.ast.DatabaseName;
import org.neo4j.cypher.internal.ast.ExternalAuth;
import org.neo4j.cypher.internal.ast.HomeDatabaseAction;
import org.neo4j.cypher.internal.ast.NamespacedName;
import org.neo4j.cypher.internal.ast.NativeAuth;
import org.neo4j.cypher.internal.ast.ParameterName;
import org.neo4j.cypher.internal.ast.Password;
import org.neo4j.cypher.internal.ast.RemoveAuth;
import org.neo4j.cypher.internal.ast.RemoveHomeDatabaseAction$;
import org.neo4j.cypher.internal.ast.SetHomeDatabaseAction;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.ListLiteral;
import org.neo4j.cypher.internal.expressions.Parameter;
import org.neo4j.cypher.internal.expressions.StringLiteral;
import org.neo4j.cypher.internal.logical.plans.NameValidator$;
import org.neo4j.cypher.internal.procs.Continue$;
import org.neo4j.cypher.internal.procs.InitAndFinallyFunctions;
import org.neo4j.cypher.internal.procs.InitAndFinallyFunctions$;
import org.neo4j.cypher.internal.procs.ParameterTransformer;
import org.neo4j.cypher.internal.procs.ParameterTransformer$;
import org.neo4j.cypher.internal.procs.QueryHandler$;
import org.neo4j.cypher.internal.procs.QueryHandlerBuilder;
import org.neo4j.cypher.internal.procs.QueryHandlerResult;
import org.neo4j.cypher.internal.procs.ThrowException;
import org.neo4j.cypher.internal.procs.UpdatingSystemCommandExecutionPlan;
import org.neo4j.cypher.internal.procs.UpdatingSystemCommandExecutionPlan$;
import org.neo4j.cypher.internal.util.HomeDatabaseNotPresent;
import org.neo4j.cypher.internal.util.InternalNotification;
import org.neo4j.cypher.internal.util.symbols.CypherType;
import org.neo4j.cypher.internal.util.symbols.StringType;
import org.neo4j.cypher.internal.util.symbols.package$;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.exceptions.CypherExecutionException;
import org.neo4j.exceptions.DatabaseAdministrationOnFollowerException;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.exceptions.ParameterNotFoundException;
import org.neo4j.exceptions.ParameterWrongTypeException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlHelper;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.security.SecurityAuthorizationHandler;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.schema.UniquePropertyValueValidationException;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.server.security.SecureHasher;
import org.neo4j.server.security.SystemGraphCredential;
import org.neo4j.server.security.systemgraph.UserSecurityGraphComponent;
import org.neo4j.server.security.systemgraph.versions.KnownCommunitySecurityComponentVersion;
import org.neo4j.string.UTF8;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.ByteArray;
import org.neo4j.values.storable.IntValue;
import org.neo4j.values.storable.StringValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.utils.PrettyPrinter;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Using;
import scala.util.Using$;

public final class AdministrationCommandRuntime$ {
    public static final AdministrationCommandRuntime$ MODULE$ = new AdministrationCommandRuntime$();
    private static final String userLabel = KnownCommunitySecurityComponentVersion.USER_LABEL.name();
    private static final String userIdPropKey = "id";
    private static final String userNamePropKey = "name";
    private static final String userCredPropKey = "credentials";
    private static final String userPwChangeReqPropKey = "passwordChangeRequired";
    private static final String userSuspendedPropKey = "suspended";
    private static final String userHomeDbPropKey = "homeDatabase";
    private static final String authRelType = KnownCommunitySecurityComponentVersion.HAS_AUTH.name();
    private static final String authLabel = KnownCommunitySecurityComponentVersion.AUTH_LABEL.name();
    private static final String authProviderPropKey = "provider";
    private static final String authIdPropKey = "id";
    private static final String followerError = "Administration commands must be executed on the LEADER server.";
    private static final SecureHasher secureHasher = new SecureHasher();
    private static final String internalPrefix = "__internal_";

    public String userLabel() {
        return userLabel;
    }

    public String userIdPropKey() {
        return userIdPropKey;
    }

    public String userNamePropKey() {
        return userNamePropKey;
    }

    public String userCredPropKey() {
        return userCredPropKey;
    }

    public String userPwChangeReqPropKey() {
        return userPwChangeReqPropKey;
    }

    public String userSuspendedPropKey() {
        return userSuspendedPropKey;
    }

    public String userHomeDbPropKey() {
        return userHomeDbPropKey;
    }

    public String authRelType() {
        return authRelType;
    }

    public String authLabel() {
        return authLabel;
    }

    public String authProviderPropKey() {
        return authProviderPropKey;
    }

    public String authIdPropKey() {
        return authIdPropKey;
    }

    public String followerError() {
        return followerError;
    }

    private SecureHasher secureHasher() {
        return secureHasher;
    }

    private String internalPrefix() {
        return internalPrefix;
    }

    public String internalKey(String name) {
        return this.internalPrefix() + name;
    }

    public byte[] validatePassword(byte[] password, Config config) {
        byte[] byArray;
        if (password == null || password.length == 0) {
            throw new InvalidArgumentException("A password cannot be empty.");
        }
        Integer minimumPasswordLength = (Integer)config.get(GraphDatabaseSettings.auth_minimum_password_length);
        CharBuffer cb = StandardCharsets.UTF_8.decode(ByteBuffer.wrap(password));
        try {
            if (cb.codePoints().count() < (long)Predef$.MODULE$.Integer2int(minimumPasswordLength)) {
                throw InvalidArgumentException.shortPassword((int)Predef$.MODULE$.Integer2int(minimumPasswordLength));
            }
            byArray = password;
        }
        finally {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), cb.length()).foreach((Function1 & Serializable)i -> cb.put(BoxesRunTime.unboxToInt((Object)i), '0'));
        }
        return byArray;
    }

    public TextValue hashPassword(byte[] initialPassword) {
        return Values.utf8Value((String)SystemGraphCredential.createCredentialForPassword((byte[])initialPassword, (SecureHasher)this.secureHasher()).serialize());
    }

    public TextValue validateAndFormatEncryptedPassword(byte[] password) {
        TextValue textValue = Values.utf8Value((String)SystemGraphCredential.serialize((byte[])password));
        return textValue;
    }

    public AdministrationCommandRuntime.PasswordExpression getPasswordExpression(Expression password, boolean isEncryptedPassword, String[] otherParams, Config config) {
        Expression expression = password;
        if (expression instanceof Parameter) {
            Parameter parameter = (Parameter)expression;
            this.validateStringParameterType(parameter);
            String hashedPwKey = this.ensureUniqueParamName(this.internalKey(parameter.name()) + "_hashed", otherParams);
            String passwordByteKey = this.ensureUniqueParamName(this.internalKey(parameter.name()) + "_bytes", otherParams);
            return new AdministrationCommandRuntime.PasswordExpression(hashedPwKey, Values.NO_VALUE, passwordByteKey, Values.NO_VALUE, (Function2<Transaction, MapValue, MapValue>)(Function2 & Serializable)(x$1, params) -> this.convertPasswordParameters$1((MapValue)params, parameter, isEncryptedPassword, config, hashedPwKey, passwordByteKey));
        }
        throw new IllegalStateException("Internal error when processing password.");
    }

    public byte[] getValidPasswordParameter(MapValue params, String passwordParameter) {
        AnyValue anyValue = params.get(passwordParameter);
        if (anyValue instanceof ByteArray) {
            ByteArray byteArray = (ByteArray)anyValue;
            return byteArray.asObject();
        }
        if (anyValue instanceof StringValue) {
            StringValue stringValue = (StringValue)anyValue;
            return UTF8.encode((String)stringValue.stringValue());
        }
        Value value = Values.NO_VALUE;
        AnyValue anyValue2 = anyValue;
        if (!(value != null ? !value.equals(anyValue2) : anyValue2 != null)) {
            throw new ParameterNotFoundException("Expected parameter(s): " + passwordParameter);
        }
        PrettyPrinter pp = new PrettyPrinter();
        anyValue.writeTo((AnyValueWriter)pp);
        ErrorGqlStatusObject gql = GqlHelper.getGql42N51((String)passwordParameter, (ErrorGqlStatusObject)GqlHelper.getGql22G03_22N27((String)"******", (String)GqlParams.StringParam.param.process((Object)passwordParameter), java.util.List.of("STRING")));
        throw new ParameterWrongTypeException(gql, "Expected password parameter $" + passwordParameter + " to have type String but was " + anyValue.getTypeName());
    }

    public String ensureUniqueParamName(String originalName, String[] otherParams) {
        ObjectRef uniqueName = ObjectRef.create((Object)originalName);
        IndexedSeq params = Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.refArrayOps((Object[])otherParams), (Ordering)Ordering.String$.MODULE$));
        params.foreach((Function1 & Serializable)otherParamName -> {
            AdministrationCommandRuntime$.$anonfun$ensureUniqueParamName$1(uniqueName, otherParamName);
            return BoxedUnit.UNIT;
        });
        return (String)uniqueName.elem;
    }

    public void validateStringParameterType(Parameter param) {
        CypherType cypherType = param.parameterType();
        if (cypherType instanceof StringType) {
            return;
        }
        ErrorGqlStatusObject gql = GqlHelper.getGql42N51((String)param.name(), (ErrorGqlStatusObject)GqlHelper.getGql22G03_22N27((String)("type " + String.valueOf(param.parameterType())), (String)"password", java.util.List.of("STRING")));
        throw new ParameterWrongTypeException(gql, "Only " + package$.MODULE$.CTString() + " values are accepted as password, got: " + param.parameterType());
    }

    public ExecutionPlan makeCreateUserExecutionPlan(Either<String, Parameter> userName, boolean suspended, Option<HomeDatabaseAction> defaultDatabase, Option<NativeAuth> nativeAuth, Seq<ExternalAuth> externalAuths, Function2<Seq<ExternalAuth>, Option<NativeAuth>, QueryHandlerResult> validateAuth, Option<ExecutionPlan> sourcePlan, ExecutionEngine normalExecutionEngine, SecurityAuthorizationHandler securityAuthorizationHandler, Config config) {
        Option changeRequiredOption = nativeAuth.map((Function1 & Serializable)auth -> BoxesRunTime.boxToBoolean((boolean)AdministrationCommandRuntime$.$anonfun$makeCreateUserExecutionPlan$1(auth)));
        String passwordChangeRequiredKey = this.internalKey("passwordChangeRequired");
        String suspendedKey = this.internalKey("suspended");
        String uuidKey = this.internalKey("uuid");
        TextValue userId = Values.utf8Value((String)UUID.randomUUID().toString());
        String authKey = this.internalKey("auth");
        Option homeDatabaseFields = defaultDatabase.map((Function1 & Serializable)x0$1 -> {
            HomeDatabaseAction homeDatabaseAction = x0$1;
            if (RemoveHomeDatabaseAction$.MODULE$.equals(homeDatabaseAction)) {
                return new AdministrationCommandRuntime.NameFields(MODULE$.internalPrefix() + "homeDatabase", Values.NO_VALUE, AdministrationCommandRuntime$IdentityConverter$.MODULE$);
            }
            if (homeDatabaseAction instanceof SetHomeDatabaseAction) {
                SetHomeDatabaseAction setHomeDatabaseAction = (SetHomeDatabaseAction)homeDatabaseAction;
                DatabaseName name = setHomeDatabaseAction.name();
                return MODULE$.getNameFields("homeDatabase", (Either<String, Parameter>)name.asLegacyName(), (Function1<String, String>)(Function1 & Serializable)s -> new NormalizedDatabaseName(s).name());
            }
            throw new MatchError((Object)homeDatabaseAction);
        });
        AdministrationCommandRuntime.NameFields userNameFields = this.getNameFields("username", userName, this.getNameFields$default$3());
        String[] nonPasswordParameterNames = (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])new String[]{userNameFields.nameKey(), uuidKey, suspendedKey, authKey}), (IterableOnce)homeDatabaseFields.map((Function1 & Serializable)x$4 -> x$4.nameKey()), ClassTag$.MODULE$.apply(String.class))), (IterableOnce)changeRequiredOption.map((Function1 & Serializable)x$5 -> passwordChangeRequiredKey), ClassTag$.MODULE$.apply(String.class));
        Option credentialsOption = Option$.MODULE$.option2Iterable(nativeAuth.map((Function1 & Serializable)x$6 -> x$6.password())).collectFirst((PartialFunction)new Serializable(nonPasswordParameterNames, config){
            private static final long serialVersionUID = 0L;
            private final String[] nonPasswordParameterNames$1;
            private final Config config$2;

            public final <A1 extends Option<Password>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Some some;
                Password password;
                A1 A1 = x1;
                if (A1 instanceof Some && (password = (Password)(some = (Some)A1).value()) != null) {
                    Expression password2 = password.password();
                    boolean isEncrypted = password.isEncrypted();
                    return (B1)AdministrationCommandRuntime$.MODULE$.getPasswordExpression(password2, isEncrypted, this.nonPasswordParameterNames$1, this.config$2);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Option<Password> x1) {
                Some some;
                Password password;
                Option<Password> option = x1;
                return option instanceof Some && (password = (Password)(some = (Some)option).value()) != null;
            }
            {
                this.nonPasswordParameterNames$1 = nonPasswordParameterNames$1;
                this.config$2 = config$2;
            }
        });
        String homeDatabaseCypher = (String)homeDatabaseFields.map((Function1 & Serializable)ddf -> ", " + MODULE$.userHomeDbPropKey() + ": $`" + ddf.nameKey() + "`").getOrElse((Function0 & Serializable)() -> "");
        String nativeAuthCypher = (String)credentialsOption.map((Function1 & Serializable)credentials -> ", " + MODULE$.userCredPropKey() + ": $`" + credentials.key() + "`, " + MODULE$.userPwChangeReqPropKey() + ": $`" + passwordChangeRequiredKey + "`").getOrElse((Function0 & Serializable)() -> "");
        ParameterTransformer parameterTransformer = ParameterTransformer$.MODULE$.apply((Function3<Transaction, SecurityContext, MapValue, MapValue>)AdministrationCommandRuntime$.authMapGenerator$1(externalAuths, nativeAuth, userId, authKey)).convert(userNameFields.nameConverter()).optionallyConvert((Option<Function2<Transaction, MapValue, MapValue>>)homeDatabaseFields.map((Function1 & Serializable)x$10 -> x$10.nameConverter())).optionallyConvert((Option<Function2<Transaction, MapValue, MapValue>>)credentialsOption.map((Function1 & Serializable)x$11 -> x$11.mapValueConverter())).validate((Function2<Transaction, MapValue, Tuple2<MapValue, Set<InternalNotification>>>)(Function2 & Serializable)(tx, params) -> MODULE$.isHomeDatabasePresent((Option<AdministrationCommandRuntime.NameFields>)homeDatabaseFields, (Transaction)tx, (MapValue)params));
        String x$16 = "CreateUser";
        ExecutionEngine x$2 = normalExecutionEngine;
        SecurityAuthorizationHandler x$3 = securityAuthorizationHandler;
        String x$42 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("CREATE (u:" + this.userLabel() + " {" + this.userNamePropKey() + ": $`" + userNameFields.nameKey() + "`, " + this.userIdPropKey() + ": $`" + uuidKey + "`, " + this.userSuspendedPropKey() + ": $`" + suspendedKey + "`\n         |" + nativeAuthCypher + "\n         |" + homeDatabaseCypher + " })\n         |WITH u\n         |CALL {\n         |  WITH u\n         |  UNWIND $`" + authKey + "` AS auth\n         |  CREATE (u)-[:" + this.authRelType() + "]->(:" + this.authLabel() + " {" + this.authProviderPropKey() + ": auth.provider, " + this.authIdPropKey() + ": auth.id})\n         |}\n         |RETURN u." + this.userNamePropKey()));
        MapValue x$52 = VirtualValues.map((String[])((String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])credentialsOption.map((Function1 & Serializable)credentials -> (String[])((Object[])new String[]{credentials.key(), credentials.bytesKey()})).getOrElse((Function0 & Serializable)() -> (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)))), (Object)nonPasswordParameterNames, ClassTag$.MODULE$.apply(String.class))), (AnyValue[])((AnyValue[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])credentialsOption.map((Function1 & Serializable)credentials -> (AnyValue[])((Object[])new AnyValue[]{credentials.value(), credentials.bytesValue()})).getOrElse((Function0 & Serializable)() -> (AnyValue[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(AnyValue.class)))), (Object)new AnyValue[]{userNameFields.nameValue(), userId, Values.booleanValue((boolean)suspended), Values.NO_VALUE}, ClassTag$.MODULE$.apply(AnyValue.class))), (IterableOnce)homeDatabaseFields.map((Function1 & Serializable)x$12 -> x$12.nameValue()), ClassTag$.MODULE$.apply(AnyValue.class))), (IterableOnce)changeRequiredOption.map((Function1 & Serializable)x$1 -> AdministrationCommandRuntime$.$anonfun$makeCreateUserExecutionPlan$23(BoxesRunTime.unboxToBoolean((Object)x$1))), ClassTag$.MODULE$.apply(AnyValue.class))));
        QueryHandlerBuilder x$62 = QueryHandler$.MODULE$.handleNoResult((Function1<MapValue, Option<QueryHandlerResult>>)(Function1 & Serializable)params -> new Some((Object)new ThrowException((Throwable)CypherExecutionException.createEntity((String)"user", (String)MODULE$.runtimeStringValue(userName, (MapValue)params))))).handleError((Function2<Throwable, MapValue, Throwable>)(Function2 & Serializable)(error, params) -> {
            Throwable e;
            Throwable e2;
            Tuple2 tuple2 = new Tuple2(error, (Object)error.getCause());
            if (tuple2 != null && (e2 = (Throwable)tuple2._2()) instanceof UniquePropertyValueValidationException) {
                UniquePropertyValueValidationException uniquePropertyValueValidationException = (UniquePropertyValueValidationException)e2;
                if (uniquePropertyValueValidationException.constraint().getName().equals("auth-constraint")) {
                    return new InvalidArgumentException("Failed to create the specified user '" + MODULE$.runtimeStringValue(userName, (MapValue)params) + "': The combination of provider and id is already in use.", error);
                }
                return new InvalidArgumentException("Failed to create the specified user '" + MODULE$.runtimeStringValue(userName, (MapValue)params) + "': User already exists.", error);
            }
            if (tuple2 != null && (e = (Throwable)tuple2._1()) instanceof Status.HasStatus) {
                Throwable throwable = e;
                Status status = ((Status.HasStatus)throwable).status();
                Status.Cluster cluster = Status.Cluster.NotALeader;
                if (!(status != null ? !status.equals(cluster) : cluster != null)) {
                    return DatabaseAdministrationOnFollowerException.notALeader((String)"CREATE USER", (String)("Failed to create the specified user '" + MODULE$.runtimeStringValue(userName, (MapValue)params) + "'"), (Throwable)error);
                }
            }
            return CypherExecutionException.createEntityCause((String)"user", (String)MODULE$.runtimeStringValue(userName, (MapValue)params), (Throwable)error);
        }).handleResult((Function3<Object, AnyValue, MapValue, QueryHandlerResult>)(Function3 & Serializable)(x$13, x$14, x$15) -> AdministrationCommandRuntime$.$anonfun$makeCreateUserExecutionPlan$26(validateAuth, externalAuths, nativeAuth, BoxesRunTime.unboxToInt((Object)x$13), x$14, x$15));
        Option<ExecutionPlan> x$7 = sourcePlan;
        InitAndFinallyFunctions x$8 = new InitAndFinallyFunctions((Function1<MapValue, Object>)(Function1 & Serializable)params -> BoxesRunTime.boxToBoolean((boolean)NameValidator$.MODULE$.assertValidUsername(AdministrationCommandRuntime$.MODULE$.runtimeStringValue((Either<String, Parameter>)userName, params))), (Function1<MapValue, BoxedUnit>)(Function1 & Serializable)p -> {
            credentialsOption.foreach((Function1 & Serializable)credentials -> {
                AdministrationCommandRuntime$.$anonfun$makeCreateUserExecutionPlan$29(p, credentials);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        ParameterTransformer x$9 = parameterTransformer;
        boolean x$102 = UpdatingSystemCommandExecutionPlan$.MODULE$.apply$default$8();
        Function1<Transaction, BoxedUnit> x$112 = UpdatingSystemCommandExecutionPlan$.MODULE$.apply$default$11();
        return new UpdatingSystemCommandExecutionPlan("CreateUser", x$2, x$3, x$42, x$52, x$62, x$7, x$102, x$8, x$9, x$112);
    }

    public Function2<Seq<ExternalAuth>, Option<NativeAuth>, QueryHandlerResult> makeCreateUserExecutionPlan$default$6() {
        return (Function2 & Serializable)(x$2, x$3) -> Continue$.MODULE$;
    }

    public ExecutionPlan makeAlterUserExecutionPlan(Either<String, Parameter> userName, Option<Object> suspended, Option<HomeDatabaseAction> homeDatabase, Option<NativeAuth> nativeAuth, Seq<ExternalAuth> externalAuths, RemoveAuth removeAuths, Function2<Seq<ExternalAuth>, Option<NativeAuth>, QueryHandlerResult> validateAuth, Option<ExecutionPlan> sourcePlan, ExecutionEngine normalExecutionEngine, SecurityAuthorizationHandler securityAuthorizationHandler, UserSecurityGraphComponent userSecurityGraphComponent, Config config) {
        AdministrationCommandRuntime.NameFields userNameFields = this.getNameFields("username", userName, this.getNameFields$default$3());
        String setAuthKey = this.internalKey("setAuth");
        String removeAuthKey = this.internalKey("removeAuth");
        String removeNativeKey = this.internalKey("removeNative");
        String enforceAuthKey = this.internalKey("enforceAuth");
        Option homeDatabaseFields = homeDatabase.map((Function1 & Serializable)x0$1 -> {
            HomeDatabaseAction homeDatabaseAction = x0$1;
            if (RemoveHomeDatabaseAction$.MODULE$.equals(homeDatabaseAction)) {
                return new AdministrationCommandRuntime.NameFields(MODULE$.internalPrefix() + "homeDatabase", Values.NO_VALUE, AdministrationCommandRuntime$IdentityConverter$.MODULE$);
            }
            if (homeDatabaseAction instanceof SetHomeDatabaseAction) {
                SetHomeDatabaseAction setHomeDatabaseAction = (SetHomeDatabaseAction)homeDatabaseAction;
                DatabaseName name = setHomeDatabaseAction.name();
                return MODULE$.getNameFields("homeDatabase", (Either<String, Parameter>)name.asLegacyName(), (Function1<String, String>)(Function1 & Serializable)s -> new NormalizedDatabaseName(s).name());
            }
            throw new MatchError((Object)homeDatabaseAction);
        });
        String[] nonPasswordParameterNames = (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])new String[]{userNameFields.nameKey()}), (IterableOnce)homeDatabaseFields.map((Function1 & Serializable)x$18 -> x$18.nameKey()), ClassTag$.MODULE$.apply(String.class))), (Object)new String[]{setAuthKey, removeAuthKey, removeNativeKey, enforceAuthKey}, ClassTag$.MODULE$.apply(String.class));
        Option maybePw = Option$.MODULE$.option2Iterable(nativeAuth.map((Function1 & Serializable)x$19 -> x$19.password())).collectFirst((PartialFunction)new Serializable(nonPasswordParameterNames, config){
            private static final long serialVersionUID = 0L;
            private final String[] nonPasswordParameterNames$2;
            private final Config config$3;

            public final <A1 extends Option<Password>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Some some;
                Password password;
                A1 A1 = x1;
                if (A1 instanceof Some && (password = (Password)(some = (Some)A1).value()) != null) {
                    Expression password2 = password.password();
                    boolean isEncrypted = password.isEncrypted();
                    return (B1)AdministrationCommandRuntime$.MODULE$.getPasswordExpression(password2, isEncrypted, this.nonPasswordParameterNames$2, this.config$3);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Option<Password> x1) {
                Some some;
                Password password;
                Option<Password> option = x1;
                return option instanceof Some && (password = (Password)(some = (Some)option).value()) != null;
            }
            {
                this.nonPasswordParameterNames$2 = nonPasswordParameterNames$2;
                this.config$3 = config$3;
            }
        });
        Seq params2 = (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)maybePw), (Object)this.userCredPropKey()), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)nativeAuth.flatMap((Function1 & Serializable)x$20 -> x$20.changeRequired())), (Object)this.userPwChangeReqPropKey()), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(suspended), (Object)this.userSuspendedPropKey()), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)homeDatabaseFields), (Object)this.userHomeDbPropKey()), (List)Nil$.MODULE$)))).flatMap((Function1 & Serializable)param -> {
            Object nameFields;
            Object passwordExpression;
            boolean bl = false;
            Some some = null;
            Option option = (Option)param._1();
            if (None$.MODULE$.equals(option)) {
                return (Seq)scala.package$.MODULE$.Seq().empty();
            }
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                Object boolExpr = some.value();
                if (boolExpr instanceof Boolean) {
                    boolean bl2 = BoxesRunTime.unboxToBoolean((Object)boolExpr);
                    return new .colon.colon((Object)new Tuple3(param._2(), (Object)MODULE$.internalKey((String)param._2()), (Object)Values.booleanValue((boolean)bl2)), (List)Nil$.MODULE$);
                }
            }
            if (bl && (passwordExpression = some.value()) instanceof AdministrationCommandRuntime.PasswordExpression) {
                AdministrationCommandRuntime.PasswordExpression passwordExpression2 = (AdministrationCommandRuntime.PasswordExpression)passwordExpression;
                return new .colon.colon((Object)new Tuple3(param._2(), (Object)passwordExpression2.key(), (Object)passwordExpression2.value()), (List)Nil$.MODULE$);
            }
            if (bl && (nameFields = some.value()) instanceof AdministrationCommandRuntime.NameFields) {
                AdministrationCommandRuntime.NameFields nameFields2 = (AdministrationCommandRuntime.NameFields)nameFields;
                return new .colon.colon((Object)new Tuple3(param._2(), (Object)nameFields2.nameKey(), (Object)nameFields2.nameValue()), (List)Nil$.MODULE$);
            }
            if (bl) {
                Object p = some.value();
                ErrorGqlStatusObject gql = GqlHelper.getGql42N51((String)String.valueOf(p), (ErrorGqlStatusObject)GqlHelper.getGql22G03_22N27((String)String.valueOf(p.getClass().getSimpleName()), (String)GqlParams.StringParam.cmd.process((Object)"ALTER USER"), java.util.List.of("BOOLEAN", "STRING")));
                throw new InvalidArgumentException(gql, "Invalid option type for ALTER USER, expected PasswordExpression, Boolean, String or Parameter but got: " + p.getClass().getSimpleName());
            }
            throw new MatchError((Object)option);
        });
        Tuple3 tuple3 = (Tuple3)params2.foldLeft((Object)new Tuple3((Object)"", (Object)scala.package$.MODULE$.Seq().empty(), (Object)scala.package$.MODULE$.Seq().empty()), (Function2 & Serializable)(acc, param) -> {
            String propertyName = (String)param._1();
            String key = (String)param._2();
            Value value = (Value)param._3();
            return new Tuple3((Object)((String)acc._1() + " SET user." + propertyName + " = $`" + key + "`"), ((SeqOps)acc._2()).$colon$plus((Object)key), ((SeqOps)acc._3()).$colon$plus((Object)value));
        });
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        String setParts = (String)tuple3._1();
        Seq keys = (Seq)tuple3._2();
        Seq values = (Seq)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)setParts, (Object)keys, (Object)values);
        String setParts2 = (String)tuple32._1();
        Seq keys2 = (Seq)tuple32._2();
        Seq values2 = (Seq)tuple32._3();
        String[] parameterKeys = (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])((IterableOnceOps)((SeqOps)keys2.$plus$plus((IterableOnce)Option$.MODULE$.option2Iterable(maybePw.map((Function1 & Serializable)x$22 -> x$22.bytesKey())).toSeq())).$colon$plus((Object)userNameFields.nameKey())).toArray(ClassTag$.MODULE$.apply(String.class))), (Object)new String[]{setAuthKey, removeAuthKey, removeNativeKey, enforceAuthKey}, ClassTag$.MODULE$.apply(String.class));
        AnyValue[] parameterValues = (AnyValue[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])((IterableOnceOps)((SeqOps)values2.$plus$plus((IterableOnce)Option$.MODULE$.option2Iterable(maybePw.map((Function1 & Serializable)x$23 -> x$23.bytesValue())).toSeq())).$colon$plus((Object)userNameFields.nameValue())).toArray(ClassTag$.MODULE$.apply(Value.class))), (Object)new AnyValue[]{Values.NO_VALUE, Values.NO_VALUE, Values.NO_VALUE, Values.NO_VALUE}, ClassTag$.MODULE$.apply(AnyValue.class));
        String authMatch = removeAuths.all() ? "OPTIONAL MATCH (user)-[:" + this.authRelType() + "]->(a:" + this.authLabel() + ")" : StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("UNWIND $`" + removeAuthKey + "` AS auth\n             |  OPTIONAL MATCH (user)-[:" + this.authRelType() + "]->(a:" + this.authLabel() + " {" + this.authProviderPropKey() + ": auth})"));
        String removeAuthString = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("WITH user, oldCredentials\n         |CALL {\n         |  WITH user\n         |  WITH user,\n         |  CASE\n         |    WHEN $`" + removeNativeKey + "` THEN {credentials: null, change: null}\n         |    ELSE {credentials: user." + this.userCredPropKey() + ", change: user." + this.userPwChangeReqPropKey() + "}\n         |  END AS cMap\n         |  SET user." + this.userCredPropKey() + " = cMap.credentials, user." + this.userPwChangeReqPropKey() + " = cMap.change\n         |}\n         |WITH user, oldCredentials\n         |CALL {\n         |  WITH user\n         |  " + authMatch + "\n         |  DETACH DELETE (a)\n         |}"));
        String addNativeAuthString = nativeAuth.nonEmpty() ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("MERGE (user)-[:" + this.authRelType() + "]->(:" + this.authLabel() + " {" + this.authProviderPropKey() + ": 'native', " + this.authIdPropKey() + ": user." + this.userIdPropKey() + "})\n           |SET user." + this.userPwChangeReqPropKey() + " = coalesce(user." + this.userPwChangeReqPropKey() + ", true)")) : "";
        String nativeAuthValid = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |WITH user, oldCredentials\n         |OPTIONAL MATCH (user)-[:" + this.authRelType() + "]->(nativeAuth:" + this.authLabel() + " {" + this.authProviderPropKey() + ": 'native'})\n         |WITH user, oldCredentials,\n         | CASE EXISTS { (nativeAuth) }\n         |  WHEN true THEN EXISTS { (user) WHERE user." + this.userCredPropKey() + " IS NOT NULL AND user." + this.userPwChangeReqPropKey() + " IS NOT NULL }\n         |  ELSE true\n         | END AS validNativeAuth\n         |"));
        String addAuthString = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("WITH user, oldCredentials\n         |CALL {\n         |  WITH user\n         |  UNWIND $`" + setAuthKey + "` AS auth\n         |  MERGE (user)-[:" + this.authRelType() + "]->(a:" + this.authLabel() + " {" + this.authProviderPropKey() + ": auth.provider}) SET a." + this.authIdPropKey() + " = auth.id\n         |}"));
        String enforceAuthString = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("CASE $`" + enforceAuthKey + "`\n         | WHEN true THEN EXISTS { (user)-[:" + this.authRelType() + "]->(:" + this.authLabel() + ") }\n         | ELSE true\n         |END AS authOk\n         |"));
        ParameterTransformer parameterTransformer = new ParameterTransformer(ParameterTransformer$.MODULE$.apply$default$1(), ParameterTransformer$.MODULE$.apply$default$2()).generate((Function3<Transaction, SecurityContext, MapValue, MapValue>)AdministrationCommandRuntime$.enforceAuthGen$1(userSecurityGraphComponent, enforceAuthKey)).generate((Function3<Transaction, SecurityContext, MapValue, MapValue>)AdministrationCommandRuntime$.authMapGenerator$2(externalAuths, removeAuths, setAuthKey, removeAuthKey, removeNativeKey)).convert(userNameFields.nameConverter()).optionallyConvert((Option<Function2<Transaction, MapValue, MapValue>>)homeDatabaseFields.map((Function1 & Serializable)x$28 -> x$28.nameConverter())).optionallyConvert((Option<Function2<Transaction, MapValue, MapValue>>)maybePw.map((Function1 & Serializable)x$29 -> x$29.mapValueConverter())).validate((Function2<Transaction, MapValue, Tuple2<MapValue, Set<InternalNotification>>>)(Function2 & Serializable)(tx, params) -> MODULE$.isHomeDatabasePresent((Option<AdministrationCommandRuntime.NameFields>)homeDatabaseFields, (Transaction)tx, (MapValue)params));
        String x$3 = "AlterUser";
        ExecutionEngine x$4 = normalExecutionEngine;
        SecurityAuthorizationHandler x$5 = securityAuthorizationHandler;
        String x$6 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("MATCH (user:" + this.userLabel() + " {" + this.userNamePropKey() + ": $`" + userNameFields.nameKey() + "`})\n         |WITH user, user." + this.userCredPropKey() + " AS oldCredentials\n         |" + removeAuthString + "\n         |" + setParts2 + "\n         |" + addNativeAuthString + "\n         |" + addAuthString + "\n         |" + nativeAuthValid + "\n         |RETURN EXISTS { (user:" + this.userLabel() + " {" + this.userNamePropKey() + ": $`" + userNameFields.nameKey() + "`}) } AS exists,\n         |oldCredentials, " + enforceAuthString + ", validNativeAuth "));
        MapValue x$7 = VirtualValues.map((String[])parameterKeys, (AnyValue[])parameterValues);
        QueryHandlerBuilder x$8 = QueryHandler$.MODULE$.handleNoResult((Function1<MapValue, Option<QueryHandlerResult>>)(Function1 & Serializable)p -> new Some((Object)new ThrowException(InvalidArgumentException.alterMissingUser((String)MODULE$.runtimeStringValue(userName, (MapValue)p))))).handleError((Function2<Throwable, MapValue, Throwable>)(Function2 & Serializable)(error, p) -> {
            Throwable e;
            Tuple2 tuple2 = new Tuple2(error, (Object)error.getCause());
            if (tuple2 != null && tuple2._2() instanceof UniquePropertyValueValidationException) {
                return new InvalidArgumentException("Failed to alter the specified user '" + MODULE$.runtimeStringValue(userName, (MapValue)p) + "': The combination of provider and id is already in use.", error);
            }
            if (tuple2 != null && (e = (Throwable)tuple2._1()) instanceof Status.HasStatus) {
                Throwable throwable = e;
                Status status = ((Status.HasStatus)throwable).status();
                Status.Cluster cluster = Status.Cluster.NotALeader;
                if (!(status != null ? !status.equals(cluster) : cluster != null)) {
                    return DatabaseAdministrationOnFollowerException.notALeader((String)"ALTER USER", (String)("Failed to alter the specified user '" + MODULE$.runtimeStringValue(userName, (MapValue)p) + "'"), (Throwable)error);
                }
            }
            return CypherExecutionException.alterEntityCause((String)"user", (String)MODULE$.runtimeStringValue(userName, (MapValue)p), (Throwable)error);
        }).handleResult((Function3<Object, AnyValue, MapValue, QueryHandlerResult>)(Function3 & Serializable)(x0$2, x1$1, x2$1) -> AdministrationCommandRuntime$.$anonfun$makeAlterUserExecutionPlan$20(userName, maybePw, validateAuth, externalAuths, nativeAuth, BoxesRunTime.unboxToInt((Object)x0$2), x1$1, x2$1));
        Option<ExecutionPlan> x$9 = sourcePlan;
        Function1 & Serializable x$1 = (Function1 & Serializable)p -> {
            maybePw.foreach((Function1 & Serializable)newPw -> {
                AdministrationCommandRuntime$.$anonfun$makeAlterUserExecutionPlan$24(p, newPw);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        };
        Function1<MapValue, Object> x$2 = InitAndFinallyFunctions$.MODULE$.apply$default$1();
        InitAndFinallyFunctions x$10 = new InitAndFinallyFunctions(x$2, (Function1<MapValue, BoxedUnit>)x$1);
        ParameterTransformer x$11 = parameterTransformer;
        boolean x$12 = UpdatingSystemCommandExecutionPlan$.MODULE$.apply$default$8();
        Function1<Transaction, BoxedUnit> x$13 = UpdatingSystemCommandExecutionPlan$.MODULE$.apply$default$11();
        return new UpdatingSystemCommandExecutionPlan("AlterUser", x$4, x$5, x$6, x$7, x$8, x$9, x$12, x$10, x$11, x$13);
    }

    public Function2<Seq<ExternalAuth>, Option<NativeAuth>, QueryHandlerResult> makeAlterUserExecutionPlan$default$7() {
        return (Function2 & Serializable)(x$16, x$17) -> Continue$.MODULE$;
    }

    private Tuple2<MapValue, Set<InternalNotification>> isHomeDatabasePresent(Option<AdministrationCommandRuntime.NameFields> homeDatabaseFields, Transaction tx, MapValue params) {
        return (Tuple2)homeDatabaseFields.map((Function1 & Serializable)ddf -> {
            AnyValue anyValue = params.get(ddf.nameKey());
            if (anyValue instanceof TextValue) {
                TextValue textValue = (TextValue)anyValue;
                Set notifications = Iterators.asList((Iterator)tx.findNodes(TopologyGraphDbmsModel.DATABASE_NAME_LABEL, "displayName", (Object)textValue.stringValue())).isEmpty() ? (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InternalNotification[]{new HomeDatabaseNotPresent(textValue.stringValue())})) : Predef$.MODULE$.Set().empty();
                return new Tuple2((Object)params, (Object)notifications);
            }
            return new Tuple2((Object)params, (Object)Predef$.MODULE$.Set().empty());
        }).getOrElse((Function0 & Serializable)() -> new Tuple2((Object)params, (Object)Predef$.MODULE$.Set().empty()));
    }

    public ExecutionPlan makeRenameExecutionPlan(PrivilegeGQLCodeEntity entity, String namePropKey, Either<String, Parameter> fromName, Either<String, Parameter> toName, Function1<MapValue, Object> initFunction, Option<ExecutionPlan> sourcePlan, ExecutionEngine normalExecutionEngine, SecurityAuthorizationHandler securityAuthorizationHandler) {
        AdministrationCommandRuntime.NameFields fromNameFields = this.getNameFields("fromName", fromName, this.getNameFields$default$3());
        AdministrationCommandRuntime.NameFields toNameFields = this.getNameFields("toName", toName, this.getNameFields$default$3());
        ParameterTransformer parameterTransformer = new ParameterTransformer(ParameterTransformer$.MODULE$.apply$default$1(), ParameterTransformer$.MODULE$.apply$default$2()).convert(fromNameFields.nameConverter()).convert(toNameFields.nameConverter());
        String x$1 = "Create" + entity;
        ExecutionEngine x$2 = normalExecutionEngine;
        SecurityAuthorizationHandler x$3 = securityAuthorizationHandler;
        String x$4 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("MATCH (old:" + entity + " {" + namePropKey + ": $`" + fromNameFields.nameKey() + "`})\n         |SET old." + namePropKey + " = $`" + toNameFields.nameKey() + "`\n         |RETURN old." + namePropKey + "\n        "));
        MapValue x$5 = VirtualValues.map((String[])((String[])((Object[])new String[]{fromNameFields.nameKey(), toNameFields.nameKey()})), (AnyValue[])((AnyValue[])((Object[])new AnyValue[]{fromNameFields.nameValue(), toNameFields.nameValue()})));
        QueryHandlerBuilder x$6 = QueryHandler$.MODULE$.handleNoResult((Function1<MapValue, Option<QueryHandlerResult>>)(Function1 & Serializable)p -> new Some((Object)new ThrowException(InvalidArgumentException.renameEntityNotFound((ErrorGqlStatusObject)PrivilegeGQLCodeEntity$.MODULE$.entityNotFoundGqlStatus(entity, entity.toString()), (String)entity.toString().toLowerCase(Locale.ROOT), (String)MODULE$.runtimeStringValue(fromName, (MapValue)p), (String)MODULE$.runtimeStringValue(toName, (MapValue)p))))).handleError((Function2<Throwable, MapValue, Throwable>)(Function2 & Serializable)(error, p) -> {
            Throwable e;
            Tuple2 tuple2 = new Tuple2(error, (Object)error.getCause());
            if (tuple2 != null && tuple2._2() instanceof UniquePropertyValueValidationException) {
                return InvalidArgumentException.renameEntityAlreadyExists((ErrorGqlStatusObject)PrivilegeGQLCodeEntity$.MODULE$.entityAlreadyExistsGqlStatus(entity, entity.toString()), (String)entity.toString(), (String)MODULE$.runtimeStringValue(fromName, (MapValue)p), (String)MODULE$.runtimeStringValue(toName, (MapValue)p), (Throwable)error);
            }
            if (tuple2 != null && (e = (Throwable)tuple2._1()) instanceof Status.HasStatus) {
                Throwable throwable = e;
                Status status = ((Status.HasStatus)throwable).status();
                Status.Cluster cluster = Status.Cluster.NotALeader;
                if (!(status != null ? !status.equals(cluster) : cluster != null)) {
                    return DatabaseAdministrationOnFollowerException.notALeader((String)("RENAME " + entity.toString().toUpperCase(Locale.ROOT)), (String)("Failed to rename the specified " + entity.toString().toLowerCase(Locale.ROOT) + " '" + MODULE$.runtimeStringValue(fromName, (MapValue)p) + "'"), (Throwable)error);
                }
            }
            return CypherExecutionException.renameEntityCause((String)entity.toString().toLowerCase(Locale.ROOT), (String)MODULE$.runtimeStringValue(fromName, (MapValue)p), (String)MODULE$.runtimeStringValue(toName, (MapValue)p), (Throwable)error);
        });
        Option<ExecutionPlan> x$7 = sourcePlan;
        InitAndFinallyFunctions x$8 = new InitAndFinallyFunctions(initFunction, InitAndFinallyFunctions$.MODULE$.apply$default$2());
        ParameterTransformer x$9 = parameterTransformer;
        boolean x$10 = UpdatingSystemCommandExecutionPlan$.MODULE$.apply$default$8();
        Function1<Transaction, BoxedUnit> x$11 = UpdatingSystemCommandExecutionPlan$.MODULE$.apply$default$11();
        return new UpdatingSystemCommandExecutionPlan(x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$10, x$8, x$9, x$11);
    }

    public AdministrationCommandRuntime.NameFields getNameFields(String key, Either<String, Parameter> name, Function1<String, String> valueMapper) {
        Either<String, Parameter> either = name;
        if (either instanceof Left) {
            Left left = (Left)either;
            String u = (String)left.value();
            return new AdministrationCommandRuntime.NameFields(this.internalKey(key), (Value)Values.utf8Value((String)((String)valueMapper.apply((Object)u))), AdministrationCommandRuntime$IdentityConverter$.MODULE$);
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Parameter parameter = (Parameter)right.value();
            return new AdministrationCommandRuntime.NameFields(this.internalKey(key), Values.NO_VALUE, new AdministrationCommandRuntime.RenamingStringParameterConverter(parameter.name(), this.internalKey(key), (Function1<TextValue, TextValue>)(Function1 & Serializable)v -> Values.utf8Value((String)((String)valueMapper.apply((Object)v.stringValue())))));
        }
        throw new MatchError(either);
    }

    public Function1<String, String> getNameFields$default$3() {
        return (Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x);
    }

    public AdministrationCommandRuntime.DatabaseNameFields getDatabaseNameFields(String nameKey, DatabaseName name) {
        Option option;
        Function1 & Serializable valueMapper = (Function1 & Serializable)x$30 -> new NormalizedDatabaseName(x$30).name();
        boolean bl = false;
        NamespacedName namespacedName = null;
        DatabaseName databaseName = name;
        if (databaseName instanceof NamespacedName) {
            bl = true;
            namespacedName = (NamespacedName)databaseName;
            Option option2 = namespacedName.namespace();
            if (None$.MODULE$.equals(option2)) {
                return new AdministrationCommandRuntime.DatabaseNameFields(this.internalPrefix() + nameKey, (Value)Values.utf8Value((String)((String)valueMapper.apply((Object)namespacedName.name()))), this.internalPrefix() + nameKey + "_namespace", (Value)Values.utf8Value((String)"system-root"), this.internalPrefix() + nameKey + "_displayName", (Value)Values.utf8Value((String)((String)valueMapper.apply((Object)namespacedName.name()))), false, AdministrationCommandRuntime$IdentityConverter$.MODULE$);
            }
        }
        if (bl && (option = namespacedName.namespace()) instanceof Some) {
            Some some = (Some)option;
            String namespace = (String)some.value();
            String string = namespace;
            String string2 = "system-root";
            return new AdministrationCommandRuntime.DatabaseNameFields(this.internalPrefix() + nameKey, (Value)Values.utf8Value((String)((String)valueMapper.apply((Object)namespacedName.name()))), this.internalPrefix() + nameKey + "_namespace", (Value)Values.utf8Value((String)((String)valueMapper.apply((Object)namespace))), this.internalPrefix() + nameKey + "_displayName", (Value)Values.utf8Value((String)(!(string != null ? !string.equals(string2) : string2 != null) ? (String)valueMapper.apply((Object)namespacedName.name()) : (String)valueMapper.apply((Object)namespace) + "." + valueMapper.apply((Object)namespacedName.name()))), false, AdministrationCommandRuntime$IdentityConverter$.MODULE$);
        }
        if (databaseName instanceof ParameterName) {
            ParameterName parameterName = (ParameterName)databaseName;
            Parameter parameter = parameterName.parameter();
            String displayNameKey = this.internalKey(parameter.name() + "_displayName");
            return new AdministrationCommandRuntime.DatabaseNameFields((String)AdministrationCommandRuntime$.rename$1().apply((Object)parameter.name()), Values.NO_VALUE, this.internalKey(parameter.name() + "_namespace"), (Value)Values.utf8Value((String)"system-root"), displayNameKey, Values.NO_VALUE, true, (Function2<Transaction, MapValue, MapValue>)(Function2 & Serializable)(x$31, params) -> {
                Tuple3 tuple3 = parameterName.getNameParts(params, "system-root");
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                Option namespace = (Option)tuple3._1();
                String name = (String)tuple3._2();
                String displayName = (String)tuple3._3();
                Tuple3 tuple32 = new Tuple3((Object)namespace, (Object)name, (Object)displayName);
                Option namespace2 = (Option)tuple32._1();
                String name2 = (String)tuple32._2();
                String displayName2 = (String)tuple32._3();
                return params.updatedWith(MODULE$.internalKey(parameter.name() + "_namespace"), (AnyValue)Values.utf8Value((String)((String)valueMapper.apply(namespace2.getOrElse((Function0 & Serializable)() -> "system-root"))))).updatedWith(MODULE$.internalKey(parameter.name()), (AnyValue)Values.utf8Value((String)((String)valueMapper.apply((Object)name2)))).updatedWith(displayNameKey, (AnyValue)Values.utf8Value((String)((String)valueMapper.apply((Object)displayName2))));
            });
        }
        throw new MatchError((Object)databaseName);
    }

    public int runtimeIntInRange(MapValue params, int lower, int upper, String component, Either<Object, Parameter> literalOrParam) {
        int value = this.runtimeIntValue(literalOrParam, params, component);
        if (value < lower || value > upper) {
            Either<Object, Parameter> either = literalOrParam;
            if (either instanceof Right) {
                Right right = (Right)either;
                Parameter param = (Parameter)right.value();
                throw this.parameterOutOfNumericRangeException(param, component, Values.intValue((int)value), lower, upper);
            }
            if (either instanceof Left) {
                throw CypherExecutionException.internalError((String)"Cypher Execution", (String)("Numeric value for " + component + " out of range of valid values"), null);
            }
            throw new MatchError(either);
        }
        return value;
    }

    public String runtimeStringValue(DatabaseName field, MapValue params) {
        DatabaseName databaseName = field;
        if (databaseName instanceof NamespacedName) {
            NamespacedName namespacedName = (NamespacedName)databaseName;
            return namespacedName.toString();
        }
        if (databaseName instanceof ParameterName) {
            ParameterName parameterName = (ParameterName)databaseName;
            Parameter p = parameterName.parameter();
            return this.runtimeStringValue(p.name(), params, false);
        }
        throw new MatchError((Object)databaseName);
    }

    public int runtimeIntValue(Either<Object, Parameter> either, MapValue params, String component) {
        Either<Object, Parameter> either2 = either;
        if (either2 instanceof Left) {
            Left left = (Left)either2;
            int literal = BoxesRunTime.unboxToInt((Object)left.value());
            return literal;
        }
        if (either2 instanceof Right) {
            Right right = (Right)either2;
            Parameter param = (Parameter)right.value();
            AnyValue anyValue = params.get(param.name());
            if (anyValue instanceof IntValue) {
                IntValue intValue = (IntValue)anyValue;
                return intValue.value();
            }
            throw this.parameterWrongTypeException(param, anyValue, java.util.List.of(package$.MODULE$.CTInteger().toCypherTypeString()), component);
        }
        throw new MatchError(either2);
    }

    private ParameterWrongTypeException parameterWrongTypeException(Parameter parameter, AnyValue value, java.util.List<String> expected, String component) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42N51((String)parameter.name(), (ErrorGqlStatusObject)GqlHelper.getGql22G03_22N27((String)value.toString(), (String)component, expected));
        return new ParameterWrongTypeException(gql, gql.getMessage());
    }

    private InvalidArgumentException parameterOutOfNumericRangeException(Parameter parameter, String component, IntValue value, int lower, int upper) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N51).withParam(GqlParams.StringParam.param, parameter.name()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N03).withParam(GqlParams.StringParam.component, component).withParam(GqlParams.StringParam.valueType, value.getTypeName()).withParam(GqlParams.NumberParam.lower, (Number)Predef$.MODULE$.int2Integer(lower)).withParam(GqlParams.NumberParam.upper, (Number)Predef$.MODULE$.int2Integer(upper)).withParam(GqlParams.StringParam.value, String.valueOf(value.value())).build()).build();
        return new InvalidArgumentException(gql, gql.getMessage());
    }

    public String runtimeStringValue(Either<String, Parameter> field, MapValue params) {
        Either<String, Parameter> either = field;
        if (either instanceof Left) {
            Left left = (Left)either;
            String s = (String)left.value();
            return s;
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Parameter p = (Parameter)right.value();
            return this.runtimeStringValue(p.name(), params, false);
        }
        throw new MatchError(either);
    }

    public String runtimeStringValue(Expression field, MapValue params, boolean prettyPrint) {
        return (String)new Serializable(params, prettyPrint){
            private static final long serialVersionUID = 0L;
            private final MapValue params$4;
            private final boolean prettyPrint$1;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof StringLiteral) {
                    StringLiteral stringLiteral = (StringLiteral)A1;
                    String s = stringLiteral.value();
                    return (B1)s;
                }
                if (A1 instanceof Parameter) {
                    Parameter parameter = (Parameter)A1;
                    return (B1)AdministrationCommandRuntime$.MODULE$.runtimeStringValue(parameter.name(), this.params$4, this.prettyPrint$1);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                if (expression instanceof StringLiteral) {
                    return true;
                }
                return expression instanceof Parameter;
            }
            {
                this.params$4 = params$4;
                this.prettyPrint$1 = prettyPrint$1;
            }
        }.apply(field);
    }

    public String runtimeStringValue(String parameter, MapValue params, boolean prettyPrint) {
        Tuple2 tuple2;
        AnyValue value = params.containsKey(parameter) ? params.get(parameter) : params.get(this.internalKey(parameter));
        AnyValue anyValue = value;
        if (anyValue instanceof TextValue) {
            TextValue textValue = (TextValue)anyValue;
            return textValue.stringValue();
        }
        if (prettyPrint) {
            PrettyPrinter pp = new PrettyPrinter();
            value.writeTo((AnyValueWriter)pp);
            v0 = new Tuple2((Object)("`$" + parameter + "`"), (Object)("`" + pp.value() + "`."));
        } else {
            v0 = tuple2 = new Tuple2((Object)("$" + parameter), (Object)value.toString());
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String p = (String)tuple2._1();
        String v = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)p, (Object)v);
        String p2 = (String)tuple22._1();
        String v2 = (String)tuple22._2();
        PrettyPrinter prettyParam = new PrettyPrinter();
        value.writeTo((AnyValueWriter)prettyParam);
        ErrorGqlStatusObject gql = GqlHelper.getGql42N51((String)p2, (ErrorGqlStatusObject)GqlHelper.getGql22G03_22N27((String)prettyParam.value(), (String)GqlParams.StringParam.param.process((Object)parameter), java.util.List.of("STRING")));
        throw new ParameterWrongTypeException(gql, "Expected parameter " + p2 + " to have type String but was " + v2);
    }

    public List<String> runtimeStringListValue(Expression field, MapValue params) {
        ListLiteral listLiteral;
        StringLiteral stringLiteral;
        String s;
        Expression expression = field;
        if (expression instanceof StringLiteral && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(s = (stringLiteral = (StringLiteral)expression).value()))) {
            return new .colon.colon((Object)s, (List)Nil$.MODULE$);
        }
        if (expression instanceof ListLiteral && (listLiteral = (ListLiteral)expression).expressions().forall((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)AdministrationCommandRuntime$.$anonfun$runtimeStringListValue$1(e))) && listLiteral.expressions().nonEmpty()) {
            return ((IterableOnceOps)listLiteral.expressions().map((Function1 & Serializable)x$34 -> ((StringLiteral)x$34).value())).toList();
        }
        if (expression instanceof Parameter) {
            ListValue listValue;
            TextValue textValue;
            Parameter parameter = (Parameter)expression;
            AnyValue value = params.containsKey(parameter.name()) ? params.get(parameter.name()) : params.get(this.internalKey(parameter.name()));
            PrettyPrinter pp = new PrettyPrinter();
            AnyValue anyValue = value;
            if (anyValue instanceof TextValue && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((textValue = (TextValue)anyValue).stringValue()))) {
                return new .colon.colon((Object)textValue.stringValue(), (List)Nil$.MODULE$);
            }
            if (anyValue instanceof ListValue && (listValue = (ListValue)anyValue).nonEmpty()) {
                return CollectionConverters$.MODULE$.IteratorHasAsScala(listValue.iterator()).asScala().map((Function1 & Serializable)x0$1 -> {
                    TextValue textValue;
                    AnyValue anyValue = x0$1;
                    if (anyValue instanceof TextValue && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((textValue = (TextValue)anyValue).stringValue()))) {
                        return textValue.stringValue();
                    }
                    anyValue.writeTo((AnyValueWriter)pp);
                    throw new ParameterWrongTypeException("Expected parameter `$" + parameter.name() + "` to only contain non-empty Strings but contained `" + pp.value() + "`.");
                }).toList();
            }
            value.writeTo((AnyValueWriter)pp);
            throw new ParameterWrongTypeException("Expected parameter `$" + parameter.name() + "` to be a non-empty String or a non-empty List of non-empty Strings but was `" + pp.value() + "`.");
        }
        throw new InvalidArgumentException("Expected non-empty String or non-empty List of non-empty Strings but was `" + field.asCanonicalStringVal() + "`.");
    }

    private void validateAuthId(String id) {
        if (id.isEmpty()) {
            throw new InvalidArgumentException("Invalid input. Auth id is not allowed to be an empty string.");
        }
    }

    public Tuple2<MapValue, Set<InternalNotification>> checkNamespaceExists(AdministrationCommandRuntime.DatabaseNameFields aliasNameFields, Transaction tx, MapValue params) {
        String string = AdministrationCommandRuntime$.paramString$1(aliasNameFields.namespaceKey(), params);
        String string2 = "system-root";
        if (string == null ? string2 != null : !string.equals(string2)) {
            boolean compositeDatabaseExists = BoxesRunTime.unboxToBoolean((Object)Using$.MODULE$.resource((Object)tx.findNodes(TopologyGraphDbmsModel.DATABASE_NAME_LABEL, "name", (Object)AdministrationCommandRuntime$.paramString$1(aliasNameFields.namespaceKey(), params)), (Function1 & Serializable)nodes -> BoxesRunTime.boxToBoolean((boolean)AdministrationCommandRuntime$.$anonfun$checkNamespaceExists$1(nodes)), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$));
            if (!compositeDatabaseExists) {
                String aliasName = AdministrationCommandRuntime$.paramString$1(aliasNameFields.namespaceKey(), params) + "." + AdministrationCommandRuntime$.paramString$1(aliasNameFields.nameKey(), params);
                return new Tuple2((Object)params.updatedWith(aliasNameFields.nameKey(), (AnyValue)Values.utf8Value((String)aliasName)).updatedWith(aliasNameFields.namespaceKey(), (AnyValue)Values.utf8Value((String)"system-root")), (Object)Predef$.MODULE$.Set().empty());
            }
            return new Tuple2((Object)params, (Object)Predef$.MODULE$.Set().empty());
        }
        return new Tuple2((Object)params, (Object)Predef$.MODULE$.Set().empty());
    }

    private final MapValue convertPasswordParameters$1(MapValue params, Parameter x2$1, boolean isEncryptedPassword$1, Config config$1, String hashedPwKey$1, String passwordByteKey$1) {
        byte[] encodedPassword = this.getValidPasswordParameter(params, x2$1.name());
        TextValue hashedPassword = isEncryptedPassword$1 ? this.validateAndFormatEncryptedPassword(encodedPassword) : this.hashPassword(this.validatePassword(encodedPassword, config$1));
        return params.updatedWith(hashedPwKey$1, (AnyValue)hashedPassword).updatedWith(passwordByteKey$1, (AnyValue)Values.byteArray((byte[])encodedPassword));
    }

    public static final /* synthetic */ void $anonfun$ensureUniqueParamName$1(ObjectRef uniqueName$1, String otherParamName) {
        if (otherParamName.equals((String)uniqueName$1.elem)) {
            uniqueName$1.elem = (String)uniqueName$1.elem + "_";
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$makeCreateUserExecutionPlan$1(NativeAuth auth) {
        return BoxesRunTime.unboxToBoolean((Object)auth.changeRequired().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> true));
    }

    private static final Function3 authMapGenerator$1(Seq externalAuths$1, Option nativeAuth$1, TextValue userId$1, String authKey$1) {
        return (Function3 & Serializable)(x$7, x$8, params) -> {
            Seq authList = (Seq)((IterableOps)externalAuths$1.map((Function1 & Serializable)auth -> {
                String id = MODULE$.runtimeStringValue(auth.id(), (MapValue)params, true);
                MODULE$.validateAuthId(id);
                return VirtualValues.map((String[])((String[])((Object[])new String[]{"provider", "id"})), (AnyValue[])((AnyValue[])((Object[])new AnyValue[]{Values.utf8Value((String)auth.provider()), Values.utf8Value((String)id)})));
            })).$plus$plus((IterableOnce)nativeAuth$1.map((Function1 & Serializable)x$9 -> VirtualValues.map((String[])((String[])((Object[])new String[]{"provider", "id"})), (AnyValue[])((AnyValue[])((Object[])new AnyValue[]{Values.utf8Value((String)"native"), userId$1})))));
            return VirtualValues.map((String[])((String[])((Object[])new String[]{authKey$1})), (AnyValue[])((AnyValue[])((Object[])new AnyValue[]{VirtualValues.list((AnyValue[])((AnyValue[])authList.toArray(ClassTag$.MODULE$.apply(MapValue.class))))})));
        };
    }

    public static final /* synthetic */ BooleanValue $anonfun$makeCreateUserExecutionPlan$23(boolean x$1) {
        return Values.booleanValue((boolean)x$1);
    }

    public static final /* synthetic */ QueryHandlerResult $anonfun$makeCreateUserExecutionPlan$26(Function2 validateAuth$1, Seq externalAuths$1, Option nativeAuth$1, int x$13, AnyValue x$14, MapValue x$15) {
        return (QueryHandlerResult)validateAuth$1.apply((Object)externalAuths$1, (Object)nativeAuth$1);
    }

    public static final /* synthetic */ void $anonfun$makeCreateUserExecutionPlan$29(MapValue p$1, AdministrationCommandRuntime.PasswordExpression credentials) {
        ((ByteArray)p$1.get(credentials.bytesKey())).zero();
    }

    private static final Function3 enforceAuthGen$1(UserSecurityGraphComponent userSecurityGraphComponent$1, String enforceAuthKey$1) {
        return (Function3 & Serializable)(transaction, x$24, x$25) -> {
            BooleanValue enforced = Values.booleanValue((boolean)userSecurityGraphComponent$1.requiresAuthObject(transaction));
            return VirtualValues.map((String[])((String[])((Object[])new String[]{enforceAuthKey$1})), (AnyValue[])((AnyValue[])((Object[])new AnyValue[]{enforced})));
        };
    }

    private static final Function3 authMapGenerator$2(Seq externalAuths$2, RemoveAuth removeAuths$1, String setAuthKey$1, String removeAuthKey$1, String removeNativeKey$1) {
        return (Function3 & Serializable)(x$26, x$27, params) -> {
            Seq setAuthList = (Seq)externalAuths$2.map((Function1 & Serializable)auth -> {
                String id = MODULE$.runtimeStringValue(auth.id(), (MapValue)params, true);
                MODULE$.validateAuthId(id);
                return VirtualValues.map((String[])((String[])((Object[])new String[]{"provider", "id"})), (AnyValue[])((AnyValue[])((Object[])new AnyValue[]{Values.utf8Value((String)auth.provider()), Values.utf8Value((String)id)})));
            });
            List providers = (List)removeAuths$1.auths().flatMap((Function1 & Serializable)expr -> MODULE$.runtimeStringListValue((Expression)expr, (MapValue)params)).distinct();
            boolean removeNative = providers.contains((Object)"native");
            List removeAuthList = providers.map((Function1 & Serializable)x$1 -> Values.utf8Value((String)x$1));
            return VirtualValues.map((String[])((String[])((Object[])new String[]{setAuthKey$1, removeAuthKey$1, removeNativeKey$1})), (AnyValue[])((AnyValue[])((Object[])new AnyValue[]{VirtualValues.list((AnyValue[])((AnyValue[])setAuthList.toArray(ClassTag$.MODULE$.apply(MapValue.class)))), VirtualValues.list((AnyValue[])((AnyValue[])removeAuthList.toArray(ClassTag$.MODULE$.apply(TextValue.class)))), Values.booleanValue((boolean)removeNative)})));
        };
    }

    public static final /* synthetic */ QueryHandlerResult $anonfun$makeAlterUserExecutionPlan$20(Either userName$2, Option maybePw$1, Function2 validateAuth$2, Seq externalAuths$2, Option nativeAuth$2, int x0$2, AnyValue x1$1, MapValue x2$1) {
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)x0$2), (Object)x1$1, (Object)x2$1);
        if (tuple3 != null) {
            BooleanValue booleanValue;
            int n = BoxesRunTime.unboxToInt((Object)tuple3._1());
            AnyValue value = (AnyValue)tuple3._2();
            MapValue p = (MapValue)tuple3._3();
            if (0 == n && value instanceof BooleanValue && !(booleanValue = (BooleanValue)value).booleanValue()) {
                return new ThrowException(new InvalidArgumentException("Failed to alter the specified user '" + MODULE$.runtimeStringValue((Either<String, Parameter>)userName$2, p) + "': User does not exist."));
            }
        }
        if (tuple3 != null) {
            int n = BoxesRunTime.unboxToInt((Object)tuple3._1());
            AnyValue value = (AnyValue)tuple3._2();
            MapValue p = (MapValue)tuple3._3();
            if (1 == n && value instanceof TextValue) {
                TextValue textValue = (TextValue)value;
                return (QueryHandlerResult)maybePw$1.map((Function1 & Serializable)newPw -> {
                    byte[] newValue;
                    SystemGraphCredential oldCredentials = SystemGraphCredential.deserialize((String)textValue.stringValue(), (SecureHasher)MODULE$.secureHasher());
                    if (oldCredentials.matchesPassword(newValue = ((ByteArray)p.get(newPw.bytesKey())).asObject())) {
                        return new ThrowException(InvalidArgumentException.oldPasswordEqualsNew((String)MODULE$.runtimeStringValue((Either<String, Parameter>)userName$2, p), (Boolean)Predef$.MODULE$.boolean2Boolean(false)));
                    }
                    return (QueryHandlerResult)validateAuth$2.apply((Object)externalAuths$2, (Object)nativeAuth$2);
                }).getOrElse((Function0 & Serializable)() -> (QueryHandlerResult)validateAuth$2.apply((Object)externalAuths$2, (Object)nativeAuth$2));
            }
        }
        if (tuple3 != null) {
            BooleanValue booleanValue;
            int n = BoxesRunTime.unboxToInt((Object)tuple3._1());
            AnyValue value = (AnyValue)tuple3._2();
            if (2 == n && value instanceof BooleanValue && !(booleanValue = (BooleanValue)value).booleanValue()) {
                return new ThrowException(new InvalidArgumentException("User has no auth provider. Add at least one auth provider for the user or consider suspending them."));
            }
        }
        if (tuple3 != null) {
            BooleanValue booleanValue;
            int n = BoxesRunTime.unboxToInt((Object)tuple3._1());
            AnyValue value = (AnyValue)tuple3._2();
            if (3 == n && value instanceof BooleanValue && !(booleanValue = (BooleanValue)value).booleanValue()) {
                return new ThrowException(InvalidArgumentException.missingMandatoryAuthClause((String)"SET PASSWORD", (String)"native", (String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"Clause `SET PASSWORD` is mandatory for auth provider `native`."}))));
            }
        }
        return (QueryHandlerResult)validateAuth$2.apply((Object)externalAuths$2, (Object)nativeAuth$2);
    }

    public static final /* synthetic */ void $anonfun$makeAlterUserExecutionPlan$24(MapValue p$3, AdministrationCommandRuntime.PasswordExpression newPw) {
        ((ByteArray)p$3.get(newPw.bytesKey())).zero();
    }

    private static final Function1 rename$1() {
        return (Function1 & Serializable)paramName -> MODULE$.internalKey((String)paramName);
    }

    public static final /* synthetic */ boolean $anonfun$runtimeStringListValue$1(Expression e) {
        return e instanceof StringLiteral && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(((StringLiteral)e).value()));
    }

    private static final String paramString$1(String key, MapValue params$5) {
        return ((StringValue)params$5.get(key)).stringValue();
    }

    public static final /* synthetic */ boolean $anonfun$checkNamespaceExists$2(Node n) {
        return n.getProperty("namespace").equals("system-root") && n.getSingleRelationship(TopologyGraphDbmsModel.TARGETS_RELATIONSHIP, Direction.OUTGOING).getEndNode().hasLabel(TopologyGraphDbmsModel.COMPOSITE_DATABASE_LABEL);
    }

    public static final /* synthetic */ boolean $anonfun$checkNamespaceExists$1(ResourceIterator nodes) {
        return CollectionConverters$.MODULE$.IteratorHasAsScala((Iterator)nodes).asScala().exists((Function1 & Serializable)n -> BoxesRunTime.boxToBoolean((boolean)AdministrationCommandRuntime$.$anonfun$checkNamespaceExists$2(n)));
    }

    private AdministrationCommandRuntime$() {
    }
}

