/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.javacompat;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.neo4j.cypher.internal.NonFatalCypherError;
import org.neo4j.cypher.internal.javacompat.ResultRowImpl;
import org.neo4j.cypher.internal.result.string.ResultStringBuilder;
import org.neo4j.exceptions.CypherExecutionException;
import org.neo4j.exceptions.Neo4jException;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.GqlStatusObject;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.internal.helpers.collection.PrefetchingResourceIterator;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.impl.util.DefaultValueMapper;
import org.neo4j.util.VisibleForTesting;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ValueMapper;

public class ResultSubscriber
extends PrefetchingResourceIterator<Map<String, Object>>
implements QuerySubscriber,
Result {
    private ValueMapper<Object> valueMapper;
    private final TransactionalContext context;
    private QueryExecution execution;
    private AnyValue[] currentRecord;
    private Throwable error;
    private QueryStatistics statistics;
    private Result.ResultVisitor<?> visitor;
    private Exception visitException;
    private List<Map<String, Object>> materializeResult;
    private Iterator<Map<String, Object>> materializedIterator;

    public ResultSubscriber(TransactionalContext context) {
        this(context, (ValueMapper<Object>)new DefaultValueMapper(context.transaction()));
    }

    public ResultSubscriber(TransactionalContext context, ValueMapper<Object> valueMapper) {
        this.context = context;
        this.valueMapper = valueMapper;
    }

    public void init(QueryExecution execution) {
        this.execution = execution;
        this.assertNoErrors();
    }

    public void materialize(QueryExecution execution) throws Exception {
        this.execution = execution;
        this.materializeResult = new ArrayList<Map<String, Object>>();
        this.doFetchResults(Long.MAX_VALUE);
    }

    public void onResult(int numberOfFields) {
        this.currentRecord = new AnyValue[numberOfFields];
    }

    public void onRecord() {
    }

    public void onField(int offset, AnyValue value) {
        this.currentRecord[offset] = value;
    }

    public void onRecordCompleted() {
        if (this.visitor != null) {
            try {
                if (!this.visitor.visit((Result.ResultRow)new ResultRowImpl(this.createPublicRecord()))) {
                    this.execution.cancel();
                    this.visitor = null;
                }
            }
            catch (Exception exception) {
                this.visitException = exception;
            }
        }
        if (this.materializeResult != null) {
            this.materializeResult.add(this.createPublicRecord());
        }
    }

    public void onError(Throwable throwable) {
        if (this.error == null) {
            this.error = throwable;
        } else if (this.error != throwable) {
            this.error.addSuppressed(throwable);
        }
    }

    public void onResultCompleted(QueryStatistics statistics) {
        this.statistics = statistics;
    }

    public void onValueMapperCreated(ValueMapper<Object> valueMapper) {
        this.valueMapper = valueMapper;
    }

    public QueryExecutionType getQueryExecutionType() {
        try {
            return this.execution.executionType();
        }
        catch (Throwable throwable) {
            this.close();
            throw ResultSubscriber.converted(throwable);
        }
    }

    public List<String> columns() {
        return Arrays.asList(this.execution.fieldNames());
    }

    public <T> ResourceIterator<T> columnAs(final String name) {
        return new ResourceIterator<T>(){

            public void close() {
                ResultSubscriber.this.close();
            }

            public boolean hasNext() {
                return ResultSubscriber.this.hasNext();
            }

            public T next() {
                Map next = (Map)ResultSubscriber.this.next();
                return next.get(name);
            }
        };
    }

    public void close() {
        block2: {
            this.execution.cancel();
            try {
                this.execution.awaitCleanup();
            }
            catch (Exception e) {
                if (this.error == null || this.error == e) break block2;
                this.error.addSuppressed(e);
            }
        }
    }

    public QueryStatistics getQueryStatistics() {
        return this.statistics == null ? QueryStatistics.EMPTY : this.statistics;
    }

    public ExecutionPlanDescription getExecutionPlanDescription() {
        try {
            return this.execution.executionPlanDescription();
        }
        catch (Exception e) {
            throw ResultSubscriber.converted(e);
        }
    }

    public String resultAsString() {
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        this.writeAsStringTo(writer);
        writer.flush();
        return out.toString();
    }

    public void writeAsStringTo(PrintWriter writer) {
        ResultStringBuilder stringBuilder = ResultStringBuilder.apply(this.execution.fieldNames(), this.context);
        try {
            if (this.hasFetchedNext()) {
                stringBuilder.addRow(new ResultRowImpl((Map)this.getNextObject()));
            }
            this.accept(stringBuilder);
            stringBuilder.result(writer, this.statistics);
            for (Notification notification : this.getNotifications()) {
                writer.println(notification.getDescription());
            }
        }
        catch (Exception e) {
            this.close();
            throw ResultSubscriber.converted(e);
        }
    }

    public Iterable<Notification> getNotifications() {
        return this.execution.getNotifications();
    }

    public Iterable<GqlStatusObject> getGqlStatusObjects() {
        return this.execution.getGqlStatusObjects();
    }

    public <VisitationException extends Exception> void accept(Result.ResultVisitor<VisitationException> visitor) throws VisitationException {
        if (this.isMaterialized()) {
            this.acceptFromMaterialized(visitor);
        } else {
            this.acceptFromSubscriber(visitor);
        }
        this.close();
    }

    protected Map<String, Object> fetchNextOrNull() {
        Map<String, Object> result = this.isMaterialized() ? this.nextFromMaterialized() : this.nextFromSubscriber();
        this.assertNoErrors();
        return result;
    }

    private Map<String, Object> nextFromMaterialized() {
        this.assertNoErrors();
        if (this.materializedIterator == null) {
            this.materializedIterator = this.materializeResult.iterator();
        }
        if (this.materializedIterator.hasNext()) {
            Map<String, Object> next = this.materializedIterator.next();
            if (!this.materializedIterator.hasNext()) {
                this.close();
            }
            return next;
        }
        this.close();
        return null;
    }

    private Map<String, Object> nextFromSubscriber() {
        this.fetchResults(1L);
        this.assertNoErrors();
        if (this.hasNewValues()) {
            Map<String, Object> record = this.createPublicRecord();
            this.markAsRead();
            return record;
        }
        this.close();
        return null;
    }

    private boolean hasNewValues() {
        return this.currentRecord.length > 0 && this.currentRecord[0] != null;
    }

    private void markAsRead() {
        if (this.currentRecord.length > 0) {
            this.currentRecord[0] = null;
        }
    }

    private void fetchResults(long numberOfResults) {
        try {
            this.doFetchResults(numberOfResults);
        }
        catch (Exception e) {
            this.close();
            throw ResultSubscriber.converted(e);
        }
    }

    private void doFetchResults(long numberOfResults) throws Exception {
        this.execution.request(numberOfResults);
        this.assertNoErrors();
        this.execution.await();
    }

    private Map<String, Object> createPublicRecord() {
        String[] fieldNames = this.execution.fieldNames();
        HashMap<String, Object> result = new HashMap<String, Object>((int)Math.ceil((double)fieldNames.length * 1.33));
        try {
            for (int i = 0; i < fieldNames.length; ++i) {
                result.put(fieldNames[i], this.currentRecord[i].map(this.valueMapper));
            }
        }
        catch (Throwable t) {
            throw ResultSubscriber.converted(t);
        }
        return result;
    }

    private void assertNoErrors() {
        if (this.error != null) {
            if (NonFatalCypherError.isNonFatal((Throwable)this.error)) {
                try {
                    this.close();
                }
                catch (Throwable suppressed) {
                    this.error.addSuppressed(suppressed);
                }
            }
            throw ResultSubscriber.converted(this.error);
        }
    }

    private static QueryExecutionException converted(Throwable e) {
        Neo4jException neo4jException;
        if (e instanceof Neo4jException) {
            neo4jException = (Neo4jException)e;
        } else {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            neo4jException = CypherExecutionException.unexpectedError((Throwable)e);
        }
        return QueryExecutionKernelException.wrapError((Throwable)neo4jException).asUserException();
    }

    private <VisitationException extends Exception> void acceptFromMaterialized(Result.ResultVisitor<VisitationException> visitor) throws VisitationException {
        this.assertNoErrors();
        for (Map<String, Object> materialized : this.materializeResult) {
            if (!visitor.visit((Result.ResultRow)new ResultRowImpl(materialized))) break;
        }
    }

    private <VisitationException extends Exception> void acceptFromSubscriber(Result.ResultVisitor<VisitationException> visitor) throws VisitationException {
        this.visitor = visitor;
        this.fetchResults(Long.MAX_VALUE);
        if (this.visitException != null) {
            throw this.visitException;
        }
        this.assertNoErrors();
    }

    @VisibleForTesting
    public boolean isMaterialized() {
        return this.materializeResult != null;
    }
}

