/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.procs;

import org.neo4j.cypher.internal.expressions.BooleanTypeName;
import org.neo4j.cypher.internal.expressions.CypherTypeName;
import org.neo4j.cypher.internal.expressions.DateTypeName;
import org.neo4j.cypher.internal.expressions.DurationTypeName;
import org.neo4j.cypher.internal.expressions.FloatTypeName;
import org.neo4j.cypher.internal.expressions.IntegerTypeName;
import org.neo4j.cypher.internal.expressions.LocalDateTimeTypeName;
import org.neo4j.cypher.internal.expressions.LocalTimeTypeName;
import org.neo4j.cypher.internal.expressions.PointTypeName;
import org.neo4j.cypher.internal.expressions.StringTypeName;
import org.neo4j.cypher.internal.expressions.ZonedDateTimeTypeName;
import org.neo4j.cypher.internal.expressions.ZonedTimeTypeName;
import org.neo4j.internal.schema.SchemaValueType;
import org.neo4j.internal.schema.constraints.PropertyTypeSet;

public final class PropertyTypeMapper$ {
    public static final PropertyTypeMapper$ MODULE$ = new PropertyTypeMapper$();

    public PropertyTypeSet asPropertyTypeSet(CypherTypeName propertyType) {
        SchemaValueType schemaValueType;
        CypherTypeName cypherTypeName = propertyType;
        if (cypherTypeName instanceof BooleanTypeName) {
            schemaValueType = SchemaValueType.BOOLEAN;
        } else if (cypherTypeName instanceof StringTypeName) {
            schemaValueType = SchemaValueType.STRING;
        } else if (cypherTypeName instanceof IntegerTypeName) {
            schemaValueType = SchemaValueType.INTEGER;
        } else if (cypherTypeName instanceof FloatTypeName) {
            schemaValueType = SchemaValueType.FLOAT;
        } else if (cypherTypeName instanceof DateTypeName) {
            schemaValueType = SchemaValueType.DATE;
        } else if (cypherTypeName instanceof LocalTimeTypeName) {
            schemaValueType = SchemaValueType.LOCAL_TIME;
        } else if (cypherTypeName instanceof ZonedTimeTypeName) {
            schemaValueType = SchemaValueType.ZONED_TIME;
        } else if (cypherTypeName instanceof LocalDateTimeTypeName) {
            schemaValueType = SchemaValueType.LOCAL_DATETIME;
        } else if (cypherTypeName instanceof ZonedDateTimeTypeName) {
            schemaValueType = SchemaValueType.ZONED_DATETIME;
        } else if (cypherTypeName instanceof DurationTypeName) {
            schemaValueType = SchemaValueType.DURATION;
        } else if (cypherTypeName instanceof PointTypeName) {
            schemaValueType = SchemaValueType.POINT;
        } else {
            throw new IllegalStateException("Invalid property type: " + cypherTypeName.description());
        }
        SchemaValueType schemaType = schemaValueType;
        return PropertyTypeSet.of((SchemaValueType[])new SchemaValueType[]{schemaType});
    }

    private PropertyTypeMapper$() {
    }
}

