/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.collector;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.internal.collector.QueriesSection;
import org.neo4j.internal.collector.QueryAnonymizer;
import org.neo4j.internal.collector.RetrieveResult;
import org.neo4j.internal.collector.TruncatedQuerySnapshot;
import org.neo4j.values.virtual.MapValue;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class QueriesSection$ {
    public static final QueriesSection$ MODULE$;
    private final Regex QUERY_FILTER;

    static {
        new QueriesSection$();
    }

    private Regex QUERY_FILTER() {
        return this.QUERY_FILTER;
    }

    public Stream<RetrieveResult> retrieve(java.util.Iterator<TruncatedQuerySnapshot> querySnapshots, QueryAnonymizer anonymizer, int maxInvocations) {
        scala.collection.mutable.HashMap queries = new scala.collection.mutable.HashMap();
        while (querySnapshots.hasNext()) {
            BoxedUnit boxedUnit;
            TruncatedQuerySnapshot snapshot = querySnapshots.next();
            String queryString = snapshot.queryText;
            if (this.QUERY_FILTER().findFirstMatchIn((CharSequence)queryString).isEmpty()) {
                QueriesSection.QueryKey queryKey = new QueriesSection.QueryKey(queryString, snapshot.fullQueryTextHash, snapshot.queryPlanSupplier.get());
                QueriesSection.QueryData snapshotList = (QueriesSection.QueryData)queries.getOrElseUpdate((Object)queryKey, (Function0)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final QueriesSection.QueryData apply() {
                        return new QueriesSection.QueryData();
                    }
                });
                boxedUnit = snapshotList.invocations().$plus$eq((Object)new QueriesSection.SingleInvocation(snapshot.queryParameters, Predef$.MODULE$.Long2long(snapshot.elapsedTimeMicros), Predef$.MODULE$.Long2long(snapshot.compilationTimeMicros), Predef$.MODULE$.Long2long(snapshot.startTimestampMillis)));
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.asRetrieveStream((Iterator<RetrieveResult>)queries.toIterator().map((Function1)new scala.Serializable(anonymizer, maxInvocations){
            public static final long serialVersionUID = 0L;
            private final QueryAnonymizer anonymizer$1;
            private final int maxInvocations$1;

            public final RetrieveResult apply(Tuple2<QueriesSection.QueryKey, QueriesSection.QueryData> x0$1) {
                Tuple2<QueriesSection.QueryKey, QueriesSection.QueryData> tuple2 = x0$1;
                if (tuple2 != null) {
                    QueriesSection.QueryKey queryKey = (QueriesSection.QueryKey)tuple2._1();
                    QueriesSection.QueryData queryData = (QueriesSection.QueryData)tuple2._2();
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("query", this.anonymizer$1.queryText(queryKey.queryText()));
                    ArrayList<Object> estimatedRows = new ArrayList<Object>();
                    data.put("queryExecutionPlan", QueriesSection$.MODULE$.org$neo4j$internal$collector$QueriesSection$$planToMap(queryKey.plan(), estimatedRows));
                    data.put("estimatedRows", estimatedRows);
                    data.put("invocations", QueriesSection$.MODULE$.org$neo4j$internal$collector$QueriesSection$$invocations((ArrayBuffer<QueriesSection.SingleInvocation>)((ArrayBuffer)queryData.invocations().take(this.maxInvocations$1)), this.anonymizer$1));
                    data.put("invocationSummary", QueriesSection$.MODULE$.org$neo4j$internal$collector$QueriesSection$$invocationSummary(queryData.invocations()));
                    RetrieveResult retrieveResult = new RetrieveResult("QUERIES", data);
                    return retrieveResult;
                }
                throw new MatchError(tuple2);
            }
            {
                this.anonymizer$1 = anonymizer$1;
                this.maxInvocations$1 = maxInvocations$1;
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Object> org$neo4j$internal$collector$QueriesSection$$planToMap(ExecutionPlanDescription plan, ArrayList<Object> estimatedRows) {
        void var3_3;
        HashMap<String, Object> data = new HashMap<String, Object>();
        Integer id = Predef$.MODULE$.int2Integer(estimatedRows.size());
        estimatedRows.add(BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble(plan.getArguments().get("EstimatedRows"))));
        data.put("id", id);
        data.put("operator", plan.getName());
        List children = plan.getChildren();
        int n = children.size();
        switch (n) {
            default: {
                throw new IllegalStateException(new StringBuilder().append((Object)"Cannot handle operators with more that 2 children, got ").append((Object)BoxesRunTime.boxToInteger((int)n)).toString());
            }
            case 2: {
                data.put("lhs", this.org$neo4j$internal$collector$QueriesSection$$planToMap((ExecutionPlanDescription)children.get(0), estimatedRows));
                Object object = data.put("rhs", this.org$neo4j$internal$collector$QueriesSection$$planToMap((ExecutionPlanDescription)children.get(1), estimatedRows));
                break;
            }
            case 1: {
                Object object = data.put("lhs", this.org$neo4j$internal$collector$QueriesSection$$planToMap((ExecutionPlanDescription)children.get(0), estimatedRows));
                break;
            }
            case 0: {
                Object object = BoxedUnit.UNIT;
            }
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public ArrayList<Map<String, Object>> org$neo4j$internal$collector$QueriesSection$$invocations(ArrayBuffer<QueriesSection.SingleInvocation> invocations2, QueryAnonymizer anonymizer) {
        void var3_3;
        ArrayList result = new ArrayList();
        invocations2.withFilter((Function1)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(QueriesSection.SingleInvocation check$ifrefutable$1) {
                QueriesSection.SingleInvocation singleInvocation = check$ifrefutable$1;
                boolean bl = singleInvocation != null;
                return bl;
            }
        }).foreach((Function1)new scala.Serializable(anonymizer, result){
            public static final long serialVersionUID = 0L;
            private final QueryAnonymizer anonymizer$2;
            private final ArrayList result$1;

            public final boolean apply(QueriesSection.SingleInvocation x$1) {
                QueriesSection.SingleInvocation singleInvocation = x$1;
                if (singleInvocation != null) {
                    Long l;
                    MapValue queryParameters = singleInvocation.queryParameters();
                    long elapsedTimeMicros = singleInvocation.elapsedTimeMicros();
                    long compilationTimeMicros = singleInvocation.compilationTimeMicros();
                    long startTimestampMillis = singleInvocation.startTimestampMillis();
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    Object object = queryParameters.size() > 0 ? data.put("params", this.anonymizer$2.queryParams(queryParameters)) : BoxedUnit.UNIT;
                    long compileTime = compilationTimeMicros;
                    long elapsed = elapsedTimeMicros;
                    if (compileTime > 0L) {
                        data.put("elapsedCompileTimeInUs", BoxesRunTime.boxToLong((long)compileTime));
                        l = data.put("elapsedExecutionTimeInUs", BoxesRunTime.boxToLong((long)(elapsed - compileTime)));
                    } else {
                        l = data.put("elapsedExecutionTimeInUs", BoxesRunTime.boxToLong((long)elapsed));
                    }
                    data.put("startTimestampMillis", BoxesRunTime.boxToLong((long)startTimestampMillis));
                    boolean bl = this.result$1.add(data);
                    return bl;
                }
                throw new MatchError((Object)singleInvocation);
            }
            {
                this.anonymizer$2 = anonymizer$2;
                this.result$1 = result$1;
            }
        });
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Object> org$neo4j$internal$collector$QueriesSection$$invocationSummary(ArrayBuffer<QueriesSection.SingleInvocation> invocations2) {
        void var2_2;
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        QueriesSection.Stats compileTime = new QueriesSection.Stats();
        QueriesSection.Stats executionTime = new QueriesSection.Stats();
        invocations2.foreach((Function1)new scala.Serializable(compileTime, executionTime){
            public static final long serialVersionUID = 0L;
            private final QueriesSection.Stats compileTime$1;
            private final QueriesSection.Stats executionTime$1;

            public final void apply(QueriesSection.SingleInvocation invocation) {
                this.compileTime$1.onValue(invocation.compilationTimeMicros());
                this.executionTime$1.onValue(invocation.elapsedTimeMicros() - invocation.compilationTimeMicros());
            }
            {
                this.compileTime$1 = compileTime$1;
                this.executionTime$1 = executionTime$1;
            }
        });
        result.put("compileTimeInUs", compileTime.asMap());
        result.put("executionTimeInUs", executionTime.asMap());
        result.put("invocationCount", BoxesRunTime.boxToLong((long)invocations2.size()));
        return var2_2;
    }

    private Stream<RetrieveResult> asRetrieveStream(Iterator<RetrieveResult> iterator) {
        return StreamSupport.stream(Spliterators.spliterator((java.util.Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(iterator).asJava(), 0L, 256), false);
    }

    private QueriesSection$() {
        MODULE$ = this;
        this.QUERY_FILTER = new StringOps(Predef$.MODULE$.augmentString("(?:(?i)call)\\s+(?:dbms\\.|db\\.stats\\.)")).r();
    }
}

