/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.collector;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.internal.collector.QueriesSection;
import org.neo4j.internal.collector.QueryAnonymizer;
import org.neo4j.internal.collector.RetrieveResult;
import org.neo4j.internal.collector.TruncatedQuerySnapshot;
import org.neo4j.values.virtual.MapValue;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.mutable.ArrayBuffer;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class QueriesSection$ {
    public static final QueriesSection$ MODULE$ = new QueriesSection$();
    private static final Regex QUERY_FILTER = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(?:(?i)call)\\s+(?:dbms\\.|db\\.stats\\.)"));

    private Regex QUERY_FILTER() {
        return QUERY_FILTER;
    }

    public Stream<RetrieveResult> retrieve(java.util.Iterator<TruncatedQuerySnapshot> querySnapshots, QueryAnonymizer anonymizer, int maxInvocations) {
        scala.collection.mutable.HashMap queries = new scala.collection.mutable.HashMap();
        while (querySnapshots.hasNext()) {
            BoxedUnit boxedUnit;
            TruncatedQuerySnapshot snapshot = querySnapshots.next();
            String queryString = snapshot.queryText;
            if (this.QUERY_FILTER().findFirstMatchIn((CharSequence)queryString).isEmpty()) {
                QueriesSection.QueryKey queryKey = new QueriesSection.QueryKey(queryString, snapshot.fullQueryTextHash, snapshot.queryPlanSupplier.get());
                QueriesSection.QueryData snapshotList = (QueriesSection.QueryData)queries.getOrElseUpdate((Object)queryKey, (Function0 & Serializable)() -> new QueriesSection.QueryData());
                boxedUnit = snapshotList.invocations().$plus$eq((Object)new QueriesSection.SingleInvocation(snapshot.queryParameters, snapshot.elapsedTimeMicros, snapshot.compilationTimeMicros, snapshot.startTimestampMillis));
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.asRetrieveStream((Iterator<RetrieveResult>)queries.toIterator().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            QueriesSection.QueryKey queryKey = (QueriesSection.QueryKey)tuple2._1();
            QueriesSection.QueryData queryData = (QueriesSection.QueryData)tuple2._2();
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("query", anonymizer.queryText(queryKey.queryText()));
            ArrayList<Object> estimatedRows = new ArrayList<Object>();
            data.put("queryExecutionPlan", MODULE$.planToMap(queryKey.plan(), estimatedRows));
            data.put("estimatedRows", estimatedRows);
            data.put("invocations", MODULE$.invocations((ArrayBuffer<QueriesSection.SingleInvocation>)((ArrayBuffer)queryData.invocations().take(maxInvocations)), anonymizer));
            data.put("invocationSummary", MODULE$.invocationSummary(queryData.invocations()));
            RetrieveResult retrieveResult = new RetrieveResult("QUERIES", data);
            return retrieveResult;
        }));
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, Object> planToMap(ExecutionPlanDescription plan, ArrayList<Object> estimatedRows) {
        void var3_3;
        HashMap<String, Object> data = new HashMap<String, Object>();
        Integer id = Predef$.MODULE$.int2Integer(estimatedRows.size());
        estimatedRows.add(BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble(plan.getArguments().get("EstimatedRows"))));
        data.put("id", id);
        data.put("operator", plan.getName());
        List children = plan.getChildren();
        int n = children.size();
        switch (n) {
            case 0: {
                Object object = BoxedUnit.UNIT;
                break;
            }
            case 1: {
                Object object = data.put("lhs", this.planToMap((ExecutionPlanDescription)children.get(0), estimatedRows));
                break;
            }
            case 2: {
                data.put("lhs", this.planToMap((ExecutionPlanDescription)children.get(0), estimatedRows));
                Object object = data.put("rhs", this.planToMap((ExecutionPlanDescription)children.get(1), estimatedRows));
                break;
            }
            default: {
                throw new IllegalStateException("Cannot handle operators with more that 2 children, got " + n);
            }
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private ArrayList<Map<String, Object>> invocations(ArrayBuffer<QueriesSection.SingleInvocation> invocations, QueryAnonymizer anonymizer) {
        void var3_3;
        ArrayList result = new ArrayList();
        invocations.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)QueriesSection$.$anonfun$invocations$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)QueriesSection$.$anonfun$invocations$2(anonymizer, result, x$1)));
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, Object> invocationSummary(ArrayBuffer<QueriesSection.SingleInvocation> invocations) {
        void var2_2;
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        QueriesSection.Stats compileTime = new QueriesSection.Stats();
        QueriesSection.Stats executionTime = new QueriesSection.Stats();
        invocations.foreach((Function1 & Serializable)invocation -> {
            QueriesSection$.$anonfun$invocationSummary$1(compileTime, executionTime, invocation);
            return BoxedUnit.UNIT;
        });
        result.put("compileTimeInUs", compileTime.asMap());
        result.put("executionTimeInUs", executionTime.asMap());
        result.put("invocationCount", BoxesRunTime.boxToLong((long)invocations.size()));
        return var2_2;
    }

    private Stream<RetrieveResult> asRetrieveStream(Iterator<RetrieveResult> iterator) {
        return StreamSupport.stream(Spliterators.spliterator(CollectionConverters$.MODULE$.IteratorHasAsJava(iterator).asJava(), 0L, 256), false);
    }

    public static final /* synthetic */ boolean $anonfun$invocations$1(QueriesSection.SingleInvocation check$ifrefutable$1) {
        QueriesSection.SingleInvocation singleInvocation = check$ifrefutable$1;
        boolean bl = singleInvocation != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$invocations$2(QueryAnonymizer anonymizer$2, ArrayList result$1, QueriesSection.SingleInvocation x$1) {
        HashMap<String, Object> data;
        long startTimestampMillis;
        QueriesSection.SingleInvocation singleInvocation = x$1;
        if (singleInvocation != null) {
            MapValue queryParameters = singleInvocation.queryParameters();
            long elapsedTimeMicros = singleInvocation.elapsedTimeMicros();
            long compilationTimeMicros = singleInvocation.compilationTimeMicros();
            startTimestampMillis = singleInvocation.startTimestampMillis();
            data = new HashMap<String, Object>();
            Object object = queryParameters.size() > 0 ? data.put("params", anonymizer$2.queryParams(queryParameters)) : BoxedUnit.UNIT;
            long compileTime = compilationTimeMicros;
            long elapsed = elapsedTimeMicros;
            if (compileTime > 0L) {
                data.put("elapsedCompileTimeInUs", BoxesRunTime.boxToLong((long)compileTime));
                v1 = data.put("elapsedExecutionTimeInUs", BoxesRunTime.boxToLong((long)(elapsed - compileTime)));
            } else {
                v1 = data.put("elapsedExecutionTimeInUs", BoxesRunTime.boxToLong((long)elapsed));
            }
        } else {
            throw new MatchError((Object)singleInvocation);
        }
        data.put("startTimestampMillis", BoxesRunTime.boxToLong((long)startTimestampMillis));
        boolean bl = result$1.add(data);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$invocationSummary$1(QueriesSection.Stats compileTime$1, QueriesSection.Stats executionTime$1, QueriesSection.SingleInvocation invocation) {
        compileTime$1.onValue(invocation.compilationTimeMicros());
        executionTime$1.onValue(invocation.elapsedTimeMicros() - invocation.compilationTimeMicros());
    }

    private QueriesSection$() {
    }
}

