/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.archive.backup;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.neo4j.dbms.archive.StandardCompressionFormat;
import org.neo4j.dbms.archive.backup.BackupCompressionFormat;
import org.neo4j.dbms.archive.backup.BackupDescription;
import org.neo4j.dbms.archive.backup.BackupMetadataV2;

public class BackupZstdFormatV2
implements BackupCompressionFormat {
    static final String MAGIC_HEADER = "BZV2";
    private BackupMetadataV2 metadata;

    @Override
    public void setMetadata(BackupDescription description) {
        this.metadata = BackupMetadataV2.from(description);
    }

    @Override
    public OutputStream compress(OutputStream stream) throws IOException {
        stream.write(MAGIC_HEADER.getBytes());
        OutputStream compressionStream = StandardCompressionFormat.ZSTD.compress(stream);
        try {
            this.writeDescriptionToStream(compressionStream);
            return compressionStream;
        }
        catch (IOException e) {
            compressionStream.close();
            throw e;
        }
    }

    @Override
    public InputStream decompress(InputStream stream) throws IOException {
        InputStream decompress = StandardCompressionFormat.ZSTD.decompress(stream);
        try {
            BackupZstdFormatV2.readMetadataFromZstdStream(decompress);
            return decompress;
        }
        catch (IOException e) {
            decompress.close();
            throw e;
        }
    }

    @Override
    public BackupCompressionFormat.StreamWithDescription decompressAndDescribe(InputStream stream) throws IOException {
        InputStream decompress = StandardCompressionFormat.ZSTD.decompress(stream);
        try {
            BackupDescription description = BackupZstdFormatV2.readMetadataFromZstdStream(decompress).toBackupDescription();
            return new BackupCompressionFormat.StreamWithDescription(decompress, description);
        }
        catch (IOException e) {
            decompress.close();
            throw e;
        }
    }

    @Override
    public BackupDescription readMetadata(InputStream inputStream) throws IOException {
        try (InputStream decompress = StandardCompressionFormat.ZSTD.decompress(inputStream);){
            BackupDescription backupDescription = BackupZstdFormatV2.readMetadataFromZstdStream(decompress).toBackupDescription();
            return backupDescription;
        }
    }

    private void writeDescriptionToStream(OutputStream outputStream) throws IOException {
        int metadataVersion = 2;
        outputStream.write(metadataVersion);
        this.metadata.writeToStreamV2(outputStream);
    }

    private static BackupMetadataV2 readMetadataFromZstdStream(InputStream inputStream) throws IOException {
        int metadataVersion = inputStream.read();
        switch (metadataVersion) {
            case 2: {
                break;
            }
            default: {
                throw new IOException(String.format("Unsupported metadata version %d found in backup", metadataVersion));
            }
        }
        return BackupMetadataV2.readFromStream(inputStream);
    }
}

