/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.routing;

import java.util.Optional;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.configuration.connectors.ConnectorType;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.configuration.helpers.SocketAddressParser;
import org.neo4j.dbms.routing.RoutingException;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.logging.InternalLog;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

public class RoutingTableServiceHelpers {
    public static final String FROM_ALIAS_KEY = "alias";
    public static final String ADDRESS_CONTEXT_KEY = "address";
    public static final String POLICY_KEY = "policy";

    public static SocketAddress findClientProvidedAddress(MapValue routingContext) throws RoutingException {
        Optional<AnyValue> value = Optional.ofNullable(routingContext.get(ADDRESS_CONTEXT_KEY)).filter(v -> v != Values.NO_VALUE);
        if (value.isEmpty()) {
            return null;
        }
        AnyValue anyValue = value.get();
        if (anyValue instanceof TextValue) {
            TextValue textValue = (TextValue)anyValue;
            try {
                String address = textValue.stringValue();
                if (address != null && !address.isEmpty() && !address.isBlank()) {
                    return SocketAddressParser.socketAddress((String)address, (int)7687, SocketAddress::new);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new RoutingException((Status)Status.Procedure.ProcedureCallFailed, "An address key is included in the routing table request, but its value could not be parsed.");
    }

    public static String findClientProvidedPolicy(MapValue routingContext) throws RoutingException {
        Optional<AnyValue> value = Optional.ofNullable(routingContext.get(POLICY_KEY)).filter(v -> v != Values.NO_VALUE);
        if (value.isEmpty()) {
            return null;
        }
        AnyValue anyValue = value.get();
        if (anyValue instanceof TextValue) {
            TextValue textValue = (TextValue)anyValue;
            return textValue.stringValue();
        }
        throw new RoutingException((Status)Status.Procedure.ProcedureCallFailed, "An policy key is included in the routing table request, but its value could not be parsed.");
    }

    public static String findClientProvidedAliasChain(MapValue routingContext) throws RoutingException {
        Optional<AnyValue> value = Optional.ofNullable(routingContext.get(FROM_ALIAS_KEY)).filter(v -> v != Values.NO_VALUE);
        if (value.isEmpty()) {
            return null;
        }
        AnyValue anyValue = value.get();
        if (anyValue instanceof TextValue) {
            TextValue textValue = (TextValue)anyValue;
            return textValue.stringValue();
        }
        throw new RoutingException((Status)Status.Procedure.ProcedureCallFailed, "An from alias key is included in the routing table request, but its value could not be parsed.");
    }

    static SocketAddress ensureBoltAddressIsUsable(MapValue routingContext, ConnectorPortRegister portRegister, SocketAddress localAdvertisedAddress) throws RoutingException {
        return RoutingTableServiceHelpers.ensureBoltAddressIsUsable(RoutingTableServiceHelpers.findClientProvidedAddress(routingContext), portRegister, localAdvertisedAddress);
    }

    public static SocketAddress ensureBoltAddressIsUsable(SocketAddress clientProvidedAddress, ConnectorPortRegister portRegister, SocketAddress localAdvertisedAddress) {
        HostnamePort localAddress;
        SocketAddress addressToUse;
        SocketAddress socketAddress = clientProvidedAddress == null ? localAdvertisedAddress : (addressToUse = clientProvidedAddress.getPort() == 0 ? localAdvertisedAddress : clientProvidedAddress);
        if (addressToUse.getPort() <= 0 && (localAddress = portRegister.getLocalAddress(ConnectorType.BOLT)) != null) {
            addressToUse = new SocketAddress(addressToUse.getHostname(), localAddress.getPort());
        }
        return addressToUse;
    }

    public static Optional<SocketAddress> findClientProvidedAddress(MapValue routingContext, int defaultBoltPort, InternalLog log) throws RoutingException {
        AnyValue address = routingContext.get(ADDRESS_CONTEXT_KEY);
        if (address == null || address == Values.NO_VALUE) {
            return Optional.empty();
        }
        if (address instanceof TextValue) {
            try {
                String clientProvidedAddress = ((TextValue)address).stringValue();
                if (clientProvidedAddress != null && !clientProvidedAddress.isEmpty() && !clientProvidedAddress.isBlank()) {
                    return Optional.of(SocketAddressParser.socketAddress((String)clientProvidedAddress, (int)defaultBoltPort, SocketAddress::new));
                }
            }
            catch (Exception e) {
                log.warn("Exception attempting to determine address value from routing context", (Throwable)e);
            }
        }
        throw RoutingException.invalidAddressKey();
    }

    public static RoutingException databaseNotFoundException(String databaseName) {
        return RoutingException.routingTableForNonExistingDb(databaseName);
    }

    public static RoutingException databaseNotAvailableException(String databaseName) {
        return RoutingException.routingTableForUnavailableDb(databaseName);
    }
}

